/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.extras;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.MyDate;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.Zeile;

public class ReportCrawler2 {
    private static final TreeMap VALS = new TreeMap();
    private static final int LINE_LENGTH = 150;
    private static final int KEY_LENGTH = 19;
    private static final int BODY_LINE_WIDTH = 131;
    private static final StringBuilder OSB = new StringBuilder();
    private static final StringBuilder TSB = new StringBuilder();
    private static final GregorianCalendar GREG = new GregorianCalendar();

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("java mausoleum.extras.ReportCrawler2 group [report prefix] ID");
            System.exit(1);
        }
        String group = args[0];
        String objectType = args[1];
        String startToCheck = String.valueOf(args[2]) + ";";
        String dir = String.valueOf(GroupFileManager.getGroupDir(group)) + "/protocols";
        HashMap linesByMillis = new HashMap();
        File dirF = new File(dir);
        String[] files = dirF.list();
        TreeSet<String> ts = new TreeSet<String>();
        try {
            String path;
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".zip")) {
                    ts.add(String.valueOf(dir) + "/" + files[i]);
                }
                ++i;
            }
            Iterator iterator = ts.iterator();
            while (iterator.hasNext()) {
                path = (String)iterator.next();
                ReportCrawler2.checkZip(path, objectType, startToCheck, linesByMillis);
            }
            ts.clear();
            i = 0;
            while (i < files.length) {
                if (!files[i].endsWith(".zip") && files[i].startsWith(objectType)) {
                    ts.add(String.valueOf(dir) + "/" + files[i]);
                }
                ++i;
            }
            Iterator iterator2 = ts.iterator();
            while (iterator2.hasNext()) {
                path = (String)iterator2.next();
                ReportCrawler2.checkString(new FileReader(path), startToCheck, linesByMillis);
            }
        }
        catch (Exception e) {
            System.out.println("Riesenkack " + e);
        }
    }

    private static void checkString(Reader input, String startToCheck, HashMap linesByMillis) {
        BufferedReader br = new BufferedReader(input);
        try {
            String line = br.readLine();
            while (line != null) {
                if (line.startsWith(startToCheck)) {
                    VALS.clear();
                    String hline = line.substring(startToCheck.length(), line.length());
                    int ind = hline.indexOf(";");
                    if (ind != -1) {
                        String dats = hline.substring(0, ind);
                        String rest = hline.substring(ind + 1, hline.length());
                        Zeile z = new Zeile(rest, ' ');
                        if (z.size() > 3) {
                            int i = 3;
                            while (i < z.size() - 1) {
                                String vLine = z.getString(i, "");
                                int glind = vLine.indexOf("=");
                                if (glind != -1) {
                                    String key = vLine.substring(0, glind);
                                    String akey = (String)IDObjectXMLHandler.KEY_DICT_HER.get(key);
                                    if (akey != null) {
                                        key = akey;
                                    }
                                    VALS.put(key, vLine.substring(glind + 1, vLine.length()));
                                }
                                ++i;
                            }
                        }
                        System.out.println("----------------------------------------------");
                        System.out.println(dats);
                        System.out.println("----------------------------------------------");
                        Iterator iterator = VALS.keySet().iterator();
                        while (iterator.hasNext()) {
                            String key = (String)iterator.next();
                            String val = (String)VALS.get(key);
                            if (val.startsWith("S@")) {
                                val = (String)IDObjectXMLHandler.getObject(val);
                            } else if (val.startsWith("I@")) {
                                val = val.substring(2, val.length());
                            } else if (val.startsWith("L@")) {
                                val = val.substring(2, val.length());
                            } else if (val.startsWith("DT@")) {
                                try {
                                    long l = Long.parseLong(val.substring(3, val.length()));
                                    GREG.setTimeInMillis(l * 1000L);
                                    MyDate md = new MyDate(GREG);
                                    val = DatumFormat.getProtDateTimeString(md);
                                }
                                catch (Exception l) {}
                            } else if (val.startsWith("V[@")) {
                                TSB.setLength(0);
                                Vector v = StringHelper.splitStringByAny(val.substring(3, val.length()), "|");
                                Iterator iterator2 = v.iterator();
                                while (iterator2.hasNext()) {
                                    MyDate md;
                                    String visS = (String)iterator2.next();
                                    Zeile zz = new Zeile(visS, '$');
                                    TSB.append(zz.getString(0, "")).append(" | ");
                                    TSB.append(zz.getString(1, "")).append(" | ");
                                    long l = zz.getLong(2, 0L);
                                    if (l != 0L) {
                                        GREG.setTimeInMillis(l * 1000L);
                                        md = new MyDate(GREG);
                                        TSB.append(DatumFormat.getProtDateTimeString(md));
                                    }
                                    TSB.append(" | ");
                                    TSB.append(zz.getString(3, "")).append(" | ");
                                    l = zz.getLong(4, 0L);
                                    if (l != 0L) {
                                        GREG.setTimeInMillis(l);
                                        md = new MyDate(GREG);
                                        TSB.append(DatumFormat.getProtDateTimeString(md));
                                    }
                                    TSB.append(" | ");
                                    TSB.append(zz.getString(5, "")).append("\n");
                                }
                                val = TSB.toString();
                            }
                            System.out.println(ReportCrawler2.makeOutoput(key, val).trim());
                        }
                    }
                }
                line = br.readLine();
            }
        }
        catch (Exception e) {
            System.out.println("Kack " + e);
        }
    }

    private static String makeOutoput(String key, String msg) {
        msg = msg.replaceAll("\r\n", "\n");
        msg = msg.replaceAll("\r", "\n");
        msg = msg.replaceAll("\t", " ");
        msg = msg.trim();
        Vector v = StringHelper.splitStringByAny(msg, "\n");
        Vector<String> broken = new Vector<String>();
        int i = 0;
        while (i < v.size()) {
            String line = (String)v.elementAt(i);
            int relevantWidth = 131 - (key.length() > 19 ? key.length() + 1 : 19);
            while (line.length() > relevantWidth) {
                broken.add(line.substring(0, relevantWidth));
                line = line.substring(relevantWidth, line.length());
                relevantWidth = 131;
            }
            if (line.length() != 0) {
                broken.add(line);
            }
            ++i;
        }
        OSB.setLength(0);
        i = 0;
        while (i < broken.size()) {
            int lsofar = 0;
            if (i == 0) {
                OSB.append(key);
                lsofar = key.length();
            }
            while (lsofar < 19) {
                OSB.append(" ");
                ++lsofar;
            }
            OSB.append(broken.elementAt(i)).append("\n");
            ++i;
        }
        return OSB.toString();
    }

    public static void checkZip(String zipPath, String entryPrefix, String startToCheck, HashMap linesByMillis) {
        block7: {
            try {
                ZipInputStream zin;
                File f = new File(zipPath);
                if (!f.exists() || (zin = new ZipInputStream(new FileInputStream(f))) == null) break block7;
                try {
                    ZipEntry entry = zin.getNextEntry();
                    while (entry != null) {
                        String name = entry.getName();
                        if (name.startsWith(entryPrefix)) {
                            int readbyte;
                            ByteArrayOutputStream myOut = new ByteArrayOutputStream();
                            byte[] mybuf = new byte[1024];
                            while ((readbyte = zin.read(mybuf)) > 0) {
                                myOut.write(mybuf, 0, readbyte);
                            }
                            String res = new String(myOut.toByteArray());
                            myOut.close();
                            ReportCrawler2.checkString(new StringReader(res), startToCheck, linesByMillis);
                        }
                        entry = zin.getNextEntry();
                    }
                }
                catch (Exception e) {
                    System.out.println("Problem beim Ueberpruefen der Datei innen " + entryPrefix + " im Zip " + zipPath);
                }
                zin.close();
            }
            catch (Exception e) {
                System.out.println("Problem beim Ueberpruefen der Datei " + entryPrefix + " im Zip " + zipPath);
            }
        }
    }
}

