/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.factsheets.FactSheet;
import mausoleum.factsheets.IDObjectMerker;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.DatumFormat;
import mausoleum.mouse.Mouse;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.rack.Rack;
import mausoleum.room.Room;
import mausoleum.ui.UIDef;
import mausoleum.visit.Visit;

public class FactSheetCage
extends FactSheet {
    public int addPrintElements(String group, Object object, int y, int width, Vector target, HashSet selection, String sonderVorspann) {
        int lw = 120;
        int rx = lw + UIDef.INNER_RAND;
        int rw = width - rx;
        if (object instanceof Cage) {
            Cage cage = (Cage)object;
            int[] yBeiAusgabeStart = new int[1];
            y = FactSheetCage.createStandardStartLines(cage, String.valueOf(Babel.get("FS_C_FOR_CAGE")) + " " + cage.getLabelIDString(), y, rx, width, target, yBeiAusgabeStart, sonderVorspann);
            int yMitCageCard = yBeiAusgabeStart[0];
            if (cage.isAliveAndVisible()) {
                PrintElementFactSheet peCageCard;
                int cageCardWidth = 250;
                if (cageCardWidth > width / 2) {
                    cageCardWidth = width / 2;
                }
                if ((peCageCard = LabelPrinter.getCageCardAsPrintElementFactSheet(cage, 0, yBeiAusgabeStart[0], cageCardWidth)) != null) {
                    int ccw = peCageCard.ivWidth;
                    int ccx = width - ccw;
                    int cch = peCageCard.ivHeight;
                    peCageCard.ivX = ccx;
                    target.add(peCageCard);
                    target.add(PrintElementFactSheet.getBoxElement(ccx, yBeiAusgabeStart[0], ccw, cch, 0.5f));
                    yMitCageCard += cch;
                    rw -= ccw + UIDef.INNER_RAND;
                }
            }
            String alle = Babel.get("FS_C_ALL_MEMBERS");
            String rein = cage.getOwnerAllString(alle);
            String userLink = null;
            userLink = rein == alle ? IDObjectMerker.getLink(UserManager.getActualHandlingUsers(cage.getGroup()), null) : IDObjectMerker.getLink(cage.getOwnerObjects(), null);
            y = FactSheetCage.addLongText(Babel.get("FS_M_OWNER"), rein, rx, rw, y, target, null, userLink);
            char mark = cage.getChar("CAG_FLAG");
            if (mark == '\u0001') {
                y = FactSheetCage.addLine(Babel.get("FS_MARK"), "\u261e", rx, y, target);
            } else if (mark != '\u0000') {
                char[] ica = new char[]{mark};
                y = FactSheetCage.addLine(Babel.get("FS_MARK"), new String(ica), rx, y, target);
            }
            y = FactSheetCage.addStringAttrLine(Babel.get("FS_AN_TAG"), cage, "CAG_ANTAG", rx, y, target);
            y += 5;
            Rack rack = cage.getSuperCageIfThere().getRack();
            if (rack != null) {
                y = FactSheetCage.addLine(Babel.get("FS_RACK"), rack.getName(), rx, y, target, null, IDObjectMerker.getLink(rack, null));
                Room room = (Room)ObjectStore.getClientObject(10, rack.getLong("RCK_ROOM", 0L), rack.getGroup());
                if (room != null) {
                    y = FactSheetCage.addLine(Babel.get("FS_ROOM"), room.getString("ROM_NAME", Babel.get("unknown")), rx, y, target, null, IDObjectMerker.getLink(room, null));
                }
                y += 5;
            }
            Vector actMice = new Vector();
            cage.addActualMice(actMice);
            if (!actMice.isEmpty()) {
                y = actMice.size() == 1 ? FactSheetCage.addLine(Babel.get("FS_C_ACT_MICE"), "1 " + Babel.get("FS_MOUSE"), rx, y, target, null, IDObjectMerker.getLink(actMice, null)) : FactSheetCage.addLine(Babel.get("FS_C_ACT_MICE"), String.valueOf(actMice.size()) + " " + Babel.get("FS_MICE"), rx, y, target, null, IDObjectMerker.getLink(actMice, null));
            }
            Vector allMice = cage.getAllMiceEverVisited();
            HashMap<Object, Mouse> allMiceByID = new HashMap<Object, Mouse>();
            if (!allMice.isEmpty()) {
                Iterator iter = allMice.iterator();
                while (iter.hasNext()) {
                    Mouse mouse = (Mouse)iter.next();
                    allMiceByID.put(mouse.get("IDO_ID"), mouse);
                }
                y = allMice.size() == 1 ? FactSheetCage.addLine(Babel.get("FS_C_ALL_MICE"), "1 " + Babel.get("FS_MOUSE"), rx, y, target, null, IDObjectMerker.getLink(allMice, null)) : FactSheetCage.addLine(Babel.get("FS_C_ALL_MICE"), String.valueOf(allMice.size()) + " " + Babel.get("FS_MICE"), rx, y, target, null, IDObjectMerker.getLink(allMice, null));
                allMice.clear();
            }
            y += 5;
            HashSet sammler = new HashSet();
            String typs = AllgUtils.getTypeString(cage, cage.getActualMice(), 0, sammler, true);
            if (typs != null) {
                y = FactSheetCage.addLongText(Babel.get("FS_C_LINES"), typs, rx, rw, y, target, null, IDObjectMerker.getLink(sammler, null));
            }
            if ((typs = AllgUtils.getTypeString(cage, cage.getActualMice(), 2, true)) != null) {
                y = FactSheetCage.addLongText(Babel.get("FS_C_GENOTYPES"), typs, rx, rw, y, target, null, null);
            }
            sammler.clear();
            typs = AllgUtils.getTypeString(cage, cage.getActualMice(), 1, sammler, true);
            if (typs != null) {
                y = FactSheetCage.addLongText(Babel.get("FS_C_STRAINS"), typs, rx, rw, y, target, null, IDObjectMerker.getLink(sammler, null));
            }
            if (y < yMitCageCard) {
                y = yMitCageCard;
            }
            y += 15;
            y = FactSheetCage.addLongStringSector(Babel.get("FS_COMMENT"), cage.getString("CAG_COMMENT", null), y, width, target);
            Visit[] varr = (Visit[])cage.get("CAG_VISIT");
            if (varr != null && varr.length != 0) {
                y = FactSheetCage.createPEHeader(y, target, Babel.get("FS_M_VISITS"), width);
                y = FactSheetCage.collectVisitElementLines(varr, allMiceByID, target, y, width);
                y += 15;
            }
        }
        return y;
    }

    private static int collectVisitElementLines(Visit[] varr, HashMap allMiceByID, Vector target, int y, int width) {
        Vector lines = new Vector();
        Vector<Integer> horizLineYPos = new Vector<Integer>();
        Vector<Integer> lineYs = new Vector<Integer>();
        horizLineYPos.add(new Integer(y));
        lineYs.add(new Integer(y));
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 4, Babel.get("FS_MOUSE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_START"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_END"), TABHEADER_FONT));
        y += TABHEADER_FONT.getSize() + 2;
        horizLineYPos.add(new Integer(y += 4));
        Vector<Visit> tv = new Vector<Visit>(varr.length);
        int i = 0;
        while (i < varr.length) {
            if (tv.isEmpty() || varr[i].ivEndDate != null) {
                tv.add(varr[i]);
            } else {
                tv.insertElementAt(varr[i], 0);
            }
            ++i;
        }
        varr = new Visit[tv.size()];
        i = 0;
        while (i < tv.size()) {
            varr[i] = (Visit)tv.elementAt(i);
            ++i;
        }
        i = 0;
        while (i < varr.length) {
            Mouse mouse = (Mouse)allMiceByID.get(new Long(varr[i].ivMouseID));
            if (mouse != null) {
                StringBuffer ssb;
                line = new Vector();
                lines.add(line);
                lineYs.add(new Integer(y));
                if (i == 0) {
                    y += 3;
                }
                if (varr[i].ivEndDate == null) {
                    line.add(PrintElementFactSheet.getTextElement(0, y, mouse.getIDStringForReports(false), FETT_FONT, IDObjectMerker.getLink(mouse, null)));
                    ssb = new StringBuffer();
                    ssb.append(DatumFormat.getJustDateString(varr[i].ivStartDate)).append(" ");
                    ssb.append(Visit.translateMode(varr[i].ivStartMode));
                    line.add(PrintElementFactSheet.getTextElement(0, y, ssb.toString(), FETT_FONT));
                    line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                } else {
                    line.add(PrintElementFactSheet.getTextElement(0, y, mouse.getIDStringForReports(false), STANDARD_FONT, IDObjectMerker.getLink(mouse, null)));
                    ssb = new StringBuffer();
                    ssb.append(DatumFormat.getJustDateString(varr[i].ivStartDate)).append(" ");
                    ssb.append(Visit.translateMode(varr[i].ivStartMode));
                    line.add(PrintElementFactSheet.getTextElement(0, y, ssb.toString(), STANDARD_FONT));
                    ssb = new StringBuffer();
                    ssb.append(DatumFormat.getJustDateString(varr[i].ivEndDate)).append(" ");
                    ssb.append(Visit.translateMode(varr[i].ivEndMode));
                    line.add(PrintElementFactSheet.getTextElement(0, y, ssb.toString(), STANDARD_FONT));
                }
                y += STANDARD_FONT.getSize() + 2;
            }
            ++i;
        }
        horizLineYPos.add(new Integer(y += 3));
        lineYs.add(new Integer(y));
        return FactSheetCage.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
    }
}

