/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Point;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.cage.colors.AgeColor;
import mausoleum.cage.colors.MouseCount;
import mausoleum.factsheets.FactSheet;
import mausoleum.factsheets.FactSheetFrame;
import mausoleum.factsheets.FactSheetQuotaReport;
import mausoleum.factsheets.FactSheetServiceInfo;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.factsheets.groupreport.GroupInfoCollector;
import mausoleum.factsheets.multidimreport.MultiDimAnalyzer;
import mausoleum.factsheets.multidimreport.MultiDimReportFrame;
import mausoleum.factsheets.service.ServiceLineCollector;
import mausoleum.factsheets.sessionreports.SessionReport;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.LogTrick;
import mausoleum.helper.Zeile;
import mausoleum.inspector.Inspector;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.requester.AllgPickRequester;
import mausoleum.requester.calendar.CalendarRequester;
import mausoleum.requester.mouse.MultiDeadProgressRequester;
import mausoleum.sonderreports.SonderReports;
import mausoleum.ui.UIDef;
import mausoleum.usergroup.UserGroup;
import mausoleum.usergroup.UsergroupManager;
import mausoleum.util.InstallationType;

public class FactSheetGroup
extends FactSheet {
    public static final String DEF_GROUP = "GROUP";
    public static final String DEF_START = "PD_START";
    public static final String DEF_END = "PD_END";
    public static final String SEL_TOTAL = "FS_M_TOTAL";
    public static final String SEL_LICENSE = "FS_GR_BY_LICENSE";
    public static final String SEL_RACK = "FS_GR_BY_RACK";
    public static final String SEL_ROOM = "FS_GR_BY_ROOM";
    public static final String SEL_LINE = "FS_GR_BY_LINE";
    public static final String SEL_STRAIN = "FS_GR_BY_STRAIN";
    public static final String SEL_USER = "FS_GR_BY_USER";
    public static final String SEL_EARTAG = "FS_GR_BY_EARTAG";
    public static final String SEL_AGE_DIAGRAM = "FS_GR_AGE_STRUCTURE";
    public static final String SEL_CAGE_FILL = "FS_GR_CAGE_FILL";
    public static final String NULL_STRING = "";
    public static final String LINK_TRENNER = "#\u00a7#";
    public static final String[] CHOICES = new String[]{"FS_M_TOTAL", "FS_GR_BY_LICENSE", "FS_GR_BY_RACK", "FS_GR_BY_ROOM", "FS_GR_BY_LINE", "FS_GR_BY_STRAIN", "FS_GR_BY_USER", "FS_GR_BY_EARTAG", "FS_GR_AGE_STRUCTURE"};
    private static final int REPORT_MODE_AD_HOC = 1;
    private static final int REPORT_MODE_PER_DIEM_SINGLE = 2;
    private static final int REPORT_MODE_PER_DIEM_PERIOD = 3;
    private static final int REPORT_MODE_SESSION = 4;
    private static final int REPORT_MODE_SERVICE_UNIT = 5;
    private static final int REPORT_MODE_LINES = 6;
    private static final int REPORT_MODE_GROUP = 7;
    private static final int REPORT_MODE_MULTIDIM_MOUSE = 8;
    private static final int REPORT_MODE_MULTIDIM_CAGE = 9;
    private static final int REPORT_MODE_QUOTA = 10;
    private static final int REPORT_MODE_MULTIDIM_TASK = 11;
    private static final int REPORT_MODE_MULTIDIM_DEAD_MICE = 12;
    public static final int REPORT_MODE_SONDER_AUFSCHLAG = 1000;
    private static final String[] REPORT_CHOICES = new String[]{Babel.get("AD_HOC_REPORT"), Babel.get("PER_DIEM_REPORT_SINGLE"), Babel.get("PER_DIEM_REPORT_PERIOD"), Babel.get("SESSION_REPORT"), Babel.get("MULTIDIM_ANALYSIS_MOUSE"), Babel.get("MULTIDIM_ANALYSIS_CAGE")};
    private static final int[] REPORT_MODES = new int[]{1, 2, 3, 4, 8, 9};
    private static final String[] REPORT_CHOICES_OHNE_SESSION = new String[]{Babel.get("AD_HOC_REPORT"), Babel.get("PER_DIEM_REPORT_SINGLE"), Babel.get("PER_DIEM_REPORT_PERIOD"), Babel.get("MULTIDIM_ANALYSIS_MOUSE"), Babel.get("MULTIDIM_ANALYSIS_CAGE")};
    private static final int[] REPORT_MODES_OHNE_SESSION = new int[]{1, 2, 3, 8, 9};
    private static final String[] REPORT_CHOICES_GURU = new String[]{Babel.get("AD_HOC_REPORT"), Babel.get("PER_DIEM_REPORT_SINGLE"), Babel.get("PER_DIEM_REPORT_PERIOD"), Babel.get("QUOTA_REPORT"), Babel.get("SESSION_REPORT"), Babel.get("MULTIDIM_ANALYSIS_MOUSE"), Babel.get("MULTIDIM_ANALYSIS_CAGE"), Babel.get("MULTIDIM_ANALYSIS_DEAD_MICE")};
    private static final int[] REPORT_MODES_GURU = new int[]{1, 2, 3, 10, 4, 8, 9, 12};
    private static final String[] REPORT_CHOICES_OHNE_SESSION_GURU = new String[]{Babel.get("AD_HOC_REPORT"), Babel.get("PER_DIEM_REPORT_SINGLE"), Babel.get("PER_DIEM_REPORT_PERIOD"), Babel.get("QUOTA_REPORT"), Babel.get("MULTIDIM_ANALYSIS_MOUSE"), Babel.get("MULTIDIM_ANALYSIS_CAGE"), Babel.get("MULTIDIM_ANALYSIS_DEAD_MICE")};
    private static final int[] REPORT_MODES_OHNE_SESSION_GURU = new int[]{1, 2, 3, 10, 8, 9, 12};
    private static final String[] REPORT_CHOICES_OHNE_SESSION_HOS = new String[]{Babel.get("AD_HOC_REPORT"), Babel.get("PER_DIEM_REPORT_SINGLE"), Babel.get("PER_DIEM_REPORT_PERIOD")};
    private static final int[] REPORT_MODES_OHNE_SESSION_HOS = new int[]{1, 2, 3};
    private static final String[] REPORT_CHOICES_HEAD_OF_SERVICE = new String[]{Babel.get("SERVICE_UNIT_REPORT"), Babel.get("LINES_REPORT"), Babel.get("GROUP_REPORT"), Babel.get("QUOTA_REPORT"), Babel.get("MULTIDIM_ANALYSIS_MOUSE"), Babel.get("MULTIDIM_ANALYSIS_CAGE"), Babel.get("MULTIDIM_ANALYSIS_DEAD_MICE")};
    private static final int[] REPORT_MODES_HEAD_OF_SERVICE = new int[]{5, 6, 7, 10, 8, 9, 12};
    private static String[] cvReportChoicesHOSWithSonder = null;
    private static int[] cvReportModesHOSWithSonder = null;
    private static HashSet cvHOSSonderChoices = new HashSet();
    private static final DecimalFormat DEC_FORMAT = new DecimalFormat("#,##0.#");
    private static final int DIAGRAM_MODE_AGE = 1;
    private static final int DIAGRAM_MODE_MOUSE_COUNT = 2;

    public static void showAdHocGroupReportClientSide(String group) {
        GroupInfoCollector gic = GroupInfoCollector.collectInfosForAdHocGroupReportClientSide(group);
        if (gic != null) {
            Vector<GroupInfoCollector> v = new Vector<GroupInfoCollector>();
            v.add(gic);
            FactSheetFrame.showTab(group, v, Babel.get("FS_GROUP_HEADER"));
        }
    }

    public static boolean groupReportForHeadOfService(Vector userGroups) {
        int[] modeAndDates;
        if (MausoleumClient.isHeadOfService() && (modeAndDates = FactSheetGroup.getReportModeAndDates(REPORT_CHOICES_OHNE_SESSION_HOS, REPORT_MODES_OHNE_SESSION_HOS, null)) != null) {
            Point dates = null;
            byte request = 0;
            if (modeAndDates[0] == 1) {
                request = 34;
            } else {
                request = 54;
                dates = new Point(modeAndDates[1], modeAndDates[2]);
            }
            Vector<Object> sammler = new Vector<Object>();
            Iterator iter = userGroups.iterator();
            while (iter.hasNext()) {
                UserGroup ug = (UserGroup)iter.next();
                Object ooo = RequestManager.createSendAndGetObjectIfFinished(request, ug.getName(), UserManager.getFirstGroup(), dates);
                if (ooo == null) continue;
                sammler.add(ooo);
            }
            if (!sammler.isEmpty()) {
                FactSheetFrame.showTab(UserManager.getFirstGroup(), sammler, Babel.get("FS_GROUP_HEADER"));
                return true;
            }
            Alert.showAlert(Babel.get("NO_DATA_AVAILABLE"), true);
        }
        return false;
    }

    public static void groupReportForReportButton() {
        int[] modeAndDates;
        if (MausoleumClient.isRegularOrTGService()) {
            int[] modeAndDates2 = FactSheetGroup.getReportModeAndDates();
            if (modeAndDates2 != null) {
                if (modeAndDates2[0] == 1) {
                    FactSheetGroup.showAdHocGroupReportClientSide(UserManager.getFirstGroup());
                } else if (modeAndDates2[0] == 4) {
                    SessionReport.showSessionReport();
                } else if (modeAndDates2[0] == 10) {
                    FactSheetQuotaReport.makeQuotaReport();
                } else if (modeAndDates2[0] == 8) {
                    new MultiDimReportFrame(null, 1, -1, null);
                } else if (modeAndDates2[0] == 9) {
                    int cageMode = AllgChoiceRequester.getIntAnswer(Inspector.getInspector(), Babel.get("MD_CAGE_MODE_SELECT"), MultiDimAnalyzer.CAGE_MODE_STRINGS, MultiDimAnalyzer.CAGE_MODE_INTS, -1);
                    if (cageMode != -1) {
                        new MultiDimReportFrame(null, 2, cageMode, null);
                    }
                } else if (modeAndDates2[0] == 11) {
                    new MultiDimReportFrame(null, 15, -1, null);
                } else if (modeAndDates2[0] == 12) {
                    FactSheetGroup.startDeadMulti(UserManager.getFirstGroup(), modeAndDates2);
                } else {
                    FactSheetGroup.showPerDiemReport(UserManager.getFirstGroup(), modeAndDates2);
                }
            }
        } else if (MausoleumClient.isServiceCaretaker()) {
            if (SessionReport.cvSessionReportAvailable) {
                SessionReport.showSessionReport();
            }
        } else if (MausoleumClient.isHeadOfService() && (modeAndDates = FactSheetGroup.getReportModeAndDates()) != null) {
            if (modeAndDates[0] == 5) {
                FactSheetServiceInfo.createServiceReport();
            } else if (modeAndDates[0] == 6) {
                Object ooo = RequestManager.createSendAndGetObjectIfFinished((byte)61, null, UserManager.getFirstGroup());
                if (ooo != null) {
                    Vector<ServiceLineCollector> sammler = new Vector<ServiceLineCollector>();
                    sammler.add(new ServiceLineCollector((TreeMap)ooo));
                    FactSheetFrame.showTab(UserManager.getFirstGroup(), sammler, Babel.get("FS_SERV_LINE_OVERVIEW"));
                }
            } else if (modeAndDates[0] == 7) {
                Vector groups = AllgPickRequester.pickFromList(Inspector.getInspector(), UsergroupManager.cvInstance.getActualObjectVectorAllGroups(), "SELECT_GROUP", "GROUPS", new int[]{1, 2}, new String[]{"APR_SELECT_ALL", "APR_SELECT_NONE"}, 2);
                if (groups != null) {
                    FactSheetFrame.showTab(groups, Babel.get("FS_HEADER"));
                }
            } else if (modeAndDates[0] == 10) {
                FactSheetQuotaReport.makeQuotaReport();
            } else if (modeAndDates[0] == 8) {
                new MultiDimReportFrame(null, 1, -1, null);
            } else if (modeAndDates[0] == 12) {
                FactSheetGroup.startDeadMulti(NULL_STRING, modeAndDates);
            } else if (modeAndDates[0] == 9) {
                int cageMode = AllgChoiceRequester.getIntAnswer(Inspector.getInspector(), Babel.get("MD_CAGE_MODE_SELECT"), MultiDimAnalyzer.CAGE_MODE_STRINGS, MultiDimAnalyzer.CAGE_MODE_INTS, -1);
                if (cageMode != -1) {
                    new MultiDimReportFrame(null, 2, cageMode, null);
                }
            } else if (modeAndDates[0] == 11) {
                new MultiDimReportFrame(null, 15, -1, null);
            } else if (modeAndDates[0] > 1000) {
                modeAndDates[0] = modeAndDates[0] - 1000;
                SonderReports.modeAndDatesSelected(modeAndDates);
            }
        }
    }

    private static void startDeadMulti(String group, int[] modeAndDates) {
        new MultiDeadProgressRequester((Frame)Inspector.getInspector(), String.valueOf(group) + "|" + modeAndDates[1] + "|" + modeAndDates[2]);
    }

    private static int[] getReportModeAndDates() {
        HashSet sonderChoices = null;
        String[] choices = null;
        int[] modes = null;
        if (MausoleumClient.isHeadOfService()) {
            sonderChoices = cvHOSSonderChoices;
            if (cvReportChoicesHOSWithSonder == null) {
                cvReportChoicesHOSWithSonder = SonderReports.enrichHOSReportStrings(REPORT_CHOICES_HEAD_OF_SERVICE, cvHOSSonderChoices);
            }
            choices = cvReportChoicesHOSWithSonder;
            if (cvReportModesHOSWithSonder == null) {
                cvReportModesHOSWithSonder = SonderReports.enrichHOSReportModes(REPORT_MODES_HEAD_OF_SERVICE);
            }
            modes = cvReportModesHOSWithSonder;
        } else {
            boolean ses = SessionReport.cvSessionReportAvailable;
            if (UserManager.cvIsGURU) {
                choices = ses ? REPORT_CHOICES_GURU : REPORT_CHOICES_OHNE_SESSION_GURU;
                modes = ses ? REPORT_MODES_GURU : REPORT_MODES_OHNE_SESSION_GURU;
            } else {
                choices = ses ? REPORT_CHOICES : REPORT_CHOICES_OHNE_SESSION;
                modes = ses ? REPORT_MODES : REPORT_MODES_OHNE_SESSION;
            }
        }
        return FactSheetGroup.getReportModeAndDates(choices, modes, sonderChoices);
    }

    private static int[] getReportModeAndDates(String[] choices, int[] modes, HashSet extraChoices) {
        int[] res = null;
        int ind = AllgChoiceRequester.getIndexAnswer(Inspector.getInspector(), Babel.get("SELECT_REPORT_TYPE"), choices, false, true, extraChoices);
        if (ind != -1) {
            boolean needsStartAndEnd = false;
            int mode = modes[ind];
            needsStartAndEnd = mode == 1 || mode == 4 || mode == 5 || mode == 6 || mode == 7 || mode == 8 || mode == 9 || mode == 11 || mode == 10 ? false : (mode > 1000 ? SonderReports.needsStartAndEnd(mode - 1000) : true);
            if (!needsStartAndEnd) {
                res = new int[3];
                res[0] = mode;
            } else {
                Date start;
                String titel = Babel.get("SELECT_START_DATE");
                if (mode == 2) {
                    titel = Babel.get("SELECT_DATE");
                }
                if ((start = CalendarRequester.getDate(Inspector.getInspector(), titel)) != null) {
                    Date end = null;
                    if (mode == 2) {
                        end = start;
                    } else if (mode == 12) {
                        titel = Babel.get("SELECT_END_DATE");
                        GregorianCalendar gc = new GregorianCalendar();
                        gc.setTime(start);
                        MyDate minMD = new MyDate(gc);
                        int minimum = minMD.getTage();
                        int maximum = minimum + 366;
                        if (maximum > MyDate.HEUTE) {
                            maximum = MyDate.HEUTE;
                        }
                        end = CalendarRequester.getDate(Inspector.getInspector(), minMD, new MyDate(maximum), titel);
                    } else {
                        titel = Babel.get("SELECT_END_DATE");
                        end = CalendarRequester.getDate(Inspector.getInspector(), titel);
                    }
                    if (end != null) {
                        res = new int[]{mode, (int)(start.getTime() / 86400000L), (int)(end.getTime() / 86400000L)};
                    }
                }
            }
        }
        return res;
    }

    public static void showPerDiemReport(String group, int[] modeAndDates) {
        Object ooo = RequestManager.createSendAndGetObjectIfFinished((byte)54, group, UserManager.getFirstGroup(), new Point(modeAndDates[1], modeAndDates[2]));
        if (ooo != null) {
            Vector<Object> v = new Vector<Object>();
            v.add(ooo);
            FactSheetFrame.showTab(group, v, Babel.get("FS_GROUP_HEADER"));
        } else {
            Alert.showAlert(Babel.get("NO_DATA_AVAILABLE"), true);
        }
    }

    public int addPrintElements(String group, Object object, int y, int width, Vector target, HashSet selection, String sonderVorspann) {
        if (object instanceof GroupInfoCollector) {
            GroupInfoCollector gic = (GroupInfoCollector)object;
            int lw = 120;
            int rx = lw + UIDef.INNER_RAND;
            String mainTitel = String.valueOf(Babel.get("FS_GR_FOR_GROUP")) + " " + gic.get(DEF_GROUP);
            if (gic.isPerDiem()) {
                String sS = (String)gic.get(DEF_START);
                String sE = (String)gic.get(DEF_END);
                if (sS != null && sE != null) {
                    try {
                        int start = Integer.parseInt(sS);
                        int ende = Integer.parseInt(sE);
                        mainTitel = start == ende ? String.valueOf(mainTitel) + " (" + DatumFormat.getJustDateString(start) + ") " : String.valueOf(mainTitel) + " (" + DatumFormat.getJustDateString(start) + " - " + DatumFormat.getJustDateString(ende) + ") ";
                    }
                    catch (Exception start) {
                        // empty catch block
                    }
                }
            }
            y = FactSheetGroup.createStandardStartLines(null, mainTitel, y, rx, width, target, null, sonderVorspann);
            Vector lines = new Vector();
            Vector<Integer> horizLineYPos = new Vector<Integer>();
            Vector<Integer> lineYs = new Vector<Integer>();
            Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
            lines.add(line);
            horizLineYPos.add(new Integer(y));
            lineYs.add(new Integer(y));
            y += 4;
            int colspan = 0;
            if (gic.isPerDiem()) {
                line.add(PrintElementFactSheet.getTextElement(0, y, NULL_STRING, FactSheet.TABHEADER_FONT));
                colspan = 3;
                FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, Babel.get("MICE"), TABHEADER_FONT, 0), colspan);
                FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_CAGES"), TABHEADER_FONT, 0), colspan);
                if (InstallationType.useMatings()) {
                    FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_MATINGS"), TABHEADER_FONT, 0), colspan);
                }
            } else {
                line.add(PrintElementFactSheet.getTextElement(0, y, DatumFormat.getDateTimeString(System.currentTimeMillis()), FactSheet.TABHEADER_FONT));
                FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, DefaultManager.getMale(), TABHEADER_FONT, 0), colspan);
                FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, DefaultManager.getFemale(), TABHEADER_FONT, 0), colspan);
                FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, "?", TABHEADER_FONT, 0), colspan);
                FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, "T", TABHEADER_FONT, 0), colspan);
                FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_CAGES"), TABHEADER_FONT, 0), colspan);
                if (InstallationType.useMatings()) {
                    FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_MATINGS"), TABHEADER_FONT, 0), colspan);
                }
            }
            y += TABHEADER_FONT.getSize() + 2;
            horizLineYPos.add(new Integer(y += 4));
            lineYs.add(new Integer(y));
            y += 4;
            if (gic.isPerDiem()) {
                line = new Vector();
                lines.add(line);
                FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, NULL_STRING, TABHEADER_FONT, 0), 0);
                FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, "\u00d8", TABHEADER_FONT, 0), 0);
                FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, "min", TABHEADER_FONT, 0), 0);
                FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, "max", TABHEADER_FONT, 0), 0);
                FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, "\u00d8", TABHEADER_FONT, 0), 0);
                FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, "min", TABHEADER_FONT, 0), 0);
                FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, "max", TABHEADER_FONT, 0), 0);
                if (InstallationType.useMatings()) {
                    FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, "\u00d8", TABHEADER_FONT, 0), 0);
                    FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, "min", TABHEADER_FONT, 0), 0);
                    FactSheetGroup.addHeader(line, PrintElementFactSheet.getTextElement(0, y, "max", TABHEADER_FONT, 0), 0);
                }
                y += TABHEADER_FONT.getSize() + 2;
                horizLineYPos.add(new Integer(y += 4));
                lineYs.add(new Integer(y));
                y += 4;
            }
            line = new Vector();
            lines.add(line);
            Vector v = (Vector)gic.get(SEL_TOTAL);
            if (v != null && !v.isEmpty()) {
                FactSheetGroup.addValues(Base64Manager.encodeBase64(Babel.get(SEL_TOTAL)), line, y, (String)v.firstElement(), gic.isPerDiem());
                y += FETT_FONT.getSize() + 2 + 4;
            }
            y = FactSheetGroup.makeBlock(selection, SEL_LICENSE, gic, lines, y, lineYs, horizLineYPos, gic.isPerDiem());
            y = FactSheetGroup.makeBlock(selection, SEL_RACK, gic, lines, y, lineYs, horizLineYPos, gic.isPerDiem());
            y = FactSheetGroup.makeBlock(selection, SEL_ROOM, gic, lines, y, lineYs, horizLineYPos, gic.isPerDiem());
            y = FactSheetGroup.makeBlock(selection, SEL_LINE, gic, lines, y, lineYs, horizLineYPos, gic.isPerDiem());
            y = FactSheetGroup.makeBlock(selection, SEL_STRAIN, gic, lines, y, lineYs, horizLineYPos, gic.isPerDiem());
            y = FactSheetGroup.makeBlock(selection, SEL_USER, gic, lines, y, lineYs, horizLineYPos, gic.isPerDiem());
            if ((selection == null || selection.contains(SEL_EARTAG)) && (v = (Vector)gic.get(SEL_EARTAG)) != null && v.size() == 2) {
                line = new Vector();
                lines.add(line);
                FactSheetGroup.addValues(Base64Manager.encodeBase64(Babel.get("FS_GR_WITHEARTAG")), line, y += 4, (String)v.elementAt(0), gic.isPerDiem());
                line = new Vector();
                lines.add(line);
                FactSheetGroup.addValues(Base64Manager.encodeBase64(Babel.get("FS_GR_WITHOUTEARTAG")), line, y += FETT_FONT.getSize() + 2, (String)v.elementAt(1), gic.isPerDiem());
                y += FETT_FONT.getSize() + 2;
                y += 4;
            }
            horizLineYPos.add(new Integer(y));
            lineYs.add(new Integer(y));
            HashSet<Integer> wantedVerticalLineIndices = null;
            if (gic.isPerDiem()) {
                wantedVerticalLineIndices = new HashSet<Integer>();
                wantedVerticalLineIndices.add(new Integer(0));
                wantedVerticalLineIndices.add(new Integer(1));
                wantedVerticalLineIndices.add(new Integer(4));
                wantedVerticalLineIndices.add(new Integer(7));
                wantedVerticalLineIndices.add(new Integer(10));
                wantedVerticalLineIndices.add(new Integer(13));
                wantedVerticalLineIndices.add(new Integer(16));
                wantedVerticalLineIndices.add(new Integer(19));
            }
            y = FactSheetGroup.createTable(lines, horizLineYPos, target, width, lineYs, wantedVerticalLineIndices, null);
            y = FactSheetGroup.createSimpleCountDiagram(selection, SEL_AGE_DIAGRAM, gic, target, y, width, Babel.get("FS_GR_AGE_MONTHS"), 1);
            y = FactSheetGroup.createSimpleCountDiagram(selection, SEL_CAGE_FILL, gic, target, y, width, Babel.get("FS_GR_CAGE_FILLS"), 2);
        }
        return y;
    }

    private static void addHeader(Vector line, PrintElementFactSheet pen, int colspan) {
        pen.ivColspan = colspan;
        line.add(pen);
    }

    private static int makeBlock(HashSet selection, String selKey, GroupInfoCollector gic, Vector lines, int y, Vector lineYs, Vector horizLineYPos, boolean isPerDiem) {
        Vector dataLines;
        if ((selection == null || selection.contains(selKey)) && (dataLines = (Vector)gic.get(selKey)) != null) {
            horizLineYPos.add(new Integer(y));
            lineYs.add(new Integer(y));
            y = FactSheetGroup.addZwischentitel(Babel.get(selKey), lines, y, lineYs);
            y = FactSheetGroup.addValues(dataLines, lines, y, lineYs, isPerDiem);
            horizLineYPos.add(new Integer(y += 4));
            lineYs.add(new Integer(y));
        }
        return y;
    }

    private static int addZwischentitel(String titel, Vector lines, int y, Vector lineYs) {
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 4, titel, FactSheet.TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, NULL_STRING, TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, NULL_STRING, TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, NULL_STRING, TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, NULL_STRING, TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, NULL_STRING, TABHEADER_FONT));
        if (InstallationType.useMatings()) {
            line.add(PrintElementFactSheet.getTextElement(0, y, NULL_STRING, TABHEADER_FONT));
        }
        lineYs.add(new Integer(y += TABHEADER_FONT.getSize() + 2 + 4));
        return y;
    }

    private static final int addValues(Vector griLines, Vector lines, int y, Vector lineYs, boolean isPerDiem) {
        if (griLines != null) {
            Iterator iter = griLines.iterator();
            while (iter.hasNext()) {
                String griLine = (String)iter.next();
                Vector line = new Vector();
                lines.add(line);
                lineYs.add(new Integer(y));
                FactSheetGroup.addValues(null, line, y, griLine, isPerDiem);
                y += FETT_FONT.getSize() + 2;
            }
        }
        return y;
    }

    private static final void addValues(String titel, Vector line, int y, String grlTS, boolean isPerDiem) {
        Zeile z = new Zeile(grlTS, '|');
        String titelLink = null;
        if (titel == null) {
            titel = z.getString(0, NULL_STRING);
        }
        if (titel.trim().length() == 0) {
            titel = Base64Manager.encodeBase64(Babel.get("NONE"));
        } else {
            int ind = titel.indexOf(LINK_TRENNER);
            if (ind != -1) {
                titelLink = titel.substring(ind + LINK_TRENNER.length(), titel.length());
                titel = titel.substring(0, ind);
            }
        }
        line.add(PrintElementFactSheet.getTextElement(0, y, Base64Manager.getDecodedString(titel), STANDARD_FONT, titelLink));
        if (isPerDiem) {
            FactSheetGroup.addValue(z.getString(4, NULL_STRING), line, y);
            FactSheetGroup.addValue(z.getString(5, NULL_STRING), line, y);
            if (InstallationType.useMatings()) {
                FactSheetGroup.addValue(z.getString(6, NULL_STRING), line, y);
            }
        } else {
            FactSheetGroup.addValue(z.getString(1, NULL_STRING), line, y);
            FactSheetGroup.addValue(z.getString(2, NULL_STRING), line, y);
            FactSheetGroup.addValue(z.getString(3, NULL_STRING), line, y);
            FactSheetGroup.addValue(z.getString(4, NULL_STRING), line, y);
            FactSheetGroup.addValue(z.getString(5, NULL_STRING), line, y);
            if (InstallationType.useMatings()) {
                FactSheetGroup.addValue(z.getString(6, NULL_STRING), line, y);
            }
        }
    }

    private static final void addValue(String part, Vector line, int y) {
        if (part == null || part.trim().length() == 0) {
            line.add(PrintElementFactSheet.getTextElement(0, y, NULL_STRING, FETT_FONT));
        } else {
            Zeile z;
            String link = null;
            int ind = part.indexOf("@");
            if (ind != -1) {
                try {
                    link = Base64Manager.getDecodedString(part.substring(ind + 1, part.length()), NULL_STRING);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                part = part.substring(0, ind);
            }
            if ((z = new Zeile(part, '=')).size() == 1) {
                int anz = z.getInt(0, 0);
                String zahl = anz == 0 ? NULL_STRING : Integer.toString(anz);
                FactSheetGroup.addSingleValue(zahl, link, line, y);
            } else {
                double average = z.getDouble(0, 0.0);
                int minimum = z.getInt(1, 0);
                int maximum = z.getInt(2, 0);
                String zahl = average == 0.0 ? NULL_STRING : StringHelper.EINNKS_FORMATTER.format(average);
                FactSheetGroup.addSingleValue(zahl, link, line, y);
                zahl = minimum == 0 && maximum == 0 ? NULL_STRING : Integer.toString(minimum);
                FactSheetGroup.addSingleValue(zahl, link, line, y);
                zahl = minimum == 0 && maximum == 0 ? NULL_STRING : Integer.toString(maximum);
                FactSheetGroup.addSingleValue(zahl, link, line, y);
            }
        }
    }

    private static void addSingleValue(String zahl, String link, Vector line, int y) {
        PrintElementFactSheet pen = PrintElementFactSheet.getTextElement(0, y, zahl, FETT_FONT, 4);
        if (link != null && link.trim().length() != 0) {
            pen.ivLink = link;
        }
        line.add(pen);
    }

    private static int createSimpleCountDiagram(HashSet selection, String selKey, GroupInfoCollector gic, Vector target, int y, int width, String xLegend, int backgroundMode) {
        String data;
        if ((selection == null || selection.contains(selKey)) && (data = (String)gic.get(selKey)) != null) {
            Zeile z = new Zeile(data, '|');
            int maxXValue = z.getInt(0, 0);
            int maxYValue = z.getInt(1, 0);
            HashMap yValByxVal = new HashMap();
            HashMap yMaxByxVal = new HashMap();
            HashMap yMinByxVal = new HashMap();
            int i = 2;
            while (i < z.size()) {
                String val = z.getString(i, NULL_STRING);
                int ind = val.indexOf(",");
                if (ind != -1) {
                    String xS = val.substring(0, ind);
                    Integer xKey = new Integer(xS);
                    String yS = val.substring(ind + 1, val.length());
                    if (gic.isPerDiem()) {
                        Zeile zi = new Zeile(yS, '=');
                        FactSheetGroup.enterDiagramYValue(xKey, zi.getString(0, null), yValByxVal);
                        FactSheetGroup.enterDiagramYValue(xKey, zi.getString(1, null), yMinByxVal);
                        FactSheetGroup.enterDiagramYValue(xKey, zi.getString(2, null), yMaxByxVal);
                    } else {
                        FactSheetGroup.enterDiagramYValue(xKey, yS, yValByxVal);
                    }
                }
                ++i;
            }
            y += 15;
            Vector<PrintElementFactSheet> beutel = new Vector<PrintElementFactSheet>();
            y = FactSheetGroup.createPEHeader(y, beutel, Babel.get(selKey), width);
            int rechts = 30;
            int breite = width - rechts;
            int sheight = 200;
            int anz = maxXValue + 1;
            int sw = (int)((double)breite / (double)anz);
            int unten = y + sheight;
            PrintElementFactSheet pef = PrintElementFactSheet.getLineElement(rechts, unten, rechts + breite, unten, Color.black, 0.8f);
            beutel.add(pef);
            pef = PrintElementFactSheet.getLineElement(rechts, unten - sheight, rechts, unten, Color.black, 0.8f);
            beutel.add(pef);
            double schritt = LogTrick.getSchritt(maxYValue, (double)maxYValue / 5.0);
            double ay = 0.0;
            while (ay < (double)maxYValue) {
                int actHeight = (int)(ay / (double)maxYValue * (double)sheight);
                pef = PrintElementFactSheet.getLineElement(rechts - 3, unten - actHeight, rechts, unten - actHeight, Color.black, 0.8f);
                beutel.add(pef);
                String zahl = DEC_FORMAT.format(ay);
                pef = PrintElementFactSheet.getTextElement(rechts - 5, unten - actHeight, zahl, FETT_FONT_KLEIN, 4);
                pef.ivX -= pef.ivWidth;
                pef.ivY -= FETT_FONT_KLEIN.getSize() / 2 + 1;
                beutel.add(pef);
                ay += schritt;
            }
            int i2 = 0;
            while (i2 <= maxXValue) {
                Number number = (Number)yValByxVal.get(new Integer(i2));
                if (number != null) {
                    int actT;
                    int actHeight = (int)(number.doubleValue() / (double)maxYValue * (double)sheight);
                    Color background = Color.white;
                    if (backgroundMode == 1) {
                        background = AgeColor.getAgeColor(i2 * 30);
                    } else if (backgroundMode == 2) {
                        background = MouseCount.getMouseCountColor(i2);
                    }
                    pef = PrintElementFactSheet.getFilledBoxElement(rechts + i2 * sw, unten - actHeight, sw, actHeight, background, Color.black);
                    pef.ivLink = "jsdlksjdfkl";
                    pef.ivLineWidth = 0.8f;
                    beutel.add(pef);
                    number = (Number)yMaxByxVal.get(new Integer(i2));
                    if (number != null) {
                        actT = (int)(number.doubleValue() / (double)maxYValue * (double)sheight);
                        pef = PrintElementFactSheet.getLineElement(rechts + i2 * sw + sw / 2, unten - actHeight, rechts + i2 * sw + sw / 2, unten - actT, Color.black, 0.3f);
                        beutel.add(pef);
                        pef = PrintElementFactSheet.getLineElement(rechts + i2 * sw + sw / 2 - sw / 4, unten - actT, rechts + i2 * sw + sw / 2 + sw / 4, unten - actT, Color.black, 0.3f);
                        beutel.add(pef);
                    }
                    if ((number = (Number)yMinByxVal.get(new Integer(i2))) != null) {
                        actT = (int)(number.doubleValue() / (double)maxYValue * (double)sheight);
                        pef = PrintElementFactSheet.getLineElement(rechts + i2 * sw + sw / 2, unten - actHeight, rechts + i2 * sw + sw / 2, unten - actT, Color.black, 0.3f);
                        beutel.add(pef);
                        pef = PrintElementFactSheet.getLineElement(rechts + i2 * sw + sw / 2 - sw / 4, unten - actT, rechts + i2 * sw + sw / 2 + sw / 4, unten - actT, Color.black, 0.3f);
                        beutel.add(pef);
                    }
                }
                ++i2;
            }
            y = unten + 4;
            pef = PrintElementFactSheet.getTextElement(width, y, xLegend, FETT_FONT_KLEIN, 4);
            pef.ivX -= pef.ivWidth;
            beutel.add(pef);
            int tabu = pef.ivX;
            int step = 5;
            if (maxXValue <= 10) {
                step = 1;
            } else if (maxXValue < 20) {
                step = 2;
            }
            int i3 = step;
            while (i3 <= maxXValue) {
                int x = rechts + i3 * sw + sw / 2;
                pef = PrintElementFactSheet.getTextElement(x, y, Integer.toString(i3), FETT_FONT_KLEIN, 0);
                pef.ivX -= pef.ivWidth / 2;
                if (pef.ivX + pef.ivWidth < tabu - 2) {
                    beutel.add(pef);
                }
                i3 += step;
            }
            target.add(PrintElementFactSheet.getVectorElement(beutel));
            y += FETT_FONT_KLEIN.getSize() + 15;
        }
        return y;
    }

    private static void enterDiagramYValue(Integer xKey, String val, HashMap target) {
        if (val != null && (val = val.trim()).length() != 0) {
            try {
                target.put(xKey, new Double(val));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

