/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.util.HashSet;
import java.util.Vector;
import mausoleum.factsheets.FactSheet;
import mausoleum.factsheets.IDObjectMerker;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.helper.AllgUtils;
import mausoleum.line.Line;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.MouseManager;
import mausoleum.ui.UIDef;

public class FactSheetLine
extends FactSheet {
    public int addPrintElements(String group, Object object, int y, int width, Vector target, HashSet selection, String sonderVorspann) {
        int lw = 120;
        int rx = lw + UIDef.INNER_RAND;
        int rw = width - rx;
        if (object instanceof Line) {
            LocusAndAlleles[] lal;
            Line line = (Line)object;
            y = FactSheetLine.createStandardStartLines(line, String.valueOf(Babel.get("FS_LI_FOR_LINE")) + " " + line.getString("LIN_NAME", "?"), y, rx, width, target, null, sonderVorspann);
            y = FactSheetLine.addStringAttrLine(Babel.get("FS_C_TAG"), line, "LIN_TAG", rx, y, target);
            y = FactSheetLine.addStringAttrLine(Babel.get("FS_LI_ETPREFIX"), line, "LIN_ETPREFIX", rx, y, target);
            int matlim = line.getInt("LIN_MATLIM", -1);
            if (matlim != -1) {
                y = FactSheetLine.addLine(Babel.get("FS_MATLIM"), Integer.toString(matlim), rx, y, target);
            }
            String as = Babel.get("FS_NO");
            if (line.getBoolean("LIN_AUTOGTOK", true)) {
                as = "\u2713";
            }
            y = FactSheetLine.addLine(Babel.get("FS_AUTOGENOTYPE"), as, rx, y, target);
            Color c = (Color)line.get("LIN_COLOR");
            if (c != null) {
                target.addElement(PrintElementFactSheet.getTextElement(0, y += 5, Babel.get("FS_COLOR"), STANDARD_FONT));
                PrintElementFactSheet pen = PrintElementFactSheet.getBoxElement(rx, y, STANDARD_FONT.getSize() * 5, STANDARD_FONT.getSize() + 5, 0.5f, Color.black);
                pen.ivBackground = c;
                target.addElement(pen);
                y += STANDARD_FONT.getSize() + 5 + 2;
            }
            if (ProcessDefinition.isClient() && MausoleumClient.isRegularOrTGService()) {
                Vector actMice = MouseManager.getActualMiceOfLines(AllgUtils.getVec(line));
                if (actMice != null && !actMice.isEmpty()) {
                    y += 5;
                    y = actMice.size() == 1 ? FactSheetLine.addLine(Babel.get("FS_LI_ACT_MICE"), "1 " + Babel.get("FS_MOUSE"), rx, y, target, null, IDObjectMerker.getLink(actMice, null)) : FactSheetLine.addLine(Babel.get("FS_LI_ACT_MICE"), String.valueOf(actMice.size()) + " " + Babel.get("FS_MICE"), rx, y, target, null, IDObjectMerker.getLink(actMice, null));
                }
                y += 15;
            }
            if ((lal = (LocusAndAlleles[])line.get("LIN_LOCIALLELES")) != null) {
                y = FactSheetLine.createPEHeader(y, target, Babel.get("FS_LI_LOCI"), width);
                int i = 0;
                while (i < lal.length) {
                    Locus locus = (Locus)ObjectStore.getClientObject(14, lal[i].ivLocusID, line.getGroup());
                    if (locus != null) {
                        String locusName = locus.getBrowseName();
                        String alleles = locus.getAllelString(lal[i]);
                        y = FactSheetLine.addLongText(locusName, alleles, rx, rw, y, target, IDObjectMerker.getLink(locus, null), null);
                    }
                    ++i;
                }
                y += 15;
            }
            y = FactSheetLine.addLongStringSector(Babel.get("FS_DESCRIPTION"), line.getString("LIN_DESCRIPTION", null), y, width, target);
        }
        return y;
    }
}

