/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.util.Babel;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import mausoleum.factsheets.FactSheet;
import mausoleum.factsheets.IDObjectMerker;
import mausoleum.helper.AllgUtils;
import mausoleum.locus.Locus;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.MouseManager;
import mausoleum.ui.UIDef;

public class FactSheetLocus
extends FactSheet {
    public int addPrintElements(String group, Object object, int y, int width, Vector target, HashSet selection, String sonderVorspann) {
        int lw = 120;
        int rx = lw + UIDef.INNER_RAND;
        int rw = width - rx;
        if (object instanceof Locus) {
            String[] alleles;
            Locus locus = (Locus)object;
            y = FactSheetLocus.createStandardStartLines(locus, String.valueOf(Babel.get("FS_LO_FOR_LOCUS")) + " " + locus.getString("LOC_NAME", "?"), y, rx, width, target, null, sonderVorspann);
            y = FactSheetLocus.addLine(Babel.get("FS_LO_WILDTYP"), locus.getWTString(), rx, y, target);
            String as = Babel.get("FS_NO");
            if (locus.isAutosomal()) {
                as = "\u2713";
            }
            y = FactSheetLocus.addLine(Babel.get("FS_LO_AUTOSOMAL"), as, rx, y, target);
            as = Babel.get("FS_NO");
            if (locus.getBoolean("LOC_AUTOGTOK", true)) {
                as = "\u2713";
            }
            y = FactSheetLocus.addLine(Babel.get("FS_AUTOGENOTYPE"), as, rx, y, target);
            y += 5;
            String ens = locus.getString("LOC_ENSEMBL_NAME", null);
            String mgi = locus.getString("LOC_MGI_NAME", null);
            if (ens != null && ens.trim().length() != 0 || mgi != null && mgi.trim().length() != 0) {
                if (ens != null && ens.trim().length() != 0) {
                    y = FactSheetLocus.addLine(Babel.get("FS_LO_ENSEMBL"), ens.trim(), rx, y, target, null, IDObjectMerker.getEnsemblLink(ens.trim(), null));
                }
                if (mgi != null && mgi.trim().length() != 0) {
                    y = FactSheetLocus.addLine(Babel.get("FS_LO_MGI"), mgi.trim(), rx, y, target, null, IDObjectMerker.getMGILink(mgi, null));
                }
                y += 5;
            }
            if (ProcessDefinition.isClient() && MausoleumClient.isRegularOrTGService()) {
                Vector actMice = MouseManager.getActualMiceOfLoci(AllgUtils.getVec(locus));
                if (actMice != null && !actMice.isEmpty()) {
                    y = actMice.size() == 1 ? FactSheetLocus.addLine(Babel.get("FS_LO_ACT_MICE"), "1 " + Babel.get("FS_MOUSE"), rx, y, target, null, IDObjectMerker.getLink(actMice, null)) : FactSheetLocus.addLine(Babel.get("FS_LO_ACT_MICE"), String.valueOf(actMice.size()) + " " + Babel.get("FS_MICE"), rx, y, target, null, IDObjectMerker.getLink(actMice, null));
                }
                y += 15;
            }
            if ((alleles = (String[])locus.get("LOC_ALLELES")) != null && alleles.length != 0) {
                Hashtable descr = Locus.getAllelDescriptionHashtable(locus);
                y = FactSheetLocus.createPEHeader(y, target, Babel.get("FS_LO_ALLELES"), width);
                int i = 0;
                while (i < alleles.length) {
                    String aldesc = (String)descr.get(alleles[i]);
                    if (aldesc == null) {
                        aldesc = "";
                    }
                    y = FactSheetLocus.addLongText(locus.getAlias(alleles[i]), aldesc, rx, rw, y, target, null, null);
                    ++i;
                }
                y += 15;
            }
            y = FactSheetLocus.addLongStringSector(Babel.get("FS_DESCRIPTION"), locus.getString("LOC_DESCRIPTION", null), y, width, target);
        }
        return y;
    }
}

