/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.SexColor;
import mausoleum.experiment.Experiment;
import mausoleum.factsheets.FactSheet;
import mausoleum.factsheets.IDObjectMerker;
import mausoleum.factsheets.MatingPerformance;
import mausoleum.factsheets.MatingPerformanceObject;
import mausoleum.factsheets.PlugReport;
import mausoleum.factsheets.PlugReportObject;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.factsheets.TextWrapComponentNeu;
import mausoleum.factsheets.TextWrapElementNeu;
import mausoleum.factsheets.VisitReport;
import mausoleum.gui.ColorManager;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.NumberFormatter;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.idobjectgroup.IDObjectGroupManager;
import mausoleum.inspector.MousePlugDateObject;
import mausoleum.license.License;
import mausoleum.line.Line;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.CoatColor;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.mouse.TissueSample;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.printing.util.Wurf;
import mausoleum.rack.Rack;
import mausoleum.result.MResult;
import mausoleum.result.MResultWrapper;
import mausoleum.result.SpecialResultHelper;
import mausoleum.room.Room;
import mausoleum.strain.Strain;
import mausoleum.ui.UIDef;
import mausoleum.visit.Visit;

public class FactSheetMouse
extends FactSheet {
    public static String SEL_GENERAL = "FSM_SEL_GENERAL";
    public static String SEL_COMMENT = "FSM_SEL_COMMENT";
    public static String SEL_VISIT = "FSM_SEL_VISIT";
    public static String SEL_MATING = "FSM_SEL_MATING";
    public static String SEL_MATING_EXT = "FSM_SEL_MATING_EXT";
    public static String SEL_PLUG_DATE = "FSM_SEL_PLUGDATE";
    public static String SEL_PLUG_REPORT = "FSM_SEL_PLUGREPORT";
    public static String SEL_RESULTS = "FSM_SEL_RESULTS";
    public static String SEL_TISSUE_SAMPLES = "FSM_SEL_TISSUE_SAMPLES";
    public static String SEL_HEALTHREPORTS = "FSM_SEL_HEALTHREPORTS";
    public static String SEL_STRESS_DETAILS = "FSM_SEL_STRESS_DETAILS";
    public static String SEL_STRESS_DETAILS_EXT = "FSM_SEL_STRESS_DETAILS_EXT";
    private static final int MAX_RES_TEXT_WIDTH = 200;
    private static final int MAX_SMP_COMMENT_TEXT_WIDTH = 150;
    private static final int MAX_HEALTH_OBSERVATION_TEXT_WIDTH = 250;
    private static final NumberFormat DF1 = new DecimalFormat("#0.0");
    public static final NumberFormat DF2 = new DecimalFormat("#0.000");

    public int addPrintElements(String group, Object object, int y, int width, Vector target, HashSet selection, String sonderVorspann) {
        int lw = 120;
        int rx = lw + UIDef.INNER_RAND;
        int rw = width - rx;
        if (object instanceof Mouse) {
            Vector results;
            Vector plugReps;
            HashMap allCages;
            Vector performances;
            Vector wuerfe;
            Mouse mouse = (Mouse)object;
            String mgroup = mouse.getGroup();
            y = FactSheetMouse.createStandardStartLines(mouse, String.valueOf(Babel.get("FS_M_FOR_MOUSE")) + " " + mouse.getIDStringForReports(false), y, rx, width, target, null, sonderVorspann);
            if (selection == null || selection.contains(SEL_GENERAL) || selection.contains(SEL_STRESS_DETAILS) || selection.contains(SEL_STRESS_DETAILS_EXT)) {
                Vector licV = mouse.getLicenses(null);
                if (licV != null) {
                    Iterator iterator = licV.iterator();
                    while (iterator.hasNext()) {
                        License license = (License)iterator.next();
                        y = FactSheetMouse.addLine(Babel.get("FS_M_LICENSE"), license.getBrowseName(), rx, y, target, null, IDObjectMerker.getLink(license, null));
                    }
                }
                if (selection != null && (selection.contains(SEL_STRESS_DETAILS) || selection.contains(SEL_STRESS_DETAILS_EXT))) {
                    y += 10;
                }
            }
            if (selection == null || selection.contains(SEL_GENERAL)) {
                long[] cohortIDs;
                String gt;
                Line line;
                IndexObject[] strains;
                Color c;
                int matlim;
                long[] kidIDs;
                String s;
                if (mouse.getDate("MOS_BIRTHDAY") != null) {
                    y = FactSheetMouse.addLine(Babel.get("FS_M_BIRTHDAY"), DatumFormat.getJustDateString(mouse.getDate("MOS_BIRTHDAY")), rx, y, target);
                }
                y = FactSheetMouse.addRelative(mgroup, mouse.getLong("MOS_MOTHER", 0L), Babel.get("FS_M_MOTHER"), y, rx, target);
                y = FactSheetMouse.addRelative(mgroup, mouse.getLong("MOS_FATHER", 0L), Babel.get("FS_M_FATHER"), y, rx, target);
                y = FactSheetMouse.addRelative(mgroup, mouse.getLong("MOS_FOSTID", 0L), Babel.get("FS_M_FOSTER"), y, rx, target);
                if (mouse.getBoolean("MOS_ABGESMAN", false)) {
                    y = FactSheetMouse.addLine("", Babel.get("WEANED_MANUALLY"), rx, y, target);
                }
                if ((s = mouse.getGenerationString(true)) != null && s.trim().length() != 0) {
                    y = FactSheetMouse.addLine(Babel.get("GENERATION_FS"), s, rx, y, target);
                }
                y += 3;
                if (mouse.get("MOS_EARTAG") != null) {
                    y = FactSheetMouse.addLine(Babel.get("FS_M_EARTAG"), mouse.getCLLWEartagString(null, true, true), rx, y, target);
                }
                y = FactSheetMouse.addStringAttrLine(Babel.get("FS_AN_TAG"), mouse, "MOS_ANTAG", rx, y, target);
                char mark = mouse.getChar("MOS_FLAG");
                if (mark == '\u0001') {
                    y = FactSheetMouse.addLine(Babel.get("FS_MARK"), "\u261e", rx, y, target);
                } else if (mark != '\u0000') {
                    char[] ica = new char[]{mark};
                    y = FactSheetMouse.addLine(Babel.get("FS_MARK"), new String(ica), rx, y, target);
                }
                long[] ownerIDs = (long[])mouse.get("MOS_OWNER");
                long[] ownerGroupIDs = (long[])mouse.get("MOS_OWNERGROUPS");
                if (ownerIDs == null && ownerGroupIDs == null) {
                    y = FactSheetMouse.addLine(Babel.get("FS_M_OWNER"), Babel.get("ALL"), rx, y, target);
                } else {
                    String oname;
                    int ij;
                    Vector<IDObject> owners = new Vector<IDObject>();
                    StringBuffer msb = new StringBuffer();
                    if (ownerIDs != null) {
                        ij = 0;
                        while (ij < ownerIDs.length) {
                            oname = Babel.get("UNKNOWN");
                            User owner = UserManager.getUser(ownerIDs[ij], mgroup);
                            if (owner != null) {
                                oname = owner.getString("USR_NAME", oname);
                                owners.add(owner);
                            }
                            if (msb.length() != 0) {
                                msb.append(", ");
                            }
                            msb.append(oname);
                            ++ij;
                        }
                    }
                    if (ownerGroupIDs != null) {
                        ij = 0;
                        while (ij < ownerGroupIDs.length) {
                            oname = Babel.get("UNKNOWN");
                            IDObjectGroup iog = (IDObjectGroup)IDObjectGroupManager.cvInstance.getObject(ownerGroupIDs[ij], mgroup);
                            if (iog != null) {
                                oname = iog.getName();
                                owners.add(iog);
                            }
                            if (msb.length() != 0) {
                                msb.append(", ");
                            }
                            msb.append(oname);
                            ++ij;
                        }
                    }
                    y = FactSheetMouse.addLongText(Babel.get("FS_M_OWNER"), msb.toString(), rx, rw, y, target, null, IDObjectMerker.getLink(owners, null));
                }
                y = mouse.isAlive() ? FactSheetMouse.addLine(Babel.get("FS_M_STATUS"), Babel.get("FS_M_STATUS_ALIVE"), rx, y, target) : FactSheetMouse.addLine(Babel.get("FS_M_STATUS"), Babel.get("FS_M_STATUS_GONE"), rx, y, target);
                y += 3;
                String variant = "";
                switch (mouse.getSexVariant(0)) {
                    case 128: {
                        variant = ", " + Babel.get("STERILE");
                        break;
                    }
                    case 64: {
                        variant = ", " + Babel.get("VASECTOMIZED");
                        break;
                    }
                }
                switch (mouse.getSex()) {
                    case 1: {
                        y = FactSheetMouse.addLine(Babel.get("FS_M_SEX"), String.valueOf(Babel.get("FS_M_MALE")) + variant, rx, y, target);
                        break;
                    }
                    case 2: {
                        y = FactSheetMouse.addLine(Babel.get("FS_M_SEX"), String.valueOf(Babel.get("FS_M_FEMALE")) + variant, rx, y, target);
                        break;
                    }
                    default: {
                        y = FactSheetMouse.addLine(Babel.get("FS_M_SEX"), String.valueOf(Babel.get("FS_UNDEFINED")) + variant, rx, y, target);
                    }
                }
                Cage cage = mouse.getActCage();
                if (cage != null) {
                    y = FactSheetMouse.addLine(Babel.get("FS_M_ACTCAGE"), cage.getLabelIDString(), rx, y, target, null, IDObjectMerker.getLink(cage, null));
                    Rack rack = cage.getSuperCageIfThere().getRack();
                    if (rack != null) {
                        y = FactSheetMouse.addLine(Babel.get("FS_RACK"), rack.getName(), rx, y, target, null, IDObjectMerker.getLink(rack, null));
                        Room room = (Room)ObjectStore.getClientObject(10, rack.getLong("RCK_ROOM", 0L), rack.getGroup());
                        if (room != null) {
                            y = FactSheetMouse.addLine(Babel.get("FS_ROOM"), room.getString("ROM_NAME", Babel.get("unknown")), rx, y, target, null, IDObjectMerker.getLink(room, null));
                        }
                    }
                }
                if ((kidIDs = (long[])mouse.get("MOS_KID")) != null && kidIDs.length != 0) {
                    y += 3;
                    y = FactSheetMouse.addLine(Babel.get("FS_M_KIDS"), Integer.toString(kidIDs.length), rx, y, target, null, IDObjectMerker.getLink(kidIDs, null, 1, mgroup));
                }
                if ((matlim = mouse.getInt("MOS_MATLIM", -1)) != -1) {
                    y = FactSheetMouse.addLine(Babel.get("FS_MATLIM"), Integer.toString(matlim), rx, y, target);
                }
                y += 3;
                int coatColor = mouse.getCoatColor();
                if (coatColor != Integer.MIN_VALUE && (c = CoatColor.getColor(coatColor)) != null) {
                    target.addElement(PrintElementFactSheet.getTextElement(0, y += 3, Babel.get("COAT_COLOR"), STANDARD_FONT));
                    PrintElementFactSheet pen = PrintElementFactSheet.getTextElement(rx, y, " " + CoatColor.getDescr(coatColor, true, "") + " ", FETT_FONT, c, 0);
                    pen.ivBorderColor = Color.black;
                    pen.ivForeground = ColorManager.getForegroundColorForBackground(c);
                    pen.ivFramed = true;
                    target.addElement(pen);
                    y += STANDARD_FONT.getSize() + 2 + 3;
                }
                if ((strains = (IndexObject[])mouse.get("MOS_STRAIN")) != null) {
                    Vector<Strain> strainSammler = new Vector<Strain>();
                    StringBuffer mstr = new StringBuffer();
                    int iii = 0;
                    while (iii < strains.length) {
                        IndexObject mto = strains[iii];
                        Strain str = (Strain)ObjectStore.getClientObject(8, mto.ivObjectID, mgroup);
                        if (str == null) {
                            mstr.append("Unknown Strain");
                        } else {
                            strainSammler.add(str);
                            mstr.append(str.getString("STR_NAME"));
                        }
                        mstr.append(" (").append(NumberFormatter.STRAIN_FROMATTER.format(mto.ivNumber)).append(") ");
                        ++iii;
                    }
                    y = FactSheetMouse.addLongText(Babel.get("FS_M_STRAIN"), mstr.toString(), rx, rw, y, target, null, IDObjectMerker.getLink(strainSammler, null));
                }
                if ((line = mouse.getLine()) != null) {
                    y = FactSheetMouse.addLine(Babel.get("FS_M_LINE"), line.getBrowseName(), rx, y, target, null, IDObjectMerker.getLink(line, null));
                }
                if ((gt = mouse.getGenotype()) != null && !gt.equals("?") && gt.length() != 0) {
                    y = FactSheetMouse.addLine(Babel.get("FS_M_GENOTYPE"), gt, rx, y, target);
                }
                if ((cohortIDs = (long[])mouse.get("MOS_COHORTS")) != null) {
                    Vector<IDObjectGroup> cohorts = new Vector<IDObjectGroup>();
                    StringBuffer msb = new StringBuffer();
                    int ij = 0;
                    while (ij < cohortIDs.length) {
                        String oname = Babel.get("UNKNOWN");
                        IDObjectGroup iog = (IDObjectGroup)IDObjectGroupManager.cvInstance.getObject(cohortIDs[ij], mgroup);
                        if (iog != null) {
                            oname = iog.getName();
                            cohorts.add(iog);
                        }
                        if (msb.length() != 0) {
                            msb.append(", ");
                        }
                        msb.append(oname);
                        ++ij;
                    }
                    y = FactSheetMouse.addLongText(Babel.get("FS_M_COHORTS"), msb.toString(), rx, rw, y, target, null, IDObjectMerker.getLink(cohorts, null));
                }
                y += 15;
            }
            if (selection == null || selection.contains(SEL_COMMENT)) {
                y = FactSheetMouse.addLongStringSector(Babel.get("FS_COMMENT"), mouse.getString("MOS_COMMENT", null), y, width, target);
            }
            if (selection == null || selection.contains(SEL_MATING)) {
                wuerfe = Wurf.getWuerfeForFactsheet(mouse);
                if (wuerfe != null && !wuerfe.isEmpty()) {
                    y = FactSheetMouse.createPEHeader(y, target, Babel.get("FS_M_LITTERS"), width);
                    y = FactSheetMouse.collectWurfElementLines(mouse, wuerfe, target, y, width, mgroup);
                    y += 15;
                }
                if ((performances = MatingPerformance.getMatingPerformanceObjects(mouse, group)) != null && !performances.isEmpty()) {
                    y = FactSheetMouse.createPEHeader(y, target, Babel.get("FS_M_MATING_PERFORMANCES"), width);
                    y = FactSheetMouse.collectPerformanceLines(performances, target, y, width);
                    y += 15;
                }
            }
            if (selection != null && selection.contains(SEL_MATING_EXT)) {
                wuerfe = Wurf.getWuerfeForFactsheet(mouse);
                if (wuerfe != null && !wuerfe.isEmpty()) {
                    y = FactSheetMouse.createPEHeader(y, target, Babel.get("FS_M_LITTERS"), width);
                    y = FactSheetMouse.collectWurfElementLinesExt(mouse, wuerfe, target, y, width, mgroup);
                    y += 15;
                }
                if ((performances = MatingPerformance.getMatingPerformanceObjects(mouse, group)) != null && !performances.isEmpty()) {
                    y = FactSheetMouse.createPEHeader(y, target, Babel.get("FS_M_MATING_PERFORMANCES"), width);
                    y = FactSheetMouse.collectPerformanceLines(performances, target, y, width);
                    y += 15;
                }
            }
            if ((selection == null || selection.contains(SEL_VISIT)) && (allCages = VisitReport.collectCages(mouse)) != null && !allCages.isEmpty()) {
                y = FactSheetMouse.createPEHeader(y, target, Babel.get("FS_M_VISITS"), width);
                y = FactSheetMouse.collectVisitElementLines(mouse, allCages, target, y, width);
                y += 15;
            }
            if (selection == null || selection.contains(SEL_PLUG_DATE)) {
                Vector plugdates = new Vector();
                MousePlugDateObject.addPlugDates(mouse, plugdates);
                if (!plugdates.isEmpty()) {
                    y = FactSheetMouse.createPEHeader(y, target, Babel.get("FS_M_PLUGDATES"), width);
                    int i = 0;
                    while (i < plugdates.size()) {
                        MousePlugDateObject mpdo = (MousePlugDateObject)plugdates.elementAt(i);
                        String dateStr = "?";
                        if (mpdo.ivDatum != Integer.MIN_VALUE) {
                            dateStr = DatumFormat.getJustDateString(new Date(new MyDate(mpdo.ivDatum).getTime()));
                        }
                        if (mpdo.ivIsCurrentPlugAlert) {
                            target.add(PrintElementFactSheet.getTextElement(0, y, dateStr, FETT_FONT));
                            y += FETT_FONT.getSize() + 2;
                        } else {
                            target.add(PrintElementFactSheet.getTextElement(0, y, dateStr, STANDARD_FONT));
                            y += STANDARD_FONT.getSize() + 2;
                        }
                        ++i;
                    }
                }
            }
            if ((selection == null || selection.contains(SEL_PLUG_REPORT)) && (plugReps = PlugReport.getPlugReportObjects(mouse, System.currentTimeMillis())) != null && !plugReps.isEmpty()) {
                y = FactSheetMouse.createPEHeader(y, target, Babel.get("FS_M_PLUG_REPORT"), width);
                y = FactSheetMouse.collectPlugReportLines(plugReps, target, y, width);
                y += 15;
            }
            if ((selection == null || selection.contains(SEL_RESULTS)) && (results = (Vector)mouse.get("MOS_MRESULTS")) != null && !results.isEmpty()) {
                Vector<MResultWrapper> wrappers = new Vector<MResultWrapper>(results.size());
                Iterator iterator = results.iterator();
                while (iterator.hasNext()) {
                    MResult mres = (MResult)iterator.next();
                    if (!MResult.isRegularResult(mres)) continue;
                    wrappers.add(new MResultWrapper(mouse, mres));
                }
                if (!wrappers.isEmpty()) {
                    y = FactSheetMouse.createPEHeader(y, target, Babel.get("FS_M_RESULTS"), width);
                    y = FactSheetMouse.collectResultLines(wrappers, target, y, width, true);
                    y += 15;
                }
            }
            if (selection == null || selection.contains(SEL_TISSUE_SAMPLES)) {
                Vector samples = new Vector();
                TissueSample.getTissueSamples(mouse, samples);
                if (!samples.isEmpty()) {
                    y = FactSheetMouse.createPEHeader(y, target, Babel.get("TISSUE_SAMPLES"), width);
                    y = FactSheetMouse.collectTissueSampleLines(samples, target, y, width);
                    y += 15;
                }
            }
            Vector wrappers = new Vector();
            Vector results2 = (Vector)mouse.get("MOS_MRESULTS");
            if (selection == null || selection.contains(SEL_HEALTHREPORTS)) {
                y = FactSheetMouse.makeSpecResLines(mouse, wrappers, results2, -42L, Babel.get("FS_M_HEALTHREPORTS"), y, width, target, false);
            }
            if (TierSchutz.isLineEvaluationPossible() && (selection == null || selection.contains(SEL_STRESS_DETAILS) || selection.contains(SEL_STRESS_DETAILS_EXT))) {
                boolean extended = selection != null && selection.contains(SEL_STRESS_DETAILS_EXT);
                String pre = String.valueOf(Babel.get("STRESS_EVALUATION")) + " / ";
                y = FactSheetMouse.makeSpecResLines(mouse, wrappers, results2, -43L, String.valueOf(pre) + Babel.get("TASK_TS_EVAL_D1_WURFBEURTEILUNG"), y, width, target, extended);
                y = FactSheetMouse.makeSpecResLines(mouse, wrappers, results2, -44L, String.valueOf(pre) + Babel.get("TASK_TS_EVAL_D1_ABSETZBEURTEILUNG"), y, width, target, extended);
                y = FactSheetMouse.makeSpecResLines(mouse, wrappers, results2, -45L, String.valueOf(pre) + Babel.get("TASK_TS_EVAL_D1_BEURTEILUNG_EINZELTIER"), y, width, target, extended);
            }
        }
        return y;
    }

    private static int makeSpecResLines(Mouse mouse, Vector wrappers, Vector results, long expID, String titel, int y, int width, Vector target, boolean extended) {
        wrappers.clear();
        if (results != null && !results.isEmpty()) {
            Iterator iterator = results.iterator();
            while (iterator.hasNext()) {
                MResult mres = (MResult)iterator.next();
                if (mres.ivExpID != expID) continue;
                wrappers.add(new MResultWrapper(mouse, mres));
            }
        }
        if (!wrappers.isEmpty()) {
            y = FactSheetMouse.createPEHeader(y, target, titel, width);
            y = FactSheetMouse.collectSpecialResultReportLines(wrappers, target, y, width, extended);
            y += 15;
        }
        return y;
    }

    private static int addRelative(String group, long relID, String function, int y, int rx, Vector target) {
        Mouse relative = MouseManager.getMouse(relID, group);
        if (relative != null) {
            y = FactSheetMouse.addLine(function, relative.getIDStringForReports(false), rx, y, target, null, IDObjectMerker.getLink(relative, null));
        }
        return y;
    }

    private static int collectPerformanceLines(Vector performances, Vector target, int y, int width) {
        Vector lines = new Vector();
        Vector<Integer> horizLineYPos = new Vector<Integer>();
        Vector<Integer> lineYs = new Vector<Integer>();
        horizLineYPos.add(new Integer(y));
        lineYs.add(new Integer(y));
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 4, Babel.get("FS_M_PARTNER"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_PUPS"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_DAYS"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_WEEKS"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_PERFOMANCE_BRUCH"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_PERFOMANCE_ZAHL"), TABHEADER_FONT));
        y += TABHEADER_FONT.getSize() + 2;
        y += 4;
        Iterator iter = performances.iterator();
        while (iter.hasNext()) {
            line = new Vector();
            lines.add(line);
            horizLineYPos.add(new Integer(y));
            lineYs.add(new Integer(y));
            MatingPerformanceObject mpo = (MatingPerformanceObject)iter.next();
            int wochen = (mpo.ivTage + 4) / 7;
            line.add(PrintElementFactSheet.getTextElement(0, y += 3, mpo.ivPartner[0].getIDStringForReports(false), FETT_FONT, IDObjectMerker.getLink(mpo.ivPartner[0], null)));
            line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(mpo.ivKids.size()), FETT_FONT, 4, IDObjectMerker.getLink(mpo.ivKids, null)));
            line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(mpo.ivTage), FETT_FONT, 4));
            line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(wochen), FETT_FONT, 4));
            line.add(PrintElementFactSheet.getTextElement(0, y, String.valueOf(mpo.ivKids.size()) + " / " + wochen, FETT_FONT, 4));
            line.add(PrintElementFactSheet.getTextElement(0, y, DF2.format(mpo.ivPerformance), FETT_FONT, 4));
            lineYs.add(new Integer(y += STANDARD_FONT.getSize() + 2));
            line = new Vector();
            lines.add(line);
            StringBuilder msb = new StringBuilder("      ");
            if (mpo.ivStartDate != Integer.MIN_VALUE) {
                msb.append(DatumFormat.getJustDateString(mpo.ivStartDate));
            }
            msb.append(" - ");
            if (mpo.ivEndDate != Integer.MIN_VALUE) {
                msb.append(DatumFormat.getJustDateString(mpo.ivEndDate));
            }
            if (mpo.ivVisitCount > 1) {
                msb.append(" [").append(mpo.ivVisitCount).append("]");
            }
            line.add(PrintElementFactSheet.getTextElement(0, y, msb.toString(), FONT_KLEIN, null));
            y += STANDARD_FONT.getSize() + 2;
            y += 3;
        }
        lineYs.add(new Integer(y));
        horizLineYPos.add(new Integer(y));
        return FactSheetMouse.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
    }

    private static int collectWurfElementLines(Mouse mouse, Vector wuerfe, Vector target, int y, int width, String mgroup) {
        Vector sWsammlerM = new Vector();
        Vector sWsammlerF = new Vector();
        Vector sWsammlerU = new Vector();
        Vector sWsammlerT = new Vector();
        Vector lines = new Vector();
        Vector<Integer> horizLineYPos = new Vector<Integer>();
        Vector<Integer> lineYs = new Vector<Integer>();
        horizLineYPos.add(new Integer(y));
        lineYs.add(new Integer(y));
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 4, Babel.get("FS_M_DATE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_PARTNER"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_PUPS"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, DefaultManager.getMale(), TABHEADER_FONT, 0));
        line.add(PrintElementFactSheet.getTextElement(0, y, DefaultManager.getFemale(), TABHEADER_FONT, 0));
        line.add(PrintElementFactSheet.getTextElement(0, y, "?", TABHEADER_FONT, 0));
        line.add(PrintElementFactSheet.getTextElement(0, y, "T", TABHEADER_FONT, 0));
        y += TABHEADER_FONT.getSize() + 2;
        y += 4;
        int numMale = 0;
        int numFemale = 0;
        int numTotal = 0;
        Vector sammlerM = new Vector();
        Vector sammlerF = new Vector();
        Vector sammlerU = new Vector();
        Vector sammlerT = new Vector();
        Iterator iter = wuerfe.iterator();
        while (iter.hasNext()) {
            horizLineYPos.add(new Integer(y));
            lineYs.add(new Integer(y));
            y += 3;
            Wurf wurf = (Wurf)iter.next();
            int anz = wurf.ivNumBornTotal;
            numMale += wurf.ivNumMaleBorn;
            numFemale += wurf.ivNumFemaleBorn;
            numTotal += wurf.ivNumBornTotal;
            wurf.addMiceToSexTargets(sammlerM, sammlerF, sammlerU, sammlerT);
            sWsammlerM.clear();
            sWsammlerF.clear();
            sWsammlerU.clear();
            sWsammlerT.clear();
            wurf.addMiceToSexTargets(sWsammlerM, sWsammlerF, sWsammlerU, sWsammlerT);
            int i = 0;
            while (i < anz) {
                line = new Vector();
                lines.add(line);
                if (i == 0) {
                    line.add(PrintElementFactSheet.getTextElement(0, y, DatumFormat.getJustDateString(wurf.ivDay), FETT_FONT));
                    Mouse mii = null;
                    mii = mouse.getSex() == 1 ? MouseManager.getMouse(wurf.ivMotherID, mgroup) : MouseManager.getMouse(wurf.ivFatherID, mgroup);
                    if (mii != null) {
                        line.add(PrintElementFactSheet.getTextElement(0, y, mii.getIDStringForReports(false), FETT_FONT, IDObjectMerker.getLink(mii, null)));
                    } else {
                        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                    }
                } else {
                    lineYs.add(new Integer(y));
                    line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                    line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                }
                if (wurf.ivKids != null && i < wurf.ivKids.size()) {
                    Mouse kid = (Mouse)wurf.ivKids.elementAt(i);
                    line.add(PrintElementFactSheet.getTextElement(0, y, kid.getIDStringForReports(false), FETT_FONT, IDObjectMerker.getLink(kid, null)));
                } else {
                    line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                }
                if (i == 0) {
                    line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(wurf.ivNumMaleBorn), FETT_FONT, 4, IDObjectMerker.getLink(sWsammlerM, null)));
                    line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(wurf.ivNumFemaleBorn), FETT_FONT, 4, IDObjectMerker.getLink(sWsammlerF, null)));
                    line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(wurf.ivNumBornTotal - wurf.ivNumMaleBorn - wurf.ivNumFemaleBorn), FETT_FONT, 4, IDObjectMerker.getLink(sWsammlerU, null)));
                    line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(wurf.ivNumBornTotal), FETT_FONT, 4, IDObjectMerker.getLink(sWsammlerT, null)));
                } else {
                    line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                    line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                    line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                    line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                }
                y += STANDARD_FONT.getSize() + 2;
                y += 3;
                ++i;
            }
        }
        horizLineYPos.add(new Integer(y));
        lineYs.add(new Integer(y));
        line = new Vector();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 4, Babel.get("FS_M_TOTAL"), FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(numMale), FETT_FONT, 4, IDObjectMerker.getLink(sammlerM, null)));
        line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(numFemale), FETT_FONT, 4, IDObjectMerker.getLink(sammlerF, null)));
        line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(numTotal - numMale - numFemale), FETT_FONT, 4, IDObjectMerker.getLink(sammlerU, null)));
        line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(numTotal), FETT_FONT, 4, IDObjectMerker.getLink(sammlerT, null)));
        y += TABHEADER_FONT.getSize() + 2;
        lineYs.add(new Integer(y += 4));
        horizLineYPos.add(new Integer(y));
        y += 4;
        line = new Vector();
        lines.add(line);
        double amale = (double)numMale / (double)wuerfe.size();
        double afemale = (double)numFemale / (double)wuerfe.size();
        double aunknown = (double)(numTotal - numMale - numFemale) / (double)wuerfe.size();
        double atotal = (double)numTotal / (double)wuerfe.size();
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_AVERAGE"), FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, FactSheetMouse.formatDouble(amale), FETT_FONT, 4));
        line.add(PrintElementFactSheet.getTextElement(0, y, FactSheetMouse.formatDouble(afemale), FETT_FONT, 4));
        line.add(PrintElementFactSheet.getTextElement(0, y, FactSheetMouse.formatDouble(aunknown), FETT_FONT, 4));
        line.add(PrintElementFactSheet.getTextElement(0, y, FactSheetMouse.formatDouble(atotal), FETT_FONT, 4));
        y += FETT_FONT.getSize() + 2;
        lineYs.add(new Integer(y += 4));
        horizLineYPos.add(new Integer(y));
        return FactSheetMouse.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
    }

    private static int collectWurfElementLinesExt(Mouse mouse, Vector wuerfe, Vector target, int y, int width, String mgroup) {
        Vector sWsammlerM = new Vector();
        Vector sWsammlerF = new Vector();
        Vector sWsammlerU = new Vector();
        Vector sWsammlerT = new Vector();
        Vector lines = new Vector();
        Vector<Integer> horizLineYPos = new Vector<Integer>();
        Vector<Integer> lineYs = new Vector<Integer>();
        horizLineYPos.add(new Integer(y));
        lineYs.add(new Integer(y));
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 4, Babel.get("FS_M_DATE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_CAGE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_MOUSE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_LINE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_GENOTYPE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_DEATH"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_COMMENT"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, DefaultManager.getMale(), TABHEADER_FONT, 0));
        line.add(PrintElementFactSheet.getTextElement(0, y, DefaultManager.getFemale(), TABHEADER_FONT, 0));
        line.add(PrintElementFactSheet.getTextElement(0, y, "?", TABHEADER_FONT, 0));
        line.add(PrintElementFactSheet.getTextElement(0, y, "T", TABHEADER_FONT, 0));
        y += TABHEADER_FONT.getSize() + 2;
        y += 4;
        int numMale = 0;
        int numFemale = 0;
        int numTotal = 0;
        Vector sammlerM = new Vector();
        Vector sammlerF = new Vector();
        Vector sammlerU = new Vector();
        Vector sammlerT = new Vector();
        Iterator iter = wuerfe.iterator();
        while (iter.hasNext()) {
            horizLineYPos.add(new Integer(y));
            lineYs.add(new Integer(y));
            y += 3;
            Wurf wurf = (Wurf)iter.next();
            numMale += wurf.ivNumMaleBorn;
            numFemale += wurf.ivNumFemaleBorn;
            numTotal += wurf.ivNumBornTotal;
            wurf.addMiceToSexTargets(sammlerM, sammlerF, sammlerU, sammlerT);
            sWsammlerM.clear();
            sWsammlerF.clear();
            sWsammlerU.clear();
            sWsammlerT.clear();
            wurf.addMiceToSexTargets(sWsammlerM, sWsammlerF, sWsammlerU, sWsammlerT);
            boolean headerWarDa = false;
            Mouse mii = MouseManager.getMouse(wurf.ivMotherID, mgroup);
            if (mii != null) {
                lineYs.add(new Integer(y));
                y = FactSheetMouse.createExtendedParentLine(mii, SexColor.FEMALE_EXTREME_LIGHT, wurf, lines, y, headerWarDa, sWsammlerM, sWsammlerF, sWsammlerU, sWsammlerT);
                headerWarDa = true;
            }
            if ((mii = MouseManager.getMouse(wurf.ivFatherID, mgroup)) != null) {
                lineYs.add(new Integer(y));
                y = FactSheetMouse.createExtendedParentLine(mii, SexColor.MALE_EXTREME_LIGHT, wurf, lines, y, headerWarDa, sWsammlerM, sWsammlerF, sWsammlerU, sWsammlerT);
                headerWarDa = true;
            }
            Iterator iterator = wurf.ivKids.iterator();
            while (iterator.hasNext()) {
                Mouse kid = (Mouse)iterator.next();
                lineYs.add(new Integer(y));
                line = new Vector();
                lines.add(line);
                line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                line.add(PrintElementFactSheet.getTextElement(0, y, kid.getIDStringForReports(false), FETT_FONT, IDObjectMerker.getLink(kid, null)));
                line.add(PrintElementFactSheet.getTextElement(0, y, kid.getCLLWLineString(), FETT_FONT, null));
                line.add(PrintElementFactSheet.getTextElement(0, y, kid.getGenotype(""), FETT_FONT, null));
                Date dod = kid.getDate("IDO_END_DATE");
                if (dod != null) {
                    line.add(PrintElementFactSheet.getTextElement(0, y, DatumFormat.getJustDateString(MyDate.getTage(dod)), FETT_FONT, null));
                } else {
                    line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT, null));
                }
                String comment = kid.getString("MOS_COMMENT", "                       ");
                PrintElementFactSheet pefs = PrintElementFactSheet.getTextElementMaxWidthSingleLine(0, y, comment, FETT_FONT, 120);
                line.add(pefs);
                line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                y += STANDARD_FONT.getSize() + 2;
                y += 3;
            }
        }
        horizLineYPos.add(new Integer(y));
        lineYs.add(new Integer(y));
        line = new Vector();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 4, Babel.get("FS_M_TOTAL"), FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(numMale), FETT_FONT, 4, IDObjectMerker.getLink(sammlerM, null)));
        line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(numFemale), FETT_FONT, 4, IDObjectMerker.getLink(sammlerF, null)));
        line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(numTotal - numMale - numFemale), FETT_FONT, 4, IDObjectMerker.getLink(sammlerU, null)));
        line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(numTotal), FETT_FONT, 4, IDObjectMerker.getLink(sammlerT, null)));
        y += TABHEADER_FONT.getSize() + 2;
        lineYs.add(new Integer(y += 4));
        horizLineYPos.add(new Integer(y));
        y += 4;
        line = new Vector();
        lines.add(line);
        double amale = (double)numMale / (double)wuerfe.size();
        double afemale = (double)numFemale / (double)wuerfe.size();
        double aunknown = (double)(numTotal - numMale - numFemale) / (double)wuerfe.size();
        double atotal = (double)numTotal / (double)wuerfe.size();
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_AVERAGE"), FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, FactSheetMouse.formatDouble(amale), FETT_FONT, 4));
        line.add(PrintElementFactSheet.getTextElement(0, y, FactSheetMouse.formatDouble(afemale), FETT_FONT, 4));
        line.add(PrintElementFactSheet.getTextElement(0, y, FactSheetMouse.formatDouble(aunknown), FETT_FONT, 4));
        line.add(PrintElementFactSheet.getTextElement(0, y, FactSheetMouse.formatDouble(atotal), FETT_FONT, 4));
        y += FETT_FONT.getSize() + 2;
        lineYs.add(new Integer(y += 4));
        horizLineYPos.add(new Integer(y));
        return FactSheetMouse.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
    }

    private static int createExtendedParentLine(Mouse mii, Color col, Wurf wurf, Vector lines, int y, boolean headerWarDa, Vector sWsammlerM, Vector sWsammlerF, Vector sWsammlerU, Vector sWsammlerT) {
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        if (!headerWarDa) {
            line.add(PrintElementFactSheet.getTextElement(0, y, DatumFormat.getJustDateString(wurf.ivDay), FETT_FONT));
            Cage cage = wurf.getCage();
            if (cage != null) {
                line.add(PrintElementFactSheet.getTextElement(0, y, cage.getLabelIDString(), FETT_FONT));
            }
        } else {
            line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
            line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
        }
        line.add(PrintElementFactSheet.getTextElement(0, y, mii.getIDStringForReports(false), FETT_FONT, IDObjectMerker.getLink(mii, null), col));
        line.add(PrintElementFactSheet.getTextElement(0, y, mii.getCLLWLineString(), FETT_FONT, null, col));
        line.add(PrintElementFactSheet.getTextElement(0, y, mii.getGenotype(""), FETT_FONT, null, col));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT, null, col));
        String comment = mii.getString("MOS_COMMENT", " ");
        PrintElementFactSheet pefs = PrintElementFactSheet.getTextElementMaxWidthSingleLine(0, y, comment, FETT_FONT, 120);
        line.add(pefs);
        if (!headerWarDa) {
            line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(wurf.ivNumMaleBorn), FETT_FONT, 4, IDObjectMerker.getLink(sWsammlerM, null)));
            line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(wurf.ivNumFemaleBorn), FETT_FONT, 4, IDObjectMerker.getLink(sWsammlerF, null)));
            line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(wurf.ivNumBornTotal - wurf.ivNumMaleBorn - wurf.ivNumFemaleBorn), FETT_FONT, 4, IDObjectMerker.getLink(sWsammlerU, null)));
            line.add(PrintElementFactSheet.getTextElement(0, y, Integer.toString(wurf.ivNumBornTotal), FETT_FONT, 4, IDObjectMerker.getLink(sWsammlerT, null)));
        } else {
            line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
            line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
            line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
            line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
        }
        return y + STANDARD_FONT.getSize() + 5;
    }

    private static String formatDouble(double d) {
        if (Double.isNaN(d)) {
            return "n. a.";
        }
        return DF1.format(d);
    }

    private static int collectVisitElementLines(Mouse mouse, HashMap allCages, Vector target, int y, int width) {
        if (mouse != null) {
            HashMap meetings = new HashMap();
            HashMap allMice = VisitReport.collectMice(allCages, mouse.getGroup());
            HashSet<Long> mouseKids = new HashSet<Long>(10);
            long[] mkids = (long[])mouse.get("MOS_KID");
            if (mkids != null) {
                int i = 0;
                while (i < mkids.length) {
                    mouseKids.add(new Long(mkids[i]));
                    ++i;
                }
            }
            Vector lines = new Vector();
            Vector<Integer> horizLineYPos = new Vector<Integer>();
            Vector<Integer> lineYs = new Vector<Integer>();
            horizLineYPos.add(new Integer(y));
            lineYs.add(new Integer(y));
            Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
            lines.add(line);
            line.add(PrintElementFactSheet.getTextElement(0, y += 4, Babel.get("FS_CAGE"), TABHEADER_FONT));
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_START"), TABHEADER_FONT));
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_END"), TABHEADER_FONT));
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_CAGEMATES"), TABHEADER_FONT));
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_KIDS"), TABHEADER_FONT));
            y += TABHEADER_FONT.getSize() + 2;
            y += 4;
            Visit[] visArr = (Visit[])mouse.get("MOS_VISIT");
            if (visArr != null) {
                int i = 0;
                while (i < visArr.length) {
                    horizLineYPos.add(new Integer(y));
                    lineYs.add(new Integer(y));
                    y += 3;
                    Cage c = (Cage)allCages.get(new Long(visArr[i].ivCageID));
                    meetings.clear();
                    Vector cagePals = VisitReport.getCagePals(c, mouse, visArr[i], allMice, meetings);
                    int anz = cagePals.size() + 1;
                    if (anz < 1) {
                        anz = 1;
                    }
                    int j = 0;
                    while (j < anz) {
                        line = new Vector();
                        lines.add(line);
                        if (j == 0) {
                            StringBuffer ssb;
                            if (c != null) {
                                if (c.isAlive()) {
                                    line.add(PrintElementFactSheet.getTextElement(0, y, c.getLabelIDString(), FETT_FONT, IDObjectMerker.getLink(c, null)));
                                } else {
                                    line.add(PrintElementFactSheet.getTextElement(0, y, c.getLabelIDString(), FETT_FONT));
                                }
                            } else {
                                line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_UNKNOWN_CAGE"), FETT_FONT));
                            }
                            if (visArr[i].ivStartDate != null) {
                                ssb = new StringBuffer();
                                ssb.append(DatumFormat.getJustDateString(visArr[i].ivStartDate)).append(" ");
                                ssb.append(Visit.translateMode(visArr[i].ivStartMode));
                                line.add(PrintElementFactSheet.getTextElement(0, y, ssb.toString(), FETT_FONT));
                            } else {
                                line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                            }
                            if (visArr[i].ivEndDate != null) {
                                ssb = new StringBuffer();
                                ssb.append(DatumFormat.getJustDateString(visArr[i].ivEndDate)).append(" ");
                                ssb.append(Visit.translateMode(visArr[i].ivEndMode));
                                line.add(PrintElementFactSheet.getTextElement(0, y, ssb.toString(), FETT_FONT));
                            } else {
                                line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                            }
                        } else {
                            lineYs.add(new Integer(y));
                            line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                            line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                            line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                        }
                        if (j == 0) {
                            if (!cagePals.isEmpty()) {
                                if (cagePals.size() == 1) {
                                    line.add(PrintElementFactSheet.getTextElement(0, y, "1 " + Babel.get("MOUSE"), FETT_FONT, IDObjectMerker.getLink(cagePals, null)));
                                } else {
                                    line.add(PrintElementFactSheet.getTextElement(0, y, String.valueOf(cagePals.size()) + " " + Babel.get("MICE"), FETT_FONT, IDObjectMerker.getLink(cagePals, null)));
                                }
                            } else {
                                line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                            }
                        } else if (j - 1 < cagePals.size()) {
                            Mouse pal = (Mouse)cagePals.elementAt(j - 1);
                            Vector<Mouse> commonKids = new Vector<Mouse>();
                            long[] ckarr = (long[])pal.get("MOS_KID");
                            if (ckarr != null) {
                                int mki = 0;
                                while (mki < ckarr.length) {
                                    Mouse ck;
                                    if (mouseKids.contains(new Long(ckarr[mki])) && (ck = MouseManager.getMouse(ckarr[mki], pal.getGroup())) != null) {
                                        commonKids.add(ck);
                                    }
                                    ++mki;
                                }
                            }
                            line.add(PrintElementFactSheet.getTextElement(0, y, pal.getIDStringForReports(false), FETT_FONT, IDObjectMerker.getLink(pal, null)));
                            if (!commonKids.isEmpty()) {
                                if (commonKids.size() == 1) {
                                    line.add(PrintElementFactSheet.getTextElement(0, y, "1 " + Babel.get("FS_KID"), FETT_FONT, IDObjectMerker.getLink(commonKids, null)));
                                } else {
                                    line.add(PrintElementFactSheet.getTextElement(0, y, String.valueOf(commonKids.size()) + " " + Babel.get("FS_KIDS"), FETT_FONT, IDObjectMerker.getLink(commonKids, null)));
                                }
                            } else {
                                line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                            }
                            Point[] ovrArr = (Point[])meetings.get(pal.getLongID());
                            if (ovrArr != null) {
                                y += FETT_FONT.getSize() + 2;
                                int k = 0;
                                while (k < ovrArr.length) {
                                    line = new Vector();
                                    lines.add(line);
                                    line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                                    line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                                    line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                                    lineYs.add(new Integer(y));
                                    StringBuilder msb = new StringBuilder(" ");
                                    if (ovrArr[k].x == Integer.MIN_VALUE && ovrArr[k].y == Integer.MIN_VALUE) {
                                        msb.append(Babel.get("NO_DATA_AVAILABLE"));
                                    } else {
                                        if (ovrArr[k].x != Integer.MIN_VALUE) {
                                            msb.append(DatumFormat.getVeryShortDateString(new MyDate(ovrArr[k].x))).append(" ");
                                        }
                                        msb.append("-");
                                        if (ovrArr[k].y != Integer.MIN_VALUE) {
                                            msb.append(" ").append(DatumFormat.getVeryShortDateString(new MyDate(ovrArr[k].y)));
                                        }
                                    }
                                    line.add(PrintElementFactSheet.getTextElement(0, y, msb.toString(), FONT_KLEIN, null));
                                    y += FONT_KLEIN.getSize() + 2;
                                    ++k;
                                }
                                y -= FETT_FONT.getSize();
                            }
                        }
                        y += FETT_FONT.getSize() + 2 + (j == 0 ? 3 : 0);
                        ++j;
                    }
                    y += 3;
                    ++i;
                }
            }
            lineYs.add(new Integer(y));
            horizLineYPos.add(new Integer(y));
            y = FactSheetMouse.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
        }
        return y;
    }

    public static int collectResultLines(Vector wrappers, Vector target, int y, int width, boolean showExperiment) {
        Vector lines = new Vector();
        Vector<Integer> horizLineYPos = new Vector<Integer>();
        Vector<Integer> lineYs = new Vector<Integer>();
        horizLineYPos.add(new Integer(y));
        lineYs.add(new Integer(y));
        y += 4;
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        if (showExperiment) {
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_EXPERIMENT"), TABHEADER_FONT));
        } else {
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_MOUSE"), TABHEADER_FONT));
        }
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_DATE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_RESEARCHER"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_RESULT"), TABHEADER_FONT));
        y += TABHEADER_FONT.getSize() + 2;
        horizLineYPos.add(new Integer(y += 4));
        lineYs.add(new Integer(y));
        Iterator iter = wrappers.iterator();
        while (iter.hasNext()) {
            MResultWrapper wrapper = (MResultWrapper)iter.next();
            line = new Vector();
            lines.add(line);
            PrintElementFactSheet objPEN = PrintElementFactSheet.getTextElement(0, y += 3, "", FETT_FONT);
            if (showExperiment) {
                Experiment exp = wrapper.getExperiment();
                if (exp != null) {
                    objPEN = PrintElementFactSheet.getTextElement(0, y, exp.getString("EXP_NAME", ""), FETT_FONT);
                    objPEN.ivLink = IDObjectMerker.getLink(exp, null);
                }
            } else {
                Mouse mouse = MouseManager.getMouse(wrapper.ivMouseID, wrapper.ivGroup);
                if (mouse != null) {
                    objPEN = PrintElementFactSheet.getTextElement(0, y, mouse.getIDStringForReports(false), FETT_FONT);
                    objPEN.ivLink = IDObjectMerker.getLink(mouse, null);
                }
            }
            String dateStr = "";
            if (wrapper.ivMresult.ivDate != Integer.MIN_VALUE) {
                dateStr = DatumFormat.getJustDateString(wrapper.ivMresult.ivDate);
            }
            String perfStr = wrapper.ivMresult.ivPerformer;
            int lineheight = FETT_FONT.getSize() + 3;
            Object o = wrapper.ivMresult.getRepresentation(false, wrapper.ivGroup);
            if (o == null) {
                line.add(objPEN);
                line.add(PrintElementFactSheet.getTextElement(0, y, dateStr, FETT_FONT));
                line.add(PrintElementFactSheet.getTextElement(0, y, perfStr, FETT_FONT));
                line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                y += lineheight;
            } else if (o instanceof String) {
                String resrep = (String)o;
                resrep = String.valueOf(resrep) + " " + wrapper.ivMresult.getUnit(wrapper.ivGroup);
                resrep = resrep.trim();
                TextWrapComponentNeu twc = new TextWrapComponentNeu(resrep, 2, FETT_FONT, 200);
                Vector starget = twc.getElements();
                int i = 0;
                while (i < starget.size()) {
                    if (i == 0) {
                        line.add(objPEN);
                        line.add(PrintElementFactSheet.getTextElement(0, y, dateStr, FETT_FONT));
                        line.add(PrintElementFactSheet.getTextElement(0, y, perfStr, FETT_FONT));
                    } else {
                        line = new Vector();
                        lines.add(line);
                        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                        line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT));
                    }
                    TextWrapElementNeu twe = (TextWrapElementNeu)starget.elementAt(i);
                    line.add(PrintElementFactSheet.getTextElement(0, y, twe.ivText, FETT_FONT));
                    y += lineheight;
                    ++i;
                }
            } else if (o instanceof Image) {
                Image img = (Image)o;
                line.add(objPEN);
                line.add(PrintElementFactSheet.getTextElement(0, y, dateStr, FETT_FONT));
                line.add(PrintElementFactSheet.getTextElement(0, y, perfStr, FETT_FONT));
                line.add(PrintElementFactSheet.getImageElement(0, y, new ImageIcon(img), 1.0));
                int imgh = img.getHeight(null) + 3;
                if (imgh > lineheight) {
                    lineheight = imgh;
                }
                y += lineheight;
            }
            horizLineYPos.add(new Integer(y));
            lineYs.add(new Integer(y));
        }
        return FactSheetMouse.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
    }

    private static int collectTissueSampleLines(Vector samples, Vector target, int y, int width) {
        Vector lines = new Vector();
        Vector<Integer> horizLineYPos = new Vector<Integer>();
        Vector<Integer> lineYs = new Vector<Integer>();
        horizLineYPos.add(new Integer(y));
        lineYs.add(new Integer(y));
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 4, Babel.get("TISSUE_SAMPLE_ID"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_DATE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("TISSUE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("TISSUE_PREP"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("TISSUE_FIXATION"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("TISSUE_EMBEDDING"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("SAMPLE_LOCATION"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("COMMENT"), TABHEADER_FONT));
        y += TABHEADER_FONT.getSize() + 2;
        horizLineYPos.add(new Integer(y += 4));
        lineYs.add(new Integer(y));
        Iterator iter = samples.iterator();
        while (iter.hasNext()) {
            y += 3;
            TissueSample ts = (TissueSample)iter.next();
            Vector<String> commentStrings = new Vector<String>();
            if (ts.ivComment == null) {
                commentStrings.add("");
            } else {
                TextWrapComponentNeu twc = new TextWrapComponentNeu(ts.ivComment, 2, FETT_FONT, 150);
                Vector starget = twc.getElements();
                Iterator iterator = starget.iterator();
                while (iterator.hasNext()) {
                    TextWrapElementNeu twn = (TextWrapElementNeu)iterator.next();
                    commentStrings.add(twn.ivText);
                }
            }
            int i = 0;
            while (i < commentStrings.size()) {
                line = new Vector();
                lines.add(line);
                String comm = (String)commentStrings.elementAt(i);
                line.add(PrintElementFactSheet.getTextElement(0, y, i != 0 ? "" : ts.getSpecimenID(""), FETT_FONT));
                line.add(PrintElementFactSheet.getTextElement(0, y, i != 0 ? "" : ts.getDate(""), FETT_FONT));
                line.add(PrintElementFactSheet.getTextElement(0, y, i != 0 ? "" : ts.getTissue(""), FETT_FONT));
                line.add(PrintElementFactSheet.getTextElement(0, y, i != 0 ? "" : ts.getPreparation(""), FETT_FONT));
                line.add(PrintElementFactSheet.getTextElement(0, y, i != 0 ? "" : ts.getFixation(""), FETT_FONT));
                line.add(PrintElementFactSheet.getTextElement(0, y, i != 0 ? "" : ts.getEmbedding(""), FETT_FONT));
                line.add(PrintElementFactSheet.getTextElement(0, y, i != 0 ? "" : ts.getLocation(""), FETT_FONT));
                line.add(PrintElementFactSheet.getTextElement(0, y, comm, FETT_FONT));
                y += FETT_FONT.getSize();
                ++i;
            }
            horizLineYPos.add(new Integer(y += 3));
            lineYs.add(new Integer(y));
        }
        return FactSheetMouse.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
    }

    private static int collectSpecialResultReportLines(Vector resultWrapper, Vector target, int y, int width, boolean showAlsoEmptyValues) {
        Vector lines = new Vector();
        Vector<Integer> horizLineYPos = new Vector<Integer>();
        Vector<Integer> lineYs = new Vector<Integer>();
        horizLineYPos.add(new Integer(y));
        lineYs.add(new Integer(y));
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 4, Babel.get("FS_M_DATE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("TSG_RESEARCHER"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("TSG_ISSUE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("TSG_OBSERVATION"), TABHEADER_FONT));
        y += TABHEADER_FONT.getSize() + 2;
        horizLineYPos.add(new Integer(y += 4));
        lineYs.add(new Integer(y));
        HashSet rowsWithLongTextHS = new HashSet();
        Iterator iter = resultWrapper.iterator();
        while (iter.hasNext()) {
            y += 3;
            MResultWrapper wrapper = (MResultWrapper)iter.next();
            String dateStr = "";
            if (wrapper.ivMresult.ivDate != Integer.MIN_VALUE) {
                dateStr = DatumFormat.getJustDateString(wrapper.ivMresult.ivDate);
            }
            String perfStr = wrapper.ivMresult.ivPerformer;
            rowsWithLongTextHS.clear();
            Object[] arr = SpecialResultHelper.getTableRepresentation((String)wrapper.ivMresult.ivResult, rowsWithLongTextHS, SpecialResultHelper.getInstanceFor(wrapper.ivMresult.ivExpID), wrapper.ivGroup, Babel.cvUserLangue, true, showAlsoEmptyValues);
            if (arr == null || arr.length == 0) {
                arr = new String[]{"", ""};
            }
            int row = 0;
            while (row < arr.length / 2) {
                String issue = (String)arr[2 * row];
                String observation = (String)arr[2 * row + 1];
                Vector<String> subRows = new Vector<String>();
                if (rowsWithLongTextHS.contains(new Integer(row))) {
                    TextWrapComponentNeu twc = new TextWrapComponentNeu(observation, 2, FETT_FONT, 250);
                    Vector starget = twc.getElements();
                    Iterator iterator = starget.iterator();
                    while (iterator.hasNext()) {
                        TextWrapElementNeu twn = (TextWrapElementNeu)iterator.next();
                        subRows.add(twn.ivText);
                    }
                } else {
                    subRows.add(observation);
                }
                int subRow = 0;
                while (subRow < subRows.size()) {
                    line = new Vector();
                    lines.add(line);
                    line.add(PrintElementFactSheet.getTextElement(0, y, row == 0 && subRow == 0 ? dateStr : "", FETT_FONT));
                    line.add(PrintElementFactSheet.getTextElement(0, y, row == 0 && subRow == 0 ? perfStr : "", FETT_FONT));
                    line.add(PrintElementFactSheet.getTextElement(0, y, subRow == 0 ? issue : "", FETT_FONT));
                    line.add(PrintElementFactSheet.getTextElement(0, y, (String)subRows.elementAt(subRow), FETT_FONT));
                    y += FETT_FONT.getSize() + 1;
                    ++subRow;
                }
                y += 3;
                ++row;
            }
            horizLineYPos.add(new Integer(y += 3));
            lineYs.add(new Integer(y));
        }
        return FactSheetMouse.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
    }

    private static int collectPlugReportLines(Vector plugReports, Vector target, int y, int width) {
        Vector lines = new Vector();
        Vector<Integer> horizLineYPos = new Vector<Integer>();
        Vector<Integer> lineYs = new Vector<Integer>();
        horizLineYPos.add(new Integer(y));
        lineYs.add(new Integer(y));
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 4, Babel.get("FS_M_FEMALE_PARTNERS"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_DATE_IN"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_PLUG_DATE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_DATE_OUT"), TABHEADER_FONT));
        y += TABHEADER_FONT.getSize() + 2;
        horizLineYPos.add(new Integer(y += 4));
        lineYs.add(new Integer(y));
        Iterator iter = plugReports.iterator();
        while (iter.hasNext()) {
            line = new Vector();
            lines.add(line);
            PlugReportObject pro = (PlugReportObject)iter.next();
            line.add(PrintElementFactSheet.getTextElement(0, y += 3, pro.ivMouse.getIDStringForReports(false), FETT_FONT, IDObjectMerker.getLink(pro.ivMouse, null)));
            String datestr = "";
            if (pro.ivInDate != Integer.MIN_VALUE) {
                datestr = DatumFormat.getJustDateString(new Date(new MyDate(pro.ivInDate).getTime()));
            }
            line.add(PrintElementFactSheet.getTextElement(0, y, datestr, FETT_FONT, 0));
            datestr = "";
            if (pro.ivPlugDate != Integer.MIN_VALUE) {
                datestr = DatumFormat.getJustDateString(new Date(new MyDate(pro.ivPlugDate).getTime()));
            }
            line.add(PrintElementFactSheet.getTextElement(0, y, datestr, FETT_FONT, 0));
            datestr = "";
            if (pro.ivOutDate != Integer.MIN_VALUE) {
                datestr = DatumFormat.getJustDateString(new Date(new MyDate(pro.ivOutDate).getTime()));
            }
            line.add(PrintElementFactSheet.getTextElement(0, y, datestr, FETT_FONT, 0));
            horizLineYPos.add(new Integer(y += FETT_FONT.getSize() + 3));
            lineYs.add(new Integer(y));
        }
        return FactSheetMouse.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
    }
}

