/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.NULLObject;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PrinterJob;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import mausoleum.cage.Cage;
import mausoleum.factsheets.FactSheet;
import mausoleum.factsheets.FactSheetComponentScreen;
import mausoleum.factsheets.FactSheetFrame;
import mausoleum.factsheets.FactSheetPrintDelegate;
import mausoleum.factsheets.FactSheetPrintPreviewFrame;
import mausoleum.factsheets.FactSheetPrinter;
import mausoleum.factsheets.IDObjectMerker;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.gui.ClosableTabbedPane;
import mausoleum.gui.MDisposable;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.FocusHoler;
import mausoleum.helper.FontManager;
import mausoleum.helper.KomfortHashMap;
import mausoleum.helper.WindowUtils;
import mausoleum.inspector.DormantPanel;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.locus.LOAWeb;
import mausoleum.line.Line;
import mausoleum.locus.Locus;
import mausoleum.mouse.Mouse;
import mausoleum.printing.util.CPPageFormat;
import mausoleum.printing.util.CPPageFormatDialog;
import mausoleum.rack.frame.RackFrame;
import mausoleum.strain.Strain;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.models.MTCageFS;
import mausoleum.tables.models.MTLineFS;
import mausoleum.tables.models.MTLocusFS;
import mausoleum.tables.models.MTMouseFS;
import mausoleum.tables.models.MTStrainFS;
import mausoleum.tables.models.MTUserFS;
import mausoleum.ui.UIDef;

public class FactSheetPanel
extends RequesterPane
implements ActionListener,
LayoutManager,
MDisposable,
FactSheetPrintDelegate {
    private static final long serialVersionUID = 1L;
    private static final int RAND = UIDef.getScaled(5);
    private static final int BUT_HEIGHT = UIDef.getScaled(24);
    private static final String COM_VOR = "VOR";
    private static final String COM_ZURUECK = "ZURUECK";
    private static final String COM_PRINT = "PRINT";
    private static final String COM_PRINT_ALL = "PRINTALL";
    private static final String COM_PREVIEW = "PREVIEW";
    private static final String COM_PREVIEW_ALL = "PREVIEWALL";
    private static final String COM_COPYTAB = "COPYTAB";
    protected final FactSheetComponentScreen ivComponent;
    protected final JScrollPane ivScrollpane;
    private final Hashtable ivButtonsHT = new Hashtable(10);
    private final Vector ivObjectVectors = new Vector();
    private final Vector ivSelectionHashMaps = new Vector();
    private int ivAktPos = -1;
    public String ivTabName = "";
    public String ivLink = null;
    public final String ivGroup;
    public final String ivTitle;
    static /* synthetic */ Class class$0;

    public FactSheetPanel(String group, Vector objects, KomfortHashMap infoSelection, String title) {
        super((LayoutManager)new BorderLayout(), "inspectorButton");
        this.setLayout(this);
        this.setOpaque(false);
        this.ivTitle = title;
        this.ivGroup = group;
        this.ivComponent = new FactSheetComponentScreen(true);
        this.ivScrollpane = new JScrollPane(this.ivComponent);
        this.ivScrollpane.setVerticalScrollBarPolicy(22);
        this.ivScrollpane.setHorizontalScrollBarPolicy(31);
        this.ivScrollpane.getVerticalScrollBar().setUnitIncrement(20);
        this.add(this.ivScrollpane);
        this.enterButton(new MGButton("<"), COM_ZURUECK, true, this);
        this.enterButton(new MGButton(">"), COM_VOR, true, this);
        this.enterButton(new MGButton(Babel.get("FS_PM_COPY_TAB")), COM_COPYTAB, true, this);
        this.enterButton(new MGButton(Babel.get(COM_PREVIEW)), COM_PREVIEW, true, this);
        this.enterButton(new MGButton(Babel.get(COM_PRINT)), COM_PRINT, true, this);
        this.enterButton(new MGButton(Babel.get(COM_PREVIEW_ALL)), COM_PREVIEW_ALL, true, this);
        this.enterButton(new MGButton(Babel.get(COM_PRINT_ALL)), COM_PRINT_ALL, true, this);
        this.handleObjects(objects, true, infoSelection);
        this.ivScrollpane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                FactSheetPanel.this.ivComponent.manageResize();
                FactSheetPanel.this.ivScrollpane.repaint();
            }
        });
        this.ivComponent.setPrintDelegate(this);
        this.ivComponent.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JComponent comp;
                FactSheetPanel.this.ivLink = null;
                Object o = FactSheetPanel.this.ivComponent.getElementAt(e.getPoint(), -1);
                if (o instanceof PrintElementFactSheet) {
                    PrintElementFactSheet pe = (PrintElementFactSheet)o;
                    FactSheetPanel.this.ivLink = pe.ivLink;
                }
                if (FactSheetPanel.this.ivLink != null && FactSheetPanel.this.ivLink.trim().length() != 0) {
                    FactSheetPanel.this.ivComponent.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        if (e.isMetaDown()) {
                            if (!FactSheetPanel.this.ivLink.startsWith("ensembl_") && !FactSheetPanel.this.ivLink.startsWith("mgi_")) {
                                comp = (JComponent)e.getSource();
                                FactSheetPanel.this.createMenu(true).show(comp, e.getX(), e.getY());
                            }
                        } else if (FactSheetPanel.this.ivLink.startsWith("ensembl_")) {
                            LOAWeb.openUrl(true, FactSheetPanel.this.ivLink.substring("ensembl_".length(), FactSheetPanel.this.ivLink.length()));
                        } else if (FactSheetPanel.this.ivLink.startsWith("mgi_")) {
                            LOAWeb.openUrl(false, FactSheetPanel.this.ivLink.substring("mgi_".length(), FactSheetPanel.this.ivLink.length()));
                        } else {
                            FactSheetPanel.this.gleicherTab(IDObjectMerker.getObjectsFromLink(FactSheetPanel.this.ivLink));
                        }
                    }
                    catch (Exception comp2) {
                        // empty catch block
                    }
                    FactSheetPanel.this.ivComponent.setCursor(Cursor.getDefaultCursor());
                } else {
                    FactSheetPanel.this.ivComponent.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        if (e.isMetaDown()) {
                            comp = (JComponent)e.getSource();
                            FactSheetPanel.this.createMenu(false).show(comp, e.getX(), e.getY());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    FactSheetPanel.this.ivComponent.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.ivComponent.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                Object o = FactSheetPanel.this.ivComponent.getElementAt(e.getPoint(), -1);
                if (o instanceof PrintElementFactSheet) {
                    PrintElementFactSheet pe = (PrintElementFactSheet)o;
                    if (pe.ivLink != null) {
                        Vector v;
                        if (!pe.ivLink.startsWith("ensembl_") && !pe.ivLink.startsWith("mgi_") && (v = IDObjectMerker.getObjectsFromLink(pe.ivLink)) != null && v.size() == 1) {
                            Object obj = v.elementAt(0);
                            if (obj instanceof Mouse) {
                                Mouse mouse = (Mouse)obj;
                                FactSheetPanel.this.ivComponent.setToolTipText(mouse.getToolTipString());
                            } else if (obj instanceof Cage) {
                                Cage cage = (Cage)obj;
                                FactSheetPanel.this.ivComponent.setToolTipText(cage.getToolTipString(false));
                            }
                        }
                        FactSheetPanel.this.ivComponent.setCursor(Cursor.getPredefinedCursor(12));
                        return;
                    }
                }
                FactSheetPanel.this.ivComponent.setCursor(Cursor.getDefaultCursor());
                FactSheetPanel.this.ivComponent.setToolTipText(null);
            }
        });
        new FocusHoler(this.ivComponent);
    }

    private void enterButton(MGButton but, String ac, boolean enabled, JPanel panel) {
        but.setActionCommand(ac);
        but.addActionListener(this);
        but.setFont(FontManager.getFont("SSB12"));
        but.setFocusable(false);
        this.ivButtonsHT.put(ac, but);
        but.setEnabled(enabled);
        panel.add(but);
    }

    private void neuesFenster(Vector lobjects) {
        if (lobjects != null && !lobjects.isEmpty()) {
            FactSheetFrame fsfs = new FactSheetFrame(10, 10);
            fsfs.addNewTab(this.ivGroup, lobjects, null, null, this.ivTitle, null, true);
        }
    }

    private void neuerTab(Vector lobjects, KomfortHashMap infoSelection) {
        if (lobjects != null && !lobjects.isEmpty()) {
            JFrame jf = WindowUtils.getJFrame(this);
            if (jf instanceof FactSheetFrame) {
                FactSheetFrame fsf = (FactSheetFrame)jf;
                fsf.addNewTab(this.ivGroup, lobjects, infoSelection, this.ivTitle);
            }
            this.checkButs();
        }
    }

    private void neuerTab(MausoleumTable mt, String titel) {
        JFrame jf;
        if (mt != null && (jf = WindowUtils.getJFrame(this)) instanceof FactSheetFrame) {
            FactSheetFrame fsf = (FactSheetFrame)jf;
            fsf.addNewTableTab(mt, titel);
        }
    }

    private void tabKopie() {
        Vector objects = (Vector)this.ivObjectVectors.elementAt(this.ivAktPos);
        Vector nobj = new Vector(objects.size());
        nobj.addAll(objects);
        KomfortHashMap infoSelection = null;
        Object ooo = this.ivSelectionHashMaps.elementAt(this.ivAktPos);
        if (ooo instanceof KomfortHashMap) {
            infoSelection = (KomfortHashMap)ooo;
        }
        this.neuerTab(nobj, infoSelection);
    }

    private void gleicherTab(Vector lobjects) {
        if (lobjects != null && !lobjects.isEmpty()) {
            this.handleObjects(lobjects, true, null);
        }
    }

    public void anhaengen(Vector lobjects) {
        if (lobjects != null && !lobjects.isEmpty() && this.ivAktPos < this.ivObjectVectors.size()) {
            Vector altobjects = (Vector)this.ivObjectVectors.elementAt(this.ivAktPos);
            Vector nlobjects = new Vector(lobjects.size() + altobjects.size());
            nlobjects.addAll(altobjects);
            nlobjects.addAll(lobjects);
            this.handleObjects(nlobjects, false, null);
        }
    }

    private void vor() {
        if (this.ivAktPos < this.ivObjectVectors.size() - 1) {
            Vector objects = (Vector)this.ivObjectVectors.elementAt(this.ivAktPos + 1);
            KomfortHashMap infoSelection = null;
            Object esi = this.ivSelectionHashMaps.elementAt(this.ivAktPos + 1);
            if (esi instanceof KomfortHashMap) {
                infoSelection = (KomfortHashMap)esi;
            }
            ++this.ivAktPos;
            this.displayObjects(objects, true, infoSelection);
        }
    }

    private void zurueck() {
        if (this.ivAktPos > 0) {
            Vector objects = (Vector)this.ivObjectVectors.elementAt(this.ivAktPos - 1);
            KomfortHashMap infoSelection = null;
            Object esi = this.ivSelectionHashMaps.elementAt(this.ivAktPos - 1);
            if (esi instanceof KomfortHashMap) {
                infoSelection = (KomfortHashMap)esi;
            }
            --this.ivAktPos;
            this.displayObjects(objects, true, infoSelection);
        }
    }

    private void generatePrinter(boolean preview) {
        Vector objects = (Vector)this.ivObjectVectors.elementAt(this.ivAktPos);
        KomfortHashMap infoSelection = null;
        if (!(this.ivSelectionHashMaps.elementAt(this.ivAktPos) instanceof NULLObject)) {
            infoSelection = (KomfortHashMap)this.ivSelectionHashMaps.elementAt(this.ivAktPos);
        }
        FactSheetPanel.printFactSheet(preview, objects, this.ivGroup, this.ivTitle, WindowUtils.getJFrame(this), infoSelection);
    }

    private void printAllFactSheets(boolean preview) {
        ClosableTabbedPane ctb;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.gui.ClosableTabbedPane");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ctb = (ClosableTabbedPane)WindowUtils.findComponent(clazz, this)) != null) {
            Vector<Component> factSheetPanels = new Vector<Component>();
            Component[] arr = ctb.getAllTabComponents();
            if (arr != null) {
                int i = 0;
                while (i < arr.length) {
                    if (arr[i] instanceof FactSheetPanel) {
                        factSheetPanels.add(arr[i]);
                    }
                    ++i;
                }
            }
            if (!factSheetPanels.isEmpty()) {
                boolean[] pageBreaks = new boolean[1];
                CPPageFormat pageFormat = FactSheetPanel.getPageFormat(preview, WindowUtils.getJFrame(this), pageBreaks);
                if (pageFormat != null) {
                    Vector documentElements = new Vector();
                    Iterator iterator = factSheetPanels.iterator();
                    while (iterator.hasNext()) {
                        FactSheetPanel fsp = (FactSheetPanel)iterator.next();
                        Vector objects = (Vector)fsp.ivObjectVectors.elementAt(fsp.ivAktPos);
                        KomfortHashMap infoSelection = null;
                        if (!(fsp.ivSelectionHashMaps.elementAt(fsp.ivAktPos) instanceof NULLObject)) {
                            infoSelection = (KomfortHashMap)fsp.ivSelectionHashMaps.elementAt(fsp.ivAktPos);
                        }
                        Vector ttarget = new Vector();
                        FactSheet.fillElements(fsp.ivGroup, objects, (int)pageFormat.getImageableWidth(), ttarget, null, infoSelection);
                        Vector tdoc = FactSheetPrinter.createDocument(ttarget, pageFormat, fsp.ivTitle, true, pageBreaks[0]);
                        documentElements.addAll(tdoc);
                    }
                    FactSheetPanel.printIt(documentElements, pageFormat, preview);
                }
            }
        }
    }

    public static void printFactSheet(boolean preview, Vector objects, String group, String title, JFrame sender, KomfortHashMap infoSelection) {
        boolean[] pageBreaks;
        CPPageFormat pageFormat;
        if (objects != null && !objects.isEmpty() && (pageFormat = FactSheetPanel.getPageFormat(preview, sender, pageBreaks = new boolean[1])) != null) {
            Vector printElementsTarget = new Vector();
            FactSheet.fillElements(group, objects, (int)pageFormat.getImageableWidth(), printElementsTarget, null, infoSelection);
            Vector documentPages = FactSheetPrinter.createDocument(printElementsTarget, pageFormat, title, true, pageBreaks[0]);
            FactSheetPanel.printIt(documentPages, pageFormat, preview);
        }
    }

    private static void printIt(Vector documentPages, CPPageFormat pageFormat, boolean preview) {
        if (!documentPages.isEmpty()) {
            FactSheetPrinter fsp = new FactSheetPrinter(pageFormat, documentPages, PrinterJob.getPrinterJob());
            if (preview) {
                new FactSheetPrintPreviewFrame(fsp);
            } else {
                fsp.printIt();
            }
        }
    }

    private static CPPageFormat getPageFormat(boolean preview, JFrame sender, boolean[] pageBreaks) {
        String butTitel = Babel.get(COM_PRINT);
        if (preview) {
            butTitel = Babel.get("PRINT_PREVIEW");
        }
        JCheckBox box = new JCheckBox(Babel.get("PAGEBREAK_FOR_RECORDS"));
        box.setOpaque(false);
        Vector<JCheckBox> extracomps = new Vector<JCheckBox>();
        extracomps.add(box);
        CPPageFormat format = CPPageFormatDialog.getPageFormat(sender, null, butTitel, extracomps);
        pageBreaks[0] = box.isSelected();
        return format;
    }

    private void handleObjects(Vector objects, boolean changeScrollPos, KomfortHashMap infoSelection) {
        if (this.ivAktPos < 0) {
            this.ivObjectVectors.clear();
            this.ivObjectVectors.add(objects);
            this.ivSelectionHashMaps.clear();
            this.ivSelectionHashMaps.add(infoSelection);
            this.ivAktPos = 0;
        } else {
            Vector zv = new Vector(this.ivAktPos);
            int i = 0;
            while (i <= this.ivAktPos) {
                zv.add(this.ivObjectVectors.elementAt(i));
                ++i;
            }
            this.ivObjectVectors.clear();
            this.ivObjectVectors.addAll(zv);
            this.ivObjectVectors.add(objects);
            zv.clear();
            i = 0;
            while (i <= this.ivAktPos) {
                zv.add(this.ivSelectionHashMaps.elementAt(i));
                ++i;
            }
            this.ivSelectionHashMaps.clear();
            this.ivSelectionHashMaps.addAll(zv);
            if (infoSelection == null) {
                this.ivSelectionHashMaps.add(NULLObject.INSTANCE);
            } else {
                this.ivSelectionHashMaps.add(infoSelection);
            }
            ++this.ivAktPos;
        }
        this.displayObjects(objects, changeScrollPos, infoSelection);
    }

    private void displayObjects(Vector objects, boolean changeScrollPos, KomfortHashMap infoSelection) {
        JTabbedPane jtb;
        StringBuffer kurzTitelSB = new StringBuffer();
        Vector elements = new Vector();
        int y = FactSheet.fillElements(null, objects, 600, elements, kurzTitelSB, infoSelection);
        this.ivTabName = kurzTitelSB.toString();
        this.ivComponent.setElements(elements, y);
        this.ivComponent.revalidate();
        this.ivComponent.repaint();
        if (changeScrollPos) {
            this.ivScrollpane.getVerticalScrollBar().setValue(0);
        }
        if ((jtb = WindowUtils.getJTabbedPane(this)) != null) {
            int count = jtb.getTabCount();
            int i = 0;
            while (i < count) {
                if (jtb.getComponentAt(i) == this) {
                    jtb.setTitleAt(i, this.ivTabName);
                }
                ++i;
            }
        }
        this.checkButs();
        DormantPanel.actionDone();
    }

    protected void checkButs() {
        ((JComponent)this.ivButtonsHT.get(COM_VOR)).setEnabled(this.ivAktPos < this.ivObjectVectors.size() - 1);
        ((JComponent)this.ivButtonsHT.get(COM_ZURUECK)).setEnabled(this.ivAktPos > 0);
    }

    public void mDispose() {
        if (this.ivObjectVectors != null) {
            Iterator iter = this.ivObjectVectors.iterator();
            while (iter.hasNext()) {
                Vector v = (Vector)iter.next();
                v.clear();
            }
            this.ivObjectVectors.clear();
        }
        this.ivButtonsHT.clear();
        this.ivObjectVectors.clear();
        this.ivSelectionHashMaps.clear();
    }

    private JPopupMenu createMenu(boolean hasLink) {
        JPopupMenu erg = new JPopupMenu();
        if (hasLink) {
            int ot;
            JMenuItem item = new JMenuItem(Babel.get("FS_PM_OPEN_HERE"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FactSheetPanel.this.gleicherTab(IDObjectMerker.getObjectsFromLink(FactSheetPanel.this.ivLink));
                }
            });
            erg.add(item);
            item = new JMenuItem(Babel.get("FS_PM_OPEN_NEW_TAB"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FactSheetPanel.this.neuerTab(IDObjectMerker.getObjectsFromLink(FactSheetPanel.this.ivLink), null);
                }
            });
            erg.add(item);
            item = new JMenuItem(Babel.get("FS_PM_OPEN_NEW_FRAME"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FactSheetPanel.this.neuesFenster(IDObjectMerker.getObjectsFromLink(FactSheetPanel.this.ivLink));
                }
            });
            erg.add(item);
            item = new JMenuItem(Babel.get("FS_PM_APPEND"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FactSheetPanel.this.anhaengen(IDObjectMerker.getObjectsFromLink(FactSheetPanel.this.ivLink));
                }
            });
            erg.add(item);
            if (Inspector.getInspector().isAliveAndAwake() && (ot = IDObjectMerker.getCommonIDObjectType(this.ivLink, -1)) != -1) {
                Vector sov;
                IDObject ido;
                item = new JMenuItem(Babel.get("FS_PM_SHOW_IN_TAB"));
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Vector v = IDObjectMerker.getObjectsFromLink(FactSheetPanel.this.ivLink);
                        if (v != null && !v.isEmpty()) {
                            MausoleumTableModel mtm = null;
                            if (v.elementAt(0) instanceof Mouse) {
                                mtm = new MTMouseFS();
                            } else if (v.elementAt(0) instanceof Cage) {
                                mtm = new MTCageFS();
                            } else if (v.elementAt(0) instanceof Line) {
                                mtm = new MTLineFS();
                            } else if (v.elementAt(0) instanceof Strain) {
                                mtm = new MTStrainFS();
                            } else if (v.elementAt(0) instanceof Locus) {
                                mtm = new MTLocusFS();
                            } else if (v.elementAt(0) instanceof User) {
                                mtm = new MTUserFS();
                            }
                            if (mtm != null) {
                                MausoleumTable mt = new MausoleumTable(mtm, false);
                                mt.setIsSubdisplay();
                                mt.setHeader("");
                                ((MausoleumTableModel)mtm).setTable(v);
                                mt.setOwnerButtonState(true);
                                StringBuffer kurzTitelSB = new StringBuffer();
                                if (v.size() == 1) {
                                    kurzTitelSB.append("T 1 object");
                                } else {
                                    kurzTitelSB.append("T ").append(v.size()).append(" objects");
                                }
                                FactSheetPanel.this.neuerTab(mt, kurzTitelSB.toString());
                            }
                        }
                    }
                });
                erg.add(item);
                if ((ot == 1 || ot == 2) && IDObjectMerker.isSingleObjectLink(this.ivLink) && (ido = (IDObject)(sov = IDObjectMerker.getObjectsFromLink(this.ivLink)).elementAt(0)).isAliveAndVisible()) {
                    boolean possible = false;
                    if (ido instanceof Cage) {
                        Cage cage = (Cage)ido;
                        possible = cage.getSuperCageIfThere().getRack() != null;
                    } else if (ido instanceof Mouse) {
                        Mouse mouse = (Mouse)ido;
                        boolean bl = possible = mouse.getRack() != null;
                    }
                    if (possible) {
                        item = new JMenuItem(Babel.get("FS_PM_SHOW_POS"));
                        item.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                Vector sov2 = IDObjectMerker.getObjectsFromLink(FactSheetPanel.this.ivLink);
                                if (sov2 != null && sov2.size() == 1) {
                                    Cage c;
                                    IDObject ido2 = (IDObject)sov2.elementAt(0);
                                    if (ido2 instanceof Cage) {
                                        RackFrame.showCagePosition(sov2);
                                    }
                                    if (ido2 instanceof Mouse && (c = ((Mouse)ido2).getActCage()) != null) {
                                        Vector<Cage> sov3 = new Vector<Cage>();
                                        sov3.add(c);
                                        RackFrame.showCagePosition(sov3);
                                    }
                                }
                            }
                        });
                        erg.add(item);
                    }
                }
            }
        }
        if (this.ivComponent != null) {
            this.ivComponent.addPopupItems(erg);
        }
        return erg;
    }

    public void printFactSheet(boolean isPreview) {
        this.generatePrinter(isPreview);
    }

    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals(COM_VOR)) {
            this.vor();
        } else if (comm.equals(COM_ZURUECK)) {
            this.zurueck();
        } else if (comm.equals(COM_COPYTAB)) {
            this.tabKopie();
        } else if (comm.equals(COM_PRINT)) {
            this.generatePrinter(false);
        } else if (comm.equals(COM_PREVIEW)) {
            this.generatePrinter(true);
        } else if (comm.equals(COM_PRINT_ALL)) {
            this.printAllFactSheets(false);
        } else if (comm.equals(COM_PREVIEW_ALL)) {
            this.printAllFactSheets(true);
        }
    }

    public void addLayoutComponent(String s, Component c) {
    }

    public void layoutContainer(Container c) {
        Dimension d = c.getSize();
        int width = d.width;
        int height = d.height;
        int innerwidth = width - 2 * RAND;
        int innerheight = height - 2 * RAND;
        int obenheight = innerheight - RAND - BUT_HEIGHT;
        this.ivScrollpane.setBounds(RAND, RAND, innerwidth, obenheight);
        int uy = 2 * RAND + obenheight;
        if (this.ivButtonsHT != null && !this.ivButtonsHT.isEmpty()) {
            int anzbuts = this.ivButtonsHT.size();
            int urand = 3;
            int raender = (anzbuts - 1) * urand;
            int platz = innerwidth - raender;
            String[] BUT_LAYOUT_COMS = new String[]{COM_ZURUECK, COM_VOR, COM_COPYTAB, COM_PREVIEW, COM_PRINT, COM_PREVIEW_ALL, COM_PRINT_ALL};
            int sum = 0;
            int i = 0;
            while (i < BUT_LAYOUT_COMS.length) {
                JComponent jc = (JComponent)this.ivButtonsHT.get(BUT_LAYOUT_COMS[i]);
                sum += jc.getPreferredSize().width;
                ++i;
            }
            int uebrig = platz - sum;
            int ganzuebrig = uebrig / anzbuts;
            int restuebrig = uebrig - anzbuts * ganzuebrig;
            int ux = RAND;
            int i2 = 0;
            while (i2 < BUT_LAYOUT_COMS.length) {
                JComponent jc = (JComponent)this.ivButtonsHT.get(BUT_LAYOUT_COMS[i2]);
                int w = jc.getPreferredSize().width + ganzuebrig;
                if (restuebrig > 0) {
                    ++w;
                    --restuebrig;
                }
                jc.setBounds(ux, uy, w, BUT_HEIGHT);
                ux += w + urand;
                ++i2;
            }
        }
    }

    public Dimension minimumLayoutSize(Container c) {
        return new Dimension(400, 300);
    }

    public Dimension preferredLayoutSize(Container c) {
        return new Dimension(800, 600);
    }

    public void removeLayoutComponent(Component c) {
    }
}

