/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.print.PageFormat;
import java.io.File;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import mausoleum.factsheets.FactSheetPrinter;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.FileHelper;
import mausoleum.helper.FontManager;
import mausoleum.helper.MFF;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.ui.UIDef;

public class FactSheetPrintPreviewFrame
extends JFrame
implements ActionListener,
LayoutManager {
    private static final long serialVersionUID = 11681351353L;
    protected final JComponent ivComponent;
    protected final JScrollPane ivScrollpane;
    private final HashMap ivButtonsByActionCommand = new HashMap(10);
    protected final FactSheetPrinter ivPrinter;
    protected int ivAktPage = 0;

    public FactSheetPrintPreviewFrame(FactSheetPrinter hePrinter) {
        RequesterPane panel = new RequesterPane(this);
        this.setContentPane(panel);
        this.setIconImage(MausoleumImageStore.getLogo());
        this.ivPrinter = hePrinter;
        this.ivComponent = new JComponent(){
            private static final long serialVersionUID = 145L;

            public Dimension getPreferredSize() {
                PageFormat pf = FactSheetPrintPreviewFrame.this.ivPrinter.getPageFormat();
                return new Dimension((int)(FactSheetPrintPreviewFrame.this.ivPrinter.ivFaktor * pf.getWidth()), (int)(FactSheetPrintPreviewFrame.this.ivPrinter.ivFaktor * pf.getHeight()));
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public void paint(Graphics g) {
                PageFormat pf = FactSheetPrintPreviewFrame.this.ivPrinter.getPageFormat();
                g.setColor(Color.white);
                g.fillRect(0, 0, (int)(FactSheetPrintPreviewFrame.this.ivPrinter.ivFaktor * pf.getWidth()), (int)(FactSheetPrintPreviewFrame.this.ivPrinter.ivFaktor * pf.getHeight()));
                try {
                    FactSheetPrintPreviewFrame.this.ivPrinter.print(g, pf, FactSheetPrintPreviewFrame.this.ivAktPage);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.ivScrollpane = new JScrollPane(this.ivComponent);
        this.ivScrollpane.setVerticalScrollBarPolicy(22);
        this.ivScrollpane.setHorizontalScrollBarPolicy(31);
        panel.add(this.ivScrollpane);
        if (this.ivPrinter.getNumberOfPages() > 1) {
            this.enterButton(new MGButton(Babel.get("PRINT_FIRST")), "FIRST", false, panel);
            this.enterButton(new MGButton(Babel.get("PRINT_PREVIOUS")), "PREV", false, panel);
            this.enterButton(new MGButton(Babel.get("PRINT_NEXT")), "NEXT", false, panel);
            this.enterButton(new MGButton(Babel.get("PRINT_LAST")), "LAST", false, panel);
        }
        this.enterButton(new MGButton(Babel.get("PRINT")), "PRINT", true, panel);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FactSheetPrintPreviewFrame jf = (FactSheetPrintPreviewFrame)WindowUtils.getJFrame(FactSheetPrintPreviewFrame.this.ivComponent);
                if (jf != null) {
                    int ww = 0;
                    int wh = 0;
                    jf.pack();
                    Insets inni = FactSheetPrintPreviewFrame.this.getInsets();
                    PageFormat pf = jf.ivPrinter.getPageFormat();
                    ww = inni.left + inni.right + (int)pf.getWidth() + 2 * UIDef.INNER_RAND + UIDef.INNER_RAND;
                    wh = inni.top + inni.bottom + (int)pf.getHeight() + 3 * UIDef.INNER_RAND + UIDef.BUT_HEIGHT + UIDef.INNER_RAND;
                    WindowUtils.setSizeAndCenterOnScreen(jf, ww, wh);
                    FactSheetPrintPreviewFrame.this.adjustButtons();
                    WindowUtils.bringUpFrame(jf);
                }
            }
        });
        this.ivScrollpane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Dimension d = FactSheetPrintPreviewFrame.this.ivScrollpane.getViewport().getSize();
                FactSheetPrintPreviewFrame.this.ivPrinter.ivFaktor = (double)d.width / FactSheetPrintPreviewFrame.this.ivPrinter.getPageFormat().getWidth();
                FactSheetPrintPreviewFrame.this.ivScrollpane.repaint();
            }
        });
    }

    private void enterButton(MGButton but, String ac, boolean enabled, JPanel panel) {
        but.setActionCommand(ac);
        but.addActionListener(this);
        but.setFont(FontManager.getFont("SSB12"));
        this.ivButtonsByActionCommand.put(ac, but);
        but.setEnabled(enabled);
        panel.add(but);
    }

    private void adjustButtons() {
        this.setTitle(String.valueOf(Babel.get("PRINT_PREVIEW")) + " " + Babel.get("PRINT_PAGE") + (this.ivAktPage + 1));
        int anyPages = this.ivPrinter.getNumberOfPages();
        if (anyPages > 1) {
            this.setEnabled("FIRST", this.ivAktPage != 0);
            this.setEnabled("PREV", this.ivAktPage != 0);
            this.setEnabled("NEXT", this.ivAktPage < anyPages - 1);
            this.setEnabled("LAST", this.ivAktPage < anyPages - 1);
        }
    }

    private void setEnabled(String com, boolean en) {
        MGButton mgb = (MGButton)this.ivButtonsByActionCommand.get(com);
        if (mgb != null) {
            mgb.setEnabled(en);
        }
    }

    private void setPage(int page) {
        this.ivAktPage = page;
        this.ivComponent.repaint();
        this.adjustButtons();
    }

    public void actionPerformed(ActionEvent e) {
        File file;
        String comm = e.getActionCommand();
        if (comm.equals("FIRST")) {
            this.setPage(0);
        } else if (comm.equals("PREV")) {
            this.setPage(this.ivAktPage - 1);
        } else if (comm.equals("NEXT")) {
            this.setPage(this.ivAktPage + 1);
        } else if (comm.equals("LAST")) {
            this.setPage(this.ivPrinter.getNumberOfPages() - 1);
        } else if (comm.equals("PRINT")) {
            this.ivPrinter.printIt();
        } else if (comm.equals("PDF") && (file = FileHelper.selectFile(this, Babel.get("SELECT_OUTPUT_FILE"), true, MFF.getFilter(3), null)) != null) {
            this.ivPrinter.pdfIt(file.getAbsolutePath());
        }
    }

    public void addLayoutComponent(String s, Component c) {
    }

    public void layoutContainer(Container c) {
        Dimension d = c.getSize();
        int width = d.width;
        int height = d.height;
        int innerwidth = width - 2 * UIDef.INNER_RAND;
        int innerheight = height - 2 * UIDef.INNER_RAND;
        int obenheight = innerheight - UIDef.INNER_RAND - UIDef.BUT_HEIGHT;
        this.ivScrollpane.setBounds(UIDef.INNER_RAND, UIDef.INNER_RAND, innerwidth, obenheight);
        int uy = 2 * UIDef.INNER_RAND + obenheight;
        if (this.ivPrinter.getNumberOfPages() > 1) {
            int anzbuts = 5;
            int butw = (innerwidth - (anzbuts - 1) * UIDef.INNER_RAND) / anzbuts;
            int lbutw = innerwidth - (anzbuts - 1) * UIDef.INNER_RAND - (anzbuts - 1) * butw;
            int ux = UIDef.INNER_RAND;
            ((JComponent)this.ivButtonsByActionCommand.get("FIRST")).setBounds(ux, uy, butw, UIDef.BUT_HEIGHT);
            ((JComponent)this.ivButtonsByActionCommand.get("PREV")).setBounds(ux += butw + UIDef.INNER_RAND, uy, butw, UIDef.BUT_HEIGHT);
            ((JComponent)this.ivButtonsByActionCommand.get("NEXT")).setBounds(ux += butw + UIDef.INNER_RAND, uy, butw, UIDef.BUT_HEIGHT);
            ((JComponent)this.ivButtonsByActionCommand.get("LAST")).setBounds(ux += butw + UIDef.INNER_RAND, uy, butw, UIDef.BUT_HEIGHT);
            ((JComponent)this.ivButtonsByActionCommand.get("PRINT")).setBounds(ux += butw + UIDef.INNER_RAND, uy, lbutw, UIDef.BUT_HEIGHT);
            ux += butw + UIDef.INNER_RAND;
        } else {
            int anzbuts = 1;
            int butw = (innerwidth - (anzbuts - 1) * UIDef.INNER_RAND) / anzbuts;
            int ux = UIDef.INNER_RAND;
            ((JComponent)this.ivButtonsByActionCommand.get("PRINT")).setBounds(ux, uy, butw, UIDef.BUT_HEIGHT);
            ux += butw + UIDef.INNER_RAND;
        }
    }

    public Dimension minimumLayoutSize(Container c) {
        return new Dimension(400, 300);
    }

    public Dimension preferredLayoutSize(Container c) {
        return new Dimension(800, 600);
    }

    public void removeLayoutComponent(Component c) {
    }
}

