/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.objectstore.NULLObject;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import mausoleum.factsheets.FactSheet;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.helper.DatumFormat;
import mausoleum.printing.PrintTask;

public class FactSheetPrinter
implements Pageable,
Printable {
    private static final int HEADER_PLATZ = 26;
    private static final int FOOTER_PLATZ = 24;
    private Vector ivDocument = new Vector();
    public PageFormat ivPageFormat = null;
    public double ivFaktor = 1.0;
    public int ivXOffset = 0;
    private PrinterJob ivJob = null;
    private Rectangle ivUsedRect = null;
    private double ivInnerFactor = 1.0;

    public static int getMaxY(PageFormat pageformat, boolean withFooter) {
        return (int)pageformat.getImageableHeight() - 26 - (withFooter ? 24 : 0);
    }

    public static Vector createDocumentAlt(Vector printElements, PageFormat pageformat, String pheader, boolean withFooter, boolean onlyOneRecordPerPage) {
        Vector pages = new Vector();
        TreeMap<Integer, Vector<PrintElementFactSheet>> linesByY = new TreeMap<Integer, Vector<PrintElementFactSheet>>();
        Iterator iter = printElements.iterator();
        while (iter.hasNext()) {
            PrintElementFactSheet pe = (PrintElementFactSheet)iter.next();
            Integer key = new Integer(pe.ivY);
            Vector<PrintElementFactSheet> line = (Vector<PrintElementFactSheet>)linesByY.get(key);
            if (line == null) {
                line = new Vector<PrintElementFactSheet>();
                linesByY.put(key, line);
            }
            line.add(pe);
        }
        Vector aktpage = FactSheetPrinter.newPage(pages);
        int maxY = (int)pageformat.getImageableHeight() - 26 - (withFooter ? 24 : 0);
        int aktYOffset = 0;
        Iterator iter2 = linesByY.keySet().iterator();
        while (iter2.hasNext()) {
            PrintElementFactSheet pe;
            Integer intY = (Integer)iter2.next();
            int yOnPage = intY - aktYOffset;
            int maxh = 0;
            Vector line = (Vector)linesByY.get(intY);
            boolean wasRecordBreak = false;
            Iterator iterator = line.iterator();
            while (iterator.hasNext()) {
                pe = (PrintElementFactSheet)iterator.next();
                if (pe.ivHeight > maxh) {
                    maxh = pe.ivHeight;
                }
                if (!onlyOneRecordPerPage || pe.ivType != 10) continue;
                wasRecordBreak = true;
            }
            if (wasRecordBreak || yOnPage + maxh > maxY) {
                aktpage = FactSheetPrinter.newPage(pages);
                aktYOffset = intY;
            }
            iterator = line.iterator();
            while (iterator.hasNext()) {
                pe = (PrintElementFactSheet)iterator.next();
                if (pe.ivType == 10) continue;
                pe.translateY(-aktYOffset);
                aktpage.add(pe);
            }
        }
        FactSheetPrinter.addHeaderAndFooter(pages, pageformat, pheader, withFooter);
        return pages;
    }

    public static Vector createDocument(Vector printElements, PageFormat pageformat, String pheader, boolean withFooter, boolean onlyOneRecordPerPage) {
        Vector pages = new Vector();
        int maxY = (int)pageformat.getImageableHeight() - 26 - (withFooter ? 24 : 0);
        Vector pageContigs = PrintElementFactSheet.createPageContigsAndEliminateByRecordBreaks(printElements, onlyOneRecordPerPage);
        Iterator iter = pageContigs.iterator();
        while (iter.hasNext()) {
            FactSheetPrinter.manageOneContig((Vector)iter.next(), pages, maxY);
        }
        FactSheetPrinter.addHeaderAndFooter(pages, pageformat, pheader, withFooter);
        return pages;
    }

    private static void manageOneContig(Vector elements, Vector pages, int maxY) {
        if (elements != null && !elements.isEmpty()) {
            TreeMap linesByY = PrintElementFactSheet.groupByY(elements);
            Vector aktpage = FactSheetPrinter.newPage(pages);
            int aktYOffset = -1;
            Iterator iter = linesByY.keySet().iterator();
            while (iter.hasNext()) {
                Integer intY = (Integer)iter.next();
                Vector line = (Vector)linesByY.get(intY);
                if (line == null || line.isEmpty()) continue;
                if (aktYOffset == -1) {
                    aktYOffset = intY;
                }
                int yOnPage = intY - aktYOffset;
                boolean lineDone = false;
                int maxh = PrintElementFactSheet.getHeightOfLine(line);
                if (yOnPage + maxh > maxY) {
                    if (line.size() == 1) {
                        PrintElementFactSheet pefs = (PrintElementFactSheet)line.firstElement();
                        if (pefs.ivSplittable) {
                            int ganzunten = pefs.ivY + pefs.ivHeight;
                            int lastHeight = 0;
                            int maxYFirst = maxY - yOnPage;
                            Vector splitteds = pefs.getSplittedElements(maxYFirst, maxY, yOnPage);
                            Iterator iterator = splitteds.iterator();
                            while (iterator.hasNext()) {
                                Object ooo = iterator.next();
                                if (ooo instanceof PrintElementFactSheet) {
                                    PrintElementFactSheet splefs = (PrintElementFactSheet)ooo;
                                    aktpage.add(splefs);
                                    if (iterator.hasNext()) {
                                        aktpage = FactSheetPrinter.newPage(pages);
                                    }
                                    lastHeight = splefs.ivHeight;
                                    continue;
                                }
                                if (!(ooo instanceof NULLObject)) continue;
                                aktpage = FactSheetPrinter.newPage(pages);
                            }
                            aktYOffset = ganzunten - lastHeight;
                            lineDone = true;
                        }
                    }
                    if (!lineDone) {
                        aktpage = FactSheetPrinter.newPage(pages);
                        aktYOffset = intY;
                    }
                }
                if (lineDone) continue;
                Iterator iterator = line.iterator();
                while (iterator.hasNext()) {
                    PrintElementFactSheet pe = (PrintElementFactSheet)iterator.next();
                    pe.translateY(-aktYOffset);
                    aktpage.add(pe);
                }
            }
        }
    }

    private static Vector newPage(Vector pages) {
        Vector[] pageArr = new Vector[3];
        pageArr[1] = new Vector();
        pages.addElement(pageArr);
        return pageArr[1];
    }

    private static void addHeaderAndFooter(Vector pages, PageFormat pageformat, String pheader, boolean withFooter) {
        String header = String.valueOf(pheader) + " " + DatumFormat.getDateTimeString(System.currentTimeMillis());
        int pw = (int)pageformat.getImageableWidth();
        int y2 = FactSheet.PAGE_HEADER_FONT.getSize() + 3;
        int y3 = (int)pageformat.getImageableHeight() - FactSheet.PAGE_HEADER_FONT.getSize() - 1;
        int y4 = y3 - 3;
        int anzpages = pages.size();
        int i = 0;
        while (i < anzpages) {
            Vector[] page = (Vector[])pages.elementAt(i);
            page[0] = new Vector();
            PrintElementFactSheet pen = PrintElementFactSheet.getTextElement(0, 0, header, FactSheet.PAGE_HEADER_FONT, 2);
            pen.ivX += (pw - pen.ivWidth) / 2;
            page[0].add(pen);
            page[0].addElement(PrintElementFactSheet.getLineElement(0, y2, (int)pageformat.getImageableWidth(), y2, Color.darkGray, 0.1f));
            if (withFooter) {
                page[2] = new Vector();
                pen = PrintElementFactSheet.getTextElement(0, y3, "- " + Babel.get("PRINT_PAGE") + " " + (i + 1) + " / " + anzpages + " -", FactSheet.PAGE_HEADER_FONT, 2);
                pen.ivX += (pw - pen.ivWidth) / 2;
                page[2].add(pen);
                page[2].addElement(PrintElementFactSheet.getLineElement(0, y4, (int)pageformat.getImageableWidth(), y4, Color.darkGray, 0.1f));
            }
            ++i;
        }
    }

    public static double getFactorForSingleElement(PrintElementFactSheet pefs, PageFormat pageformat, boolean withFooter) {
        int maxW = (int)pageformat.getImageableWidth();
        int maxH = 0;
        maxH = withFooter ? (int)pageformat.getImageableHeight() - 26 - 24 : (int)pageformat.getImageableHeight() - 26;
        double xFak = (double)maxW / (double)pefs.ivWidth;
        double yFak = (double)maxH / (double)pefs.ivHeight;
        double fak = xFak;
        if (yFak < xFak) {
            fak = yFak;
        }
        if (fak > 1.0) {
            fak = 1.0;
        }
        return fak;
    }

    public FactSheetPrinter(PageFormat pageFormat, Vector elements, PrinterJob job) {
        this.ivPageFormat = pageFormat;
        this.ivJob = job;
        this.ivDocument = elements;
        this.ivUsedRect = new Rectangle((int)this.ivPageFormat.getImageableX(), (int)this.ivPageFormat.getImageableY(), (int)this.ivPageFormat.getImageableWidth(), (int)this.ivPageFormat.getImageableHeight());
        this.prepareDocument(this.ivPageFormat);
    }

    public void setInnerFactor(double fak) {
        this.ivInnerFactor = fak;
    }

    private void prepareDocument(PageFormat pageFormat) {
        int width = (int)pageFormat.getImageableWidth() - 1;
        int height = (int)pageFormat.getImageableHeight() - 1;
        int fh = 0;
        double xfaktor = (double)width / (double)this.ivUsedRect.width;
        double yfaktor = (double)(height -= fh + 12) / (double)this.ivUsedRect.height;
        double faktor = xfaktor;
        if (yfaktor < xfaktor) {
            faktor = yfaktor;
        }
        if (faktor < 1.0) {
            this.ivFaktor = faktor;
        }
        this.ivXOffset = (int)((double)width - faktor * (double)this.ivUsedRect.width) / 2;
    }

    public PageFormat getPageFormat(int pageIndex) {
        return this.ivPageFormat;
    }

    public Printable getPrintable(int pageIndex) {
        return this;
    }

    public PageFormat getPageFormat() {
        return this.ivPageFormat;
    }

    public void printIt() {
        if (this.ivJob == null) {
            this.ivJob = PrinterJob.getPrinterJob();
        }
        this.ivJob.setPageable(this);
        this.ivJob.setPrintable(this, this.ivPageFormat);
        if (this.ivJob.printDialog()) {
            new PrintTask(this.ivJob, this.getClass());
        }
    }

    public void pdfIt(String filename) {
    }

    public int getNumberOfPages() {
        return this.ivDocument.size();
    }

    public boolean isRotated() {
        return false;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        PrintElementFactSheet element;
        Graphics2D g2d = (Graphics2D)graphics;
        if (pageIndex >= this.ivDocument.size()) {
            return 1;
        }
        int oben = (int)pageFormat.getImageableY();
        int links = (int)pageFormat.getImageableX();
        if (this.ivFaktor != 1.0) {
            g2d.scale(this.ivFaktor, this.ivFaktor);
        }
        g2d.translate(links, oben);
        g2d.translate(this.ivXOffset, 0);
        Vector[] page = (Vector[])this.ivDocument.elementAt(pageIndex);
        Iterator iter = page[0].iterator();
        while (iter.hasNext()) {
            element = (PrintElementFactSheet)iter.next();
            element.print(g2d, false);
        }
        g2d.translate(0, 26);
        if (this.ivInnerFactor != 1.0) {
            g2d.scale(this.ivInnerFactor, this.ivInnerFactor);
        }
        iter = page[1].iterator();
        while (iter.hasNext()) {
            element = (PrintElementFactSheet)iter.next();
            element.print(g2d, false);
        }
        if (this.ivInnerFactor != 1.0) {
            g2d.scale(1.0 / this.ivInnerFactor, 1.0 / this.ivInnerFactor);
        }
        g2d.translate(0, -26);
        if (page[2] != null) {
            iter = page[2].iterator();
            while (iter.hasNext()) {
                element = (PrintElementFactSheet)iter.next();
                element.print(g2d, false);
            }
        }
        g2d.translate(-this.ivXOffset, 0);
        if (this.ivFaktor != 1.0) {
            g2d.scale(1.0 / this.ivFaktor, 1.0 / this.ivFaktor);
        }
        return 0;
    }
}

