/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ImageIcon;
import mausoleum.cage.Cage;
import mausoleum.definitionlists.Microorganism;
import mausoleum.factsheets.FactSheet;
import mausoleum.factsheets.IDObjectMerker;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.helper.DatumFormat;
import mausoleum.main.MausoleumClient;
import mausoleum.rack.Rack;
import mausoleum.rack.frame.RackGraphicsManager;
import mausoleum.result.rackhealthreport.RResHealthReport;
import mausoleum.result.rackhealthreport.RResWrapper;
import mausoleum.room.Room;
import mausoleum.ui.UIDef;

public class FactSheetRack
extends FactSheet {
    private static final int RAND = 5;

    public int addPrintElements(String group, Object object, int y, int width, Vector target, HashSet selection, String sonderVorspann) {
        int lw = 120;
        int rx = lw + UIDef.INNER_RAND;
        if (object instanceof Rack) {
            String hafo;
            Rack rack = (Rack)object;
            y = FactSheetRack.createStandardStartLines(rack, String.valueOf(Babel.get("FS_RA_FOR_RACK")) + " " + rack.getName(), y, rx, width, target, null, sonderVorspann);
            if (!MausoleumClient.isHeadOfService()) {
                y = FactSheetRack.createImage(rack, target, y, width);
            }
            y += 10;
            Room room = (Room)ObjectStore.getClientObject(10, rack.getLong("RCK_ROOM", 0L), rack.getGroup());
            if (room != null) {
                y = FactSheetRack.addLine(Babel.get("FS_ROOM"), room.getBrowseName(), rx, y, target, null, IDObjectMerker.getLink(room, null));
            }
            if ((hafo = rack.getString("RCK_HAFO", null)) != null) {
                y = FactSheetRack.addLine(Babel.get("RES_TS_WB_HALTUNGSFORM"), hafo, rx, y, target);
            }
            if (!MausoleumClient.isHeadOfService()) {
                Vector cages = rack.getCages(false);
                Vector matings = rack.getCages(true);
                if (cages != null && !cages.isEmpty()) {
                    y = FactSheetRack.addLine(Babel.get("FS_CAGES"), Integer.toString(cages.size()), rx, y, target, null, IDObjectMerker.getLink(cages, null));
                    if (matings != null && !matings.isEmpty()) {
                        y = FactSheetRack.addLine(Babel.get("FS_MATINGS"), Integer.toString(matings.size()), rx, y, target, null, IDObjectMerker.getLink(matings, null));
                    }
                    Vector mice = new Vector();
                    Iterator iter = cages.iterator();
                    while (iter.hasNext()) {
                        Cage cage = (Cage)iter.next();
                        cage.addActualMice(mice);
                    }
                    y = FactSheetRack.addLine(Babel.get("FS_MICE"), Integer.toString(mice.size()), rx, y, target, null, IDObjectMerker.getLink(mice, null));
                }
            } else if (MausoleumClient.isHeadOfService() && Privileges.hasPrivilege("RCK_VIEW_HEALTHREPORT")) {
                Vector<Rack> idObjects = new Vector<Rack>(1);
                idObjects.add(rack);
                Vector healthReports = new Vector();
                RResHealthReport.addHealthReportWrappers(idObjects, healthReports);
                if (!healthReports.isEmpty()) {
                    y += 15;
                    y = FactSheetRack.createPEHeader(y, target, Babel.get("RACK_HEALTH_REPORTS"), width);
                    y = FactSheetRack.collectHealthReportElementLines(healthReports, y, target, width);
                    y += 15;
                }
            }
        }
        return y;
    }

    private static int createImage(Rack rack, Vector target, int y, int width) {
        long[] cidarr = (long[])rack.get("RCK_CAGES");
        if (cidarr != null && cidarr.length != 0) {
            int cols = rack.getInt("RCK_COLUMNS");
            int rows = rack.getInt("RCK_ROWS");
            int cw = 50;
            int ch = 25;
            int gw = cols * cw + (cols - 1) * RackGraphicsManager.CAGESEP + 10;
            int gh = rows * ch + (rows - 1) * RackGraphicsManager.CAGESEP + 10;
            BufferedImage img = new BufferedImage(gw, gh, 1);
            Graphics g = img.getGraphics();
            g.setColor(new Color(240, 240, 240));
            g.fillRect(0, 0, gw, gh);
            g.setColor(Color.black);
            g.drawRect(0, 0, gw - 1, gh - 1);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RackGraphicsManager.paintCages(g, FactSheetRack.getCages(rack, true), cols, rows, 5, cw + RackGraphicsManager.CAGESEP, ch + RackGraphicsManager.CAGESEP, cw, ch, new Vector(), null);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            double faktor = (double)(width - 5) / 2.0 / (double)gw;
            Image img2 = img.getScaledInstance((int)((double)gw * faktor), (int)((double)gh * faktor), 16);
            target.add(PrintElementFactSheet.getImageElement(0, y, new ImageIcon(img2), 1.0));
            if (rack.getInt("RCK_SIDES") == 2) {
                g.setColor(new Color(240, 240, 240));
                g.fillRect(0, 0, gw, gh);
                g.setColor(Color.black);
                g.drawRect(0, 0, gw - 1, gh - 1);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                RackGraphicsManager.paintCages(g, FactSheetRack.getCages(rack, false), cols, rows, 5, cw + RackGraphicsManager.CAGESEP, ch + RackGraphicsManager.CAGESEP, cw, ch, new Vector(), null);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                int x = (int)((double)(width + 5) / 2.0);
                img2 = img.getScaledInstance((int)((double)gw * faktor), (int)((double)gh * faktor), 4);
                target.add(PrintElementFactSheet.getImageElement(x, y, new ImageIcon(img2), 1.0));
            }
            y += (int)((double)gh * faktor) + 5;
        }
        return y;
    }

    private static Cage[] getCages(Rack rack, boolean vorne) {
        int cols;
        int rows;
        int arrsiz;
        if ((vorne || rack.getInt("RCK_SIDES") == 2) && (arrsiz = (rows = rack.getInt("RCK_ROWS", 0)) * (cols = rack.getInt("RCK_COLUMNS", 0))) != 0) {
            Cage[] res = new Cage[arrsiz];
            int pos = 0;
            int y = 0;
            while (y < rows) {
                int x = 0;
                while (x < cols) {
                    res[pos++] = rack.getCage(vorne ? 0 : 1, y, x);
                    ++x;
                }
                ++y;
            }
            return res;
        }
        return null;
    }

    public static int collectHealthReportElementLines(Vector healthReports, int y, Vector target, int width) {
        TreeMap<Integer, Vector<RResWrapper>> reportSammlerByDate = new TreeMap<Integer, Vector<RResWrapper>>();
        Iterator iterator = healthReports.iterator();
        while (iterator.hasNext()) {
            RResWrapper wrapper = (RResWrapper)iterator.next();
            Integer key = new Integer(wrapper.ivHealthReport.ivDate);
            Vector<RResWrapper> v = (Vector<RResWrapper>)reportSammlerByDate.get(key);
            if (v == null) {
                v = new Vector<RResWrapper>();
                reportSammlerByDate.put(key, v);
            }
            v.add(wrapper);
        }
        Vector lines = new Vector();
        Vector<Integer> horizLineYPos = new Vector<Integer>();
        Vector<Integer> lineYs = new Vector<Integer>();
        horizLineYPos.add(new Integer(y));
        lineYs.add(new Integer(y));
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 4, Babel.get("FS_M_DATE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("PERFORMEDBY"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_R_ANZ_CHECKED"), TABHEADER_FONT));
        int i = 0;
        while (i < Microorganism.KEIM_TYP_BABELS.length) {
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get(Microorganism.KEIM_TYP_BABELS[i]), TABHEADER_FONT));
            ++i;
        }
        int[] byKeimArray = new int[(Microorganism.KEIM_TYPES.length + 1) * 2];
        StringBuilder ksb = new StringBuilder();
        HashSet checkedKeimeF = new HashSet();
        HashSet checkedKeimeNF = new HashSet();
        TreeSet<String> performers = new TreeSet<String>();
        y += TABHEADER_FONT.getSize() + 2;
        horizLineYPos.add(new Integer(y += 4));
        lineYs.add(new Integer(y));
        Iterator iter = reportSammlerByDate.keySet().iterator();
        while (iter.hasNext()) {
            y += 3;
            int i2 = 0;
            while (i2 < byKeimArray.length) {
                byKeimArray[i2] = -1;
                ++i2;
            }
            checkedKeimeF.clear();
            checkedKeimeNF.clear();
            performers.clear();
            Integer dateI = (Integer)iter.next();
            Vector datWrappers = (Vector)reportSammlerByDate.get(dateI);
            Iterator iterator2 = datWrappers.iterator();
            while (iterator2.hasNext()) {
                RResWrapper rreswr = (RResWrapper)iterator2.next();
                RResHealthReport.MicroSortable.fillFS(rreswr, byKeimArray, checkedKeimeF, checkedKeimeNF);
                RResHealthReport healthReport = rreswr.ivHealthReport;
                performers.add(healthReport.ivPerformer);
            }
            line = new Vector();
            lines.add(line);
            line.add(PrintElementFactSheet.getTextElement(0, y, DatumFormat.getJustDateString(dateI), FETT_FONT, null));
            ksb.setLength(0);
            iterator2 = performers.iterator();
            while (iterator2.hasNext()) {
                String perf = (String)iterator2.next();
                if (ksb.length() != 0) {
                    ksb.append(", ");
                }
                ksb.append(perf);
            }
            line.add(PrintElementFactSheet.getTextElement(0, y, ksb.toString(), FETT_FONT, null));
            line.add(PrintElementFactSheet.getTextElement(0, y, String.valueOf(checkedKeimeF.size()) + " / " + checkedKeimeNF.size(), FETT_FONT, 0));
            int i3 = 0;
            while (i3 < Microorganism.KEIM_TYPES.length) {
                ksb.setLength(0);
                int mit = byKeimArray[Microorganism.KEIM_TYPES[i3] * 2];
                int ohne = byKeimArray[Microorganism.KEIM_TYPES[i3] * 2 + 1];
                if (mit == -1 && ohne == -1) {
                    ksb.append(" - / - ").append(ohne);
                } else {
                    boolean dick = false;
                    if (mit == -1) {
                        ksb.append(" - / ").append(ohne);
                        dick = ohne != 0;
                    } else if (ohne == -1) {
                        ksb.append(mit).append(" / - ");
                        dick = mit != 0;
                    } else {
                        ksb.append(mit).append(" / ").append(ohne);
                        dick = mit != 0 || ohne != 0;
                    }
                    line.add(PrintElementFactSheet.getTextElement(0, y, ksb.toString(), dick ? FETT_FONT : STANDARD_FONT, 0));
                }
                ++i3;
            }
            y += FETT_FONT.getSize() + 1;
            horizLineYPos.add(new Integer(y += 4));
            lineYs.add(new Integer(y));
        }
        y = FactSheetRack.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
        PrintElementFactSheet pen = PrintElementFactSheet.getTextElement(0, y += 3, Babel.get("FS_R_FELASA_NUMBERS"), STANDARD_FONT);
        target.addElement(pen);
        return y += STANDARD_FONT.getSize() + 5;
    }

    public static int collectHealthReportElementLinesOld(Vector healthReports, int y, Vector target, int width) {
        Vector lines = new Vector();
        Vector<Integer> horizLineYPos = new Vector<Integer>();
        Vector<Integer> lineYs = new Vector<Integer>();
        horizLineYPos.add(new Integer(y));
        lineYs.add(new Integer(y));
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 4, Babel.get("FS_RACK"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_DATE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_RESEARCHER"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("ARHR_FS_MICORORGANISM"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("ARHR_POSITIVE"), TABHEADER_FONT, 0));
        y += TABHEADER_FONT.getSize() + 2;
        horizLineYPos.add(new Integer(y += 4));
        lineYs.add(new Integer(y));
        Iterator iter = healthReports.iterator();
        while (iter.hasNext()) {
            y += 3;
            RResWrapper rreswr = (RResWrapper)iter.next();
            RResHealthReport healthReport = rreswr.ivHealthReport;
            int i = 0;
            while (i < healthReport.ivMicroResults.length) {
                RResHealthReport.MicroRes micorres = healthReport.ivMicroResults[i];
                line = new Vector();
                lines.add(line);
                if (i == 0) {
                    String name = "";
                    Rack rack = (Rack)ObjectStore.getObjectDeadOrAlive(3, rreswr.ivRackID, rreswr.ivGroup, null, false);
                    if (rack != null) {
                        name = rack.getBrowseNameWITHOUTServicePrefix();
                    }
                    line.add(PrintElementFactSheet.getTextElement(0, y, name, FETT_FONT, null));
                    line.add(PrintElementFactSheet.getTextElement(0, y, DatumFormat.getJustDateString(healthReport.ivDate), FETT_FONT, null));
                    line.add(PrintElementFactSheet.getTextElement(0, y, healthReport.ivPerformer, FETT_FONT, null));
                } else {
                    line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT, null));
                    line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT, null));
                    line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT, null));
                }
                Font f = micorres.ivFound == 0 ? STANDARD_FONT : FETT_FONT;
                line.add(PrintElementFactSheet.getTextElement(0, y, micorres.getMicroInfo(), f, null));
                line.add(PrintElementFactSheet.getTextElement(0, y, String.valueOf(micorres.ivFound) + " / " + healthReport.ivNumChecked, f, 0));
                lineYs.add(new Integer(y));
                y += FETT_FONT.getSize() + 1;
                ++i;
            }
            horizLineYPos.add(new Integer(y += 4));
            lineYs.add(new Integer(y));
        }
        y = FactSheetRack.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
        return y;
    }
}

