/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Point;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.colors.SexColor;
import mausoleum.factsheets.FactSheet;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.factsheets.sessionreports.SessionCageLine;
import mausoleum.factsheets.sessionreports.SessionMouseLine;
import mausoleum.factsheets.sessionreports.SessionReport;
import mausoleum.factsheets.sessionreports.WeaningLine;
import mausoleum.ui.UIDef;

public class FactSheetSessionReport
extends FactSheet {
    public int addPrintElements(String group, Object object, int y, int width, Vector target, HashSet selection, String sonderVorspann) {
        int lw = 100;
        int rx = lw + UIDef.INNER_RAND;
        if (object instanceof SessionReport) {
            Vector touchedCageLines;
            Vector newCageLines;
            Vector weanedMiceLines;
            Vector killedMiceLines;
            SessionReport report = (SessionReport)object;
            y = FactSheetSessionReport.createStandardStartLines(null, null, y, rx, width, target, null, report.getString("TITLE", ""));
            y = FactSheetSessionReport.addLine(Babel.get("FS_SES_USER"), report.getString("USERNAME", ""), rx, y, target);
            y = FactSheetSessionReport.addLine(Babel.get("DATE"), report.getString("DATE", ""), rx, y, target);
            y = FactSheetSessionReport.addLine(Babel.get("FS_M_TOTAL"), report.getString("TOTAL_NR", ""), rx, y, target, null, report.getString("TOTAL_LINK", null));
            Vector newMiceLines = (Vector)report.get("NEW_MICE");
            if (newMiceLines != null) {
                y = FactSheetSessionReport.collectNewMouseLines(report, newMiceLines, target, y, width, rx);
            }
            if ((killedMiceLines = (Vector)report.get("KILLED_MICE")) != null) {
                y = FactSheetSessionReport.collectKilledMouseLines(report, killedMiceLines, target, y, width, rx);
            }
            if ((weanedMiceLines = (Vector)report.get("WEANED_MICE")) != null) {
                y = FactSheetSessionReport.collectWeanedMouseLines(report, weanedMiceLines, target, y, width, rx);
            }
            if ((newCageLines = (Vector)report.get("NEW_CAGES")) != null) {
                y = FactSheetSessionReport.collectCageLines(report, newCageLines, target, y, width, rx);
            }
            if ((touchedCageLines = (Vector)report.get("TOUCHED_CAGES")) != null) {
                y = FactSheetSessionReport.collectCageLines(report, touchedCageLines, target, y, width, rx);
            }
        }
        return y;
    }

    private static int collectNewMouseLines(SessionReport report, Vector newMiceLines, Vector target, int y, int width, int rx) {
        Vector lines = new Vector();
        Vector<Integer> horizLineYPos = new Vector<Integer>();
        Vector<Integer> lineYs = new Vector<Integer>();
        horizLineYPos.add(new Integer(y += 15));
        lineYs.add(new Integer(y));
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 4, Babel.get("FS_ID"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("SEXSHORT"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_EARTAG"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_LINE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_STRAIN"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_GENOTYPE"), TABHEADER_FONT));
        y += TABHEADER_FONT.getSize() + 2;
        y += 4;
        Iterator iter = newMiceLines.iterator();
        while (iter.hasNext()) {
            horizLineYPos.add(new Integer(y));
            lineYs.add(new Integer(y));
            SessionMouseLine nml = (SessionMouseLine)iter.next();
            line = new Vector();
            lines.add(line);
            line.add(PrintElementFactSheet.getTextElement(0, y += 3, nml.ivID, FETT_FONT, nml.ivLink));
            line.add(PrintElementFactSheet.getTextElement(0, y, nml.ivSex, FETT_FONT, null));
            line.add(PrintElementFactSheet.getTextElement(0, y, nml.ivTag, FETT_FONT, null));
            line.add(PrintElementFactSheet.getTextElement(0, y, nml.ivLine, FETT_FONT, nml.ivLineLink));
            line.add(PrintElementFactSheet.getTextElement(0, y, nml.ivStrain, FETT_FONT, nml.ivStrainLink));
            line.add(PrintElementFactSheet.getTextElement(0, y, nml.ivGenotype, FETT_FONT, null));
            y += FETT_FONT.getSize() + 2;
            y += 3;
        }
        lineYs.add(new Integer(y));
        horizLineYPos.add(new Integer(y));
        return FactSheetSessionReport.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
    }

    private static int collectKilledMouseLines(SessionReport report, Vector killedMouseLines, Vector target, int y, int width, int rx) {
        Vector lines = new Vector();
        Vector<Integer> horizLineYPos = new Vector<Integer>();
        Vector<Integer> lineYs = new Vector<Integer>();
        horizLineYPos.add(new Integer(y += 15));
        lineYs.add(new Integer(y));
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 4, Babel.get("FS_ID"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("SEXSHORT"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_EARTAG"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_LINE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_STRAIN"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_GENOTYPE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("EXITMODE"), TABHEADER_FONT));
        y += TABHEADER_FONT.getSize() + 2;
        y += 4;
        Iterator iter = killedMouseLines.iterator();
        while (iter.hasNext()) {
            horizLineYPos.add(new Integer(y));
            lineYs.add(new Integer(y));
            SessionMouseLine kml = (SessionMouseLine)iter.next();
            line = new Vector();
            lines.add(line);
            line.add(PrintElementFactSheet.getTextElement(0, y += 3, kml.ivID, FETT_FONT, kml.ivLink));
            line.add(PrintElementFactSheet.getTextElement(0, y, kml.ivSex, FETT_FONT, null));
            line.add(PrintElementFactSheet.getTextElement(0, y, kml.ivTag, FETT_FONT, null));
            line.add(PrintElementFactSheet.getTextElement(0, y, kml.ivLine, FETT_FONT, kml.ivLineLink));
            line.add(PrintElementFactSheet.getTextElement(0, y, kml.ivStrain, FETT_FONT, kml.ivStrainLink));
            line.add(PrintElementFactSheet.getTextElement(0, y, kml.ivGenotype, FETT_FONT, null));
            line.add(PrintElementFactSheet.getTextElement(0, y, kml.ivMode, FETT_FONT, null));
            y += FETT_FONT.getSize() + 2;
            y += 3;
        }
        lineYs.add(new Integer(y));
        horizLineYPos.add(new Integer(y));
        return FactSheetSessionReport.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
    }

    private static int collectWeanedMouseLines(SessionReport report, Vector weanedMouseLines, Vector target, int y, int width, int rx) {
        int starty = y += 15;
        y = FactSheetSessionReport.addFullLongText(Babel.get("WEANING_REPORT_INFO"), width, y, target, 0);
        y += 4;
        Vector linesForAllTables = new Vector();
        Vector horizlineYpossForAllTables = new Vector();
        Vector lineYsForAllTables = new Vector();
        HashSet<Point> dontDrawVerticalLines = new HashSet<Point>();
        Iterator itera = weanedMouseLines.iterator();
        while (itera.hasNext()) {
            Iterator iter;
            Vector linesForOneTable = new Vector();
            linesForAllTables.add(linesForOneTable);
            Vector<Integer> horizLineYPos = new Vector<Integer>();
            horizlineYpossForAllTables.add(horizLineYPos);
            horizLineYPos.add(new Integer(y));
            Vector<Integer> lineYs = new Vector<Integer>();
            lineYsForAllTables.add(lineYs);
            lineYs.add(new Integer(y));
            Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
            linesForOneTable.add(line);
            line.add(PrintElementFactSheet.getTextElement(0, y += 4, Babel.get("FS_ID"), TABHEADER_FONT));
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("SEXSHORT"), TABHEADER_FONT));
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_BIRTHDAY"), TABHEADER_FONT));
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_EARTAG"), TABHEADER_FONT));
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_CAGE"), TABHEADER_FONT));
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_LINE"), TABHEADER_FONT));
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_STRAIN"), TABHEADER_FONT));
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_M_GENOTYPE"), TABHEADER_FONT));
            y += TABHEADER_FONT.getSize() + 2;
            y += 4;
            WeaningLine wml = (WeaningLine)itera.next();
            if (!wml.ivParentLines.isEmpty()) {
                iter = wml.ivParentLines.iterator();
                while (iter.hasNext()) {
                    horizLineYPos.add(new Integer(y));
                    lineYs.add(new Integer(y));
                    SessionMouseLine pl = (SessionMouseLine)iter.next();
                    line = new Vector();
                    linesForOneTable.add(line);
                    Color bg = SexColor.FEMALE_EXTREME_LIGHT;
                    if (pl.ivIsMale) {
                        bg = SexColor.MALE_EXTREME_LIGHT;
                    }
                    line.add(PrintElementFactSheet.getTextElement(0, y, pl.ivID, FETT_FONT_KLEIN, pl.ivLink, bg));
                    line.add(PrintElementFactSheet.getTextElement(0, y, pl.ivSex, FETT_FONT_KLEIN, null, bg));
                    line.add(PrintElementFactSheet.getTextElement(0, y, pl.ivBirthday, FETT_FONT_KLEIN, null, bg));
                    line.add(PrintElementFactSheet.getTextElement(0, y, pl.ivTag, FETT_FONT_KLEIN, null, bg));
                    line.add(PrintElementFactSheet.getTextElement(0, y, pl.ivCage, FETT_FONT_KLEIN, pl.ivCageLink, bg));
                    line.add(PrintElementFactSheet.getTextElement(0, y, pl.ivLine, FETT_FONT_KLEIN, pl.ivLineLink, bg));
                    line.add(PrintElementFactSheet.getTextElement(0, y, pl.ivStrain, FETT_FONT_KLEIN, pl.ivStrainLink, bg));
                    line.add(PrintElementFactSheet.getTextElement(0, y, pl.ivGenotype, FETT_FONT_KLEIN, null, bg));
                    y += ((PrintElementFactSheet)line.lastElement()).getBounds().height;
                }
                lineYs.add(new Integer(y));
                horizLineYPos.add(new Integer(y));
            }
            if (!wml.ivKidLines.isEmpty()) {
                iter = wml.ivKidLines.iterator();
                while (iter.hasNext()) {
                    horizLineYPos.add(new Integer(y));
                    lineYs.add(new Integer(y));
                    SessionMouseLine kl = (SessionMouseLine)iter.next();
                    line = new Vector();
                    linesForOneTable.add(line);
                    line.add(PrintElementFactSheet.getTextElement(0, y += 3, kl.ivID, FETT_FONT, kl.ivLink));
                    line.add(PrintElementFactSheet.getTextElement(0, y, kl.ivSex, FETT_FONT, null));
                    line.add(PrintElementFactSheet.getTextElement(0, y, kl.ivBirthday, FETT_FONT, null));
                    line.add(PrintElementFactSheet.getTextElement(0, y, kl.ivTag, FETT_FONT, null));
                    line.add(PrintElementFactSheet.getTextElement(0, y, kl.ivCage, FETT_FONT, kl.ivCageLink));
                    line.add(PrintElementFactSheet.getTextElement(0, y, kl.ivLine, FETT_FONT, kl.ivLineLink));
                    line.add(PrintElementFactSheet.getTextElement(0, y, kl.ivStrain, FETT_FONT, kl.ivStrainLink));
                    line.add(PrintElementFactSheet.getTextElement(0, y, kl.ivGenotype, FETT_FONT, null));
                    y += FETT_FONT.getSize() + 2;
                    y += 3;
                    int ddy = lineYs.size();
                    int ddx = 2;
                    while (ddx < 8) {
                        dontDrawVerticalLines.add(new Point(ddx, ddy));
                        ++ddx;
                    }
                    horizLineYPos.add(new Integer(y));
                    lineYs.add(new Integer(y));
                    y += FETT_FONT.getSize() + 2;
                    y += 3;
                }
                lineYs.add(new Integer(y));
                horizLineYPos.add(new Integer(y));
            }
            ++y;
            if (!itera.hasNext()) continue;
            lineYs.add(new Integer(y += 3));
            horizLineYPos.add(new Integer(y));
        }
        Vector alles = new Vector();
        Iterator iter = linesForAllTables.iterator();
        while (iter.hasNext()) {
            Vector v = (Vector)iter.next();
            alles.addAll(v);
        }
        int[] gesBreite = new int[1];
        int[] spbr = FactSheetSessionReport.getSpaltenbreiten(alles, width, gesBreite);
        int gbr = gesBreite[0];
        int ty = starty;
        int i = 0;
        while (i < linesForAllTables.size()) {
            ty = FactSheetSessionReport.createTable((Vector)linesForAllTables.elementAt(i), (Vector)horizlineYpossForAllTables.elementAt(i), target, width, (Vector)lineYsForAllTables.elementAt(i), null, dontDrawVerticalLines, spbr, gbr);
            if (i != linesForAllTables.size() - 1) {
                FactSheetSessionReport.createRecordBreak(target, 0, ty, false);
                ++ty;
            }
            ++i;
        }
        return ty;
    }

    private static int collectCageLines(SessionReport report, Vector cageLines, Vector target, int y, int width, int rx) {
        Vector lines = new Vector();
        Vector<Integer> horizLineYPos = new Vector<Integer>();
        Vector<Integer> lineYs = new Vector<Integer>();
        horizLineYPos.add(new Integer(y += 15));
        lineYs.add(new Integer(y));
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 4, Babel.get("FS_ID"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_CAGE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_C_RACK"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("ROOM"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("PRIMARY_OWNER"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_C_ACT_MICE"), TABHEADER_FONT));
        y += TABHEADER_FONT.getSize() + 2;
        y += 4;
        Iterator iter = cageLines.iterator();
        while (iter.hasNext()) {
            horizLineYPos.add(new Integer(y));
            lineYs.add(new Integer(y));
            SessionCageLine nml = (SessionCageLine)iter.next();
            line = new Vector();
            lines.add(line);
            line.add(PrintElementFactSheet.getTextElement(0, y += 3, nml.ivID, FETT_FONT, nml.ivLink));
            line.add(PrintElementFactSheet.getTextElement(0, y, nml.ivCage, FETT_FONT, nml.ivLink));
            line.add(PrintElementFactSheet.getTextElement(0, y, nml.ivRack, FETT_FONT, nml.ivRackLink));
            line.add(PrintElementFactSheet.getTextElement(0, y, nml.ivRoom, FETT_FONT, nml.ivRoomLink));
            line.add(PrintElementFactSheet.getTextElement(0, y, nml.ivOwner, FETT_FONT, nml.ivOwnerLink));
            line.add(PrintElementFactSheet.getTextElement(0, y, nml.ivMice, FETT_FONT, nml.ivMiceLink));
            y += FETT_FONT.getSize() + 2;
            y += 3;
        }
        lineYs.add(new Integer(y));
        horizLineYPos.add(new Integer(y));
        return FactSheetSessionReport.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
    }
}

