/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.objectstore.NULLObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Font;
import java.awt.Frame;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import mausoleum.factsheets.FactSheet;
import mausoleum.factsheets.FactSheetFrame;
import mausoleum.factsheets.IDObjectMerker;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.NumberFormatter;
import mausoleum.line.Line;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.printing.util.Wurf;
import mausoleum.requester.AllgPickRequester;
import mausoleum.room.Room;
import mausoleum.strain.Strain;
import mausoleum.ui.UIDef;

public class FactSheetWurf
extends FactSheet {
    public static String SEL_LITTER_EXT = "FSM_SEL_LITTER_EXT";
    private static final Comparator ET_SORTER = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Mouse && o2 instanceof Mouse) {
                int et2;
                Mouse m1 = (Mouse)o1;
                Mouse m2 = (Mouse)o2;
                int et1 = m1.getInt("MOS_EARTAG", Integer.MAX_VALUE);
                if (et1 < (et2 = m2.getInt("MOS_EARTAG", Integer.MAX_VALUE))) {
                    return -1;
                }
                if (et1 > et2) {
                    return 1;
                }
            }
            return 0;
        }
    };
    private static final Comparator LINE_SORTER = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Line && o2 instanceof Line) {
                Line m1 = (Line)o1;
                Line m2 = (Line)o2;
                return m1.getName().compareToIgnoreCase(m2.getName());
            }
            if (o1 instanceof Line) {
                return -1;
            }
            if (o2 instanceof Line) {
                return 1;
            }
            return 0;
        }
    };
    static /* synthetic */ Class class$0;

    public static void showExtendedLitterReport(Mouse mouse, Frame sender) {
        FactSheetWurf.showExtendedLitterReport(sender, Wurf.getWuerfeForFactsheet(mouse), "LITTERREPORT_EXTENDED");
    }

    public static void showFosterLitterReport(Frame sender, Vector wuerfe, String titleBabel) {
        if (wuerfe != null && !wuerfe.isEmpty()) {
            long lastMotherID = -1L;
            Vector<WurfChoice> choices = new Vector<WurfChoice>(wuerfe.size());
            int index = 0;
            while (index < wuerfe.size()) {
                Wurf wurf = (Wurf)wuerfe.elementAt(index);
                WurfChoice wurfChoice = new WurfChoice(wurf, index, wuerfe.size());
                wurfChoice.ivShowMotherInfo = wurf.ivMotherID != lastMotherID;
                lastMotherID = wurf.ivMotherID;
                wurfChoice.ivShowDateInMotherInfo = false;
                choices.add(wurfChoice);
                ++index;
            }
            wuerfe.clear();
            Vector<WurfChoice> sels = choices;
            if (sels != null && !sels.isEmpty()) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.factsheets.FactSheetWurf$WurfChoice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                FactSheetFrame.showTab(sels, clazz.getName(), SEL_LITTER_EXT, Babel.get(titleBabel), Babel.get(titleBabel));
            }
        }
    }

    public static void showExtendedLitterReport(Frame sender, Vector wuerfe, String titleBabel) {
        if (wuerfe != null && !wuerfe.isEmpty()) {
            Vector sels;
            Wurf.sortWuerfe(wuerfe, true);
            Vector choices = new Vector(wuerfe.size());
            int index = 0;
            while (index < wuerfe.size()) {
                choices.add(new WurfChoice((Wurf)wuerfe.elementAt(index), index, wuerfe.size()));
                ++index;
            }
            wuerfe.clear();
            Vector vector = sels = choices.size() == 1 ? choices : AllgPickRequester.pickFromList(sender, choices, "SELECT_LITTER", "LITTERS", new int[]{1, 2, 3, 4}, new String[]{"ELR_SELECT_ALL", "ELR_SELECT_NONE", "ELR_SELECT_LAST", "ELR_SELECT_FIRST"}, 1);
            if (sels != null && !sels.isEmpty()) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.factsheets.FactSheetWurf$WurfChoice");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                FactSheetFrame.showTab(sels, clazz.getName(), SEL_LITTER_EXT, Babel.get(titleBabel), Babel.get(titleBabel));
            }
        }
    }

    public int addPrintElements(String group, Object object, int y, int width, Vector target, HashSet selection, String sonderVorspann) {
        int wh = width / 2;
        int lw = 80;
        int lx1 = 0;
        int rx1 = lx1 + lw + UIDef.INNER_RAND;
        int lx2 = wh;
        int rx2 = lx2 + lw + UIDef.INNER_RAND;
        if (selection != null && selection.contains(SEL_LITTER_EXT) && object instanceof WurfChoice) {
            WurfChoice wc = (WurfChoice)object;
            Wurf wurf = wc.ivWurf;
            boolean isFosterWurf = wurf.ivFatherID == Wurf.FATHERID_FOR_FOSTER_WURF;
            Mouse mother = (Mouse)ObjectStore.getClientObject(1, wurf.ivMotherID, group);
            if (mother != null) {
                if (wc.ivShowMotherInfo) {
                    String titel = String.valueOf(Babel.get("FS_M_FOR_MOUSE")) + " " + mother.getIDStringForReports(false);
                    if (wc.ivShowDateInMotherInfo) {
                        titel = String.valueOf(titel) + " " + Babel.get("DATE") + ": " + DatumFormat.getJustDateString(wurf.ivDay);
                    }
                    y = FactSheetWurf.createStandardStartLines(null, titel, y, rx1, width, target, null, sonderVorspann);
                } else {
                    y += 5;
                }
                if (!wc.ivShowDateInMotherInfo) {
                    y = FactSheetWurf.addLine(Babel.get("DATE"), DatumFormat.getJustDateString(wurf.ivDay), rx1, y, target);
                    y += 3;
                }
                y = FactSheetWurf.addLine(Babel.get("GROUP"), group, rx1, y, target);
                long ownerID = mother.getPrimaryOwnerIDNoOwnerGroup(0L);
                User owner = ownerID == 0L ? null : UserManager.getUser(ownerID, group);
                FactSheetWurf.addLine(Babel.get("SCIENTIST"), owner == null ? "" : owner.getName(), lx1, rx1, y, target, null, owner == null ? null : IDObjectMerker.getLink(owner, null));
                Room room = mother.getRoom();
                y = FactSheetWurf.addLine(Babel.get("ROOM"), room == null ? "" : room.getName(), lx2, rx2, y, target, null, owner == null ? null : IDObjectMerker.getLink(room, null));
                FactSheetWurf.addLine(Babel.get("BIRTHDAY"), DatumFormat.getJustDateString(wurf.ivDay), lx1, rx1, y, target, null, null);
                String pups = String.valueOf(wurf.ivNumBornTotal) + " (" + wurf.ivNumMaleBorn + " " + DefaultManager.getMale() + ", " + wurf.ivNumFemaleBorn + " " + DefaultManager.getFemale() + ", " + (wurf.ivNumBornTotal - wurf.ivNumMaleBorn - wurf.ivNumFemaleBorn) + " ?)";
                y = FactSheetWurf.addLine(Babel.get("PUPS"), pups, lx2, rx2, y, target, null, null);
                if (isFosterWurf) {
                    y += 3;
                    y = FactSheetWurf.addLine(Babel.get("FOSTER"), mother.getIDStringForReports(false), lx1, rx1, y, target, null, IDObjectMerker.getLink(mother, null));
                } else {
                    y += 12;
                    y = FactSheetWurf.createPEHeader(y, target, Babel.get(isFosterWurf ? "FOSTER" : "PARENTS"), width);
                    y += 3;
                    y = this.createParentTable(wurf, y, target, width, mother, group);
                }
                TreeMap tm = this.sortPupsByLine(wurf);
                if (tm != null && !tm.isEmpty()) {
                    Iterator iterator = tm.keySet().iterator();
                    while (iterator.hasNext()) {
                        Object key = iterator.next();
                        Vector mice = (Vector)tm.get(key);
                        Line line = null;
                        if (key instanceof Line) {
                            line = (Line)key;
                        }
                        y += 12;
                        StringBuilder titelSB = new StringBuilder(Babel.get("PUPS"));
                        titelSB.append(" ");
                        if (line != null) {
                            titelSB.append(Babel.get("OFLINE")).append(" ").append(line.getName());
                        } else {
                            titelSB.append(Babel.get("WITHOUTLINE"));
                        }
                        y = FactSheetWurf.createPEHeader(y, target, titelSB.toString(), width);
                        y += 3;
                        y = this.createPupsTable(mice, line, y, target, width, group);
                    }
                }
            }
        }
        return y;
    }

    private int createParentTable(Wurf wurf, int y, Vector target, int width, Mouse mother, String group) {
        boolean isFosterWurf = wurf.ivFatherID == Wurf.FATHERID_FOR_FOSTER_WURF;
        Font mfont = mother.isAliveAndVisible() ? FETT_FONT : STANDARD_FONT;
        Mouse father = isFosterWurf ? null : (Mouse)ObjectStore.getClientObject(1, wurf.ivFatherID, group);
        Font ffont = father != null && father.isAliveAndVisible() ? FETT_FONT : STANDARD_FONT;
        Vector lines = new Vector();
        Vector<Integer> horizLineYPos = new Vector<Integer>();
        Vector<Integer> lineYs = new Vector<Integer>();
        horizLineYPos.add(new Integer(y));
        lineYs.add(new Integer(y));
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 4, "", TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get(isFosterWurf ? "FOSTER" : "MOTHER"), TABHEADER_FONT));
        if (father != null) {
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FATHER"), TABHEADER_FONT));
        }
        y += TABHEADER_FONT.getSize() + 2;
        horizLineYPos.add(new Integer(y += 4));
        lineYs.add(new Integer(y));
        line = new Vector();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 3, "ID", STANDARD_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, mother.getIDStringForReports(false), mfont, IDObjectMerker.getLink(mother, null)));
        if (father != null) {
            line.add(PrintElementFactSheet.getTextElement(0, y, father.getIDStringForReports(false), ffont, IDObjectMerker.getLink(father, null)));
        }
        horizLineYPos.add(new Integer(y += STANDARD_FONT.getSize() + 2 + 3));
        lineYs.add(new Integer(y));
        line = new Vector();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 3, Babel.get("LINE"), STANDARD_FONT));
        Line gline = mother.getLine();
        if (gline != null) {
            line.add(PrintElementFactSheet.getTextElement(0, y, gline.getName(), mfont, IDObjectMerker.getLink(gline, null)));
        } else {
            line.add(PrintElementFactSheet.getTextElement(0, y, "", mfont));
        }
        if (father != null) {
            gline = father.getLine();
            if (gline != null) {
                line.add(PrintElementFactSheet.getTextElement(0, y, gline.getName(), ffont, IDObjectMerker.getLink(gline, null)));
            } else {
                line.add(PrintElementFactSheet.getTextElement(0, y, "", ffont));
            }
        }
        y += STANDARD_FONT.getSize() + 2 + 3;
        IndexObject[] mstrains = (IndexObject[])mother.get("MOS_STRAIN");
        IndexObject[] fstrains = father == null ? null : (IndexObject[])father.get("MOS_STRAIN");
        int max = 0;
        if (mstrains != null && mstrains.length > max) {
            max = mstrains.length;
        }
        if (fstrains != null && fstrains.length > max) {
            max = fstrains.length;
        }
        if (max != 0) {
            horizLineYPos.add(new Integer(y));
            int i = 0;
            while (i < max) {
                Strain str;
                IndexObject mto;
                lineYs.add(new Integer(y));
                line = new Vector();
                lines.add(line);
                line.add(PrintElementFactSheet.getTextElement(0, y += 3, i == 0 ? Babel.get("STRAIN") : "", STANDARD_FONT));
                if (mstrains != null && i < mstrains.length) {
                    mto = mstrains[i];
                    str = (Strain)ObjectStore.getClientObject(8, mto.ivObjectID, group);
                    if (str == null) {
                        line.add(PrintElementFactSheet.getTextElement(0, y, "?", mfont, null));
                    } else {
                        line.add(PrintElementFactSheet.getTextElement(0, y, String.valueOf(str.getName()) + "(" + NumberFormatter.STRAIN_FROMATTER.format(mto.ivNumber) + ")", mfont, IDObjectMerker.getLink(str, null)));
                    }
                } else {
                    line.add(PrintElementFactSheet.getTextElement(0, y, "", mfont));
                }
                if (fstrains != null && i < fstrains.length) {
                    mto = fstrains[i];
                    str = (Strain)ObjectStore.getClientObject(8, mto.ivObjectID, group);
                    if (str == null) {
                        line.add(PrintElementFactSheet.getTextElement(0, y, "?", ffont, null));
                    } else {
                        line.add(PrintElementFactSheet.getTextElement(0, y, String.valueOf(str.getName()) + "(" + NumberFormatter.STRAIN_FROMATTER.format(mto.ivNumber) + ")", ffont, IDObjectMerker.getLink(str, null)));
                    }
                } else if (father != null) {
                    line.add(PrintElementFactSheet.getTextElement(0, y, "", ffont));
                }
                y += STANDARD_FONT.getSize() + 2;
                ++i;
            }
            y += 3;
        }
        horizLineYPos.add(new Integer(y));
        lineYs.add(new Integer(y));
        line = new Vector();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 3, Babel.get("GENOTYPE"), STANDARD_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, mother.getGenotype(), mfont));
        if (father != null) {
            line.add(PrintElementFactSheet.getTextElement(0, y, father.getGenotype(), ffont, null));
        }
        lineYs.add(new Integer(y += STANDARD_FONT.getSize() + 2 + 3));
        horizLineYPos.add(new Integer(y));
        return FactSheetWurf.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
    }

    private TreeMap sortPupsByLine(Wurf wurf) {
        TreeMap<Line, Vector<Mouse>> res = new TreeMap<Line, Vector<Mouse>>(LINE_SORTER);
        Iterator<Object> iterator = wurf.ivKids.iterator();
        while (iterator.hasNext()) {
            Vector<Mouse> v;
            Mouse mouse = (Mouse)iterator.next();
            Serializable key = mouse.getLine();
            if (key == null) {
                key = NULLObject.INSTANCE;
            }
            if ((v = (Vector<Mouse>)res.get(key)) == null) {
                v = new Vector<Mouse>();
                res.put((Line)key, v);
            }
            v.add(mouse);
        }
        iterator = res.values().iterator();
        while (iterator.hasNext()) {
            Vector v = (Vector)iterator.next();
            Collections.sort(v, ET_SORTER);
        }
        return res;
    }

    private int createPupsTable(Vector mice, Line mouseline, int y, Vector target, int width, String group) {
        Vector lines = new Vector();
        Vector<Integer> horizLineYPos = new Vector<Integer>();
        Vector<Integer> lineYs = new Vector<Integer>();
        Vector<String> comments = new Vector<String>();
        horizLineYPos.add(new Integer(y));
        lineYs.add(new Integer(y));
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 4, Babel.get("CAGE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("EARTAG"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("SEX"), TABHEADER_FONT));
        LocusAndAlleles[] lalInLine = null;
        if (mouseline != null && !mouseline.isBreeder()) {
            lalInLine = (LocusAndAlleles[])mouseline.get("LIN_LOCIALLELES");
        }
        if (lalInLine != null) {
            int i = 0;
            while (i < lalInLine.length) {
                line.add(PrintElementFactSheet.getTextElement(0, y, LocusAndAlleles.getLocusName(group, lalInLine[i].ivLocusID), TABHEADER_FONT));
                ++i;
            }
        }
        y += TABHEADER_FONT.getSize() + 2;
        y += 4;
        Iterator iterator = mice.iterator();
        while (iterator.hasNext()) {
            Mouse kid = (Mouse)iterator.next();
            Font kfont = kid.isAliveAndVisible() ? FETT_FONT : STANDARD_FONT;
            horizLineYPos.add(new Integer(y));
            lineYs.add(new Integer(y));
            line = new Vector();
            lines.add(line);
            line.add(PrintElementFactSheet.getTextElement(0, y += 3, kid.getCageString(), kfont));
            String comment = kid.getString("MOS_COMMENT", "").trim();
            if (comment.length() != 0) {
                comments.add(comment);
                line.add(PrintElementFactSheet.getTextElement(0, y, String.valueOf(kid.getCLLWEartagString().trim()) + " " + StringHelper.getUnicodeSuperString(comments.size()) + "\u207e", kfont));
            } else {
                line.add(PrintElementFactSheet.getTextElement(0, y, kid.getCLLWEartagString(), kfont));
            }
            line.add(PrintElementFactSheet.getTextElement(0, y, DefaultManager.getSexString(kid, true), kfont));
            if (lalInLine != null) {
                LocusAndAlleles[] lalInMouse = (LocusAndAlleles[])kid.get("MOS_LOCUSGENOTYPES");
                int i = 0;
                while (i < lalInLine.length) {
                    LocusAndAlleles found = LocusAndAlleles.findElement(lalInLine[i], lalInMouse);
                    if (found != null) {
                        line.add(PrintElementFactSheet.getTextElement(0, y, found.getAlleleString(group), kfont));
                    } else {
                        line.add(PrintElementFactSheet.getTextElement(0, y, "", kfont));
                    }
                    ++i;
                }
            }
            y += STANDARD_FONT.getSize() + 2 + 3;
        }
        lineYs.add(new Integer(y));
        horizLineYPos.add(new Integer(y));
        y = FactSheetWurf.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
        if (!comments.isEmpty()) {
            y += 8;
            int cop = 1;
            Iterator iterator2 = comments.iterator();
            while (iterator2.hasNext()) {
                String comment = (String)iterator2.next();
                PrintElementFactSheet pefs = PrintElementFactSheet.getTextElement(0, y, String.valueOf(StringHelper.getUnicodeSuperString(cop)) + "\u207e", STANDARD_FONT);
                target.add(pefs);
                y = FactSheetWurf.addFullLongText(comment, width, y, target, pefs.ivWidth + 2);
                ++cop;
                y += 3;
            }
        }
        return y;
    }

    public static class WurfChoice {
        private final String ivDate;
        public final Wurf ivWurf;
        private final int ivIndex;
        private final int ivGesamtZahl;
        private boolean ivShowMotherInfo = true;
        private boolean ivShowDateInMotherInfo = true;

        public WurfChoice(Wurf wurf, int index, int gesamtZahl) {
            this.ivDate = DatumFormat.getJustDateString(wurf.ivDay);
            this.ivWurf = wurf;
            this.ivIndex = index;
            this.ivGesamtZahl = gesamtZahl;
        }

        public String toString() {
            return this.ivDate;
        }
    }
}

