/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Log;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.helper.Zeile;

public abstract class IDObjectMerker {
    public static final String STRING_SIGNAL = "#S#";
    public static final String ENSEMBL_LID = "ensembl_";
    public static final String MGI_LID = "mgi_";
    static /* synthetic */ Class class$0;

    public static String getEnsemblLink(String id, String defVal) {
        if (id != null) {
            return ENSEMBL_LID + id;
        }
        return defVal;
    }

    public static String getMGILink(String id, String defVal) {
        if (id != null) {
            return MGI_LID + id;
        }
        return defVal;
    }

    public static String getLink(Object ido, String defVal) {
        if (ido != null) {
            StringBuilder msb = new StringBuilder();
            IDObjectMerker.appendLinkInfo(ido, msb, 0, null);
            if (msb.length() == 0) {
                return null;
            }
            return msb.toString();
        }
        return defVal;
    }

    public static String getLink(Vector objects, String defVal) {
        if (objects != null && !objects.isEmpty()) {
            StringBuilder msb = new StringBuilder();
            int i = 0;
            while (i < objects.size()) {
                if (i != 0) {
                    msb.append("|");
                }
                IDObjectMerker.appendLinkInfo(objects.elementAt(i), msb, 0, null);
                ++i;
            }
            if (msb.length() == 0) {
                return null;
            }
            return msb.toString();
        }
        return defVal;
    }

    public static String getLink(HashSet objects, String defVal, int defObjTyp, String group) {
        if (objects != null && !objects.isEmpty()) {
            StringBuilder msb = new StringBuilder();
            Iterator iter = objects.iterator();
            while (iter.hasNext()) {
                if (msb.length() != 0) {
                    msb.append("|");
                }
                IDObjectMerker.appendLinkInfo(iter.next(), msb, defObjTyp, group);
            }
            if (msb.length() == 0) {
                return null;
            }
            return msb.toString();
        }
        return defVal;
    }

    public static String getLink(long[] ids, String defVal, int objTyp, String group) {
        if (ids != null && ids.length != 0) {
            StringBuffer msb = new StringBuffer();
            int i = 0;
            while (i < ids.length) {
                if (msb.length() != 0) {
                    msb.append("|");
                }
                IDObjectMerker.appendLinkInfo(ids[i], msb, objTyp, group);
                ++i;
            }
            if (msb.length() == 0) {
                return null;
            }
            return msb.toString();
        }
        return defVal;
    }

    private static void appendLinkInfo(long id, StringBuffer msb, int objTyp, String group) {
        msb.append(objTyp).append(",");
        msb.append(id).append(",");
        msb.append(group);
    }

    private static void appendLinkInfo(Object object, StringBuilder msb, int defObjTyp, String group) {
        if (object instanceof IDObject) {
            IDObject ido = (IDObject)object;
            if (ido.existed()) {
                msb.append(ido.getTyp(-1)).append(",");
                msb.append(ido.getID(-1L)).append(",");
                msb.append(ido.getGroup());
            }
        } else if (object instanceof Long) {
            Long l = (Long)object;
            msb.append(defObjTyp).append(",");
            msb.append(l).append(",");
            msb.append(group);
            if (group == null) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.factsheets.IDObjectMerker");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error("Gruppe nicht gesetzt ", illegalArgumentException, clazz);
            }
        } else if (object instanceof String) {
            String s = (String)object;
            msb.append(STRING_SIGNAL + s);
        }
    }

    public static boolean isSingleObjectLink(String link) {
        if (link != null) {
            return link.indexOf("|") == -1;
        }
        return false;
    }

    public static int getCommonIDObjectType(String link, int defVal) {
        int res = defVal;
        if (link != null && (link = link.trim()).length() != 0) {
            Vector zv = StringHelper.splitStringByAny(link, "|");
            int i = 0;
            while (i < zv.size()) {
                String s = (String)zv.elementAt(i);
                if (s != null && s.length() != 0) {
                    if (s.startsWith(STRING_SIGNAL)) {
                        return defVal;
                    }
                    int ind = s.indexOf(",");
                    if (ind == -1) {
                        return defVal;
                    }
                    try {
                        int iv = Integer.parseInt(s.substring(0, ind));
                        if (res == defVal) {
                            res = iv;
                        } else if (res != iv) {
                            return defVal;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
            return res;
        }
        return defVal;
    }

    public static Vector getObjectsFromLink(String link) {
        Vector<Object> res = null;
        if (link != null) {
            res = new Vector<Object>();
            if ((link = link.trim()).length() != 0) {
                Vector zv = StringHelper.splitStringByAny(link, "|");
                int i = 0;
                while (i < zv.size()) {
                    String s = (String)zv.elementAt(i);
                    if (s != null && s.length() != 0) {
                        if (s.startsWith(STRING_SIGNAL)) {
                            res.add(s.substring(STRING_SIGNAL.length(), s.length()));
                        } else {
                            Zeile z = new Zeile(s, ',');
                            if (z.size() == 3) {
                                try {
                                    IDObject ido = ObjectStore.getObjectDeadOrAlive(z.getInt(0, 0), z.getLong(1, 0L), z.getString(2, ""), null, false);
                                    if (ido != null) {
                                        res.add(ido);
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        return res;
    }
}

