/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.objectstore.ObjectStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.factsheets.PlugReportObject;
import mausoleum.factsheets.VisitReport;
import mausoleum.mouse.Mouse;
import mausoleum.visit.Visit;

public abstract class PlugReport {
    public static final int TOLERANZ_TAGE = 2;

    public static Vector getMiceOKForShowingPlugReport(Vector v) {
        Vector<Mouse> res = new Vector<Mouse>();
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            Mouse maus = (Mouse)iter.next();
            if (maus.isDead() || maus.getSex() != 1 || !maus.isSexActive()) continue;
            res.add(maus);
        }
        return res;
    }

    public static Vector getPlugReportObjects(Mouse mouse, long nullVal) {
        Vector plugReportObjects = null;
        if (mouse.getSex() == 1) {
            HashMap omice;
            String group = mouse.getGroup();
            plugReportObjects = new Vector();
            Vector masterVisits = mouse.getSexualActiveVisits(nullVal);
            if (masterVisits != null && !masterVisits.isEmpty() && (omice = VisitReport.collectMice(PlugReport.collectCages(masterVisits, group), group)) != null) {
                Iterator iter = omice.values().iterator();
                while (iter.hasNext()) {
                    Mouse tmouse = (Mouse)iter.next();
                    if (tmouse.getSex() != 2) continue;
                    PlugReportObject.addObjects(tmouse, Visit.getOverlapVisits(masterVisits, tmouse.getSexualActiveVisits(nullVal), 0), plugReportObjects, nullVal);
                }
            }
        }
        if (plugReportObjects != null && plugReportObjects.size() > 1) {
            Collections.sort(plugReportObjects);
        }
        return plugReportObjects;
    }

    private static HashMap collectCages(Vector visits, String group) {
        HashMap<Object, Cage> neededCages = new HashMap<Object, Cage>();
        if (visits != null && !visits.isEmpty()) {
            HashSet<Long> cageIdHash = new HashSet<Long>();
            int i = 0;
            while (i < visits.size()) {
                Visit visit = (Visit)visits.elementAt(i);
                cageIdHash.add(new Long(visit.ivCageID));
                ++i;
            }
            if (!cageIdHash.isEmpty()) {
                long[] wantedCages = new long[cageIdHash.size()];
                int pos = 0;
                Iterator iter = cageIdHash.iterator();
                while (iter.hasNext()) {
                    Long cageID = (Long)iter.next();
                    wantedCages[pos++] = cageID;
                }
                Vector receievedCages = ObjectStore.getObjects(2, wantedCages, group);
                if (receievedCages != null) {
                    int i2 = 0;
                    while (i2 < receievedCages.size()) {
                        Cage c = (Cage)receievedCages.elementAt(i2);
                        neededCages.put(c.get("IDO_ID"), c);
                        ++i2;
                    }
                }
            }
        }
        return neededCages;
    }
}

