/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.tools.StringHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.font.LineMetrics;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import mausoleum.factsheets.TextWrapElementNeu;
import mausoleum.helper.FontManager;
import mausoleum.helper.FontManagerUS;

public class TextWrapComponentNeu
extends JComponent {
    private static final long serialVersionUID = 1L;
    public String ivString;
    protected int ivOrientation = 0;
    protected boolean ivUnterstrichen = false;
    protected Vector ivElements;
    protected int ivSpaceWidth;
    protected int ivMaxWidth;
    protected int ivAktY;
    protected int ivFontSize;
    protected int ivXMargin = 0;
    public int ivOversizeWidth = 0;

    public static int getNecessaryHeight(String s, int width, Font f) {
        TextWrapComponentNeu twc = new TextWrapComponentNeu(s, f);
        twc.setSize(width, 100);
        twc.generateElements();
        return twc.ivAktY;
    }

    public TextWrapComponentNeu(String s) {
        this.ivString = s;
        this.setFont(FontManagerUS.SSB11);
        this.setForeground(Color.black);
    }

    public TextWrapComponentNeu(String s, Font f) {
        this.ivString = s;
        this.setFont(f);
        this.setForeground(Color.black);
    }

    public TextWrapComponentNeu(String s, Font f, int width) {
        this.ivString = s;
        this.setFont(f);
        this.setForeground(Color.black);
        this.setSize(width, 100);
    }

    public TextWrapComponentNeu(String s, int orientation, Font f, int width) {
        this.ivString = s;
        this.setFont(f);
        this.setForeground(Color.black);
        this.ivOrientation = orientation;
        this.setSize(width, 100);
    }

    public TextWrapComponentNeu(String s, Font f, int width, int xmargin) {
        this.ivString = s;
        this.setFont(f);
        this.ivXMargin = xmargin;
        this.setForeground(Color.black);
        this.setSize(width, 100);
    }

    public TextWrapComponentNeu(String s, Font f, int width, boolean unterstrichen) {
        this.ivString = s;
        this.setFont(f);
        this.ivUnterstrichen = unterstrichen;
        this.setForeground(Color.black);
        this.setSize(width, 100);
    }

    public TextWrapComponentNeu(String s, Font f, boolean unterstrichen) {
        this.ivString = s;
        this.setFont(f);
        this.ivUnterstrichen = unterstrichen;
        this.setForeground(Color.black);
    }

    public void dispose() {
        this.ivString = null;
        if (this.ivElements != null) {
            Iterator iter = this.ivElements.iterator();
            while (iter.hasNext()) {
                TextWrapElementNeu twe = (TextWrapElementNeu)iter.next();
                twe.ivText = null;
            }
            this.ivElements.clear();
        }
        this.ivElements = null;
    }

    public void setOrientation(int or) {
        if (or == 0 || or == 2 || or == 4 || or == 1112) {
            this.ivOrientation = or;
            this.ivElements = null;
            return;
        }
        throw new IllegalArgumentException("Orientation not supported");
    }

    public int getHeight() {
        return this.ivAktY;
    }

    public String getText() {
        return this.ivString;
    }

    public void setText(String s) {
        if (s == null) {
            s = "";
        }
        this.ivString = s;
        this.generateElements();
    }

    public void generateElements() {
        this.ivElements = new Vector();
        if (this.ivString == null) {
            return;
        }
        if (this.ivString.trim().length() == 0) {
            return;
        }
        Vector paragraphs = StringHelper.splitStringByAny(this.ivString, "\n");
        this.ivMaxWidth = this.getSize().width - 2 * this.ivXMargin;
        FontMetrics mfm = FontManager.getFontMetrics(this.getFont());
        this.ivSpaceWidth = mfm.stringWidth(" ");
        this.ivAktY = mfm.getMaxAscent();
        this.ivFontSize = mfm.getFont().getSize();
        int i = 0;
        while (i < paragraphs.size()) {
            this.digestParagraph((String)paragraphs.elementAt(i), mfm);
            ++i;
        }
        this.ivAktY = this.ivAktY - mfm.getMaxAscent() + mfm.getMaxDescent();
    }

    public Vector getElements() {
        if (this.ivElements == null) {
            this.generateElements();
        }
        return this.ivElements;
    }

    public void drawUnterstrich(Graphics g, FontMetrics fm, String s, int xs, int ys, int sw) {
        LineMetrics lm = fm.getLineMetrics(s, g);
        int thick = (int)lm.getUnderlineThickness();
        if (thick <= 0) {
            thick = 1;
        }
        g.fillRect(xs, ys + thick, sw, thick);
    }

    public void paint(Graphics g, int xoff, int yoff) {
        if (this.ivElements == null) {
            this.generateElements();
        }
        if (this.ivElements != null) {
            Color col;
            if (this.isOpaque() && (col = this.getBackground()) != null) {
                g.setColor(col);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            g.setColor(this.getForeground());
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            int i = 0;
            while (i < this.ivElements.size()) {
                TextWrapElementNeu twe = (TextWrapElementNeu)this.ivElements.elementAt(i);
                g.drawString(twe.ivText, twe.ivX + this.ivXMargin + xoff, twe.ivY + yoff);
                if (this.ivUnterstrichen) {
                    this.drawUnterstrich(g, fm, twe.ivText, twe.ivX + this.ivXMargin + xoff, twe.ivY + yoff, fm.stringWidth(twe.ivText));
                }
                ++i;
            }
        }
    }

    private void digestParagraph(String s, FontMetrics mfm) {
        if (s == null || s.trim().length() == 0) {
            this.ivAktY += this.ivFontSize;
            return;
        }
        Vector words = StringHelper.splitStringByAny(s, " ");
        int aktWidth = 0;
        Vector<String> aktLine = new Vector<String>();
        Vector<Integer> aktWidths = new Vector<Integer>();
        int wordsWidth = 0;
        while (!words.isEmpty()) {
            int wordWidth2;
            String word = (String)words.elementAt(0);
            int wordWidth = mfm.stringWidth(word);
            if (aktLine.isEmpty()) {
                int ind = word.indexOf("-");
                if (wordWidth > this.ivMaxWidth && wordWidth > this.ivOversizeWidth) {
                    this.ivOversizeWidth = wordWidth;
                }
                if (wordWidth > this.ivMaxWidth && ind != -1 && ind < word.length() - 1) {
                    int wordWidth22 = mfm.stringWidth(word.substring(0, ind + 1));
                    aktLine.addElement(word.substring(0, ind + 1));
                    aktWidths.addElement(new Integer(wordWidth22));
                    words.removeElementAt(0);
                    words.insertElementAt(word.substring(ind + 1, word.length()), 0);
                    this.generateLineElements(aktLine, aktWidths, aktWidth += this.ivSpaceWidth + wordWidth22, wordsWidth += wordWidth22, false);
                    aktWidth = 0;
                    wordsWidth = 0;
                    aktLine = new Vector();
                    aktWidths = new Vector();
                    continue;
                }
                aktLine.addElement(word);
                aktWidths.addElement(new Integer(wordWidth));
                aktWidth += wordWidth;
                wordsWidth += wordWidth;
                words.removeElementAt(0);
                continue;
            }
            if (aktWidth + this.ivSpaceWidth + wordWidth <= this.ivMaxWidth) {
                aktLine.addElement(word);
                aktWidths.addElement(new Integer(wordWidth));
                aktWidth += this.ivSpaceWidth + wordWidth;
                wordsWidth += wordWidth;
                words.removeElementAt(0);
                continue;
            }
            boolean hatGepasst = false;
            int ind = word.indexOf("-");
            if (ind != -1 && aktWidth + this.ivSpaceWidth + (wordWidth2 = mfm.stringWidth(word.substring(0, ind + 1))) <= this.ivMaxWidth) {
                aktLine.addElement(word.substring(0, ind + 1));
                aktWidths.addElement(new Integer(wordWidth2));
                words.removeElementAt(0);
                words.insertElementAt(word.substring(ind + 1, word.length()), 0);
                this.generateLineElements(aktLine, aktWidths, aktWidth += this.ivSpaceWidth + wordWidth2, wordsWidth += wordWidth2, false);
                aktWidth = 0;
                wordsWidth = 0;
                aktLine = new Vector();
                aktWidths = new Vector();
                hatGepasst = true;
            }
            if (hatGepasst) continue;
            this.generateLineElements(aktLine, aktWidths, aktWidth, wordsWidth, false);
            aktWidth = 0;
            wordsWidth = 0;
            aktLine = new Vector();
            aktWidths = new Vector();
        }
        if (!aktLine.isEmpty()) {
            this.generateLineElements(aktLine, aktWidths, aktWidth, wordsWidth, true);
        }
    }

    private void generateLineElements(Vector words, Vector widths, int totWidth, int wordsWidth, boolean lastLine) {
        if (this.ivOrientation == 2) {
            this.ivElements.addElement(new TextWrapElementNeu(this.assembleSingleLineString(words), 0, this.ivAktY));
        } else if (this.ivOrientation == 0) {
            this.ivElements.addElement(new TextWrapElementNeu(this.assembleSingleLineString(words), (this.ivMaxWidth - totWidth) / 2, this.ivAktY));
        } else if (this.ivOrientation == 4) {
            this.ivElements.addElement(new TextWrapElementNeu(this.assembleSingleLineString(words), this.ivMaxWidth - totWidth, this.ivAktY));
        } else if (this.ivOrientation == 1112) {
            if (lastLine) {
                this.ivElements.addElement(new TextWrapElementNeu(this.assembleSingleLineString(words), 0, this.ivAktY));
            } else {
                int restWidth = this.ivMaxWidth - wordsWidth;
                int spacePlaces = words.size() - 1;
                int inter = 0;
                int extra = 0;
                if (spacePlaces > 0) {
                    inter = restWidth / spacePlaces;
                    extra = restWidth - inter * spacePlaces;
                }
                int aktx = 0;
                int i = 0;
                while (i < words.size()) {
                    this.ivElements.addElement(new TextWrapElementNeu((String)words.elementAt(i), aktx, this.ivAktY));
                    Integer traw = (Integer)widths.elementAt(i);
                    aktx += inter + traw;
                    if (extra != 0) {
                        ++aktx;
                        --extra;
                    }
                    ++i;
                }
            }
        }
        this.ivAktY += this.ivFontSize;
    }

    private String assembleSingleLineString(Vector v) {
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < v.size()) {
            if (i != 0) {
                msb.append(" ");
            }
            msb.append((String)v.elementAt(i));
            ++i;
        }
        return msb.toString().trim();
    }

    public void setSize(Dimension d) {
        super.setSize(d);
        this.generateElements();
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.generateElements();
    }

    public void paint(Graphics g) {
        Color col;
        if (this.ivElements == null) {
            this.generateElements();
        }
        if (this.ivElements == null) {
            return;
        }
        if (this.isOpaque() && (col = this.getBackground()) != null) {
            g.setColor(col);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g.setColor(this.getForeground());
        g.setFont(this.getFont());
        FontMetrics fm = g.getFontMetrics();
        int i = 0;
        while (i < this.ivElements.size()) {
            TextWrapElementNeu twe = (TextWrapElementNeu)this.ivElements.elementAt(i);
            g.drawString(twe.ivText, twe.ivX + this.ivXMargin, twe.ivY);
            if (this.ivUnterstrichen) {
                this.drawUnterstrich(g, fm, twe.ivText, twe.ivX + this.ivXMargin, twe.ivY, fm.stringWidth(twe.ivText));
            }
            ++i;
        }
    }
}

