/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets.groupreport;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.building.Building;
import mausoleum.cage.Cage;
import mausoleum.helper.Zeile;
import mausoleum.main.ProcessDefinition;
import mausoleum.rack.Rack;
import mausoleum.room.Room;

public class GroupQuotaReport {
    public static String generateGroupQuotaReport(String group) {
        StringBuilder msb = new StringBuilder();
        if (ProcessDefinition.isServer()) {
            GQBlock gqblock = new GQBlock();
            Vector groupRacks = ObjectStore.getActualObjects(3, group);
            if (groupRacks != null) {
                Iterator iterator = groupRacks.iterator();
                while (iterator.hasNext()) {
                    Rack groupRack = (Rack)iterator.next();
                    long serviceID = groupRack.getLong("IDO_SERVID", -1L);
                    if (serviceID == -1L) continue;
                    gqblock.clear();
                    Rack serviceRack = (Rack)ObjectStore.getObjectDeadOrAlive(3, serviceID, "service", null, false);
                    Room serviceRoom = serviceRack == null ? null : (Room)ObjectStore.getObjectDeadOrAlive(10, serviceRack.getLong("RCK_ROOM", 0L), "service", null, false);
                    Building serviceBuilding = serviceRoom == null ? null : (Building)ObjectStore.getObjectDeadOrAlive(22, serviceRack.getLong("ROM_BUILDING", 0L), "service", null, false);
                    gqblock.ivGroupRackID = groupRack.getID();
                    gqblock.ivGroupRoomID = groupRack.getRoomID(-1L);
                    gqblock.ivServiceBuildingID = serviceBuilding == null ? -1L : serviceBuilding.getID(-1L);
                    gqblock.ivServiceBuildingName = serviceBuilding == null ? null : serviceBuilding.getName();
                    gqblock.ivRackQuota = serviceRack == null ? -2 : serviceRack.getQuota(group, -1);
                    gqblock.ivRoomQuota = serviceRoom == null ? -2 : serviceRoom.getQuota(group, -1);
                    gqblock.ivBuildingQuota = serviceBuilding == null ? -2 : serviceBuilding.getQuota(group, -1);
                    long[] cages = (long[])groupRack.get("RCK_CAGES");
                    int i = 0;
                    while (i < cages.length) {
                        if (cages[i] > 0L) {
                            ++gqblock.ivCages;
                            Cage cage = (Cage)ObjectStore.getObjectDeadOrAlive(2, cages[i], group, null, false);
                            if (cage != null) {
                                if (!cage.hasUnfinishedVisits()) {
                                    ++gqblock.ivEmptyCages;
                                }
                                if (cage.isMatingCage()) {
                                    ++gqblock.ivMatingCages;
                                }
                            }
                        }
                        ++i;
                    }
                    gqblock.appendTransport(msb);
                }
            }
        }
        return msb.toString();
    }

    public static class GQBlock {
        public long ivGroupRackID = -1L;
        public long ivGroupRoomID = -1L;
        public long ivServiceBuildingID = -1L;
        public String ivServiceBuildingName = null;
        public int ivCages = 0;
        public int ivEmptyCages = 0;
        public int ivMatingCages = 0;
        public int ivRackQuota = -1;
        public int ivRoomQuota = -1;
        public int ivBuildingQuota = -1;

        public static GQInfoLineVector generateInfoLinesFromTransport(String transport, String group) {
            Vector lines;
            GQInfoLineVector res = new GQInfoLineVector(group);
            if (transport != null && (lines = StringHelper.splitStringByAny(transport, "\n")) != null) {
                GQBlock block = new GQBlock();
                Iterator iterator = lines.iterator();
                while (iterator.hasNext()) {
                    Zeile z;
                    String line = (String)iterator.next();
                    if (line.length() == 0 || (z = new Zeile(line, '|')).size() <= 5) continue;
                    block.clear();
                    int col = 0;
                    block.ivGroupRackID = z.getLong(col++, -1L);
                    block.ivGroupRoomID = z.getLong(col++, -1L);
                    block.ivServiceBuildingID = z.getLong(col++, -1L);
                    block.ivServiceBuildingName = z.getStringB64(col++, null);
                    block.ivCages = z.getInt(col++, 0);
                    block.ivEmptyCages = z.getInt(col++, 0);
                    block.ivMatingCages = z.getInt(col++, 0);
                    block.ivRackQuota = z.getInt(col++, -1);
                    block.ivRoomQuota = z.getInt(col++, -1);
                    block.ivBuildingQuota = z.getInt(col++, -1);
                    GQInfoLine.handleBlock(block, group, res);
                }
            }
            return res;
        }

        public void clear() {
            this.ivGroupRackID = -1L;
            this.ivGroupRoomID = -1L;
            this.ivServiceBuildingID = -1L;
            this.ivServiceBuildingName = null;
            this.ivCages = 0;
            this.ivEmptyCages = 0;
            this.ivMatingCages = 0;
            this.ivRackQuota = -1;
            this.ivRoomQuota = -1;
            this.ivBuildingQuota = -1;
        }

        public void appendTransport(StringBuilder msb) {
            msb.append(this.ivGroupRackID).append("|");
            msb.append(this.ivGroupRoomID).append("|");
            msb.append(this.ivServiceBuildingID).append("|");
            msb.append(this.ivServiceBuildingName == null ? "" : Base64Manager.encodeBase64(this.ivServiceBuildingName)).append("|");
            msb.append(this.ivCages).append("|");
            msb.append(this.ivEmptyCages).append("|");
            msb.append(this.ivMatingCages).append("|");
            msb.append(this.ivRackQuota).append("|");
            msb.append(this.ivRoomQuota).append("|");
            msb.append(this.ivBuildingQuota).append("\n");
        }
    }

    public static class GQInfoLine
    implements Comparable {
        public static final String NO_BUILDING = "GQ_NO_BUILDING";
        public static final String NO_ROOM = "GQ_NO_ROOM";
        public static final String NO_NAME = "GQ_NO_NAME";
        private static int[] TYP_ORDER = new int[]{22, 10, 3};
        public int ivTyp = -1;
        public long ivObjectID = -1L;
        public int ivSuperTyp = -1;
        public long ivSuperObjectID = -1L;
        public String ivName = null;
        public int ivCages = 0;
        public int ivEmptyCages = 0;
        public int ivMatingCages = 0;
        public int ivQuota = -1;

        public static void handleBlock(GQBlock block, String group, GQInfoLineVector sammler) {
            GQInfoLine line = GQInfoLine.getInfoLine(group, 3, block.ivGroupRackID, block.ivRackQuota, 10, block.ivGroupRoomID, null, sammler);
            line.ivCages += block.ivCages;
            line.ivEmptyCages += block.ivEmptyCages;
            line.ivMatingCages += block.ivMatingCages;
            line = GQInfoLine.getInfoLine(group, 10, block.ivGroupRoomID, block.ivRoomQuota, 22, block.ivServiceBuildingID, null, sammler);
            line.ivCages += block.ivCages;
            line.ivEmptyCages += block.ivEmptyCages;
            line.ivMatingCages += block.ivMatingCages;
            line = GQInfoLine.getInfoLine(group, 22, block.ivServiceBuildingID, block.ivBuildingQuota, -1, -1L, block.ivServiceBuildingName, sammler);
            line.ivCages += block.ivCages;
            line.ivEmptyCages += block.ivEmptyCages;
            line.ivMatingCages += block.ivMatingCages;
        }

        public static GQInfoLine getInfoLine(String group, int typ, long id, int quota, int superTyp, long superId, String overRideName, Vector sammler) {
            IDObject ido;
            Iterator iterator = sammler.iterator();
            while (iterator.hasNext()) {
                GQInfoLine line = (GQInfoLine)iterator.next();
                if (line.ivTyp != typ || line.ivObjectID != id) continue;
                return line;
            }
            GQInfoLine res = new GQInfoLine();
            res.ivTyp = typ;
            res.ivObjectID = id;
            res.ivSuperTyp = superTyp;
            res.ivSuperObjectID = superId;
            res.ivQuota = quota;
            res.ivName = id < 0L ? Babel.get(typ == 10 ? NO_ROOM : NO_BUILDING) : (overRideName != null ? overRideName : ((ido = ObjectStore.getObjectDeadOrAlive(typ, id, group, null, false)) != null ? ido.getBrowseName() : Babel.get(NO_NAME)));
            sammler.add(res);
            return res;
        }

        public String toString() {
            return String.valueOf(this.ivName) + " " + this.ivCages + " " + this.ivEmptyCages + " " + this.ivQuota;
        }

        public synchronized boolean equals(Object arg0) {
            return this == arg0;
        }

        public int compareTo(Object arg0) {
            if (arg0 instanceof GQInfoLine) {
                GQInfoLine il = (GQInfoLine)arg0;
                if (this.ivTyp != il.ivTyp) {
                    int ind2;
                    int ind1 = ArrayHelper.findIndexInArray(this.ivTyp, TYP_ORDER);
                    if (ind1 < (ind2 = ArrayHelper.findIndexInArray(il.ivTyp, TYP_ORDER))) {
                        return -1;
                    }
                    if (ind1 > ind2) {
                        return 1;
                    }
                }
                if (this.ivCages == 0 && il.ivCages != 0) {
                    return 1;
                }
                if (this.ivCages != 0 && il.ivCages == 0) {
                    return -1;
                }
                return this.ivName.compareToIgnoreCase(il.ivName);
            }
            return 0;
        }
    }

    public static class GQInfoLineVector
    extends Vector
    implements Comparable {
        private static final long serialVersionUID = 15454453L;
        public final String ivGroup;

        public GQInfoLineVector(String group) {
            this.ivGroup = group;
        }

        public int compareTo(Object arg0) {
            if (arg0 instanceof GQInfoLineVector) {
                GQInfoLineVector iv2 = (GQInfoLineVector)arg0;
                return this.ivGroup.compareToIgnoreCase(iv2.ivGroup);
            }
            return 0;
        }

        public synchronized boolean equals(Object arg0) {
            return this == arg0;
        }
    }
}

