/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets.multidimreport;

import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import mausoleum.factsheets.FactSheetComponentScreen;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.factsheets.multidimreport.FSCompClickHandler;
import mausoleum.helper.FocusHoler;
import mausoleum.helper.WindowUtils;
import mausoleum.requester.preferences.Preferences;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.ui.UIDef;

public class FSCompScreenMD
extends FactSheetComponentScreen {
    private static final long serialVersionUID = 1L;
    public JScrollBar ivHorizontalScrollbar = new JScrollBar(0);
    public JScrollBar ivVerticalScrollbar = new JScrollBar(1);
    private final MausoleumTableModel ivDependent;
    protected int ivMaxX = 0;
    private final Point ivOrigo = new Point(0, 0);
    private final Vector ivSelecteds = new Vector();
    private int ivAktZoomIndex = ArrayHelper.finddoubleGTEQInArray((double)UIDef.getScaled(120) / 120.0, Preferences.ZOOM_FACTORS);
    public JPanel ivPanel = new JPanel(new BorderLayout());
    private final Vector ivActionListeners = new Vector();
    private final ScrollerMerker ivHorizontalScrollerMerker = new ScrollerMerker();
    private final ScrollerMerker ivVerticalScrollerMerker = new ScrollerMerker();
    private Action ivCopyTableAction = new AbstractAction(Babel.get("COPYTABLE")){
        private static final long serialVersionUID = 1342556L;

        public void actionPerformed(ActionEvent e) {
            HashMap<Point, PrintElementFactSheet> draggedElements = new HashMap<Point, PrintElementFactSheet>(FSCompScreenMD.this.ivElements.size());
            Iterator iterator = FSCompScreenMD.this.ivElements.iterator();
            while (iterator.hasNext()) {
                PrintElementFactSheet pefs = (PrintElementFactSheet)iterator.next();
                if (pefs.ivType != 3) continue;
                draggedElements.put(new Point(pefs.ivX, pefs.ivY), pefs);
            }
            FSCompScreenMD.copyDraggedElements(draggedElements);
        }
    };
    private KeyStroke ivCopyTableKS = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private Action ivExcelAction = new AbstractAction(Babel.get("EXPORT_TABLE_TO_EXCEL")){
        private static final long serialVersionUID = 1342556L;

        public void actionPerformed(ActionEvent e) {
            FSCompScreenMD.this.excel();
        }
    };
    private KeyStroke ivExcelKS = KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());

    public FSCompScreenMD(MausoleumTableModel mtm) {
        super(false);
        this.ivDependent = mtm;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Component c = e.getComponent();
                if (!c.hasFocus()) {
                    new FocusHoler(e.getComponent());
                }
                if (e.isMetaDown()) {
                    if (FSCompScreenMD.this.ivElements != null && !FSCompScreenMD.this.ivElements.isEmpty()) {
                        FSCompScreenMD.this.makePopupMenu().show(e.getComponent(), e.getX(), e.getY());
                    }
                } else {
                    boolean ctrlDown = (e.getModifiers() & 2) != 0;
                    Object o = FSCompScreenMD.this.getElementAt(e.getPoint(), -1);
                    FSCompScreenMD.this.selectElement(o, ctrlDown);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                boolean hand = false;
                Object o = FSCompScreenMD.this.getElementAt(e.getPoint(), -1);
                if (o instanceof PrintElementFactSheet) {
                    PrintElementFactSheet pe = (PrintElementFactSheet)o;
                    if (pe.ivLink != null && pe.ivLink.trim().length() != 0) {
                        hand = true;
                    }
                }
                WindowUtils.getJFrame((JComponent)e.getSource()).setCursor(hand ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
            }
        });
        MouseWheelListener mwl = new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                int notches = e.getWheelRotation();
                if ((e.getModifiers() & 2) != 0 || (e.getModifiers() & 1) != 0) {
                    int asel = FSCompScreenMD.this.ivAktZoomIndex;
                    int nsel = asel + notches;
                    if (nsel < 0) {
                        nsel = 0;
                    } else if (nsel >= Preferences.ZOOM_FACTORS.length) {
                        nsel = Preferences.ZOOM_FACTORS.length - 1;
                    }
                    if (FSCompScreenMD.this.ivAktZoomIndex != nsel) {
                        FSCompScreenMD.this.ivAktZoomIndex = nsel;
                        FSCompScreenMD.this.manageResize();
                    }
                } else {
                    int bi = FSCompScreenMD.this.ivVerticalScrollbar.getBlockIncrement();
                    if (bi != 0) {
                        int add = notches * bi / 3;
                        if (add == 0) {
                            add = notches;
                        }
                        FSCompScreenMD.this.ivVerticalScrollbar.setValue(FSCompScreenMD.this.ivVerticalScrollbar.getValue() + add);
                    }
                }
            }
        };
        this.addMouseWheelListener(mwl);
        this.ivPanel.addMouseWheelListener(mwl);
        this.ivHorizontalScrollbar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent arg0) {
                FSCompScreenMD.this.repaint();
            }
        });
        this.ivVerticalScrollbar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent arg0) {
                FSCompScreenMD.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent arg0) {
                FSCompScreenMD.this.manageResize();
            }
        });
        this.ivPanel.add("Center", this);
        this.ivPanel.add("East", this.ivVerticalScrollbar);
        this.ivPanel.add("South", this.ivHorizontalScrollbar);
        this.setBorder(new LineBorder(Color.black));
        this.makeAction(this.ivCopyTableKS, this.ivCopyTableAction, "control C");
        this.makeAction(this.ivExcelKS, this.ivExcelAction, "control E");
    }

    private void selectElement(Object o, boolean ctrlDown) {
        if (o == null) {
            this.selectNone();
            return;
        }
        if (o instanceof PrintElementFactSheet) {
            PrintElementFactSheet pefs = (PrintElementFactSheet)o;
            if (!(ctrlDown || pefs.ivType == 3 && pefs.ivText != null)) {
                this.selectNone();
                return;
            }
            Vector toSet = FSCompClickHandler.handleClick(pefs, ctrlDown, this.ivSelecteds, WindowUtils.getJFrame(this), this.ivOrigo, this.ivElements);
            this.afterSelection(toSet);
        }
    }

    public boolean hasSelecteds() {
        return !this.ivSelecteds.isEmpty();
    }

    public void selectAll() {
        this.ivSelecteds.clear();
        this.ivSelecteds.addAll(this.ivElements);
        this.afterSelection(FSCompClickHandler.collectFromPEs(this.ivSelecteds, WindowUtils.getJFrame(this), null, this.ivElements));
    }

    public void copyDraggedElements() {
        HashMap<Point, PrintElementFactSheet> hm = new HashMap<Point, PrintElementFactSheet>();
        Iterator iterator = this.ivElements.iterator();
        while (iterator.hasNext()) {
            Object ooo = iterator.next();
            if (!(ooo instanceof PrintElementFactSheet)) continue;
            PrintElementFactSheet pefs = (PrintElementFactSheet)ooo;
            if (pefs.ivBackground == null || pefs.ivText == null) continue;
            hm.put(new Point(pefs.ivX, pefs.ivY), pefs);
        }
        if (!hm.isEmpty()) {
            FSCompScreenMD.copyDraggedElements(hm);
            this.repaint();
        }
    }

    public void selectNone() {
        this.ivSelecteds.clear();
        this.ivDraggedElements.clear();
        this.afterSelection(FSCompClickHandler.collectFromPEs(this.ivSelecteds, WindowUtils.getJFrame(this), null, this.ivElements));
    }

    private void afterSelection(Vector toSet) {
        if (toSet != null && this.ivDependent != null) {
            this.ivDependent.setTable(toSet);
            this.ivDependent.selectNone();
        }
        this.repaint();
    }

    public void search(boolean nextOne) {
        this.ivDraggedElements.clear();
        Iterator iterator = this.ivSelecteds.iterator();
        while (iterator.hasNext()) {
            Object ooo = iterator.next();
            if (!(ooo instanceof PrintElementFactSheet)) continue;
            PrintElementFactSheet pefs = (PrintElementFactSheet)ooo;
            this.ivDraggedElements.put(new Point(pefs.ivX, pefs.ivY), pefs);
        }
        super.search(nextOne);
        if (!this.ivDraggedElements.isEmpty()) {
            Object o = this.ivDraggedElements.values().iterator().next();
            this.selectElement(o, false);
        }
    }

    public void addActionListener(ActionListener al) {
        this.ivActionListeners.add(al);
    }

    public void setElements(Vector elements, int[] maxCoords, int[] origo) {
        this.ivMaxX = maxCoords[0];
        this.ivMaxY = maxCoords[1];
        this.ivOrigo.x = origo[0];
        this.ivOrigo.y = origo[1];
        super.setElements(elements, this.ivMaxY);
        this.manageResize();
        this.ivSelecteds.clear();
        if (this.ivDependent != null) {
            this.ivDependent.setTable(ArrayHelper.LEER);
            this.ivDependent.selectNone();
        }
    }

    public void scrollToFirstDragged() {
        if (!this.ivDraggedElementRects.isEmpty()) {
            Rectangle r = (Rectangle)this.ivDraggedElementRects.firstElement();
            if (r.x < this.ivOrigo.x) {
                if (r.y > this.ivOrigo.y) {
                    this.scrollOneScrolbar(this.ivVerticalScrollbar, r.y, r.height, this.ivVerticalScrollerMerker);
                }
            } else if (r.y > this.ivOrigo.y) {
                this.scrollOneScrolbar(this.ivHorizontalScrollbar, r.x, r.width, this.ivHorizontalScrollerMerker);
                this.scrollOneScrolbar(this.ivVerticalScrollbar, r.y, r.height, this.ivVerticalScrollerMerker);
            } else {
                this.scrollOneScrolbar(this.ivHorizontalScrollbar, r.x, r.width, this.ivHorizontalScrollerMerker);
            }
        }
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        Color bg = this.getBackground();
        if (bg == null) {
            bg = Color.white;
        }
        g.setColor(bg);
        g.fillRect(0, 0, d.width, d.height);
        if (!this.ivElements.isEmpty()) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(10, 10);
            g2d.scale(this.ivFactor, this.ivFactor);
            int breiteCDScreen = this.ivOrigo.x;
            int hoeheBDScreen = this.ivOrigo.y;
            int breiteAScreen = this.ivMaxX - this.ivOrigo.x;
            int hoeheAScreen = this.ivMaxY - this.ivOrigo.y;
            Shape oldclip = g.getClip();
            g.setClip(oldclip);
            g.clipRect(breiteCDScreen - 1, hoeheBDScreen - 1, breiteAScreen + 2, hoeheAScreen + 2);
            g.setColor(bg);
            g.fillRect(breiteCDScreen, hoeheBDScreen, breiteAScreen, hoeheAScreen);
            g2d.translate(-this.ivHorizontalScrollbar.getValue(), -this.ivVerticalScrollbar.getValue());
            this.printElements(this.ivElements, g2d, this.ivOrigo.x, this.ivMaxX, this.ivOrigo.y, this.ivMaxY);
            g2d.translate(this.ivHorizontalScrollbar.getValue(), this.ivVerticalScrollbar.getValue());
            g.setClip(oldclip);
            g.clipRect(breiteCDScreen, 0, breiteAScreen + 1, hoeheBDScreen + 1);
            g.setColor(bg);
            g.fillRect(breiteCDScreen, 0, breiteAScreen, hoeheBDScreen);
            g2d.translate(-this.ivHorizontalScrollbar.getValue(), 0);
            this.printElements(this.ivElements, g2d, this.ivOrigo.x, this.ivMaxX, 0, this.ivOrigo.y);
            g2d.translate(this.ivHorizontalScrollbar.getValue(), 0);
            g.setClip(oldclip);
            g.clipRect(0, hoeheBDScreen, breiteCDScreen + 1, hoeheAScreen + 1);
            g.setColor(bg);
            g.fillRect(0, hoeheBDScreen, breiteCDScreen, hoeheAScreen);
            g2d.translate(0, -this.ivVerticalScrollbar.getValue());
            this.printElements(this.ivElements, g2d, 0, this.ivOrigo.x, this.ivOrigo.y, this.ivMaxY);
            g2d.translate(0, this.ivVerticalScrollbar.getValue());
            g.setClip(oldclip);
            g.clipRect(0, 0, breiteCDScreen + 1, hoeheBDScreen + 1);
            g.setColor(bg);
            g.fillRect(0, 0, breiteCDScreen, hoeheBDScreen);
            this.printElements(this.ivElements, g2d, 0, this.ivOrigo.x, 0, this.ivOrigo.y);
            g.setClip(oldclip);
            g2d.scale(1.0 / this.ivFactor, 1.0 / this.ivFactor);
            g2d.translate(-10, -10);
        }
        super.paintBorder(g);
    }

    private void printElements(Vector elements, Graphics2D g2d, int minx, int maxx, int miny, int maxy) {
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            PrintElementFactSheet element = (PrintElementFactSheet)iter.next();
            if (!element.isWithin(minx, maxx, miny, maxy)) continue;
            element.print(g2d, this.ivShowLinks);
        }
    }

    public Dimension getPreferredSize() {
        return UIDef.MINI_DIM;
    }

    public Object getElementAt(Point p, int printElementTyp) {
        p = this.getScaledPoint(p);
        if (p.x > this.ivOrigo.x) {
            p.x += this.ivHorizontalScrollbar.getValue();
        }
        if (p.y > this.ivOrigo.y) {
            p.y += this.ivVerticalScrollbar.getValue();
        }
        Iterator iter = this.ivElements.iterator();
        while (iter.hasNext()) {
            PrintElementFactSheet element = (PrintElementFactSheet)iter.next();
            Object ooo = element.getElementAtScaledPoint(p, printElementTyp);
            if (ooo == null) continue;
            return ooo;
        }
        return null;
    }

    public void manageResize() {
        this.ivFactor = Preferences.ZOOM_FACTORS[this.ivAktZoomIndex];
        Dimension d = this.getSize();
        FSCompScreenMD.manageScrollBar(this.ivVerticalScrollbar, d.height, this.ivOrigo.y, this.ivMaxY, this.ivFactor, this.ivVerticalScrollerMerker);
        FSCompScreenMD.manageScrollBar(this.ivHorizontalScrollbar, d.width, this.ivOrigo.x, this.ivMaxX, this.ivFactor, this.ivHorizontalScrollerMerker);
        this.repaint();
    }

    private static void manageScrollBar(JScrollBar sb, int sichtbarePixel, int fixiertUnskaliert, int maximumGebrauchtUnskaliert, double factor, ScrollerMerker sm) {
        int maximumGebrauchtSkaliert = (int)((double)maximumGebrauchtUnskaliert * factor);
        int totalGebraucht = maximumGebrauchtSkaliert + 20;
        int fixiertSkaliert = (int)((double)fixiertUnskaliert * factor);
        int fixiertGebraucht = fixiertSkaliert + 10;
        int unfixiertUnskaliert = maximumGebrauchtUnskaliert - fixiertUnskaliert;
        int unfixiertSkaliert = (int)((double)unfixiertUnskaliert * factor);
        int unfixiertGebraucht = unfixiertSkaliert + 10;
        int newValue = 0;
        int newExtend = 0;
        int newMinimum = 0;
        int newMaximum = 0;
        int newBlockIncrement = 0;
        if (totalGebraucht > sichtbarePixel && fixiertGebraucht < sichtbarePixel) {
            int benutzbarePixel = sichtbarePixel - fixiertGebraucht;
            newExtend = (int)((double)benutzbarePixel / factor);
            newMaximum = (int)((double)unfixiertGebraucht / factor);
            int oldValue = sb.getValue();
            if (oldValue != 0) {
                oldValue = (int)((double)oldValue / (double)sm.newMaximum * (double)newMaximum);
            }
            newValue = oldValue > newMaximum - newExtend ? newMaximum - newExtend : oldValue;
            newBlockIncrement = newExtend;
        }
        sb.setValues(newValue, newExtend, newMinimum, newMaximum);
        sb.setBlockIncrement(newBlockIncrement);
        sm.fixiertUnskaliert = fixiertUnskaliert;
        sm.factor = factor;
        sm.unfixiertGebraucht = unfixiertGebraucht;
        sm.newExtend = newExtend;
        sm.newMaximum = newMaximum;
    }

    private void scrollOneScrolbar(JScrollBar sb, int wantVorn, int wantGroesse, ScrollerMerker sm) {
        if (sm.newMaximum == 0) {
            return;
        }
        int posVornRelativZuOriogo = wantVorn - sm.fixiertUnskaliert;
        int wantedValVorn = (int)((double)posVornRelativZuOriogo * sm.factor / (double)sm.unfixiertGebraucht * (double)sm.newMaximum);
        int posHintenRelativZuOriogo = wantVorn + wantGroesse - sm.fixiertUnskaliert;
        int wantedValHinten = (int)((double)posHintenRelativZuOriogo * sm.factor / (double)sm.unfixiertGebraucht * (double)sm.newMaximum);
        int aktval = sb.getValue();
        if (aktval <= wantedValVorn && aktval + sm.newExtend >= wantedValHinten) {
            return;
        }
        int wantedVal = 0;
        wantedVal = wantedValHinten - wantedValVorn <= sm.newExtend ? wantedValVorn - (sm.newExtend - (wantedValHinten - wantedValVorn)) / 2 : wantedValVorn;
        wantedVal = wantedVal < 0 ? 0 : wantedVal;
        wantedVal = wantedVal > sm.newMaximum - sm.newExtend ? sm.newMaximum - sm.newExtend : wantedVal;
        sb.setValue(wantedVal);
    }

    private JPopupMenu makePopupMenu() {
        JPopupMenu res = new JPopupMenu();
        this.makeItem(this.ivCopyTableKS, this.ivCopyTableAction, res);
        this.makeItem(this.ivExcelKS, this.ivExcelAction, res);
        JMenu submenu = new JMenu(Babel.get("CCV_ZOOM"));
        res.add(submenu);
        int i = 0;
        while (i < Preferences.ZOOM_FACTORS.length) {
            JMenuItem item = new JMenuItem(Preferences.ZOOM_STRINGS[i]);
            item.setActionCommand(Integer.toString(i));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FSCompScreenMD.this.ivAktZoomIndex = Integer.parseInt(e.getActionCommand());
                    FSCompScreenMD.this.manageResize();
                }
            });
            submenu.add(item);
            ++i;
        }
        this.addPopupItems(res);
        return res;
    }

    private void excel() {
        ActionEvent ae = new ActionEvent(this, 1, "EXCEL");
        Iterator iterator = this.ivActionListeners.iterator();
        while (iterator.hasNext()) {
            ActionListener al = (ActionListener)iterator.next();
            al.actionPerformed(ae);
        }
    }

    public static class ScrollerMerker {
        int fixiertUnskaliert;
        double factor;
        int unfixiertGebraucht;
        int newExtend;
        int newMaximum;
    }
}

