/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets.multidimreport;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.objectstore.NULLObject;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.objectstore.requesthandler.OBRHS_Service_Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.TabManager;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.experiment.Experiment;
import mausoleum.helper.Zeile;
import mausoleum.license.License;
import mausoleum.line.Line;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.CoatColor;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.mouse.WeaningControl;
import mausoleum.rack.Rack;
import mausoleum.result.MResult;
import mausoleum.room.Room;
import mausoleum.search.profisearch.searcher.MausoSearcherObject;
import mausoleum.strain.Strain;
import mausoleum.task.DisplayTask;
import mausoleum.util.InstallationType;
import mausoleum.visit.Visit;

public abstract class MultiDimAnalyzer {
    private static final HashMap ALLES_KEYS = new HashMap();
    private static final HashMap NIX_KEYS = new HashMap();
    private static final Object NIX = NULLObject.INSTANCE;
    private static final Object ALLES = new Integer(Integer.MAX_VALUE);
    public static final int TYP_NIX = 123456;
    public static final int TYP_SEX = 1;
    public static final int TYP_LINE = 2;
    public static final int TYP_STRAIN = 3;
    public static final int TYP_ROOM = 4;
    public static final int TYP_RACK = 5;
    public static final int TYP_AGE = 6;
    public static final int TYP_OWNER = 7;
    public static final int TYP_LICENSE = 8;
    public static final int TYP_MARK = 9;
    public static final int TYP_MATING = 10;
    public static final int TYP_AGE_WEEKS = 13;
    public static final int TYP_PRIMARY_OWNER = 11;
    public static final int TYP_TASK = 12;
    public static final int TYP_GROUP = 14;
    public static final int TYP_TASK_DETAIL = 15;
    public static final int TYP_COAT_COLOR = 16;
    public static final int TYP_MOUSE_COUNT = 17;
    public static final int TYP_GENOTYPE = 18;
    public static final int TYP_START_MODE = 19;
    public static final int TYP_END_MODE = 20;
    public static final int TYP_RESULT = 21;
    public static final int TYP_GENOTYPE_FULL = 22;
    public static final int TYP_GENOTYPE_PER_LOCUS = 23;
    public static final int TYP_FILL_STATUS_BY_CAGE = 24;
    public static final int TYP_ORIGIN = 25;
    public static final int TYP_DESTINATION = 26;
    public static final int TYP_WEANING = 27;
    public static final int TYP_ISSUER = 28;
    public static final int TYP_FAVORIT = 29;
    public static final int TYP_TASK_STATUS = 30;
    public static final int TYP_PROCEDURE_TYPE = 31;
    public static final int TYP_CLINICAL_SYMPPTOMS = 32;
    public static final int TYP_ALPH_NUM_TAG = 33;
    public static final int TYP_TOTAL = 1789;
    private static final int[] ALL_TYPES = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 10, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33};
    private static final String[] ALL_TYPES_BABELS = new String[]{"MD_SEX", "MD_LINE", "MD_STRAIN", "MD_ROOM", "MD_RACK", "MD_AGE_MONTHS", "MD_OWNER", "MD_LICENSE", "MD_MARK", "MD_AGE_WEEKS", "MD_PRIMARY_OWNER", "MD_MATING", "MD_TASK", "MD_GROUP", "MD_TASK_DETAIL", "MD_COAT_COLOR", "MD_MOUSE_COUNT", "MD_GENOTYPE", "MD_START_MODE", "MD_END_MODE", "MD_RESULT", "MD_GENOTYPE_FULL", "MD_GENOTYPE_BY_LOCUS", "MD_FILL_STATUS", "FS_ORIGIN", "FS_DESTINATION", "MD_WEANING", "TASK_ISSUER", "TASK_FAVORIT", "TASK_STATUS", "TASK_TYPE", "CAG_COL_MODE_SYMPTOM", "MTM_TT_ANTAG"};
    private static final int[] MOUSE_TYPES_REGULAR = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 10, 12, 15, 16, 18, 19, 20, 21, 22, 23, 25, 26, 27, 32, 33};
    private static final int[] MOUSE_TYPES_REGULAR_DEAD = new int[]{1, 2, 3, 6, 7, 8, 9, 13, 11, 16, 18, 19, 20, 21, 22, 23, 25, 26, 32, 33};
    private static final int[] MOUSE_TYPES_SERVICE_CARETAKER = new int[]{1, 2, 3, 4, 5, 6, 7, 9, 13, 11, 10, 12, 14, 15, 16, 18, 19, 20, 21, 25, 26, 27, 32, 33};
    private static final int[] MOUSE_TYPES_HEAD_OF_SERVICE = new int[]{1, 2, 3, 4, 5, 6, 8, 9, 13, 11, 10, 12, 14, 15, 16, 18, 19, 20, 21, 27, 32, 33};
    private static final int[] MOUSE_TYPES_HEAD_OF_SERVICE_DEAD = new int[]{1, 2, 3, 6, 8, 9, 13, 11, 12, 14, 16, 18, 19, 20, 21, 32, 33};
    private static final int[] CAGE_TYPES_REGULAR = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 10, 12, 15, 17, 18, 24, 27, 32};
    private static final int[] CAGE_TYPES_SERVICE_CARETAKER = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 10, 12, 14, 15, 17, 18, 27, 32};
    private static final int[] CAGE_TYPES_HEAD_OF_SERVICE = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 11, 10, 12, 14, 15, 17, 18, 24, 27, 32};
    private static final int[] TASK_TYPES_REGULAR = new int[]{1, 2, 3, 4, 5, 6, 7, 9, 13, 11, 10, 14, 28, 29, 30, 31};
    private static final int[] TASK_TYPES_HOS = new int[]{1, 2, 3, 4, 5, 6, 9, 13, 14, 16, 28, 29, 30, 31};
    public static final Comparator VECTOR_COMPARER = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof Vector && arg1 instanceof Vector) {
                Vector v0 = (Vector)arg0;
                Vector v1 = (Vector)arg1;
                int i = 0;
                while (i < v0.size()) {
                    MDKey mdk1;
                    MDKey mdk0 = (MDKey)v0.elementAt(i);
                    int r1 = mdk0.compareTo(mdk1 = (MDKey)v1.elementAt(i));
                    if (r1 != 0) {
                        return r1;
                    }
                    ++i;
                }
            }
            return 0;
        }
    };
    public static final int CAGE_MODE_ALL = 0;
    public static final int CAGE_MODE_FILLED = 1;
    public static final int CAGE_MODE_EMPTY = 2;
    public static final int CAGE_MODE_MATING = 3;
    public static final int CAGE_MODE_NON_MATING = 4;
    public static final String[] CAGE_MODE_STRINGS = new String[]{Babel.get("MD_ALL_CAGES"), Babel.get("MD_FILLED_CAGES"), Babel.get("MD_EMPTY_CAGES"), Babel.get("MD_MATING_CAGES"), Babel.get("MD_NON_MATING_CAGE")};
    public static final int[] CAGE_MODE_INTS;
    public final TreeMap ivObjectsByMDKey = new TreeMap();
    public boolean ivIsXstart = false;
    public boolean ivIsLastOne = true;
    public boolean ivMitTotal = false;
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        CAGE_MODE_INTS = nArray;
    }

    public static boolean serviceGroupAnalyze(ObjectRequest or) {
        MultiDimAnalyzer multiDimAnaylzer = null;
        try {
            AnalyzerInfo ai = (AnalyzerInfo)or.ivObject;
            multiDimAnaylzer = MultiDimAnalyzer.analyze(OBRHS_Service_Manager.getAllServiceMultiDimObjects(ai.ivObjectType, ai.ivCageMode, ai.ivObjectHolderTicket), ai.ivTypes, ai.ivXPoint);
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.factsheets.multidimreport.MultiDimAnalyzer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Problem with multidiminsional analysis", e, clazz);
        }
        or.ivObject = multiDimAnaylzer == null ? null : IDObjectXMLHandler.getTransport(multiDimAnaylzer, true, true);
        return or.ivObject != null;
    }

    public static MultiDimAnalyzer analyze(Vector objects, int[] types, int xpos) {
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        MultiDimAnalyzer res = MultiDimAnalyzer.getSearcher(types[0]);
        res.distribute(objects);
        res.nextRound(types, 1, xpos);
        return res;
    }

    public static Vector getAllTypeObjects(int objectType, boolean forDeadObjects) {
        int[] arr = null;
        if (objectType == 1) {
            if (forDeadObjects) {
                if (MausoleumClient.isRegularOrTGService()) {
                    arr = MOUSE_TYPES_REGULAR_DEAD;
                } else if (!MausoleumClient.isServiceCaretaker() && MausoleumClient.isHeadOfService()) {
                    arr = MOUSE_TYPES_HEAD_OF_SERVICE_DEAD;
                }
            } else if (MausoleumClient.isRegularOrTGService()) {
                arr = MOUSE_TYPES_REGULAR;
            } else if (MausoleumClient.isServiceCaretaker()) {
                arr = MOUSE_TYPES_SERVICE_CARETAKER;
            } else if (MausoleumClient.isHeadOfService()) {
                arr = MOUSE_TYPES_HEAD_OF_SERVICE;
            }
        } else if (objectType == 2) {
            if (MausoleumClient.isRegularOrTGService()) {
                arr = CAGE_TYPES_REGULAR;
            } else if (MausoleumClient.isServiceCaretaker()) {
                arr = CAGE_TYPES_SERVICE_CARETAKER;
            } else if (MausoleumClient.isHeadOfService()) {
                arr = CAGE_TYPES_HEAD_OF_SERVICE;
            }
        } else if (objectType == 15) {
            if (MausoleumClient.isRegularOrTGService()) {
                arr = TASK_TYPES_REGULAR;
            } else if (!MausoleumClient.isServiceCaretaker() && MausoleumClient.isHeadOfService()) {
                arr = TASK_TYPES_HOS;
            }
        }
        if (arr != null) {
            arr = MultiDimAnalyzer.checkArray(arr);
            Vector<MDTypeObject> v = new Vector<MDTypeObject>(arr.length);
            int i = 0;
            while (i < arr.length) {
                v.add(new MDTypeObject(arr[i], StringHelper.getStringForInt(arr[i], ALL_TYPES, ALL_TYPES_BABELS, false, "")));
                ++i;
            }
            Collections.sort(v);
            return v;
        }
        return null;
    }

    public static int[] checkArray(int[] arr) {
        if (arr != null && arr.length != 0 && !InstallationType.useMatings()) {
            return ArrayHelper.getArrayWithout(arr, 10);
        }
        return arr;
    }

    public static void fetchCageBaseSet(Vector source, Vector target, int cageMode) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (cageMode != 0) break block4;
                            target.addAll(source);
                            break block5;
                        }
                        if (cageMode != 2) break block6;
                        Iterator iterator = source.iterator();
                        while (iterator.hasNext()) {
                            Cage cage = (Cage)iterator.next();
                            if (cage.hasUnfinishedVisits()) continue;
                            target.add(cage);
                        }
                        break block5;
                    }
                    if (cageMode != 1) break block7;
                    Iterator iterator = source.iterator();
                    while (iterator.hasNext()) {
                        Cage cage = (Cage)iterator.next();
                        if (!cage.hasUnfinishedVisits()) continue;
                        target.add(cage);
                    }
                    break block5;
                }
                if (cageMode != 3) break block8;
                Iterator iterator = source.iterator();
                while (iterator.hasNext()) {
                    Cage cage = (Cage)iterator.next();
                    if (!cage.hasUnfinishedVisits() || !cage.isMatingCage()) continue;
                    target.add(cage);
                }
                break block5;
            }
            if (cageMode != 4) break block5;
            Iterator iterator = source.iterator();
            while (iterator.hasNext()) {
                Cage cage = (Cage)iterator.next();
                if (!cage.hasUnfinishedVisits() || cage.isMatingCage()) continue;
                target.add(cage);
            }
        }
    }

    private static void add(TreeMap objectVectorsByMDKey, MDKey mdKey, Object mouseOrCage) {
        Vector<Object> sammler = (Vector<Object>)objectVectorsByMDKey.get(mdKey);
        if (sammler == null) {
            sammler = new Vector<Object>();
            objectVectorsByMDKey.put(mdKey, sammler);
        }
        sammler.add(mouseOrCage);
    }

    public static MultiDimAnalyzer getSearcher(int typ) {
        MultiDimAnalyzer res = null;
        boolean mitSubTotal = false;
        if (typ < 0) {
            mitSubTotal = true;
            typ = -typ;
        }
        switch (typ) {
            case 123456: {
                res = new MDSNIX();
                break;
            }
            case 1: {
                res = new MDSSex();
                break;
            }
            case 2: {
                res = new MDSLine();
                break;
            }
            case 3: {
                res = new MDSStrain();
                break;
            }
            case 8: {
                res = new MDSLicense();
                break;
            }
            case 7: {
                res = new MDSOwner(false);
                break;
            }
            case 11: {
                res = new MDSOwner(true);
                break;
            }
            case 6: {
                res = new MDSAge(6);
                break;
            }
            case 5: {
                res = new MDSRack();
                break;
            }
            case 4: {
                res = new MDSRoom();
                break;
            }
            case 9: {
                res = new MDSMark();
                break;
            }
            case 13: {
                res = new MDSAge(13);
                break;
            }
            case 10: {
                res = new MDSMating();
                break;
            }
            case 12: {
                res = new MDSTask();
                break;
            }
            case 15: {
                res = new MDSTaskDetail();
                break;
            }
            case 14: {
                res = new MDSGroup();
                break;
            }
            case 16: {
                res = new MDSCoatColor();
                break;
            }
            case 17: {
                res = new MDSMouseCount();
                break;
            }
            case 18: {
                res = new MDSGenotype();
                break;
            }
            case 19: {
                res = new MDSVisitMode(true);
                break;
            }
            case 20: {
                res = new MDSVisitMode(false);
                break;
            }
            case 21: {
                res = new MDSResult();
                break;
            }
            case 22: {
                res = new MDSGenotypeFULL();
                break;
            }
            case 23: {
                res = new MDSGenotypePerLocus();
                break;
            }
            case 24: {
                res = new MDSFillStatusByCage();
                break;
            }
            case 25: {
                res = new MDSOrigin();
                break;
            }
            case 26: {
                res = new MDSDestination();
                break;
            }
            case 27: {
                res = new MDSWeaning();
                break;
            }
            case 28: {
                res = new MDSTaskUser(true);
                break;
            }
            case 29: {
                res = new MDSTaskUser(false);
                break;
            }
            case 30: {
                res = new MDSTaskStatus();
                break;
            }
            case 31: {
                res = new MDSProcType();
                break;
            }
            case 32: {
                res = new MDSClinicalSymptoms();
                break;
            }
            case 33: {
                res = new MDSANTag();
                break;
            }
        }
        if (res != null) {
            res.ivMitTotal = mitSubTotal;
        }
        return res;
    }

    private static MDKey getNixKey(int typ) {
        Integer tkey = new Integer(typ);
        MDKey key = (MDKey)NIX_KEYS.get(tkey);
        if (key == null) {
            key = new MDKey(typ, NIX, Babel.get("NONE"), (Comparable)((Object)""));
            NIX_KEYS.put(tkey, key);
        }
        return key;
    }

    private static MDKey getAllesKey(int typ) {
        Integer tkey = new Integer(typ);
        MDKey key = (MDKey)ALLES_KEYS.get(tkey);
        if (key == null) {
            key = new MDKey(typ, ALLES, Babel.get("FS_M_TOTAL"), (Comparable)((Object)""));
            ALLES_KEYS.put(tkey, key);
        }
        return key;
    }

    public String toString() {
        return this.toString(0);
    }

    private void distribute(Vector objects) {
        Iterator iterator = objects.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            this.distribute(object);
            if (!this.totalWanted()) continue;
            MultiDimAnalyzer.add(this.ivObjectsByMDKey, MultiDimAnalyzer.getAllesKey(1789), object);
        }
    }

    private void nextRound(int[] types, int pos, int xpos) {
        boolean bl = this.ivIsXstart = pos == xpos + 1;
        if (pos < types.length) {
            this.ivIsLastOne = false;
            Iterator iterator = this.ivObjectsByMDKey.keySet().iterator();
            while (iterator.hasNext()) {
                MDKey key = (MDKey)iterator.next();
                Vector v = (Vector)this.ivObjectsByMDKey.get(key);
                MultiDimAnalyzer analyzer = MultiDimAnalyzer.getSearcher(types[pos]);
                analyzer.distribute(v);
                this.ivObjectsByMDKey.put(key, analyzer);
                analyzer.nextRound(types, pos + 1, xpos);
            }
        }
    }

    public boolean totalWanted() {
        return this.ivMitTotal;
    }

    private String toString(int tab) {
        StringBuilder msb = new StringBuilder();
        Iterator iterator = this.ivObjectsByMDKey.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object val = this.ivObjectsByMDKey.get(key);
            if (val instanceof Vector) {
                Vector v = (Vector)val;
                msb.append(TabManager.getTab(tab)).append(key).append(": ").append(v.size()).append("\n");
                continue;
            }
            if (!(val instanceof MultiDimAnalyzer)) continue;
            MultiDimAnalyzer mds = (MultiDimAnalyzer)val;
            msb.append(TabManager.getTab(tab)).append(key).append(":\n");
            msb.append(TabManager.getTab(tab)).append("{\n");
            msb.append(mds.toString(tab + 1));
            msb.append(TabManager.getTab(tab)).append("}\n");
        }
        return msb.toString();
    }

    public String getDimRes(Vector labels, int pos) {
        MDKey key = (MDKey)labels.elementAt(pos);
        Object val = this.ivObjectsByMDKey.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof Vector) {
            Vector v = (Vector)val;
            return Integer.toString(v.size());
        }
        if (val instanceof MultiDimAnalyzer) {
            MultiDimAnalyzer mds = (MultiDimAnalyzer)val;
            return mds.getDimRes(labels, pos + 1);
        }
        return "???";
    }

    public Object getVectorDimRes(Vector mdKeyVector, int pos) {
        MDKey key = (MDKey)mdKeyVector.elementAt(pos);
        Object val = this.ivObjectsByMDKey.get(key);
        if (val != null) {
            if (val instanceof MultiDimAnalyzer) {
                MultiDimAnalyzer mds = (MultiDimAnalyzer)val;
                return mds.getVectorDimRes(mdKeyVector, pos + 1);
            }
            return val;
        }
        return null;
    }

    public void addCoordinates(Vector aktVec, TreeSet xCoords, TreeSet yCoords) {
        if (this.ivIsXstart) {
            yCoords.add(aktVec);
            aktVec = null;
        }
        Iterator iterator = this.ivObjectsByMDKey.keySet().iterator();
        while (iterator.hasNext()) {
            MDKey mdKey = (MDKey)iterator.next();
            Vector<MDKey> v = new Vector<MDKey>();
            if (aktVec != null) {
                v.addAll(aktVec);
            }
            v.add(mdKey);
            if (this.ivIsLastOne) {
                xCoords.add(v);
                continue;
            }
            MultiDimAnalyzer nextAnalyzer = (MultiDimAnalyzer)this.ivObjectsByMDKey.get(mdKey);
            nextAnalyzer.addCoordinates(v, xCoords, yCoords);
        }
    }

    protected void addWithKeyForIDObject(IDObject ido, int typ, Object object, HashMap keyStore) {
        String k;
        MDKey key = null;
        if (ido != null && (key = (MDKey)keyStore.get(k = String.valueOf(ido.getGroup()) + "|" + ido.getID())) == null) {
            String name = ido.getNonNullName();
            key = new MDKey(typ, k, name, (Comparable)((Object)name));
            keyStore.put(k, key);
        }
        MultiDimAnalyzer.add(this.ivObjectsByMDKey, key != null ? key : MultiDimAnalyzer.getNixKey(typ), object);
    }

    public abstract void distribute(Object var1);

    public abstract int getTyp();

    public static class AnalyzerInfo
    implements Serializable {
        private static final long serialVersionUID = 1131383135L;
        public int[] ivTypes = null;
        public int ivXPoint = 0;
        public int ivObjectType = 0;
        public int ivCageMode = -1;
        public String ivObjectHolderTicket = null;

        public AnalyzerInfo() {
        }

        public AnalyzerInfo(int[] types, int xp, int objectType, int cageMode) {
            this(types, xp, objectType, cageMode, null);
        }

        public AnalyzerInfo(int[] types, int xp, int objectType, int cageMode, String objectHolderTicket) {
            this.ivTypes = types;
            this.ivXPoint = xp;
            this.ivObjectType = objectType;
            this.ivCageMode = cageMode;
            this.ivObjectHolderTicket = objectHolderTicket;
        }
    }

    static abstract class KeyCollectAnalyzer
    extends MultiDimAnalyzer {
        KeyCollectAnalyzer() {
        }

        public void distribute(Object object) {
            IDObject ido;
            HashSet<MDKey> keys = new HashSet<MDKey>();
            if (object instanceof Mouse) {
                this.addKeys((Mouse)object, keys);
            } else if (object instanceof Cage) {
                Cage cage = (Cage)object;
                Iterator iterator = cage.getActualMice().iterator();
                while (iterator.hasNext()) {
                    this.addKeys((Mouse)iterator.next(), keys);
                }
            } else if (object instanceof DisplayTask && (ido = ((DisplayTask)object).getUnderlying()) != null && ido instanceof Mouse) {
                this.addKeys((Mouse)ido, keys);
            }
            if (keys.isEmpty()) {
                keys.add(MultiDimAnalyzer.getNixKey(this.getTyp()));
            }
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                MDKey key = (MDKey)iterator.next();
                try {
                    MultiDimAnalyzer.add(this.ivObjectsByMDKey, key, object);
                }
                catch (Exception e) {
                    Log.error("Problem using key " + key, e, this);
                }
            }
        }

        public abstract void addKeys(Mouse var1, HashSet var2);
    }

    public static class MDKey
    implements Comparable {
        public final int ivDimTyp;
        public final Object ivKey;
        public final Comparable ivCompVal;
        public final String ivRep;

        public MDKey(int dimTyp, Object key, String rep, Comparable compVal) {
            this.ivDimTyp = dimTyp;
            this.ivKey = key;
            this.ivRep = rep;
            this.ivCompVal = compVal;
        }

        public int compareTo(Object arg0) {
            if (arg0 instanceof MDKey) {
                MDKey mdk = (MDKey)arg0;
                if (mdk.ivDimTyp != this.ivDimTyp) {
                    return this.ivDimTyp < mdk.ivDimTyp ? -1 : 1;
                }
                if (this.ivKey == mdk.ivKey) {
                    return 0;
                }
                if (this.ivKey == NIX) {
                    return -1;
                }
                if (this.ivKey == ALLES) {
                    return 1;
                }
                if (mdk.ivKey == NIX) {
                    return 1;
                }
                if (mdk.ivKey == ALLES) {
                    return -1;
                }
                if (this.ivCompVal instanceof String) {
                    String ms = (String)((Object)this.ivCompVal);
                    String ts = (String)((Object)mdk.ivCompVal);
                    return ms.compareToIgnoreCase(ts);
                }
                return this.ivCompVal.compareTo(mdk.ivCompVal);
            }
            return 0;
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof MDKey) {
                MDKey mdk = (MDKey)arg0;
                return this.ivDimTyp == mdk.ivDimTyp && this.ivKey.equals(mdk.ivKey);
            }
            return super.equals(arg0);
        }

        public int hashCode() {
            return this.ivDimTyp + this.ivKey.hashCode();
        }

        public String toString() {
            return this.ivRep;
        }
    }

    static class MDSANTag
    extends MultiDimAnalyzer {
        private static final HashMap MDKEYS_BY_PKEY = new HashMap();

        MDSANTag() {
        }

        public void distribute(Object object) {
            String tag;
            MDKey key = MultiDimAnalyzer.getNixKey(this.getTyp());
            String string = tag = object instanceof Mouse ? ((Mouse)object).getString("MOS_ANTAG", null) : null;
            if (tag != null && (key = (MDKey)MDKEYS_BY_PKEY.get(tag)) == null) {
                key = new MDKey(14, tag, tag, (Comparable)((Object)tag));
                MDKEYS_BY_PKEY.put(tag, key);
            }
            MultiDimAnalyzer.add(this.ivObjectsByMDKey, key, object);
        }

        public int getTyp() {
            return 33;
        }
    }

    static class MDSAge
    extends MultiDimAnalyzer {
        public static final HashMap cvMDKeysByPKeyW = new HashMap();
        public static final HashMap cvMDKeysByPKeyM = new HashMap();
        private final int ivType;

        public MDSAge(int type) {
            this.ivType = type;
        }

        public void distribute(Object object) {
            if (object != null) {
                if (object instanceof Mouse) {
                    MultiDimAnalyzer.add(this.ivObjectsByMDKey, this.getKey((Mouse)object), object);
                } else if (object instanceof Cage) {
                    Cage cage = (Cage)object;
                    HashSet<MDKey> keys = new HashSet<MDKey>();
                    Iterator iterator = cage.getActualMice().iterator();
                    while (iterator.hasNext()) {
                        keys.add(this.getKey((Mouse)iterator.next()));
                    }
                    if (keys.isEmpty()) {
                        keys.add(MultiDimAnalyzer.getNixKey(6));
                    }
                    iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        MultiDimAnalyzer.add(this.ivObjectsByMDKey, (MDKey)iterator.next(), object);
                    }
                } else if (object instanceof DisplayTask) {
                    MDKey key = MultiDimAnalyzer.getNixKey(6);
                    DisplayTask dTask = (DisplayTask)object;
                    IDObject underlying = dTask.getUnderlying();
                    if (underlying != null && underlying instanceof Mouse) {
                        Mouse mouse = (Mouse)underlying;
                        key = this.getKey(mouse);
                    }
                    MultiDimAnalyzer.add(this.ivObjectsByMDKey, key, object);
                }
            }
        }

        public int getTyp() {
            return this.ivType;
        }

        private MDKey getKey(Mouse mouse) {
            int age = mouse.getAgeInDays(-1);
            if (age >= 0) {
                MDKey key;
                int i = age / (this.ivType == 13 ? 7 : 30);
                Integer ageI = new Integer(i);
                MDKey mDKey = key = this.ivType == 13 ? (MDKey)cvMDKeysByPKeyW.get(ageI) : (MDKey)cvMDKeysByPKeyM.get(ageI);
                if (key == null) {
                    String val = null;
                    if (this.ivType == 13) {
                        val = i == 1 ? String.valueOf(i) + " " + Babel.get("WEEK") : String.valueOf(i) + " " + Babel.get("WEEKS");
                        key = new MDKey(this.ivType, ageI, val, new Integer(i));
                        cvMDKeysByPKeyW.put(ageI, key);
                    } else {
                        val = i == 1 ? String.valueOf(i) + " " + Babel.get("MONTH") : String.valueOf(i) + " " + Babel.get("MONTHS");
                        key = new MDKey(this.ivType, ageI, val, new Integer(i));
                        cvMDKeysByPKeyM.put(ageI, key);
                    }
                }
                return key;
            }
            return MultiDimAnalyzer.getNixKey(this.ivType);
        }
    }

    static class MDSClinicalSymptoms
    extends MultiDimAnalyzer {
        private static final MDKey YES_KEY = new MDKey(32, new Integer(1), Babel.get("TT_CC_SYMPTOM"), (Comparable)((Object)"Y"));

        MDSClinicalSymptoms() {
        }

        public void distribute(Object object) {
            Cage cage;
            Vector v;
            boolean hat = false;
            if (object instanceof Mouse) {
                hat = MDSClinicalSymptoms.hatMaus((Mouse)object);
            } else if (object instanceof Cage && (v = (cage = (Cage)object).getActualMice()) != null) {
                Iterator iterator = v.iterator();
                while (iterator.hasNext() && !hat) {
                    if (!MDSClinicalSymptoms.hatMaus((Mouse)iterator.next())) continue;
                    hat = true;
                }
            }
            MultiDimAnalyzer.add(this.ivObjectsByMDKey, hat ? MDSClinicalSymptoms.YES_KEY : MultiDimAnalyzer.getNixKey(this.getTyp()), object);
        }

        public int getTyp() {
            return 32;
        }

        private static boolean hatMaus(Mouse mouse) {
            Vector v = (Vector)mouse.get("MOS_MRESULTS");
            if (v != null) {
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    MResult mresult = (MResult)iter.next();
                    if (-42L != mresult.getExperimentID()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    static class MDSCoatColor
    extends MultiDimAnalyzer {
        public static final HashMap cvMDKeysByFKey = new HashMap();

        MDSCoatColor() {
        }

        public void distribute(Object object) {
            DisplayTask dTask;
            IDObject underlying;
            MDKey key = MultiDimAnalyzer.getNixKey(16);
            if (object instanceof Mouse) {
                Mouse mouse = (Mouse)object;
                key = this.getKey(mouse, key);
            } else if (object instanceof DisplayTask && (underlying = (dTask = (DisplayTask)object).getUnderlying()) != null && underlying instanceof Mouse) {
                Mouse mouse = (Mouse)underlying;
                key = this.getKey(mouse, key);
            }
            MultiDimAnalyzer.add(this.ivObjectsByMDKey, key, object);
        }

        public int getTyp() {
            return 16;
        }

        private MDKey getKey(Mouse mouse, MDKey defVal) {
            Integer ccI;
            MDKey key = defVal;
            int cc = mouse.getCoatColor();
            if (cc != Integer.MIN_VALUE && (key = (MDKey)cvMDKeysByFKey.get(ccI = new Integer(cc))) == null) {
                String s = CoatColor.getDescr(cc, true, "");
                key = new MDKey(16, ccI, s, (Comparable)((Object)s));
                cvMDKeysByFKey.put(ccI, key);
            }
            return key;
        }
    }

    static class MDSDestination
    extends MultiDimAnalyzer {
        public static final HashMap cvMDKeysByPKey = new HashMap();

        MDSDestination() {
        }

        public void distribute(Object object) {
            MDKey key = MultiDimAnalyzer.getNixKey(26);
            String value = null;
            if (object instanceof Mouse) {
                Mouse ido = (Mouse)object;
                value = ido.getHerkunftOderZiel(false, false);
            }
            if (value != null && (key = (MDKey)cvMDKeysByPKey.get(value)) == null) {
                key = new MDKey(26, value, value, (Comparable)((Object)value));
                cvMDKeysByPKey.put(value, key);
            }
            MultiDimAnalyzer.add(this.ivObjectsByMDKey, key, object);
        }

        public int getTyp() {
            return 26;
        }
    }

    static class MDSFillStatusByCage
    extends MultiDimAnalyzer {
        public static final HashMap cvMDKeysByPKey = new HashMap();
        private static final MDKey FILLED_KEY = new MDKey(24, new Integer(0), Babel.get("MDF_FILLED"), new Integer(0));
        private static final MDKey EMPTY_KEY = new MDKey(24, new Integer(1), Babel.get("MDF_EMPTY"), new Integer(1));

        public void distribute(Object object) {
            MDKey mdkey = EMPTY_KEY;
            if (object instanceof Cage) {
                Cage cage = (Cage)object;
                Vector v = cage.getActualMice();
                mdkey = v == null || v.isEmpty() ? EMPTY_KEY : FILLED_KEY;
                MultiDimAnalyzer.add(this.ivObjectsByMDKey, mdkey, object);
            }
        }

        public int getTyp() {
            return 24;
        }
    }

    static class MDSGenotype
    extends KeyCollectAnalyzer {
        private static final MDKey GT_SET_KEY = new MDKey(18, new Integer(1), Babel.get("MD_GT_SET"), (Comparable)((Object)"A"));
        private static final MDKey GT_NOT_SET_KEY = new MDKey(18, new Integer(2), Babel.get("MD_GT_NOT_SET"), (Comparable)((Object)"B"));
        private static final MDKey GT_PARTIALLY_SET_KEY = new MDKey(18, new Integer(16), Babel.get("MD_GT_PARTIALLY_SET"), (Comparable)((Object)"C"));
        private static final MDKey GT_FULLY_SET_KEY = new MDKey(18, new Integer(17), Babel.get("MD_GT_FULLY_SET"), (Comparable)((Object)"D"));
        private static final MDKey GT_PURE_WT_KEY = new MDKey(18, new Integer(18), Babel.get("MD_GT_PURE_WT"), (Comparable)((Object)"E"));
        private static final MDKey GT_PURE_NON_WT_KEY = new MDKey(18, new Integer(19), Babel.get("MD_GT_PURE_NON_WT"), (Comparable)((Object)"F"));
        private static final MDKey GT_MIXED_KEY = new MDKey(18, new Integer(20), Babel.get("MD_GT_MIXED_WT"), (Comparable)((Object)"G"));

        MDSGenotype() {
        }

        public void addKeys(Mouse mouse, HashSet target) {
            LocusAndAlleles[] lv;
            LocusAndAlleles[] mv = (LocusAndAlleles[])mouse.get("MOS_LOCUSGENOTYPES");
            Line line = mouse.getLine();
            LocusAndAlleles[] locusAndAllelesArray = lv = line == null ? null : (LocusAndAlleles[])line.get("LIN_LOCIALLELES");
            if (mv == null) {
                target.add(GT_NOT_SET_KEY);
            } else {
                target.add(GT_SET_KEY);
                if (MausoSearcherObject.SearcherGenotype.isGenotypeFullySet(mouse, mv, line, lv)) {
                    target.add(GT_FULLY_SET_KEY);
                    if (MausoSearcherObject.SearcherGenotype.isPureWildType(mouse, mv, line, lv)) {
                        target.add(GT_PURE_WT_KEY);
                    } else if (MausoSearcherObject.SearcherGenotype.isPureNonWildType(mouse, mv, line, lv)) {
                        target.add(GT_PURE_NON_WT_KEY);
                    } else {
                        target.add(GT_MIXED_KEY);
                    }
                } else {
                    target.add(GT_PARTIALLY_SET_KEY);
                }
            }
        }

        public int getTyp() {
            return 18;
        }
    }

    static class MDSGenotypeFULL
    extends KeyCollectAnalyzer {
        public static final HashMap cvMDKeysByPKey = new HashMap();

        MDSGenotypeFULL() {
        }

        public void addKeys(Mouse mouse, HashSet target) {
            String gt = mouse.getGenotype("?");
            MDKey key = (MDKey)cvMDKeysByPKey.get(gt);
            if (key == null) {
                key = new MDKey(23, gt, gt, (Comparable)((Object)gt));
                cvMDKeysByPKey.put(gt, key);
            }
            target.add(key);
        }

        public int getTyp() {
            return 22;
        }
    }

    static class MDSGenotypePerLocus
    extends KeyCollectAnalyzer {
        public static final HashMap cvMDKeysByPKey = new HashMap();

        MDSGenotypePerLocus() {
        }

        public void addKeys(Mouse mouse, HashSet target) {
            String fgt = mouse.getGenotype("?");
            Zeile z = new Zeile(fgt, ';');
            int i = 0;
            while (i < z.size()) {
                String gt = z.getStringNONEmpty(i, null);
                if (gt != null) {
                    MDKey key = (MDKey)cvMDKeysByPKey.get(gt = gt.trim());
                    if (key == null) {
                        key = new MDKey(23, gt, gt, (Comparable)((Object)gt));
                        cvMDKeysByPKey.put(gt, key);
                    }
                    target.add(key);
                }
                ++i;
            }
        }

        public int getTyp() {
            return 23;
        }
    }

    static class MDSGroup
    extends MultiDimAnalyzer {
        public static final HashMap cvMDKeysByPKey = new HashMap();

        MDSGroup() {
        }

        public void distribute(Object object) {
            MDKey key = MultiDimAnalyzer.getNixKey(14);
            String group = null;
            if (object instanceof IDObject) {
                IDObject ido = (IDObject)object;
                group = ido.getGroup();
            }
            if (group != null && (key = (MDKey)cvMDKeysByPKey.get(group)) == null) {
                key = new MDKey(14, group, group, (Comparable)((Object)group));
                cvMDKeysByPKey.put(group, key);
            }
            MultiDimAnalyzer.add(this.ivObjectsByMDKey, key, object);
        }

        public int getTyp() {
            return 14;
        }
    }

    static class MDSLicense
    extends KeyCollectAnalyzer {
        public static final HashMap cvMDKeysByPKey = new HashMap();

        MDSLicense() {
        }

        public void addKeys(Mouse mouse, HashSet target) {
            String group = mouse.getGroup();
            this.handleLicID((Long)mouse.get(Mouse.getLicenseTag(1)), group, target);
            this.handleLicID((Long)mouse.get(Mouse.getLicenseTag(2)), group, target);
        }

        public int getTyp() {
            return 8;
        }

        private void handleLicID(Long licenseID, String group, HashSet target) {
            if (licenseID != null) {
                String k = String.valueOf(group) + "|" + licenseID;
                MDKey key = (MDKey)cvMDKeysByPKey.get(k);
                if (key == null) {
                    License license = (License)ObjectStore.getObjectDeadOrAlive(16, licenseID, group, null, false);
                    String licenseName = license == null ? Babel.get("UNKNOWN") : license.getNonNullName();
                    key = new MDKey(8, k, licenseName, (Comparable)((Object)licenseName));
                    cvMDKeysByPKey.put(k, key);
                }
                target.add(key);
            }
        }
    }

    static class MDSLine
    extends KeyCollectAnalyzer {
        public static final HashMap cvMDKeysByPKey = new HashMap();

        MDSLine() {
        }

        public void addKeys(Mouse mouse, HashSet target) {
            Long lineID = (Long)mouse.get("MOS_LINEID");
            if (lineID != null) {
                String group = mouse.getGroup();
                String k = String.valueOf(group) + "|" + lineID;
                MDKey key = (MDKey)cvMDKeysByPKey.get(k);
                if (key == null) {
                    Line line = (Line)ObjectStore.getObjectDeadOrAlive(7, lineID, group, null, false);
                    String lineName = line == null ? Babel.get("UNKNOWN") : line.getNonNullName();
                    key = new MDKey(2, k, lineName, (Comparable)((Object)lineName));
                    cvMDKeysByPKey.put(k, key);
                }
                target.add(key);
            }
        }

        public int getTyp() {
            return 2;
        }
    }

    static class MDSMark
    extends MultiDimAnalyzer {
        public static final HashMap cvMDKeysByFKey = new HashMap();

        MDSMark() {
        }

        public void distribute(Object object) {
            DisplayTask dTask;
            IDObject underlying;
            MDKey key = MultiDimAnalyzer.getNixKey(9);
            Character c = null;
            if (object instanceof Mouse) {
                Mouse mouse = (Mouse)object;
                c = (Character)mouse.get("MOS_FLAG");
            } else if (object instanceof Cage) {
                Cage cage = (Cage)object;
                c = (Character)cage.get("CAG_FLAG");
            } else if (object instanceof DisplayTask && (underlying = (dTask = (DisplayTask)object).getUnderlying()) != null && underlying instanceof Mouse) {
                Mouse mouse = (Mouse)underlying;
                c = (Character)mouse.get("MOS_FLAG");
            }
            if (c != null && c.charValue() != '\u0000' && (key = (MDKey)cvMDKeysByFKey.get(c)) == null) {
                key = c.charValue() == '\u0001' ? new MDKey(9, c, "\u261e", new Integer(c.charValue())) : new MDKey(9, c, new String(new char[]{c.charValue()}), new Integer(c.charValue()));
                cvMDKeysByFKey.put(c, key);
            }
            MultiDimAnalyzer.add(this.ivObjectsByMDKey, key, object);
        }

        public int getTyp() {
            return 9;
        }
    }

    static class MDSMating
    extends MultiDimAnalyzer {
        private static final MDKey MATING_KEY = new MDKey(10, new Integer(1), Babel.get("WEDDING"), (Comparable)((Object)"M"));

        MDSMating() {
        }

        public void distribute(Object object) {
            DisplayTask dTask;
            IDObject underlying;
            MDKey key = null;
            if (object instanceof Mouse) {
                key = ((Mouse)object).isActiveInMating() ? MATING_KEY : null;
            } else if (object instanceof Cage) {
                key = ((Cage)object).isMatingCage() ? MATING_KEY : null;
            } else if (object instanceof DisplayTask && (underlying = (dTask = (DisplayTask)object).getUnderlying()) != null && underlying instanceof Mouse) {
                key = ((Mouse)underlying).isActiveInMating() ? MATING_KEY : null;
            }
            MultiDimAnalyzer.add(this.ivObjectsByMDKey, key != null ? key : MultiDimAnalyzer.getNixKey(10), object);
        }

        public int getTyp() {
            return 10;
        }
    }

    static class MDSMouseCount
    extends MultiDimAnalyzer {
        public static final HashMap cvMDKeysByPKey = new HashMap();
        private static final MDKey TASK_KEY = new MDKey(17, new Integer(0), Babel.get("MD_MC_EMPTY"), new Integer(0));

        public void distribute(Object object) {
            MDKey mdkey = MultiDimAnalyzer.getNixKey(17);
            if (object instanceof Cage) {
                Cage cage = (Cage)object;
                Vector v = cage.getActualMice();
                if (v == null || v.isEmpty()) {
                    mdkey = TASK_KEY;
                } else {
                    Integer ko = new Integer(v.size());
                    mdkey = (MDKey)cvMDKeysByPKey.get(ko);
                    if (mdkey == null) {
                        mdkey = v.size() == 1 ? new MDKey(17, ko, "1 " + Babel.get("MOUSE"), ko) : new MDKey(17, ko, String.valueOf(v.size()) + " " + Babel.get("MICE"), ko);
                        cvMDKeysByPKey.put(ko, mdkey);
                    }
                }
                MultiDimAnalyzer.add(this.ivObjectsByMDKey, mdkey, object);
            }
        }

        public int getTyp() {
            return 17;
        }
    }

    static class MDSNIX
    extends MultiDimAnalyzer {
        private static final MDKey NIX_KEY = new MDKey(123456, "0", "NIX", (Comparable)((Object)"0"));

        MDSNIX() {
        }

        public void distribute(Object object) {
            MultiDimAnalyzer.add(this.ivObjectsByMDKey, MDSNIX.NIX_KEY, object);
        }

        public int getTyp() {
            return 123456;
        }
    }

    static class MDSOrigin
    extends MultiDimAnalyzer {
        public static final HashMap cvMDKeysByPKey = new HashMap();

        MDSOrigin() {
        }

        public void distribute(Object object) {
            MDKey key = MultiDimAnalyzer.getNixKey(25);
            String value = null;
            if (object instanceof Mouse) {
                Mouse ido = (Mouse)object;
                value = ido.getHerkunftOderZiel(true, false);
            }
            if (value != null && (key = (MDKey)cvMDKeysByPKey.get(value)) == null) {
                key = new MDKey(14, value, value, (Comparable)((Object)value));
                cvMDKeysByPKey.put(value, key);
            }
            MultiDimAnalyzer.add(this.ivObjectsByMDKey, key, object);
        }

        public int getTyp() {
            return 25;
        }
    }

    static class MDSOwner
    extends KeyCollectAnalyzer {
        public static final HashMap cvMDKeysByPKey = new HashMap();
        private final boolean ivOnlyPrimary;

        public MDSOwner(boolean onlyPrimary) {
            this.ivOnlyPrimary = onlyPrimary;
        }

        public void addKeys(Mouse mouse, HashSet target) {
            long[] owners = (long[])mouse.get("MOS_OWNER");
            if (owners == null || owners.length == 0) {
                target.add(MultiDimAnalyzer.getNixKey(this.getTyp()));
            } else {
                String group = mouse.getGroup();
                if (this.ivOnlyPrimary) {
                    this.distribute(this.getTyp(), owners[0], group, target);
                } else {
                    int i = 0;
                    while (i < owners.length) {
                        this.distribute(this.getTyp(), owners[i], group, target);
                        ++i;
                    }
                }
            }
        }

        public int getTyp() {
            return this.ivOnlyPrimary ? 11 : 7;
        }

        private void distribute(int typ, long userID, String group, HashSet target) {
            String k = String.valueOf(this.getTyp()) + "|" + group + "|" + userID;
            MDKey key = (MDKey)cvMDKeysByPKey.get(k);
            if (key == null) {
                User user = (User)ObjectStore.getObjectDeadOrAlive(6, userID, group, null, false);
                String username = user == null ? Babel.get("UNKNOWN") : user.getNonNullName();
                key = new MDKey(this.getTyp(), k, username, (Comparable)((Object)username));
                cvMDKeysByPKey.put(k, key);
            }
            target.add(key);
        }
    }

    static class MDSProcType
    extends MultiDimAnalyzer {
        public static final HashMap cvMDKeysByFKey = new HashMap();

        MDSProcType() {
        }

        public void distribute(Object object) {
            MDKey key = MultiDimAnalyzer.getNixKey(31);
            if (object instanceof DisplayTask) {
                String s;
                DisplayTask dTask = (DisplayTask)object;
                TaskExtended te = dTask.ivTask;
                if (te.ivProcType != 0 && (s = te.getDescriptionFuerMultiDim(dTask.getGroup())) != null && (key = (MDKey)cvMDKeysByFKey.get(s)) == null) {
                    key = new MDKey(31, s, s, (Comparable)((Object)s));
                    cvMDKeysByFKey.put(s, key);
                }
            }
            MultiDimAnalyzer.add(this.ivObjectsByMDKey, key, object);
        }

        public int getTyp() {
            return 31;
        }
    }

    static class MDSRack
    extends MultiDimAnalyzer {
        public static final HashMap cvMDKeysByPKey = new HashMap();

        MDSRack() {
        }

        public void distribute(Object object) {
            if (object != null) {
                DisplayTask dTask;
                IDObject underlying;
                Rack rack = null;
                if (object instanceof Mouse) {
                    Mouse mouse = (Mouse)object;
                    rack = mouse.getRack();
                } else if (object instanceof Cage) {
                    Cage cage = (Cage)object;
                    rack = cage.getRack();
                } else if (object instanceof DisplayTask && (underlying = (dTask = (DisplayTask)object).getUnderlying()) != null && underlying instanceof Mouse) {
                    rack = ((Mouse)underlying).getRack();
                }
                this.addWithKeyForIDObject(rack, 5, object, cvMDKeysByPKey);
            }
        }

        public int getTyp() {
            return 5;
        }
    }

    static class MDSResult
    extends KeyCollectAnalyzer {
        public static final HashMap cvMDKeysByFKey = new HashMap();

        MDSResult() {
        }

        public void addKeys(Mouse mouse, HashSet target) {
            HashSet<String> dones = new HashSet<String>();
            Vector ores = (Vector)mouse.get("MOS_MRESULTS");
            if (ores != null) {
                Iterator iterator = ores.iterator();
                while (iterator.hasNext()) {
                    String ekey;
                    MResult mres = (MResult)iterator.next();
                    Experiment exp = mres.getExperiment(mouse.getGroup());
                    if (exp == null || dones.contains(ekey = exp.getIdentifierString())) continue;
                    dones.add(ekey);
                    MDKey mdkey = (MDKey)cvMDKeysByFKey.get(ekey);
                    if (mdkey == null) {
                        mdkey = new MDKey(21, ekey, exp.getNonNullName(), (Comparable)((Object)exp.getNonNullName()));
                        cvMDKeysByFKey.put(ekey, mdkey);
                    }
                    target.add(mdkey);
                }
            }
        }

        public int getTyp() {
            return 21;
        }
    }

    static class MDSRoom
    extends MultiDimAnalyzer {
        public static final HashMap cvMDKeysByPKey = new HashMap();

        MDSRoom() {
        }

        public void distribute(Object object) {
            if (object != null) {
                DisplayTask dTask;
                IDObject underlying;
                Room room = null;
                if (object instanceof Mouse) {
                    Mouse mouse = (Mouse)object;
                    room = mouse.getRoom();
                } else if (object instanceof Cage) {
                    Cage cage = (Cage)object;
                    room = cage.getRoom();
                } else if (object instanceof DisplayTask && (underlying = (dTask = (DisplayTask)object).getUnderlying()) != null && underlying instanceof Mouse) {
                    room = ((Mouse)underlying).getRoom();
                }
                this.addWithKeyForIDObject(room, 4, object, cvMDKeysByPKey);
            }
        }

        public int getTyp() {
            return 4;
        }
    }

    static class MDSSex
    extends KeyCollectAnalyzer {
        private static final MDKey MALE_KEY = new MDKey(1, new Integer(1), DefaultManager.getSexString(1, 0, false), (Comparable)((Object)"A"));
        private static final MDKey FEMALE_KEY = new MDKey(1, new Integer(2), DefaultManager.getSexString(2, 0, false), (Comparable)((Object)"B"));

        MDSSex() {
        }

        public void addKeys(Mouse mouse, HashSet target) {
            int sex = mouse.getSex();
            if (sex != 0) {
                target.add(sex == 1 ? MALE_KEY : FEMALE_KEY);
            }
        }

        public int getTyp() {
            return 1;
        }
    }

    static class MDSStrain
    extends KeyCollectAnalyzer {
        public static final HashMap cvMDKeysByPKey = new HashMap();

        MDSStrain() {
        }

        public void addKeys(Mouse mouse, HashSet target) {
            IndexObject[] strid = (IndexObject[])mouse.get("MOS_STRAIN");
            if (strid == null || strid.length == 0) {
                target.add(MultiDimAnalyzer.getNixKey(3));
            } else {
                String group = mouse.getGroup();
                int i = 0;
                while (i < strid.length) {
                    String k = String.valueOf(group) + "|" + strid[i].ivObjectID;
                    MDKey key = (MDKey)cvMDKeysByPKey.get(k);
                    if (key == null) {
                        Strain strain = (Strain)ObjectStore.getObjectDeadOrAlive(8, strid[i].ivObjectID, group, null, false);
                        String strainname = strain == null ? Babel.get("UNKNOWN") : strain.getNonNullName();
                        key = new MDKey(3, k, strainname, (Comparable)((Object)strainname));
                        cvMDKeysByPKey.put(k, key);
                    }
                    target.add(key);
                    ++i;
                }
            }
        }

        public int getTyp() {
            return 3;
        }
    }

    static class MDSTask
    extends MultiDimAnalyzer {
        private static final MDKey TASK_KEY = new MDKey(12, new Integer(1), Babel.get("TASK"), (Comparable)((Object)"1"));

        MDSTask() {
        }

        public void distribute(Object object) {
            boolean has = false;
            if (object instanceof Mouse) {
                has = this.hasTask((Mouse)object);
            } else if (object instanceof Cage) {
                Cage cage = (Cage)object;
                Iterator iterator = cage.getActualMice().iterator();
                while (iterator.hasNext() && !has) {
                    has = this.hasTask((Mouse)iterator.next());
                }
            } else if (object instanceof DisplayTask) {
                has = false;
            }
            MultiDimAnalyzer.add(this.ivObjectsByMDKey, has ? MDSTask.TASK_KEY : MultiDimAnalyzer.getNixKey(12), object);
        }

        public int getTyp() {
            return 12;
        }

        private boolean hasTask(Mouse mouse) {
            TaskExtended[] te;
            boolean allowed;
            boolean bl = allowed = ProcessDefinition.isClient() ? mouse.isTouchable() : true;
            if (allowed && (te = (TaskExtended[])mouse.get("MOS_TASKSEXT")) != null && te.length != 0) {
                int i = 0;
                while (i < te.length) {
                    if (!te[i].isFinished()) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }

    static class MDSTaskDetail
    extends KeyCollectAnalyzer {
        public static final HashMap cvMDKeysByFKey = new HashMap();

        MDSTaskDetail() {
        }

        public void addKeys(Mouse mouse, HashSet target) {
            TaskExtended[] te;
            boolean allowed;
            String group = mouse.getGroup();
            boolean bl = allowed = ProcessDefinition.isClient() ? mouse.isTouchable() : true;
            if (group != null && allowed && (te = (TaskExtended[])mouse.get("MOS_TASKSEXT")) != null && te.length != 0) {
                int i = 0;
                while (i < te.length) {
                    String s;
                    if (!te[i].isFinished() && (s = te[i].getDescriptionFuerMultiDim(group)) != null) {
                        MDKey key = (MDKey)cvMDKeysByFKey.get(s);
                        if (key == null) {
                            key = new MDKey(15, s, s, (Comparable)((Object)s));
                            cvMDKeysByFKey.put(s, key);
                        }
                        target.add(key);
                    }
                    ++i;
                }
            }
        }

        public int getTyp() {
            return 15;
        }
    }

    static class MDSTaskStatus
    extends MultiDimAnalyzer {
        public static final HashMap cvMDKeysByFKey = new HashMap();

        MDSTaskStatus() {
        }

        public void distribute(Object object) {
            MDKey key = MultiDimAnalyzer.getNixKey(30);
            if (object instanceof DisplayTask) {
                DisplayTask dTask = (DisplayTask)object;
                TaskExtended te = dTask.ivTask;
                String s = te.getStatusString();
                if (s != null && (key = (MDKey)cvMDKeysByFKey.get(s)) == null) {
                    key = new MDKey(30, s, s, (Comparable)((Object)s));
                    cvMDKeysByFKey.put(s, key);
                }
            }
            MultiDimAnalyzer.add(this.ivObjectsByMDKey, key, object);
        }

        public int getTyp() {
            return 30;
        }
    }

    static class MDSTaskUser
    extends MultiDimAnalyzer {
        public static final HashMap cvMDKeysByPKey = new HashMap();
        private final boolean ivIssuer;

        public MDSTaskUser(boolean issuer) {
            this.ivIssuer = issuer;
        }

        public void distribute(Object object) {
            MDKey key = MultiDimAnalyzer.getNixKey(31);
            if (object instanceof DisplayTask) {
                DisplayTask dTask = (DisplayTask)object;
                TaskExtended te = dTask.ivTask;
                long userID = this.ivIssuer ? te.ivIssuerID : te.ivFavoritID;
                String group = this.ivIssuer ? te.ivIssuerGroup : te.ivFavoritGroup;
                String k = String.valueOf(this.getTyp()) + "|" + group + "|" + userID;
                key = (MDKey)cvMDKeysByPKey.get(k);
                if (key == null) {
                    User user = (User)ObjectStore.getObjectDeadOrAlive(6, userID, group, null, false);
                    String username = user == null ? Babel.get("UNKNOWN") : user.getNonNullName();
                    key = new MDKey(this.getTyp(), k, username, (Comparable)((Object)username));
                    cvMDKeysByPKey.put(k, key);
                }
            }
            MultiDimAnalyzer.add(this.ivObjectsByMDKey, key, object);
        }

        public int getTyp() {
            return this.ivIssuer ? 28 : 29;
        }
    }

    static class MDSVisitMode
    extends KeyCollectAnalyzer {
        public static final HashMap cvMDKeysByPKey = new HashMap();
        private final boolean ivStart;
        private final int ivType;

        public MDSVisitMode(boolean start) {
            this.ivStart = start;
            this.ivType = start ? 19 : 20;
            int i = 0;
            while (i < Visit.MODI.length) {
                Integer key = new Integer(Visit.MODI[i]);
                cvMDKeysByPKey.put(key, new MDKey(this.ivType, key, Babel.get(Visit.MODI_BABELS[i]), key));
                ++i;
            }
        }

        public void addKeys(Mouse mouse, HashSet target) {
            MDKey fkey;
            Integer skey = (Integer)mouse.get(this.ivStart ? "MOS_STARTMODE" : "MOS_ENDMODE");
            if (skey != null && (fkey = (MDKey)cvMDKeysByPKey.get(skey)) != null) {
                target.add(fkey);
            }
        }

        public int getTyp() {
            return this.ivType;
        }
    }

    static class MDSWeaning
    extends MultiDimAnalyzer {
        public static final HashMap cvMDKeysByPKeyW = new HashMap();
        private static final int[] DAYS;
        private static final String[] BABELS;
        private static final String NO_WEANING_BABEL = "TT_CC_NO_WEANING";

        static {
            int[] nArray = new int[6];
            nArray[1] = 1;
            nArray[2] = 3;
            nArray[3] = 5;
            nArray[4] = 7;
            nArray[5] = 0x7FFFFFFE;
            DAYS = nArray;
            BABELS = new String[]{"TT_CC_WEANING_0_DAYS", "TT_CC_WEANING_1_DAYS", "TT_CC_WEANING_3_DAYS", "TT_CC_WEANING_5_DAYS", "TT_CC_WEANING_7_DAYS", "TT_CC_WEANING_LATER"};
        }

        public void distribute(Object object) {
            int days = Integer.MAX_VALUE;
            if (object instanceof Mouse) {
                Mouse mouse = (Mouse)object;
                days = this.getWeaningDays(mouse, mouse.getActCage());
            } else if (object instanceof Cage) {
                days = Integer.MAX_VALUE;
                Cage cage = (Cage)object;
                Iterator iterator = cage.getActualMice().iterator();
                while (iterator.hasNext()) {
                    Mouse mouse = (Mouse)iterator.next();
                    int td = this.getWeaningDays(mouse, cage);
                    if (td == Integer.MAX_VALUE) continue;
                    if (td < 0) {
                        td = 0;
                    }
                    if (days == Integer.MAX_VALUE) {
                        days = td;
                        continue;
                    }
                    if (td >= days) continue;
                    days = td;
                }
            }
            MultiDimAnalyzer.add(this.ivObjectsByMDKey, this.getKey(days), object);
        }

        private int getWeaningDays(Mouse mouse, Cage cage) {
            if (mouse != null && cage != null) {
                return WeaningControl.getTimeUntilWeanAlert(mouse, cage, System.currentTimeMillis(), true);
            }
            return Integer.MAX_VALUE;
        }

        private MDKey getKey(int days) {
            String tbabel = "";
            int tdays = DAYS[DAYS.length - 1];
            if (days == Integer.MAX_VALUE) {
                tdays = days;
                tbabel = NO_WEANING_BABEL;
            } else {
                int i = 0;
                while (i < DAYS.length) {
                    if (days <= DAYS[i]) {
                        tdays = DAYS[i];
                        tbabel = BABELS[i];
                        break;
                    }
                    ++i;
                }
            }
            Integer weanI = new Integer(tdays);
            MDKey key = (MDKey)cvMDKeysByPKeyW.get(weanI);
            if (key == null) {
                key = new MDKey(this.getTyp(), weanI, Babel.get(tbabel), weanI);
                cvMDKeysByPKeyW.put(weanI, key);
            }
            return key;
        }

        public int getTyp() {
            return 27;
        }
    }

    public static class MDTypeObject
    implements Comparable {
        public final int ivType;
        public final String ivFullName;
        public boolean ivWithTotal = false;

        public MDTypeObject(int type, String babel) {
            this.ivType = type;
            this.ivFullName = Babel.get(babel);
        }

        public int compareTo(Object arg0) {
            if (arg0 instanceof MDTypeObject) {
                MDTypeObject mdto = (MDTypeObject)arg0;
                return this.ivFullName.compareToIgnoreCase(mdto.ivFullName);
            }
            return 0;
        }

        public String toString() {
            return this.ivFullName;
        }
    }
}

