/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets.service;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.StringHelper;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import mausoleum.cage.colors.GroupColorManager;
import mausoleum.inspector.actions.usergroup.RackMerker;
import mausoleum.inspector.actions.usergroup.UsergroupAction;
import mausoleum.objectstore.QuotableIDObject;
import mausoleum.rack.Rack;
import mausoleum.usergroup.UserGroup;
import mausoleum.usergroup.UsergroupManager;
import mausoleum.util.Constants;

public class ServiceInfoCollector {
    public static final String PSEUDO_START = "#*#*";
    public static final String PSEUDO_GROUP_LEERER_PLATZ = "#*#*EMPTY";
    public static final String PSEUDO_GROUP_BENUTZTER_PLATZ = "#*#*USED";
    public static final String PSEUDO_GROUP_OHNE_RAUM = "#*#*ROOMLESS";
    public static final String PSEUDO_GROUP_OHNE_GEBAEUDE = "#*#*BUILDINGLESS";
    public final Vector ivGroupNames = new Vector();
    private final TreeMap ivRoomIDsByName = new TreeMap();
    private final TreeMap ivBuildingIDsByName = new TreeMap();
    private int ivTotalCagesBelegt = 0;
    private int ivTotalMatings = 0;
    private int ivTotalNonEmptyCages = 0;
    private int ivTotalMice = 0;
    private int ivTotalCageKapazitaet = 0;
    private final int[] ivTotalCagesByGroup;
    private final int[] ivTotalMatingsByGroup;
    private final int[] ivTotalNonEmptyCagesByGroup;
    private final int[] ivTotalMiceByGroup;
    private final HashMap ivCagesByRackIDAndGroup = new HashMap();
    private final HashMap ivMatingsByRackIDAndGroup = new HashMap();
    private final HashMap ivNonEmptyCagesByRackIDAndGroup = new HashMap();
    private final HashMap ivMiceByRackIDAndGroup = new HashMap();
    private final HashMap ivRackIDsByRoomID = new HashMap();
    private final HashMap ivRackIDsByBuildingID = new HashMap();
    public final SIBlock ivSIBlock;

    private static Vector getNames(TreeMap source, String last) {
        Vector<Object> res = new Vector<Object>();
        res.addAll(source.keySet());
        if (last != null) {
            res.remove(last);
            res.add(last);
        }
        return res;
    }

    private static RackMerker getMerker(long serviceID, String group) {
        Vector v;
        if (serviceID > 0L && (v = UsergroupAction.getRackMerkers(group, true)) != null) {
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                RackMerker rm = (RackMerker)iter.next();
                if (rm.ivServiceID != serviceID) continue;
                return rm;
            }
        }
        return null;
    }

    private static void storeWrapperInfo(int type, TreeMap idByNameSammler, String pseudoName) {
        Vector aktWrappers = ObjectStore.getActualObjects(type, "service");
        Iterator iterator = aktWrappers.iterator();
        while (iterator.hasNext()) {
            IDObject ug = (IDObject)iterator.next();
            idByNameSammler.put(ug.getBrowseName(), ug.get("IDO_ID"));
        }
        idByNameSammler.put(pseudoName, Constants.NULL_L);
    }

    private static void storeInWrapperInfo(Long wrapperKey, HashMap target, Long rackIDKey) {
        Vector<Long> racksInWrapper = (Vector<Long>)target.get(wrapperKey);
        if (racksInWrapper == null) {
            racksInWrapper = new Vector<Long>();
            target.put(wrapperKey, racksInWrapper);
        }
        racksInWrapper.add(rackIDKey);
    }

    public ServiceInfoCollector() {
        Vector aktGroups = UsergroupManager.cvInstance.getActualObjectVectorAllGroups();
        Iterator iterator = aktGroups.iterator();
        while (iterator.hasNext()) {
            UserGroup ug = (UserGroup)iterator.next();
            if (ug.ivName == null || ug.ivName.equals("null")) continue;
            this.ivGroupNames.add(ug.ivName);
        }
        Collections.sort(this.ivGroupNames, StringHelper.CASE_INSENSITIVE_COMPARER);
        this.ivGroupNames.add(PSEUDO_GROUP_LEERER_PLATZ);
        this.ivSIBlock = new SIBlock(this.ivGroupNames);
        ServiceInfoCollector.storeWrapperInfo(10, this.ivRoomIDsByName, PSEUDO_GROUP_OHNE_RAUM);
        ServiceInfoCollector.storeWrapperInfo(22, this.ivBuildingIDsByName, PSEUDO_GROUP_OHNE_GEBAEUDE);
        this.ivTotalCagesByGroup = new int[this.ivGroupNames.size()];
        this.ivTotalMiceByGroup = new int[this.ivGroupNames.size()];
        this.ivTotalMatingsByGroup = new int[this.ivGroupNames.size()];
        this.ivTotalNonEmptyCagesByGroup = new int[this.ivGroupNames.size()];
        Vector aktRacks = ObjectStore.getActualObjects(3, "service");
        Iterator iterator2 = aktRacks.iterator();
        while (iterator2.hasNext()) {
            int unbelegtInRack;
            Rack serviceRack = (Rack)iterator2.next();
            Long rackIDKey = (Long)serviceRack.get("IDO_ID");
            long serviceID = rackIDKey;
            int[] rackCageSammler = new int[this.ivGroupNames.size()];
            this.ivCagesByRackIDAndGroup.put(rackIDKey, rackCageSammler);
            int[] rackMiceSammler = new int[this.ivGroupNames.size()];
            this.ivMiceByRackIDAndGroup.put(rackIDKey, rackMiceSammler);
            int[] rackMatingsSammler = new int[this.ivGroupNames.size()];
            this.ivMatingsByRackIDAndGroup.put(rackIDKey, rackMatingsSammler);
            int[] rackNonEmptyCagesSammler = new int[this.ivGroupNames.size()];
            this.ivNonEmptyCagesByRackIDAndGroup.put(rackIDKey, rackNonEmptyCagesSammler);
            ServiceInfoCollector.storeInWrapperInfo(new Long(serviceRack.getRoomID(0L)), this.ivRackIDsByRoomID, rackIDKey);
            ServiceInfoCollector.storeInWrapperInfo(new Long(serviceRack.getBuildingID(0L)), this.ivRackIDsByBuildingID, rackIDKey);
            int sumInRack = 0;
            int groupIndex = 0;
            while (groupIndex < this.ivGroupNames.size() - 1) {
                String group = (String)this.ivGroupNames.elementAt(groupIndex);
                RackMerker rm = ServiceInfoCollector.getMerker(serviceID, group);
                if (rm != null) {
                    int i = 0;
                    while (i < rm.ivGroupCages.length) {
                        if (rm.ivGroupCages[i]) {
                            int n = groupIndex;
                            this.ivTotalCagesByGroup[n] = this.ivTotalCagesByGroup[n] + 1;
                            int n2 = groupIndex;
                            rackCageSammler[n2] = rackCageSammler[n2] + 1;
                            ++sumInRack;
                            ++this.ivTotalCagesBelegt;
                        }
                        ++i;
                    }
                    this.ivTotalMice += rm.ivAnzMice;
                    int n = groupIndex;
                    this.ivTotalMiceByGroup[n] = this.ivTotalMiceByGroup[n] + rm.ivAnzMice;
                    int n3 = groupIndex;
                    rackMiceSammler[n3] = rackMiceSammler[n3] + rm.ivAnzMice;
                    this.ivTotalMatings += rm.ivAnzMatings;
                    int n4 = groupIndex;
                    this.ivTotalMatingsByGroup[n4] = this.ivTotalMatingsByGroup[n4] + rm.ivAnzMatings;
                    int n5 = groupIndex;
                    rackMatingsSammler[n5] = rackMatingsSammler[n5] + rm.ivAnzMatings;
                    this.ivTotalNonEmptyCages += rm.ivAnzNonEmptyCages;
                    int n6 = groupIndex;
                    this.ivTotalNonEmptyCagesByGroup[n6] = this.ivTotalNonEmptyCagesByGroup[n6] + rm.ivAnzNonEmptyCages;
                    int n7 = groupIndex;
                    rackNonEmptyCagesSammler[n7] = rackNonEmptyCagesSammler[n7] + rm.ivAnzNonEmptyCages;
                }
                ++groupIndex;
            }
            int rackKapazitaet = serviceRack.getArraySize();
            this.ivTotalCageKapazitaet += rackKapazitaet;
            rackCageSammler[rackCageSammler.length - 1] = unbelegtInRack = rackKapazitaet - sumInRack;
            int n = this.ivTotalCagesByGroup.length - 1;
            this.ivTotalCagesByGroup[n] = this.ivTotalCagesByGroup[n] + unbelegtInRack;
        }
    }

    public Vector getRoomNames() {
        return ServiceInfoCollector.getNames(this.ivRoomIDsByName, PSEUDO_GROUP_OHNE_RAUM);
    }

    public Vector getBuildingNames() {
        return ServiceInfoCollector.getNames(this.ivBuildingIDsByName, PSEUDO_GROUP_OHNE_GEBAEUDE);
    }

    public Vector getRackIDs(String room) {
        Long roomID;
        if (room != null && (roomID = (Long)this.ivRoomIDsByName.get(room)) != null) {
            return (Vector)this.ivRackIDsByRoomID.get(roomID);
        }
        return null;
    }

    public void fillTotalBlock(SIBlock block) {
        int gind = 0;
        while (gind < this.ivGroupNames.size()) {
            block.ivPercents[gind] = (double)this.ivTotalCagesByGroup[gind] / (double)this.ivTotalCageKapazitaet;
            block.ivCages[gind] = this.ivTotalCagesByGroup[gind];
            block.ivMice[gind] = this.ivTotalMiceByGroup[gind];
            block.ivMatings[gind] = this.ivTotalMatingsByGroup[gind];
            block.ivFilledCages[gind] = this.ivTotalNonEmptyCagesByGroup[gind];
            block.ivQuota[gind] = -1;
            ++gind;
        }
        block.calcMatingPercentage();
    }

    public boolean fillBuildingBlock(SIBlock block, String buildingName) {
        Vector rackIDs;
        Long buildingID = (Long)this.ivBuildingIDsByName.get(buildingName);
        if (buildingID != null && (rackIDs = (Vector)this.ivRackIDsByBuildingID.get(buildingID)) != null) {
            this.aggregateBlock(block, rackIDs, buildingName.startsWith(PSEUDO_START) ? null : this.getQuota((QuotableIDObject)ObjectStore.getObjectDeadOrAlive(22, buildingID, "service", null, true)));
            return true;
        }
        return false;
    }

    public boolean fillRoomBlock(SIBlock block, String roomName) {
        Vector rackIDs;
        Long roomID = (Long)this.ivRoomIDsByName.get(roomName);
        if (roomID != null && (rackIDs = (Vector)this.ivRackIDsByRoomID.get(roomID)) != null) {
            this.aggregateBlock(block, rackIDs, roomName.startsWith(PSEUDO_START) ? null : this.getQuota((QuotableIDObject)ObjectStore.getObjectDeadOrAlive(10, roomID, "service", null, true)));
            return true;
        }
        return false;
    }

    public String fillRackBlock(SIBlock block, Long rackID) {
        if (rackID != null) {
            Vector<Long> rackIDs = new Vector<Long>();
            rackIDs.add(rackID);
            Rack rack = (Rack)ObjectStore.getObjectDeadOrAlive(3, rackID, "service", null, true);
            this.aggregateBlock(block, rackIDs, this.getQuota(rack));
            return rack.getName();
        }
        return null;
    }

    private int[] getQuota(QuotableIDObject qio) {
        int[] quotaSammler = new int[this.ivGroupNames.size()];
        int i = 0;
        while (i < quotaSammler.length) {
            quotaSammler[i] = -1;
            ++i;
        }
        if (qio != null) {
            String[] quotaGroups = (String[])qio.get("QIO_GNAMES");
            int[] quotaCounts = (int[])qio.get("QIO_QUOTA");
            if (quotaGroups != null && quotaCounts != null) {
                int i2 = 0;
                while (i2 < quotaGroups.length) {
                    int ind = this.ivGroupNames.indexOf(quotaGroups[i2]);
                    if (ind != -1) {
                        quotaSammler[ind] = quotaCounts[i2];
                    }
                    ++i2;
                }
            }
        }
        return quotaSammler;
    }

    private void aggregateBlock(SIBlock block, Vector rackIDs, int[] quota) {
        block.ivCages = this.aggregate(this.ivCagesByRackIDAndGroup, rackIDs);
        int sum = 0;
        int i = 0;
        while (i < block.ivCages.length) {
            sum += block.ivCages[i];
            ++i;
        }
        i = 0;
        while (i < block.ivCages.length) {
            block.ivPercents[i] = (double)block.ivCages[i] / (double)sum;
            ++i;
        }
        i = 0;
        while (i < block.ivQuota.length) {
            block.ivQuota[i] = quota != null ? quota[i] : -1;
            ++i;
        }
        block.ivMice = this.aggregate(this.ivMiceByRackIDAndGroup, rackIDs);
        block.ivMatings = this.aggregate(this.ivMatingsByRackIDAndGroup, rackIDs);
        block.ivFilledCages = this.aggregate(this.ivNonEmptyCagesByRackIDAndGroup, rackIDs);
        block.calcMatingPercentage();
    }

    private int[] aggregate(HashMap sht, Vector keys) {
        int[] res = new int[this.ivGroupNames.size()];
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            int[] arr = (int[])sht.get(key);
            if (arr == null) continue;
            int i = 0;
            while (i < arr.length) {
                int n = i;
                res[n] = res[n] + arr[i];
                ++i;
            }
        }
        return res;
    }

    public class SIBlock {
        public int[] ivCages;
        public int[] ivFilledCages;
        public int[] ivQuota;
        public int[] ivMatings;
        public int[] ivMice;
        public double[] ivPercents;
        public double[] ivMatingPercents;
        public double[] ivEmptyPercents;
        public Color[] ivColors;

        public SIBlock(Vector groupNames) {
            int anz = groupNames.size();
            this.ivCages = new int[anz];
            this.ivFilledCages = new int[anz];
            this.ivQuota = new int[anz];
            this.ivMatings = new int[anz];
            this.ivMice = new int[anz];
            this.ivPercents = new double[anz];
            this.ivMatingPercents = new double[anz];
            this.ivEmptyPercents = new double[anz];
            this.ivColors = new Color[anz];
            int i = 0;
            while (i < this.ivQuota.length) {
                this.ivQuota[i] = -1;
                ++i;
            }
            i = 0;
            while (i < this.ivColors.length - 1) {
                this.ivColors[i] = GroupColorManager.getColor((String)groupNames.elementAt(i), i, this.ivColors.length - 1);
                ++i;
            }
        }

        public void calcMatingPercentage() {
            int i;
            if (this.ivMatingPercents != null && this.ivMatingPercents.length != 0) {
                i = 0;
                while (i < this.ivMatingPercents.length) {
                    this.ivMatingPercents[i] = this.ivCages[i] <= 0 || this.ivMatings[i] <= 0 ? 0.0 : (double)this.ivMatings[i] / (double)this.ivCages[i];
                    ++i;
                }
            }
            if (this.ivEmptyPercents != null && this.ivEmptyPercents.length != 0) {
                i = 0;
                while (i < this.ivEmptyPercents.length) {
                    this.ivEmptyPercents[i] = this.ivCages[i] <= 0 || this.ivMatings[i] <= 0 ? 0.0 : (double)(this.ivCages[i] - this.ivFilledCages[i]) / (double)this.ivCages[i];
                    ++i;
                }
            }
        }
    }
}

