/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets.sessionreports;

import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.Babel;
import java.io.Serializable;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.factsheets.IDObjectMerker;
import mausoleum.main.MausoleumClient;
import mausoleum.rack.Rack;
import mausoleum.room.Room;

public class SessionCageLine
implements Serializable {
    private static final long serialVersionUID = 1138315315L;
    public String ivLink = null;
    public String ivID = "";
    public String ivCage = "";
    public String ivRack = "";
    public String ivRoom = "";
    public String ivOwner = "";
    public String ivMice = "";
    public String ivRackLink = null;
    public String ivRoomLink = null;
    public String ivOwnerLink = null;
    public String ivMiceLink = null;

    public SessionCageLine(Cage cage, int typ) {
        Vector mice;
        User owner;
        Room room;
        if (MausoleumClient.isRegularOrTGService()) {
            this.ivLink = IDObjectMerker.getLink(cage, null);
        }
        this.ivID = Long.toString(cage.getID());
        this.ivCage = cage.getNumberString();
        Rack rack = cage.getRack();
        if (rack != null) {
            this.ivRack = rack.getName();
            if (MausoleumClient.isRegularOrTGService()) {
                this.ivRackLink = IDObjectMerker.getLink(rack, null);
            }
        }
        if ((room = cage.getRoom()) != null) {
            this.ivRoom = room.getName();
            if (MausoleumClient.isRegularOrTGService()) {
                this.ivRoomLink = IDObjectMerker.getLink(room, null);
            }
        }
        if ((owner = cage.getOwnerOslo()) != null) {
            this.ivOwner = owner.getName();
            if (MausoleumClient.isRegularOrTGService()) {
                this.ivOwnerLink = IDObjectMerker.getLink(owner, null);
            }
        }
        if ((mice = cage.getActualMice()) != null && !mice.isEmpty()) {
            int nr = mice.size();
            String string = this.ivMice = nr == 1 ? String.valueOf(nr) + " " + Babel.get("FS_MOUSE") : String.valueOf(nr) + " " + Babel.get("FS_MICE");
            if (MausoleumClient.isRegularOrTGService()) {
                this.ivMiceLink = IDObjectMerker.getLink(mice, null);
            }
        }
    }
}

