/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.genealogy;

import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import mausoleum.alert.Alert;
import mausoleum.genealogy.GenealogyRenderer;
import mausoleum.genealogy.GenealogyTreeModel;
import mausoleum.genealogy.GeneaolgyExportRequester;
import mausoleum.gui.MDisposable;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.ClipboardObject;
import mausoleum.helper.FontManager;
import mausoleum.helper.WindowUtils;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseIDCard;
import mausoleum.mouse.MouseManager;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.MausoleumTableSelectionListener;
import mausoleum.tables.models.MTMouseInGenealogyDisplay;
import mausoleum.ui.UIDef;

public class GenealogyCard
extends JPanel
implements ActionListener,
TreeExpansionListener,
MausoleumTableSelectionListener,
MDisposable {
    private static final long serialVersionUID = 45678945648263L;
    private final JTree ivTree;
    private final GenealogyTreeModel ivTreeModel;
    private final MTMouseInGenealogyDisplay ivMouseTableModel = new MTMouseInGenealogyDisplay();
    private final MausoleumTable ivMouseTable = new MausoleumTable(this.ivMouseTableModel, false);
    private boolean ivReactToChanges = true;
    private final String ivGroup;
    private final Vector ivShownMice = new Vector();
    private final HashSet ivShownIDs = new HashSet();
    private boolean ivLastClickWasWithShift = false;

    public GenealogyCard(long rootID, HashMap leafIDs, String group) {
        this.ivGroup = group;
        this.ivTreeModel = new GenealogyTreeModel(rootID, leafIDs);
        this.ivTree = new JTree(this.ivTreeModel);
        this.ivTree.setCellRenderer(new GenealogyRenderer(group));
        this.ivTree.setShowsRootHandles(true);
        this.ivTree.setToggleClickCount(0);
        this.ivTree.addTreeExpansionListener(this);
        this.ivTree.setDoubleBuffered(false);
        this.ivTree.setLargeModel(true);
        this.ivTree.setRowHeight(UIDef.getScaled(28));
        this.ivTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Mouse mouse;
                if (e.getClickCount() == 2 && (mouse = GenealogyCard.this.getMouseForEvent(e)) != null) {
                    Vector<Mouse> v = new Vector<Mouse>();
                    v.add(mouse);
                    Point p1 = GenealogyCard.this.ivTree.getLocationOnScreen();
                    Point p2 = e.getPoint();
                    new MouseIDCard(v, new Point(p1.x + p2.x, p1.y + p2.y));
                }
            }

            public void mousePressed(MouseEvent arg0) {
                GenealogyCard.this.ivLastClickWasWithShift = arg0.isShiftDown();
            }
        });
        this.ivTree.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                String tooltip = null;
                if (DefaultManager.getWantsTooltips()) {
                    Mouse mouse = GenealogyCard.this.getMouseForEvent(e);
                    tooltip = mouse == null ? null : mouse.getToolTipString();
                }
                GenealogyCard.this.ivTree.setToolTipText(tooltip);
            }
        });
        this.ivTree.getSelectionModel().setSelectionMode(1);
        this.ivTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                GenealogyCard.this.ivMouseTableModel.selectElement(GenealogyCard.this.getMouseForTreePath(GenealogyCard.this.ivTree.getSelectionPath()));
            }
        });
        this.ivTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent arg0) throws ExpandVetoException {
                if (GenealogyCard.this.ivReactToChanges && GenealogyCard.this.ivLastClickWasWithShift) {
                    GenealogyCard.this.collapseOrExpandTree(arg0.getPath(), false);
                    throw new ExpandVetoException(arg0);
                }
            }

            public void treeWillCollapse(TreeExpansionEvent arg0) throws ExpandVetoException {
                if (GenealogyCard.this.ivReactToChanges && GenealogyCard.this.ivLastClickWasWithShift) {
                    GenealogyCard.this.collapseOrExpandTree(arg0.getPath(), true);
                    throw new ExpandVetoException(arg0);
                }
            }
        });
        this.setLayout(new BorderLayout(4, 4));
        int aa = UIDef.getScaled(4);
        RequesterPane tap = new RequesterPane((LayoutManager)new GridLayout(1, 3, aa, aa), "inspectorBack");
        tap.setBackground(Color.lightGray);
        tap.add(new MGButton(Babel.get("EXPAND"), "EXP", this, FontManager.getFont("SSB11")));
        tap.add(new MGButton(Babel.get("COLLAPSE"), "COL", this, FontManager.getFont("SSB11")));
        tap.add(new MGButton(Babel.get("EXPORT"), "EXPORT", this, FontManager.getFont("SSB11")));
        tap.setBorder(new LineBorder(Color.lightGray, 4));
        this.ivTree.setBorder(new EmptyBorder(aa, aa, aa, aa));
        JPanel tap2 = new JPanel(new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND));
        tap2.add("North", tap);
        tap2.add("Center", new JScrollPane(this.ivTree));
        this.ivMouseTable.setIsSubdisplay();
        this.setElements();
        this.ivMouseTableModel.addSelectionListener(this);
        JSplitPane jspp = new JSplitPane(1, tap2, this.ivMouseTable);
        jspp.setDividerLocation(UIDef.getScaled(250));
        this.add("Center", jspp);
    }

    public void mDispose() {
        this.ivShownMice.clear();
        this.ivMouseTable.mDispose();
    }

    private Mouse getMouseForEvent(MouseEvent e) {
        return this.getMouseForTreePath(this.ivTree.getPathForLocation(e.getX(), e.getY()));
    }

    private Mouse getMouseForTreePath(TreePath selPath) {
        Long longi;
        if (selPath != null && (longi = (Long)selPath.getLastPathComponent()) != null) {
            long val = longi;
            if (val < 0L) {
                val = -val;
            }
            return MouseManager.getMouse(val, this.ivGroup);
        }
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals("EXP")) {
            this.collapseOrExpandTree(new TreePath(this.ivTreeModel.getRoot()), false);
        } else if (comm.equals("COL")) {
            this.collapseOrExpandTree(new TreePath(this.ivTreeModel.getRoot()), true);
        } else if (comm.equals("EXPORT") && GeneaolgyExportRequester.determineExportParams(WindowUtils.getJFrame(this))) {
            boolean onlyVisibles = GeneaolgyExportRequester.LAST_RESULT[0];
            boolean withTable = GeneaolgyExportRequester.LAST_RESULT[1];
            String res = ((GenealogyTreeModel)this.ivTree.getModel()).getExport(this.ivGroup, this.ivTree, withTable ? this.ivMouseTableModel : null, onlyVisibles);
            ClipboardObject.manageCopy(null, res);
            Alert.showAlert(Babel.get("DATAINCLIPBOARD"), true);
        }
    }

    public MausoleumTable getTable() {
        return this.ivMouseTable;
    }

    private void collapseOrExpandTree(TreePath tp, boolean collapse) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            boolean merk = this.ivReactToChanges;
            this.ivReactToChanges = false;
            this.ivTree.cancelEditing();
            TreeUI treeui = this.ivTree.getUI();
            this.ivTree.setUI(null);
            Stack stack = new Stack();
            this.collapseOrExpandTree(tp, stack, collapse);
            while (!stack.isEmpty()) {
                TreePath ttp = (TreePath)stack.pop();
                if (collapse) {
                    this.ivTree.collapsePath(ttp);
                    continue;
                }
                this.ivTree.expandPath(ttp);
            }
            this.ivTree.setUI(treeui);
            this.ivReactToChanges = merk;
            this.setElements();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void collapseOrExpandTree(TreePath tp, Stack stack, boolean collapse) {
        if (collapse && this.ivTree.isExpanded(tp) || !collapse) {
            stack.push(tp);
            Object oo = tp.getLastPathComponent();
            int tns = this.ivTreeModel.getChildCount(oo);
            int i = 0;
            while (i < tns) {
                this.collapseOrExpandTree(tp.pathByAddingChild(this.ivTreeModel.getChild(oo, i)), stack, collapse);
                ++i;
            }
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
        if (this.ivReactToChanges) {
            this.setElements();
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        if (this.ivReactToChanges) {
            this.setElements();
        }
    }

    private synchronized void setElements() {
        this.ivShownMice.clear();
        this.ivShownIDs.clear();
        int rows = this.ivTree.getRowCount();
        int i = 0;
        while (i < rows) {
            Long to;
            TreePath selPath = this.ivTree.getPathForRow(i);
            if (selPath != null && (to = (Long)selPath.getLastPathComponent()) != null) {
                if (to > 0L) {
                    this.ivShownIDs.add(to);
                } else if (to < 0L) {
                    this.ivShownIDs.add(new Long(-to.longValue()));
                }
            }
            ++i;
        }
        Iterator iterator = this.ivShownIDs.iterator();
        while (iterator.hasNext()) {
            Long idL = (Long)iterator.next();
            Mouse mouse = MouseManager.getMouse(idL, this.ivGroup);
            if (mouse == null) continue;
            this.ivShownMice.add(mouse);
        }
        this.ivShownIDs.clear();
        this.ivMouseTableModel.setMice(this.ivShownMice);
    }

    public void selectionChanged(MausoleumTableModel mt) {
        ((GenealogyRenderer)this.ivTree.getCellRenderer()).fetchSelIDs(mt);
        this.ivTree.repaint();
    }
}

