/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.genealogy;

import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mausoleum.genealogy.GenealogyCard;
import mausoleum.gui.ClosableTabbedPane;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.WindowMinimalSizer;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.inspector.Inspector;
import mausoleum.ui.UIDef;

public class GenealogyFrame
extends JFrame {
    private static final long serialVersionUID = 145453345453L;
    private static final int BREITE = UIDef.getScaled(800);
    private static final int HOEHE = UIDef.getScaled(450);
    private static final int MIN_BREITE = UIDef.getScaled(600);
    private static final int MIN_HOEHE = UIDef.getScaled(300);
    private static GenealogyFrame cvInstance = null;
    private final ClosableTabbedPane ivTabbedPane = new ClosableTabbedPane(true, true);

    public static void showGenealogy(long rootID, HashMap leafIDs, String title, String group) {
        if (cvInstance == null) {
            cvInstance = new GenealogyFrame();
        }
        GenealogyCard gc = new GenealogyCard(rootID, leafIDs, group);
        GenealogyFrame.cvInstance.ivTabbedPane.addTab(title, gc);
        GenealogyFrame.cvInstance.ivTabbedPane.setSelectedComponent(gc);
        WindowUtils.bringUpFrame(cvInstance);
    }

    public static void hideIt() {
        if (cvInstance != null) {
            cvInstance.setVisible(false);
        }
    }

    private GenealogyFrame() {
        this.setTitle(Babel.get("GENEALOGY"));
        this.setIconImage(MausoleumImageStore.getLogo());
        this.setContentPane(new RequesterPane(new BorderLayout()));
        this.getContentPane().add("Center", this.ivTabbedPane);
        WindowUtils.setRememberedBounds(this, new Rectangle(20, 20, BREITE, HOEHE));
        this.ivTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GenealogyFrame.this.adaptToTab();
            }
        });
        new WindowMinimalSizer(this, MIN_BREITE, MIN_HOEHE, true);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                GenealogyFrame.this.adaptToTab();
            }
        });
    }

    private void adaptToTab() {
        GenealogyCard gc = (GenealogyCard)this.ivTabbedPane.getSelectedComponent();
        Inspector.adjustToTable(gc != null ? gc.getTable() : null);
    }
}

