/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.genealogy;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.tree.TreeCellRenderer;
import mausoleum.gui.ColorManager;
import mausoleum.helper.FontManager;
import mausoleum.line.Line;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.ui.UIDef;

public class GenealogyRenderer
extends JPanel
implements TreeCellRenderer {
    private static final long serialVersionUID = 4894515348153L;
    private static final String SPACE = "  ";
    private static final int BW = UIDef.getScaled(3);
    private static final Border NORM_BORDER = new CompoundBorder(new EmptyBorder(BW, BW, BW, BW), new LineBorder(Color.black, 1));
    private static final Border SELECT_BORDER = new CompoundBorder(new LineBorder(UIDef.SELECTED_BACKGROUND, BW), new LineBorder(Color.black, 1));
    private static final Color MALE_COLOR = new Color(160, 160, 255);
    private static final Color FEMALE_COLOR = new Color(255, 160, 160);
    private static final Color UNDEF_COLOR = Color.lightGray;
    private final HashSet ivSelectedIDs = new HashSet();
    private final JLabel ivDetailLabel = new JLabel();
    private final JLabel ivSexLabel = new JLabel();
    private final String ivGroup;

    public GenealogyRenderer(String group) {
        super(new BorderLayout());
        this.ivGroup = group;
        this.ivSexLabel.setPreferredSize(new Dimension(UIDef.getScaled(24), UIDef.getScaled(16)));
        this.ivSexLabel.setForeground(Color.black);
        this.ivSexLabel.setHorizontalAlignment(0);
        this.ivSexLabel.setOpaque(true);
        this.ivSexLabel.setBorder(new MatteBorder(0, 0, 0, 1, Color.black));
        this.add("West", this.ivSexLabel);
        this.ivDetailLabel.setForeground(Color.black);
        this.ivDetailLabel.setOpaque(true);
        this.add("Center", this.ivDetailLabel);
    }

    public void fetchSelIDs(MausoleumTableModel mt) {
        this.ivSelectedIDs.clear();
        Iterator iterator = mt.getSelectedObjects().iterator();
        while (iterator.hasNext()) {
            Mouse mouse = (Mouse)iterator.next();
            this.ivSelectedIDs.add(mouse.get("IDO_ID"));
        }
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Long idL = (Long)value;
        long id = idL;
        this.setOpaque(false);
        String[] txts = new String[2];
        Mouse mouse = GenealogyRenderer.getGenInfo(id, txts, this.ivGroup);
        boolean isSelected = this.ivSelectedIDs.contains(new Long(id < 0L ? -id : id));
        this.setBorder(isSelected ? SELECT_BORDER : NORM_BORDER);
        if (mouse == null || mouse.get("IDO_END_DATE") != null) {
            this.ivDetailLabel.setFont(FontManager.getFont("SSP12"));
            this.ivSexLabel.setFont(FontManager.getFont("SSP12"));
        } else {
            this.ivDetailLabel.setFont(FontManager.getFont("SSB12"));
            this.ivSexLabel.setFont(FontManager.getFont("SSB12"));
        }
        Color bg = Color.lightGray;
        Color sexbg = UNDEF_COLOR;
        this.ivSexLabel.setText(txts[0]);
        this.ivDetailLabel.setText(txts[1]);
        if (mouse != null) {
            Color linec;
            Line line = mouse.getLine();
            if (line != null && line.get("LIN_COLOR") != null && (linec = (Color)line.get("LIN_COLOR")) != null) {
                bg = linec;
            }
            switch (mouse.getSex()) {
                case 1: {
                    sexbg = MALE_COLOR;
                    break;
                }
                case 2: {
                    sexbg = FEMALE_COLOR;
                    break;
                }
            }
        }
        if (!isSelected) {
            bg = ColorManager.getLighterColor(bg);
            sexbg = ColorManager.getLighterColor(sexbg);
        }
        this.ivDetailLabel.setBackground(bg);
        this.ivDetailLabel.setForeground(ColorManager.getForegroundColorForBackground(bg));
        this.ivSexLabel.setBackground(sexbg);
        this.ivSexLabel.setForeground(ColorManager.getForegroundColorForBackground(sexbg));
        return this;
    }

    public static Mouse getGenInfo(long id, String[] res, String group) {
        Mouse mouse = null;
        mouse = id < 0L ? MouseManager.getMouse(-id, group) : MouseManager.getMouse(id, group);
        res[0] = "?";
        res[1] = " -- ??? --- ";
        if (mouse != null) {
            res[0] = DefaultManager.getSexString(mouse, true);
            res[1] = SPACE + mouse.getGenealogyString(id < 0L) + SPACE;
        }
        return mouse;
    }
}

