/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.genealogy;

import java.util.HashMap;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import mausoleum.genealogy.GenealogyRenderer;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.mouse.Mouse;
import mausoleum.tables.models.MTMouse;

public class GenealogyTreeModel
implements TreeModel {
    private static final MausoleumTableLabel LABEL = new MausoleumTableLabel();
    private final HashMap ivLeafIds;
    private final long ivRootID;

    public GenealogyTreeModel(long rootID, HashMap leafIDs) {
        this.ivRootID = rootID;
        this.ivLeafIds = leafIDs;
    }

    public String getExport(String group, JTree tree, MTMouse tableModel, boolean onlyDisplayeds) {
        int depth;
        StringBuilder msb = new StringBuilder();
        int n = depth = tableModel != null ? this.getDepth(tree, onlyDisplayeds) : 0;
        if (tableModel != null) {
            int i = 0;
            while (i < depth) {
                msb.append("\t");
                ++i;
            }
            int col = 0;
            while (col < tableModel.getColumnCount()) {
                msb.append("\t").append(tableModel.getColumnName(col));
                ++col;
            }
            msb.append("\n");
        }
        String[] target = new String[2];
        if (onlyDisplayeds) {
            int anz = tree.getRowCount();
            int i = 0;
            while (i < anz) {
                TreePath tp = tree.getPathForRow(i);
                int tabs = tp.getPath().length - 1;
                Long mouseID = (Long)tp.getLastPathComponent();
                Mouse mouse = GenealogyRenderer.getGenInfo(mouseID, target, group);
                if (mouse != null) {
                    this.addInfoForMouse(mouse, msb, target[0], target[1], tabs, depth, tableModel);
                }
                ++i;
            }
        } else {
            this.appendInfo(this.ivRootID, msb, target, group, 0, depth, tableModel);
        }
        return msb.toString();
    }

    private int getDepth(JTree tree, boolean onlyDisplayeds) {
        int max = 0;
        if (onlyDisplayeds) {
            int anz = tree.getRowCount();
            int i = 0;
            while (i < anz) {
                int depth = tree.getPathForRow(i).getPath().length;
                if (depth > max) {
                    max = depth;
                }
                ++i;
            }
        } else {
            int[] cmax = new int[1];
            this.calcMaxDepth(this.ivRootID, 1, cmax);
            max = cmax[0];
        }
        return max + 1;
    }

    private void calcMaxDepth(long id, int soFar, int[] max) {
        long[] nids;
        if (soFar > max[0]) {
            max[0] = soFar;
        }
        if ((nids = (long[])this.ivLeafIds.get(new Long(id))) != null && nids.length != 0) {
            int i = 0;
            while (i < nids.length) {
                this.calcMaxDepth(nids[i], soFar + 1, max);
                ++i;
            }
        }
    }

    private void appendInfo(long id, StringBuilder msb, String[] target, String group, int tabs, int tabStart, MTMouse tableModel) {
        Mouse mouse = GenealogyRenderer.getGenInfo(id, target, group);
        if (mouse != null) {
            this.addInfoForMouse(mouse, msb, target[0], target[1], tabs, tabStart, tableModel);
            long[] nids = (long[])this.ivLeafIds.get(new Long(id));
            if (nids != null && nids.length != 0) {
                int i = 0;
                while (i < nids.length) {
                    this.appendInfo(nids[i], msb, target, group, tabs + 1, tabStart, tableModel);
                    ++i;
                }
            }
        }
    }

    private void addInfoForMouse(Mouse mouse, StringBuilder msb, String spalte1, String spalte2, int tabs, int tabStart, MTMouse tableModel) {
        int i = 0;
        while (i < tabs) {
            msb.append("\t");
            ++i;
        }
        msb.append(spalte1).append("\t").append(spalte2);
        if (tableModel != null) {
            i = 0;
            while (i < tabStart - tabs - 1) {
                msb.append("\t");
                ++i;
            }
            int col = 0;
            while (col < tableModel.getColumnCount()) {
                tableModel.writeTheCodedElement(LABEL, mouse, tableModel.getDefinedColumnName(col), false);
                msb.append("\t").append(LABEL.getText());
                ++col;
            }
        }
        msb.append("\n");
    }

    public void dispose() {
        this.ivLeafIds.clear();
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public Object getChild(Object parent, int index) {
        long[] arr = (long[])this.ivLeafIds.get(parent);
        if (arr != null && index >= 0 && index < arr.length) {
            return new Long(arr[index]);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        long[] arr = (long[])this.ivLeafIds.get(parent);
        if (arr != null) {
            return arr.length;
        }
        return 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        long[] arr = (long[])this.ivLeafIds.get(parent);
        if (arr != null && child != null) {
            int val = ((Long)child).intValue();
            int i = 0;
            while (i < arr.length) {
                if (arr[i] == (long)val) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public Object getRoot() {
        return new Long(this.ivRootID);
    }

    public boolean isLeaf(Object node) {
        long[] arr = (long[])this.ivLeafIds.get(node);
        return arr == null;
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

