/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import mausoleum.helper.FontManager;
import mausoleum.ui.UIDef;

public class BorderPanel
extends Container
implements LayoutManager {
    private static final long serialVersionUID = -5812295499228207134L;
    private static final int RAND = UIDef.getScaled(7);
    private static final int EXTRA = UIDef.getScaled(4);
    public static final int INTERVALL = 0;
    public static final int BREITEN_DELTA = 2 * RAND;
    public static final int HOEHEN_DELTA = 2 * RAND + UIDef.getScaled(8);
    private static Dimension cvMiniDim = new Dimension(200, 200);
    private Container ivInnerContainer = null;
    private String ivText = null;
    private Font ivFont = FontManager.getFont("SSP11");

    public BorderPanel(Container p, String titel) {
        this(p, titel, FontManager.getFont("SSP11"));
    }

    public BorderPanel(Container p, String titel, Font f) {
        this.setLayout(this);
        this.ivInnerContainer = p;
        if (p != null) {
            this.add(p);
        }
        this.ivText = titel;
        this.ivFont = f;
    }

    public void setNewPanel(Container c) {
        if (this.ivInnerContainer != null) {
            this.remove(this.ivInnerContainer);
        }
        this.ivInnerContainer = c;
        if (this.ivInnerContainer != null) {
            this.add(this.ivInnerContainer);
        }
        this.validate();
        this.repaint();
    }

    public Container getPanel() {
        return this.ivInnerContainer;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.layoutContainer(this);
    }

    public void paint(Graphics g) {
        Dimension td = this.getSize();
        g.setFont(this.ivFont);
        FontMetrics mfm = g.getFontMetrics();
        int tw = mfm.stringWidth(this.ivText);
        g.setColor(Color.white);
        g.drawLine(0, UIDef.getScaled(4), UIDef.getScaled(10), UIDef.getScaled(4));
        g.drawLine(10 + tw + 2 * EXTRA, UIDef.getScaled(4), td.width - 1, UIDef.getScaled(4));
        g.drawLine(0, UIDef.getScaled(4), 0, td.height - 1);
        g.setColor(Color.black);
        g.drawLine(td.width - 1, td.height - 1, td.width - 1, UIDef.getScaled(4));
        g.drawLine(td.width - 1, td.height - 1, 0, td.height - 1);
        g.setColor(Color.black);
        g.drawLine(1, UIDef.getScaled(4) + 1 + 0, UIDef.getScaled(10), UIDef.getScaled(4) + 1 + 0);
        g.drawLine(UIDef.getScaled(10) + tw + 2 * EXTRA, UIDef.getScaled(4) + 1 + 0, td.width - 2 - 0, UIDef.getScaled(4) + 1 + 0);
        g.drawLine(1, UIDef.getScaled(4) + 1 + 0, 1, td.height - 2 - 0);
        g.setColor(Color.white);
        g.drawLine(td.width - 2 - 0, td.height - 2 - 0, td.width - 2 - 0, 5);
        g.drawLine(td.width - 2 - 0, td.height - 2 - 0, 1, td.height - 2 - 0);
        g.setColor(Color.black);
        g.drawString(this.ivText, UIDef.getScaled(10) + EXTRA, mfm.getMaxAscent() - UIDef.getScaled(2));
        super.paintComponents(g);
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void layoutContainer(Container parent) {
        if (this.ivInnerContainer != null) {
            Dimension d = parent.getSize();
            this.ivInnerContainer.setBounds(RAND, RAND + this.ivFont.getSize() - UIDef.getScaled(2), d.width - BREITEN_DELTA, d.height - HOEHEN_DELTA);
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return cvMiniDim;
    }

    public Dimension preferredLayoutSize(Container parent) {
        return cvMiniDim;
    }

    public void removeLayoutComponent(Component comp) {
    }
}

