/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import mausoleum.factsheets.FactSheetPanel;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MDisposable;
import mausoleum.gui.MGButton;
import mausoleum.helper.FontManager;
import mausoleum.helper.WindowUtils;
import mausoleum.requester.Requester;
import mausoleum.tables.MausoleumTable;
import mausoleum.ui.UIDef;

public class ClosableTabbedPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String NO_TAB_LABEL = Babel.get("NO_TABS");
    private JTabbedPane ivTabbedPane = new JTabbedPane();
    private MGButton ivRemoveButton = null;
    private int ivAktSel = -1;
    private int ivLastSel = -1;
    private final boolean ivAuchDasLetzte;
    private final boolean ivEditTabName;

    public ClosableTabbedPane(boolean auchDasLetzte, boolean editTabName) {
        super(new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND));
        this.setOpaque(false);
        this.ivAuchDasLetzte = auchDasLetzte;
        this.ivEditTabName = editTabName;
        this.ivTabbedPane = new JTabbedPane(){
            private static final long serialVersionUID = 1234234L;

            public void paint(Graphics g) {
                if (this.getTabCount() > 0) {
                    super.paint(g);
                } else {
                    Dimension d = this.getSize();
                    g.setColor(Color.darkGray);
                    g.drawRect(0, 0, d.width - 1, d.height - 1);
                    g.setFont(FontManager.getFont("SSB16"));
                    FontMetrics mfm = g.getFontMetrics();
                    int br = mfm.stringWidth(NO_TAB_LABEL);
                    int ma = mfm.getMaxAscent();
                    int md = mfm.getMaxDescent();
                    int gesh = ma + md;
                    int obka = (d.height - gesh) / 2;
                    int y = obka + ma - 1;
                    int x = (d.width - br) / 2;
                    g.drawString(NO_TAB_LABEL, x, y);
                }
            }
        };
        this.ivTabbedPane.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                int tabNumber = ClosableTabbedPane.this.getTabNummerIfIconHit(e);
                if (ClosableTabbedPane.this.ivAktSel == -1 && tabNumber >= 0 && tabNumber == ClosableTabbedPane.this.ivLastSel) {
                    ClosableTabbedPane.this.ivAktSel = ClosableTabbedPane.this.ivLastSel;
                    ClosableTabbedPane.this.setArmed(ClosableTabbedPane.this.ivAktSel, true);
                } else if (ClosableTabbedPane.this.ivAktSel != -1 && tabNumber != ClosableTabbedPane.this.ivAktSel) {
                    ClosableTabbedPane.this.unarm();
                }
            }
        });
        this.ivTabbedPane.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                int tabNumber;
                if (ClosableTabbedPane.this.ivLastSel != -1 && (tabNumber = ClosableTabbedPane.this.getTabNummerIfIconHit(e)) >= 0 && tabNumber == ClosableTabbedPane.this.ivLastSel) {
                    ClosableTabbedPane.this.ivAktSel = ClosableTabbedPane.this.ivLastSel;
                    ClosableTabbedPane.this.setArmed(ClosableTabbedPane.this.ivAktSel, true);
                }
            }

            public void mouseExited(MouseEvent e) {
                ClosableTabbedPane.this.unarm();
            }

            public void mousePressed(MouseEvent e) {
                if (e.getSource() instanceof JTabbedPane) {
                    int tabNumber;
                    boolean repaint = false;
                    if (ClosableTabbedPane.this.ivAktSel != -1) {
                        CloseTabIcon cti = (CloseTabIcon)ClosableTabbedPane.this.ivTabbedPane.getIconAt(ClosableTabbedPane.this.ivAktSel);
                        cti.ivIsArmed = false;
                        repaint = true;
                    }
                    if ((tabNumber = ClosableTabbedPane.this.getTabNummerIfIconHit(e)) >= 0) {
                        ClosableTabbedPane.this.ivAktSel = tabNumber;
                        ClosableTabbedPane.this.ivLastSel = tabNumber;
                        CloseTabIcon cti = (CloseTabIcon)ClosableTabbedPane.this.ivTabbedPane.getIconAt(ClosableTabbedPane.this.ivAktSel);
                        cti.ivIsArmed = true;
                        repaint = true;
                    }
                    if (repaint) {
                        ClosableTabbedPane.this.ivTabbedPane.repaint();
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (ClosableTabbedPane.this.ivAktSel != -1) {
                    int tabNumber;
                    boolean repaint = false;
                    CloseTabIcon cti = (CloseTabIcon)ClosableTabbedPane.this.ivTabbedPane.getIconAt(ClosableTabbedPane.this.ivAktSel);
                    if (cti.ivIsArmed) {
                        cti.ivIsArmed = false;
                        repaint = true;
                    }
                    if ((tabNumber = ClosableTabbedPane.this.getTabNummerIfIconHit(e)) == ClosableTabbedPane.this.ivAktSel) {
                        Component c = ClosableTabbedPane.this.ivTabbedPane.getComponentAt(tabNumber);
                        ClosableTabbedPane.this.ivTabbedPane.removeTabAt(tabNumber);
                        ClosableTabbedPane.this.checkButton();
                        ClosableTabbedPane.this.mdisposeComponents(new Component[]{c});
                        repaint = true;
                    }
                    ClosableTabbedPane.this.ivAktSel = -1;
                    ClosableTabbedPane.this.ivLastSel = -1;
                    if (repaint) {
                        ClosableTabbedPane.this.ivTabbedPane.repaint();
                    }
                }
            }

            public void mouseClicked(MouseEvent e) {
                String neuName;
                int tabNumber;
                if (e.getSource() instanceof JTabbedPane && e.getClickCount() == 2 && (tabNumber = ClosableTabbedPane.this.ivTabbedPane.getUI().tabForCoordinate(ClosableTabbedPane.this.ivTabbedPane, e.getX(), e.getY())) >= 0 && ClosableTabbedPane.this.ivEditTabName && e.getClickCount() == 2 && (neuName = Requester.getString(WindowUtils.getJFrame(ClosableTabbedPane.this.ivTabbedPane), Babel.get("ENTER_TAB_NAME"), ClosableTabbedPane.this.ivTabbedPane.getTitleAt(tabNumber))) != null) {
                    ClosableTabbedPane.this.ivTabbedPane.setTitleAt(tabNumber, neuName);
                }
            }
        });
        this.add("Center", this.ivTabbedPane);
        if (this.ivAuchDasLetzte) {
            this.ivRemoveButton = new MGButton(Babel.get("REMOVE_ALL_TABS"));
            this.ivRemoveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    Component[] arr = ClosableTabbedPane.this.getAllTabComponents();
                    ClosableTabbedPane.this.ivTabbedPane.removeAll();
                    ClosableTabbedPane.this.mdisposeComponents(arr);
                    ClosableTabbedPane.this.checkButton();
                }
            });
            this.ivRemoveButton.setEnabled(false);
            this.add("South", this.ivRemoveButton);
        }
    }

    private void mdisposeComponents(Component[] arr) {
        if (arr != null && arr.length != 0) {
            int i = 0;
            while (i < arr.length) {
                if (arr[i] instanceof MDisposable) {
                    ((MDisposable)((Object)arr[i])).mDispose();
                }
                ++i;
            }
        }
    }

    private void unarm() {
        if (this.ivAktSel != -1) {
            this.setArmed(this.ivAktSel, false);
            this.ivAktSel = -1;
        }
    }

    private void setArmed(int index, boolean armed) {
        CloseTabIcon cti = (CloseTabIcon)this.ivTabbedPane.getIconAt(index);
        if (cti != null && cti.ivIsArmed != armed) {
            cti.ivIsArmed = armed;
            this.ivTabbedPane.repaint();
        }
    }

    private int getTabNummerIfIconHit(MouseEvent e) {
        Rectangle rect;
        CloseTabIcon cti;
        int tabNumber = this.ivTabbedPane.getUI().tabForCoordinate(this.ivTabbedPane, e.getX(), e.getY());
        if (tabNumber >= 0 && (cti = (CloseTabIcon)this.ivTabbedPane.getIconAt(tabNumber)) != null && (rect = cti.getBounds()).contains(e.getX(), e.getY()) && (this.ivTabbedPane.getTabCount() > 1 || this.ivAuchDasLetzte)) {
            return tabNumber;
        }
        return -1;
    }

    public void checkButton() {
        if (this.ivRemoveButton != null) {
            this.ivRemoveButton.setEnabled(this.ivTabbedPane.getComponentCount() > 0);
        }
    }

    public void addTab(String title, Component component) {
        this.addTab(title, component, null);
    }

    public void addTab(String title, Component component, boolean withCloseIcon) {
        if (withCloseIcon) {
            this.addTab(title, component, null);
        } else {
            this.ivTabbedPane.addTab(title, component);
        }
    }

    public void addTab(String title, Component component, Icon extraIcon) {
        this.ivTabbedPane.addTab(title, new CloseTabIcon(extraIcon), component);
        this.checkButton();
    }

    public void setSelectedComponent(Component arg0) {
        this.ivTabbedPane.setSelectedComponent(arg0);
    }

    public Component getSelectedComponent() {
        return this.ivTabbedPane.getSelectedComponent();
    }

    public void addChangeListener(ChangeListener arg0) {
        this.ivTabbedPane.addChangeListener(arg0);
    }

    public void selectLastTab() {
        int anz = this.ivTabbedPane.getComponentCount();
        if (anz > 0) {
            this.ivTabbedPane.setSelectedIndex(anz - 1);
        }
    }

    public Component[] getAllTabComponents() {
        return this.ivTabbedPane.getComponents();
    }

    public void clearCompletely() {
        if (this.ivTabbedPane.getTabCount() != 0) {
            Component[] arr = this.ivTabbedPane.getComponents();
            int i = 0;
            while (i < arr.length) {
                if (arr[i] instanceof MausoleumTable) {
                    MausoleumTable mt = (MausoleumTable)arr[i];
                    mt.mDispose();
                } else if (arr[i] instanceof FactSheetPanel) {
                    FactSheetPanel fsp = (FactSheetPanel)arr[i];
                    fsp.mDispose();
                }
                ++i;
            }
            while (this.ivTabbedPane.getTabCount() > 0) {
                this.ivTabbedPane.remove(0);
            }
        }
    }

    class CloseTabIcon
    implements Icon {
        private int x_pos;
        private int y_pos;
        private int width;
        private int height;
        private Icon fileIcon;
        public boolean ivIsArmed = false;

        public CloseTabIcon(Icon fileIcon) {
            this.fileIcon = fileIcon;
            this.width = 16;
            this.height = 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.x_pos = x;
            this.y_pos = y;
            Color orahmenCol = Color.white;
            Color urahmenCol = Color.black;
            Color kreuzCol = Color.white;
            Color fillCol = new Color(255, 90, 90, 220);
            if (ClosableTabbedPane.this.ivTabbedPane.getTabCount() <= 1 && !ClosableTabbedPane.this.ivAuchDasLetzte) {
                orahmenCol = Color.darkGray;
                urahmenCol = Color.darkGray;
                kreuzCol = Color.darkGray;
                fillCol = null;
            } else if (this.ivIsArmed) {
                orahmenCol = Color.black;
                urahmenCol = Color.white;
                kreuzCol = Color.lightGray;
                fillCol = ColorManager.getDarkerColor(fillCol);
            }
            Color col = g.getColor();
            int y_p = y + 2;
            if (fillCol != null) {
                g.setColor(fillCol);
                g.fillRect(x + 1, y_p + 1, 12, 12);
            }
            g.setColor(orahmenCol);
            g.drawLine(x + 1, y_p, x + 12, y_p);
            g.drawLine(x, y_p + 1, x, y_p + 12);
            g.setColor(urahmenCol);
            g.drawLine(x + 1, y_p + 13, x + 12, y_p + 13);
            g.drawLine(x + 13, y_p + 1, x + 13, y_p + 12);
            if (fillCol != null) {
                if (this.ivIsArmed) {
                    g.setColor(ColorManager.getLighterColor(fillCol));
                } else {
                    g.setColor(ColorManager.getDarkerColor(fillCol));
                }
                g.drawLine(x + 1, y_p + 12, x + 12, y_p + 12);
                g.drawLine(x + 12, y_p + 1, x + 12, y_p + 12);
                if (this.ivIsArmed) {
                    g.setColor(ColorManager.getDarkerColor(fillCol));
                } else {
                    g.setColor(ColorManager.getLighterColor(fillCol));
                }
                g.drawLine(x + 1, y_p + 1, x + 12, y_p + 1);
                g.drawLine(x + 1, y_p + 1, x + 1, y_p + 12);
            }
            g.setColor(kreuzCol);
            g.drawLine(x + 3, y_p + 3, x + 10, y_p + 10);
            g.drawLine(x + 3, y_p + 4, x + 9, y_p + 10);
            g.drawLine(x + 4, y_p + 3, x + 10, y_p + 9);
            g.drawLine(x + 10, y_p + 3, x + 3, y_p + 10);
            g.drawLine(x + 10, y_p + 4, x + 4, y_p + 10);
            g.drawLine(x + 9, y_p + 3, x + 3, y_p + 9);
            g.setColor(col);
            if (this.fileIcon != null) {
                this.fileIcon.paintIcon(c, g, x + this.width, y_p);
            }
        }

        public int getIconWidth() {
            return this.width + (this.fileIcon != null ? this.fileIcon.getIconWidth() : 0);
        }

        public int getIconHeight() {
            return this.height;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.x_pos, this.y_pos, this.width, this.height);
        }
    }
}

