/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import de.hannse.netobjects.util.Log;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import mausoleum.gui.MusterColor;
import mausoleum.gui.PralineColor;

public abstract class ColorManager {
    public static final HashSet BLACK_FGS = new HashSet();
    public static final HashSet WHITE_FGS = new HashSet();
    public static final Color MC_BACK2 = new Color(224, 224, 224);
    public static final Color MC_INSPECTOR_BUTTON = new Color(250, 234, 234);
    public static final Color MC_BLAU = new Color(199, 222, 255);
    public static final Color MC_GELB = new Color(255, 254, 163);
    public static final Color MC_GRUEN = new Color(180, 255, 167);
    public static final Color MC_ROT = new Color(255, 56, 56);
    private static final int STD_GRAU = 180;
    private static final int STD_ALPHA = 70;
    private static final String[] HTMLCOLORS = new String[]{"black", "#000000", "gray", "#808080", "maroon", "#800000", "red", "#FF0000", "green", "#008000", "lime", "#00FF00", "olive", "#808000", "yellow", "#FFFF00", "navy", "#000080", "blue", "#0000FF", "purple", "#800080", "fuchsia", "#FF00FF", "teal", "#008080", "aqua", "#00FFFF", "silver", "#C0C0C0", "white", "#FFFFFF", "aliceblue", "#F0F8FF", "antiquewhite", "#FAEBD7", "aquamarine", "#7FFFD4", "azure", "#F0FFFF", "beige", "#F5F5DC", "blueviolet", "#8A2BE2", "brown", "#A52A2A", "burlywood", "#DEB887", "cadetblue", "#5F9EA0", "chartreuse", "#7FFF00", "chocolate", "#D2691E", "coral", "#FF7F50", "cornflowerblue", "#6495ED", "cornsilk", "#FFF8DC", "crimson", "#DC143C", "darkblue", "#00008B", "darkcyan", "#008B8B", "darkgoldenrod", "#B8860B", "darkgray", "#A9A9A9", "darkgreen", "#006400", "darkkhaki", "#BDB76B", "darkmagenta", "#8B008B", "darkolivegreen", "#556B2F", "darkorange", "#FF8C00", "darkorchid", "#9932CC", "darkred", "#8B0000", "darksalmon", "#E9967A", "darkseagreen", "#8FBC8F", "darkslateblue", "#483D8B", "darkslategray", "#2F4F4F", "darkturquoise", "#00CED1", "darkviolet", "#9400D3", "deeppink", "#FF1493", "deepskyblue", "#00BFFF", "dimgray", "#696969", "dodgerblue", "#1E90FF", "firebrick", "#B22222", "floralwhite", "#FFFAF0", "forestgreen", "#228B22", "gainsboro", "#DCDCDC", "ghostwhite", "#F8F8FF", "gold", "#FFD700", "goldenrod", "#DAA520", "greenyellow", "#ADFF2F", "honeydew", "#F0FFF0", "hotpink", "#FF69B4", "indianred", "#CD5C5C", "indigo", "#4B0082", "ivory", "#FFFFF0", "khaki", "#F0E68C", "lavender", "#E6E6FA", "lavenderblush", "#FFF0F5", "lawngreen", "#7CFC00", "lemonchiffon", "#FFFACD", "lightblue", "#ADD8E6", "lightcoral", "#F08080", "lightcyan", "#E0FFFF", "lightgoldenrodyellow", "#FAFAD2", "lightgreen", "#90EE90", "lightgrey", "#D3D3D3", "lightpink", "#FFB6C1", "lightsalmon", "#FFA07A", "lightseagreen", "#20B2AA", "lightskyblue", "#87CEFA", "lightslategray", "#778899", "lightsteelblue", "#B0C4DE", "lightyellow", "#FFFFE0", "limegreen", "#32CD32", "linen", "#FAF0E6", "mediumaquamarine", "#66CDAA", "mediumblue", "#0000CD", "mediumorchid", "#BA55D3", "mediumpurple", "#9370DB", "mediumseagreen", "#3CB371", "mediumslateblue", "#7B68EE", "mediumspringgreen", "#00FA9A", "mediumturquoise", "#48D1CC", "mediumvioletred", "#C71585", "midnightblue", "#191970", "mintcream", "#F5FFFA", "mistyrose", "#FFE4E1", "moccasin", "#FFE4B5", "navajowhite", "#FFDEAD", "oldlace", "#FDF5E6", "olivedrab", "#6B8E23", "orange", "#FFA500", "orangered", "#FF4500", "orchid", "#DA70D6", "palegoldenrod", "#EEE8AA", "palegreen", "#98FB98", "paleturquoise", "#AFEEEE", "palevioletred", "#DB7093", "papayawhip", "#FFEFD5", "peachpuff", "#FFDAB9", "peru", "#CD853F", "pink", "#FFC0CB", "plum", "#DDA0DD", "powderblue", "#B0E0E6", "rosybrown", "#BC8F8F", "royalblue", "#4169E1", "saddlebrown", "#8B4513", "salmon", "#FA8072", "sandybrown", "#F4A460", "seagreen", "#2E8B57", "seashell", "#FFF5EE", "sienna", "#A0522D", "skyblue", "#87CEEB", "slateblue", "#6A5ACD", "slategray", "#708090", "snow", "#FFFAFA", "springgreen", "#00FF7F", "steelblue", "#4682B4", "tan", "#D2B48C", "thistle", "#D8BFD8", "tomato", "#FF6347", "turquoise", "#40E0D0", "violet", "#EE82EE", "wheat", "#F5DEB3", "whitesmoke", "#F5F5F5", "yellowgreen", "#9ACD32"};
    private static final String[] HEX = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    private static final HashMap HTML_COLORS = new HashMap(140);
    public static final int MAXRGBFORWEISS = 180;
    public static final Color NEW_BACKGROUND = Color.orange;
    private static final HashMap MAUSO_COLORS = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        int i = 0;
        while (i < HTMLCOLORS.length) {
            HTML_COLORS.put(HTMLCOLORS[i], HTMLCOLORS[i + 1]);
            i += 2;
        }
        MAUSO_COLORS.put("yellowButton", MC_GELB);
        MAUSO_COLORS.put("redButton", MC_ROT);
        MAUSO_COLORS.put("blueButton", MC_BLAU);
        MAUSO_COLORS.put("greenButton", MC_GRUEN);
        MAUSO_COLORS.put("inspectorButton", MC_INSPECTOR_BUTTON);
        MAUSO_COLORS.put("inspectorBack", MC_BACK2);
    }

    private static int perceivedBrightness(Color c) {
        return (int)Math.sqrt((double)(c.getRed() * c.getRed()) * 0.241 + (double)(c.getGreen() * c.getGreen()) * 0.691 + (double)(c.getBlue() * c.getBlue()) * 0.068);
    }

    public static Color getMatt(Color c) {
        if (c instanceof MusterColor) {
            MusterColor mc = (MusterColor)c;
            int r = (180 + c.getRed()) / 2;
            int g = (180 + c.getGreen()) / 2;
            int b = (180 + c.getBlue()) / 2;
            Color matt2 = ColorManager.getMatt(mc.ivSecondColor);
            return new MusterColor(r, g, b, matt2, mc.ivMuster);
        }
        if (c instanceof PralineColor) {
            PralineColor mc = (PralineColor)c;
            int r = (180 + c.getRed()) / 2;
            int g = (180 + c.getGreen()) / 2;
            int b = (180 + c.getBlue()) / 2;
            return new PralineColor(r, g, b, mc.ivRahmenColor);
        }
        int r = (180 + c.getRed()) / 2;
        int g = (180 + c.getGreen()) / 2;
        int b = (180 + c.getBlue()) / 2;
        return new Color(r, g, b, 70);
    }

    public static Color getLighterColor(Color c) {
        int r = (255 + c.getRed()) / 2;
        int g = (255 + c.getGreen()) / 2;
        int b = (255 + c.getBlue()) / 2;
        return new Color(r, g, b);
    }

    public static Color getDarkerColor(Color c) {
        int r = c.getRed() / 2;
        int g = c.getGreen() / 2;
        int b = c.getBlue() / 2;
        return new Color(r, g, b);
    }

    public static Color getForegroundColorForBackground(Color col) {
        if (col != null) {
            if (BLACK_FGS.contains(col)) {
                return Color.black;
            }
            if (WHITE_FGS.contains(col)) {
                return Color.white;
            }
            if (ColorManager.perceivedBrightness(col) < 130) {
                WHITE_FGS.add(col);
                return Color.white;
            }
            BLACK_FGS.add(col);
        }
        return Color.black;
    }

    public static Color getMausoColor(String key) {
        return (Color)MAUSO_COLORS.get(key);
    }

    public static String getHTMLColorString(Color c) {
        if (c == null) {
            return "null";
        }
        String rs = Integer.toHexString(c.getRed()).toUpperCase();
        String gs = Integer.toHexString(c.getGreen()).toUpperCase();
        String bs = Integer.toHexString(c.getBlue()).toUpperCase();
        if (rs.length() == 1) {
            rs = "0" + rs;
        }
        if (gs.length() == 1) {
            gs = "0" + gs;
        }
        if (bs.length() == 1) {
            bs = "0" + bs;
        }
        return "#" + rs + gs + bs;
    }

    public static Color getColorFromString(String s) {
        if (s.equals("null")) {
            return null;
        }
        if ((s = s.trim()).startsWith("#")) {
            s = s.substring(1, s.length());
            return ColorManager.getColorFromNumberString(s);
        }
        String ns = (String)HTML_COLORS.get(s.toLowerCase().trim());
        if (ns != null) {
            return ColorManager.getColorFromNumberString(ns.substring(1, ns.length()));
        }
        return ColorManager.getColorFromNumberString(s);
    }

    public static Color getColorFromNumberString(String s) {
        Color res = null;
        if (s.length() == 5) {
            s = "0" + s;
        }
        if (s.length() == 6) {
            try {
                int r = ColorManager.getInteger(s.substring(0, 2));
                int g = ColorManager.getInteger(s.substring(2, 4));
                int b = ColorManager.getInteger(s.substring(4, 6));
                res = new Color(r, g, b);
            }
            catch (Exception e) {
                String string = "Exception while parsing Color String " + s;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.gui.ColorManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
        return res;
    }

    public static String getColorString(Color c) {
        if (c == null) {
            return "null";
        }
        String rs = Integer.toHexString(c.getRed()).toUpperCase();
        String gs = Integer.toHexString(c.getGreen()).toUpperCase();
        String bs = Integer.toHexString(c.getBlue()).toUpperCase();
        if (rs.length() == 1) {
            rs = "0" + rs;
        }
        if (gs.length() == 1) {
            gs = "0" + gs;
        }
        if (bs.length() == 1) {
            bs = "0" + bs;
        }
        return String.valueOf(rs) + gs + bs;
    }

    public static Color mix(Color col1, Color col2) {
        if (col1 != null && col2 != null) {
            int mixcr = (col1.getRed() + col2.getRed()) / 2;
            int mixcg = (col1.getGreen() + col2.getGreen()) / 2;
            int mixcb = (col1.getBlue() + col2.getBlue()) / 2;
            return new Color(mixcr, mixcg, mixcb);
        }
        return null;
    }

    private static int getInteger(String hs) {
        if (hs.length() != 2) {
            throw new IllegalArgumentException("String " + hs + " is no valid Hex code!");
        }
        int erg = ColorManager.findSingleHexValue(hs.substring(0, 1).toUpperCase());
        erg <<= 4;
        return erg += ColorManager.findSingleHexValue(hs.substring(1, 2).toUpperCase());
    }

    private static int findSingleHexValue(String s) {
        int i = 0;
        while (i < HEX.length) {
            if (s.equals(HEX[i])) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Single Hex-String " + s + " is no valid Hex code!");
    }
}

