/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import javax.swing.JScrollBar;
import mausoleum.helper.LogTrick;
import mausoleum.helper.NumberFormatter;

public class DoubleScrollBar
extends JScrollBar {
    private static final long serialVersionUID = 9112324402127409091L;
    private static int MAX = 200;
    private double ivUpperLimit;
    private double ivLowerLimit;
    private double ivDiff;
    private double ivLogTrickSchritt;
    private int ivAnzDec = 0;

    public DoubleScrollBar(int arg0) {
        super(arg0);
    }

    public void setDoubleLimits(double min, double max) {
        int ad2;
        super.setValues(0, 1, 0, MAX + 1);
        this.ivUpperLimit = max;
        this.ivLowerLimit = min;
        this.ivDiff = this.ivUpperLimit - this.ivLowerLimit;
        this.ivLogTrickSchritt = LogTrick.getSchritt(this.ivDiff, this.ivDiff / (double)MAX);
        this.ivAnzDec = LogTrick.getAnzDec(this.ivLogTrickSchritt);
        if (this.ivLowerLimit > 0.0 && (ad2 = LogTrick.getAnzDec(this.ivLowerLimit)) > this.ivAnzDec) {
            this.ivAnzDec = ad2;
        }
    }

    public void setDoubleValue(double val) {
        int ival = (int)((double)MAX * (val - this.ivLowerLimit) / this.ivDiff);
        super.setValue(ival);
    }

    public String getDoubleString(double val) {
        return NumberFormatter.formatNumberString(val, this.ivAnzDec);
    }

    public double getLowerLimit() {
        return this.ivLowerLimit;
    }

    public double getDoubleValue() {
        int ival = super.getValue();
        if (ival == MAX) {
            return this.ivUpperLimit;
        }
        if (ival == 0) {
            return this.ivLowerLimit;
        }
        double versuch = this.ivLowerLimit + (double)ival / (double)MAX * this.ivDiff;
        double res = (double)((int)(versuch / this.ivLogTrickSchritt)) * this.ivLogTrickSchritt;
        if (res < this.ivLowerLimit) {
            res = this.ivLowerLimit;
        } else if (res > this.ivUpperLimit) {
            res = this.ivUpperLimit;
        }
        return res;
    }
}

