/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import java.awt.Color;
import java.awt.Insets;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.ui.UIDef;

public abstract class GuiPropertiesMausoleum {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String tui = UIManager.getSystemLookAndFeelClassName();
        if (tui != null && (tui = tui.trim()).length() != 0) {
            try {
                UIManager.setLookAndFeel(tui);
                UIManager.put("ButtonUI", "de.hannse.cp.client.ui.HEButtonUI");
            }
            catch (Exception e) {
                String string = "Could not set UI: " + tui;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.gui.GuiPropertiesMausoleum");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
        GuiPropertiesMausoleum.showDefaults();
    }

    public static void showDefaults() {
        System.out.println("UIManager Default Properties");
        UIDefaults df1 = UIManager.getDefaults();
        Enumeration dfkeys = df1.keys();
        StringBuffer msb = new StringBuffer();
        msb.append("KEY\tVALUE\n");
        while (dfkeys.hasMoreElements()) {
            Object key = dfkeys.nextElement();
            msb.append(key).append("\t").append(df1.get(key)).append("\n");
        }
        FileManager.saveStringToFile("uidefs.txt", msb.toString());
    }

    public static void setDefaultProperties() {
        UIManager.put("Button.foreground", new ColorUIResource(UIDef.MAIN_BUTTON_FORE_COLOR));
        UIManager.put("Button.background", new ColorUIResource(UIDef.MAIN_BUTTON_BACK_COLOR));
        UIManager.put("OptionPane.okButtonText", "  " + Babel.get("OK") + "  ");
        UIManager.put("OptionPane.yesButtonText", "  " + Babel.get("YES") + "  ");
        UIManager.put("OptionPane.noButtonText", "  " + Babel.get("NO") + "  ");
        UIManager.put("OptionPane.cancelButtonText", "  " + Babel.get("CANCEL") + "  ");
        UIManager.put("ComboBox.selectionBackground", new ColorUIResource(UIDef.SELECTED_BACKGROUND));
        UIManager.put("ComboBox.selectionForeground", new ColorUIResource(Color.black));
        UIManager.put("ComboBox.font", FontManager.getFont("SSB11"));
        UIManager.put("List.selectionBackground", new ColorUIResource(UIDef.SELECTED_BACKGROUND));
        UIManager.put("List.selectionForeground", new ColorUIResource(Color.black));
        UIManager.put("List.font", FontManager.getFont("SSB11"));
        UIManager.put("ComboBox.disabledForeground", new ColorUIResource(Color.black));
        UIManager.put("TextField.inactiveForeground", new ColorUIResource(Color.black));
        UIManager.put("TextArea.selectionBackground", new ColorUIResource(UIDef.SELECTED_BACKGROUND));
        UIManager.put("TextArea.selectionForeground", new ColorUIResource(Color.black));
        UIManager.put("ComboBox.editorBorder", new EmptyBorder(new Insets(0, 0, 0, 0)));
        UIManager.put("ToolTip.background", new ColorUIResource(UIDef.TOOLTIP_BACKGROUND));
        UIManager.put("ToolTip.font", new FontUIResource(FontManager.getFont("SSP11")));
        UIManager.put("ToolTip.foreground", new ColorUIResource(Color.black));
        UIManager.put("Tree.closedIcon", new ImageIcon(ImageProvider.PLUS_IMAGE));
        UIManager.put("Tree.collapsedIcon", new ImageIcon(ImageProvider.PLUS_IMAGE));
        UIManager.put("Tree.expandedIcon", new ImageIcon(ImageProvider.MINUS_IMAGE));
        UIManager.put("TabbedPane.selected", new ColorUIResource(new Color(255, 215, 100, 140)));
        UIManager.put("TabbedPane.focus", new ColorUIResource(new Color(255, 215, 100, 140)));
        UIManager.put("TabbedPane.selectHighlight", new ColorUIResource(new Color(255, 240, 100, 140)));
        UIManager.put("Label.font", new FontUIResource(FontManager.getFont("SSB11")));
        UIManager.put("CheckBox.font", new FontUIResource(FontManager.getFont("SSB11")));
        UIManager.put("Menu.font", new FontUIResource(FontManager.getFont("SSB11")));
        UIManager.put("MenuItem.font", new FontUIResource(FontManager.getFont("SSB11")));
        UIManager.put("TabbedPane.font", new FontUIResource(FontManager.getFont("SSB11")));
        UIManager.put("Tree.font", new FontUIResource(FontManager.getFont("SSB11")));
    }
}

