/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class MausoleumComponent
extends JComponent {
    private static final long serialVersionUID = -4032365973000900935L;
    protected Image ivImage = null;
    protected Image ivImageOrig = null;
    protected Image ivBackgroundImage = null;
    protected Image ivBackgroundImageOrig = null;
    protected Image ivOffscreen = null;
    protected int ivOldWidth;
    protected int ivOldHeight;
    protected boolean isEnabled = true;

    public MausoleumComponent() {
    }

    public MausoleumComponent(Image img, Image bimg) {
        this.ivImageOrig = img;
        this.ivBackgroundImageOrig = bimg;
    }

    public void update(Graphics g) {
        if (g != null) {
            this.paint(g);
        }
    }

    public void repaint(int x, int y, int width, int height) {
        this.paint(this.getGraphics());
    }

    public void repaint() {
        Graphics g = this.getGraphics();
        if (g != null) {
            this.paint(g);
        }
    }

    public void paint(Graphics g) {
        Dimension td = this.getSize();
        if (td.width == 0 || td.height == 0) {
            return;
        }
        boolean newos = false;
        if (this.ivOffscreen == null) {
            newos = true;
        } else if (this.ivOldWidth != td.width || this.ivOldHeight != td.height) {
            newos = true;
        }
        if (newos) {
            this.ivOffscreen = new BufferedImage(td.width, td.height, 1);
            this.ivOldWidth = td.width;
            this.ivOldHeight = td.height;
            this.makeImage();
            this.makeBackgroundImage();
        }
        Graphics cg = this.ivOffscreen.getGraphics();
        cg.setClip(0, 0, td.width, td.height);
        this.drawFeld(cg);
        g.drawImage(this.ivOffscreen, 0, 0, null);
    }

    protected void drawFeld(Graphics g) {
        if (this.isEnabled) {
            if (this.ivImageOrig != null) {
                if (this.ivImage == null) {
                    this.makeImage();
                }
                if (this.ivImage != null) {
                    g.drawImage(this.ivImage, 0, 0, null);
                }
            }
        } else if (this.ivBackgroundImageOrig != null) {
            if (this.ivBackgroundImage == null) {
                this.makeBackgroundImage();
            }
            if (this.ivBackgroundImage != null) {
                g.drawImage(this.ivBackgroundImage, 0, 0, null);
            }
        }
    }

    private void makeImage() {
        this.ivImage = null;
        if (this.ivImageOrig == null) {
            return;
        }
        Rectangle r = this.getBounds();
        if (r.width == 0 || r.height == 0) {
            return;
        }
        int bw = this.ivImageOrig.getWidth(null);
        int bh = this.ivImageOrig.getHeight(null);
        if (bw <= 0 || bh <= 0) {
            return;
        }
        this.ivImage = new BufferedImage(r.width, r.height, 1);
        Graphics g = this.ivImage.getGraphics();
        while (g == null) {
            try {
                System.out.println(String.valueOf(this.getClass().getName()) + " waiting for ivImage");
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            g = this.ivImage.getGraphics();
        }
        int startx = 0;
        while (startx < r.width) {
            int starty = 0;
            while (starty < r.height) {
                g.drawImage(this.ivImageOrig, startx, starty, null);
                starty += bh;
            }
            startx += bw;
        }
    }

    private void makeBackgroundImage() {
        this.ivBackgroundImage = null;
        if (this.ivBackgroundImageOrig == null) {
            return;
        }
        Rectangle r = this.getBounds();
        if (r.width == 0 || r.height == 0) {
            return;
        }
        int myX = r.x;
        int myY = r.y;
        Container conta = this.getParent();
        while (!(conta instanceof Frame)) {
            myX += conta.getBounds().x;
            myY += conta.getBounds().y;
            conta = conta.getParent();
        }
        this.ivBackgroundImage = new BufferedImage(r.width, r.height, 1);
        Graphics g = this.ivBackgroundImage.getGraphics();
        while (g == null) {
            try {
                System.out.println(String.valueOf(this.getClass().getName()) + " waiting for ivBackgroundImage");
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            g = this.ivBackgroundImage.getGraphics();
        }
        int bw = this.ivBackgroundImageOrig.getWidth(null);
        int bh = this.ivBackgroundImageOrig.getHeight(null);
        int startx = myX / bw * bw - myX;
        while (startx < r.width) {
            int starty = myY / bw * bw - myY;
            while (starty < r.height) {
                g.drawImage(this.ivBackgroundImageOrig, startx, starty, null);
                starty += bh;
            }
            startx += bw;
        }
    }
}

