/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.border.Border;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MFLabel;
import mausoleum.gui.MusterColor;
import mausoleum.gui.PralineColor;
import mausoleum.helper.ImageProvider;
import mausoleum.main.DefaultManager;
import mausoleum.rack.frame.CageDisplayManager;

public class MausoleumTableLabel
extends JLabel {
    private static final long serialVersionUID = -5647624113586563571L;
    public final Vector ivMultiFontStrings = new Vector();
    public final Vector ivMultiBackgroundStrings = new Vector();
    public Cage ivCage = null;
    private Color ivTriangleColor = null;
    private boolean ivHasEditBorder = false;
    public boolean ivUseDefaultFontSize = false;

    public MausoleumTableLabel() {
        this.setDoubleBuffered(false);
    }

    public void dispose() {
        this.ivMultiFontStrings.clear();
        this.ivMultiBackgroundStrings.clear();
        this.ivCage = null;
        this.ivTriangleColor = null;
    }

    public void clearMultiFontStrings() {
        this.ivMultiFontStrings.clear();
        this.setText(null);
    }

    public void setMultiFontStrings(Vector v) {
        this.ivMultiFontStrings.clear();
        if (v != null) {
            this.ivMultiFontStrings.addAll(v);
            StringBuffer msb = new StringBuffer();
            int i = 0;
            while (i < v.size()) {
                MFLabel mlfo = (MFLabel)v.elementAt(i);
                msb.append(mlfo.ivString);
                ++i;
            }
            this.setText(msb.toString());
        } else {
            this.setText(null);
        }
    }

    public void setMultiFontStrings(MFLabel[] arr, boolean mitBackground) {
        Vector target = mitBackground ? this.ivMultiBackgroundStrings : this.ivMultiFontStrings;
        target.clear();
        if (arr != null) {
            int i = 0;
            while (i < arr.length) {
                target.add(arr[i]);
                ++i;
            }
            StringBuffer msb = new StringBuffer();
            int i2 = 0;
            while (i2 < arr.length) {
                msb.append(arr[i2].ivString);
                ++i2;
            }
            this.setText(msb.toString());
        } else {
            this.setText(null);
        }
    }

    public void setMultiBackgroundStrings(Vector v) {
        this.ivMultiBackgroundStrings.clear();
        if (v != null) {
            this.ivMultiBackgroundStrings.addAll(v);
            StringBuffer msb = new StringBuffer();
            int i = 0;
            while (i < v.size()) {
                MFLabel mlfo = (MFLabel)v.elementAt(i);
                msb.append(mlfo.ivString);
                ++i;
            }
            this.setText(msb.toString());
        } else {
            this.setText(null);
        }
    }

    public void setCage(Cage c) {
        this.ivCage = c;
    }

    public void setTriangleColor(Color c) {
        this.ivTriangleColor = c;
    }

    public void setBorder(Border arg0) {
        Thread.dumpStack();
    }

    public void setEditBorder(boolean hasEditBorder) {
        this.ivHasEditBorder = hasEditBorder;
    }

    public void paint(Graphics g) {
        Image triangel;
        Dimension d = this.getSize();
        int x = 0;
        int y = 0;
        if (this.ivCage != null && this.ivCage.isAlive()) {
            Color[] bckCols = this.ivCage.getColor();
            if (bckCols != null && bckCols.length != 0) {
                int anz = bckCols.length;
                int nw = d.width / anz;
                int rw = d.width - (anz - 1) * nw;
                int i = 0;
                while (i < anz) {
                    if (bckCols[i] != null) {
                        int width = nw;
                        if (i == anz - 1) {
                            width = rw;
                        }
                        if (bckCols[i] == CageColorManager.NULL_COLOR) {
                            int yy = 0;
                            while (yy < d.height) {
                                int sx = 0;
                                while (sx < width) {
                                    g.drawImage(ImageProvider.SCHRAFF_IMAGE, i * nw + sx, yy, null);
                                    sx += 8;
                                }
                                yy += 8;
                            }
                        } else if (bckCols[i] instanceof MusterColor) {
                            MusterColor mc = (MusterColor)bckCols[i];
                            mc.fill(i * nw, 0, width, d.height, g);
                        } else if (bckCols[i] instanceof PralineColor) {
                            PralineColor mc = (PralineColor)bckCols[i];
                            mc.fill(i * nw, 0, width, d.height, g);
                        } else {
                            g.setColor(bckCols[i]);
                            g.fillRect(i * nw, 0, width, d.height);
                        }
                    }
                    ++i;
                }
            }
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            String number = this.ivCage.getNumberString();
            int sw = fm.stringWidth(number);
            int ma = fm.getMaxAscent();
            int md = fm.getMaxDescent();
            int rest = (d.height - ma - md) / 2;
            int rand = 1;
            int sty = rest + ma;
            int stx = rand;
            switch (this.getHorizontalAlignment()) {
                case 4: {
                    stx = d.width - rand - sw;
                    break;
                }
                case 0: {
                    stx = rand + (d.width - 2 * rand - sw) / 2;
                    break;
                }
            }
            Color[] arr = CageDisplayManager.CLEAR_NUMBER_FOREGROUNDS;
            if (!this.ivCage.itsMine(null) && DefaultManager.getMaskCagesMode() >= 2) {
                arr = CageDisplayManager.MATT_NUMBER_FOREGRUNDS;
            }
            this.setForeground(arr[0]);
            this.drawSimpleText(g, number, stx, sty, arr[1]);
        } else if (!this.ivMultiFontStrings.isEmpty()) {
            if (this.isOpaque() && this.getBackground() != null) {
                g.setColor(this.getBackground());
                g.fillRect(x, y, d.width, d.height);
            }
            g.setColor(this.getForeground());
            int align = this.getHorizontalAlignment();
            if (align == 0 || align == 4) {
                int needed = 0;
                Iterator iter = this.ivMultiFontStrings.iterator();
                while (iter.hasNext()) {
                    MFLabel mflo = (MFLabel)iter.next();
                    g.setFont(mflo.ivFont);
                    FontMetrics fm = g.getFontMetrics();
                    needed += fm.stringWidth(mflo.ivString);
                }
                x = align == 0 ? (d.width - needed) / 2 : d.width - 3 - needed;
                if (x < 3) {
                    x = 3;
                }
            } else {
                x = 3;
            }
            int i = 0;
            while (i < this.ivMultiFontStrings.size()) {
                MFLabel mflo = (MFLabel)this.ivMultiFontStrings.elementAt(i);
                g.setFont(mflo.ivFont);
                FontMetrics fm = g.getFontMetrics();
                int ma = fm.getMaxAscent();
                int md = fm.getMaxDescent();
                int rest = (d.height - ma - md) / 2;
                int yf = rest + ma;
                g.drawString(mflo.ivString, x, yf);
                x += fm.stringWidth(mflo.ivString);
                ++i;
            }
        } else if (!this.ivMultiBackgroundStrings.isEmpty()) {
            if (this.ivMultiBackgroundStrings.size() == 1) {
                MFLabel mflo = (MFLabel)this.ivMultiBackgroundStrings.firstElement();
                g.setFont(this.getFont());
                FontMetrics fm = g.getFontMetrics();
                int ma = fm.getMaxAscent();
                int md = fm.getMaxDescent();
                int rest = (d.height - ma - md) / 2;
                int yf = rest + ma;
                Color bg = mflo.ivBackground;
                if (bg instanceof MusterColor) {
                    MusterColor mc = (MusterColor)bg;
                    mc.fill(x, y, d.width, d.height, g);
                } else if (bg instanceof PralineColor) {
                    PralineColor mc = (PralineColor)bg;
                    mc.fill(x, y, d.width, d.height, g);
                } else {
                    g.setColor(bg);
                    g.fillRect(x, y, d.width, d.height);
                }
                g.setColor(ColorManager.getForegroundColorForBackground(bg));
                g.drawString(mflo.ivString, x + 3, yf);
            } else {
                if (this.isOpaque() && this.getBackground() != null) {
                    g.setColor(this.getBackground());
                    g.fillRect(x, y, d.width, d.height);
                }
                g.setFont(this.getFont());
                g.setColor(this.getForeground());
                FontMetrics fm = g.getFontMetrics();
                int ma = fm.getMaxAscent();
                int md = fm.getMaxDescent();
                int rest = (d.height - ma - md) / 2;
                int yf = rest + ma;
                int gw = 0;
                int[] w = new int[this.ivMultiBackgroundStrings.size()];
                int i = 0;
                while (i < this.ivMultiBackgroundStrings.size()) {
                    MFLabel mflo = (MFLabel)this.ivMultiBackgroundStrings.elementAt(i);
                    w[i] = fm.stringWidth(mflo.ivString) + 6;
                    gw += w[i];
                    ++i;
                }
                int extra1 = 0;
                int extra2 = 0;
                if (gw < d.width) {
                    int diff = d.width - gw;
                    extra1 = diff / this.ivMultiBackgroundStrings.size();
                    extra2 = diff - this.ivMultiBackgroundStrings.size() * extra1;
                }
                int i2 = 0;
                while (i2 < this.ivMultiBackgroundStrings.size()) {
                    Color mc;
                    Color bg;
                    MFLabel mflo = (MFLabel)this.ivMultiBackgroundStrings.elementAt(i2);
                    int width = w[i2] + extra1;
                    if (extra2 > 0) {
                        ++width;
                        --extra2;
                    }
                    if ((bg = mflo.ivBackground) instanceof MusterColor) {
                        mc = (MusterColor)bg;
                        ((MusterColor)mc).fill(x, y, width, d.height, g);
                    } else if (bg instanceof PralineColor) {
                        mc = (PralineColor)bg;
                        ((PralineColor)mc).fill(x, y, width, d.height, g);
                    } else {
                        g.setColor(bg);
                        g.fillRect(x, y, width, d.height);
                    }
                    g.setColor(ColorManager.getForegroundColorForBackground(bg));
                    g.drawString(mflo.ivString, x + 3, yf);
                    x += width;
                    ++i2;
                }
            }
        } else if (this.getIcon() != null) {
            super.paint(g);
        } else {
            String s;
            if (this.isOpaque() && this.getBackground() != null) {
                Color mc;
                Color bg = this.getBackground();
                if (bg instanceof MusterColor) {
                    mc = (MusterColor)bg;
                    ((MusterColor)mc).fill(d, g);
                } else if (bg instanceof PralineColor) {
                    mc = (PralineColor)bg;
                    ((PralineColor)mc).fill(d, g);
                } else {
                    g.setColor(this.getBackground());
                    g.fillRect(x, y, d.width, d.height);
                }
            }
            if ((s = this.getText()) != null && s.length() != 0) {
                g.setColor(this.getForeground());
                g.setFont(this.getFont());
                FontMetrics fm = g.getFontMetrics();
                int ma = fm.getMaxAscent();
                int md = fm.getMaxDescent();
                int rest = (d.height - ma - md) / 2;
                int yf = rest + ma;
                int ori = this.getHorizontalAlignment();
                if (ori == 2) {
                    this.drawSimpleText(g, s, x + 3, yf, null);
                } else if (ori == 0) {
                    int sw = fm.stringWidth(s);
                    int rw = d.width - 6 - sw;
                    if (rw > 0) {
                        this.drawSimpleText(g, s, x + rw / 2, yf, null);
                    } else {
                        this.drawSimpleText(g, s, x + 3, yf, null);
                    }
                } else if (ori == 4) {
                    int sw = fm.stringWidth(s);
                    int rw = d.width - 6 - sw;
                    if (rw > 0) {
                        this.drawSimpleText(g, s, x + rw, yf, null);
                        g.drawString(s, x + rw, yf);
                    } else {
                        this.drawSimpleText(g, s, x + 3, yf, null);
                    }
                }
            }
        }
        if (this.ivTriangleColor != null && (triangel = ImageProvider.getTriangle(this.ivTriangleColor)) != null) {
            g.drawImage(triangel, 0, 0, null);
        }
        if (this.ivHasEditBorder) {
            g.setColor(Color.yellow);
            g.drawRect(0, 0, d.width - 1, d.height - 1);
        }
    }

    private void drawSimpleText(Graphics g, String s, int x, int y, Color randOverride) {
        Color fg = this.getForeground();
        Color bg = this.getBackground();
        if (randOverride != null || bg != null && bg instanceof MusterColor) {
            boolean doit = false;
            if (randOverride != null) {
                g.setColor(randOverride);
                doit = true;
            } else if (fg.equals(Color.black)) {
                g.setColor(Color.white);
                doit = true;
            } else if (fg.equals(Color.white)) {
                g.setColor(Color.black);
                doit = true;
            }
            if (doit) {
                g.drawString(s, x - 1, y - 1);
                g.drawString(s, x - 1, y + 1);
                g.drawString(s, x + 1, y - 1);
                g.drawString(s, x + 1, y + 1);
                if (randOverride != null) {
                    g.drawString(s, x, y - 1);
                    g.drawString(s, x, y + 1);
                    g.drawString(s, x - 1, y);
                    g.drawString(s, x + 1, y);
                }
            }
        }
        g.setColor(fg);
        g.drawString(s, x, y);
    }
}

