/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import mausoleum.helper.FontManager;

public class PermanentLabel {
    private final String ivString;
    private final int ivX;
    private final int ivY;
    private int ivHeight = -1;
    private final Font ivFont = FontManager.getFont("SSB14");
    private boolean ivVisible = true;

    public static int preferredWidth(String s, Font f) {
        return FontManager.getFontMetrics(f).stringWidth(s);
    }

    public PermanentLabel(String s, int x, int y, int height) {
        this.ivString = s;
        this.ivX = x;
        this.ivY = y;
        this.ivHeight = height;
    }

    public void setVisible(boolean visible) {
        this.ivVisible = visible;
    }

    public int preferredWidth() {
        return PermanentLabel.preferredWidth(this.ivString, this.ivFont);
    }

    public void paint(Graphics g) {
        if (this.ivVisible) {
            g.setFont(this.ivFont);
            FontMetrics fm = g.getFontMetrics();
            int y = this.ivY + this.ivFont.getSize();
            if (this.ivHeight != -1) {
                int off = (this.ivHeight - (fm.getAscent() + fm.getDescent())) / 2;
                y = this.ivY + off + fm.getAscent();
            }
            int x = this.ivX;
            g.drawString(this.ivString, x, y);
        }
    }
}

