/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import de.hannse.netobjects.tools.StringHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import mausoleum.gui.TextWrapElement;
import mausoleum.helper.FontManager;

public class TextWrapComponent
extends JComponent {
    private static final long serialVersionUID = 56360356036340482L;
    public static final int JUSTIFIED = 1112;
    private String ivString;
    private Font ivFont;
    private int ivOrientation = 0;
    private Vector ivElements = null;
    private int ivSpaceWidth;
    protected int ivMaxWidth;
    private int ivAktY;
    protected int ivFontSize;
    protected int ivAktZeile = 0;
    public int ivNeededWidth;
    public boolean ivHardWrapPossible = false;

    public static int getNecessaryHeight(String s, int width, Font f) {
        TextWrapComponent twc = new TextWrapComponent(s, f);
        twc.setSize(width, 100);
        twc.generateElements();
        return twc.ivAktY;
    }

    public TextWrapComponent(String s) {
        this.ivString = s;
        this.ivFont = FontManager.getFont("SSB24");
        this.setForeground(Color.black);
    }

    public TextWrapComponent(String s, Font f) {
        this.ivString = s;
        this.ivFont = f;
        this.setForeground(Color.black);
    }

    public TextWrapComponent(String s, Font f, int width) {
        this.ivString = s;
        this.ivFont = f;
        this.setForeground(Color.black);
        this.setSize(width, 100);
        this.generateElements();
    }

    public TextWrapComponent(String s, Font f, int width, int orientation) {
        this.ivString = s;
        this.ivFont = f;
        this.ivOrientation = orientation;
        this.setForeground(Color.black);
        this.setSize(width, 100);
        this.generateElements();
    }

    public TextWrapComponent(String s, boolean klein) {
        this.ivString = s;
        this.ivFont = klein ? FontManager.getFont("SSB12") : FontManager.getFont("SSB24");
        this.setForeground(Color.black);
    }

    public void setOrientation(int or) {
        if (or == 0 || or == 2 || or == 4 || or == 1112) {
            this.ivOrientation = or;
            this.ivElements = null;
            return;
        }
        throw new IllegalArgumentException("Orientation not supported");
    }

    public int getOrientation() {
        return this.ivOrientation;
    }

    public Font getFont() {
        return this.ivFont;
    }

    public int getNecessaryHeight() {
        if (this.ivElements == null) {
            this.generateElements();
        }
        return this.ivAktY;
    }

    public Enumeration getElements() {
        if (this.ivElements == null) {
            this.generateElements();
        }
        return this.ivElements.elements();
    }

    public int getAnzElements() {
        if (this.ivElements == null) {
            this.generateElements();
        }
        if (this.ivElements != null) {
            return this.ivElements.size();
        }
        return 0;
    }

    public void generateElements() {
        this.ivAktZeile = 0;
        this.ivElements = new Vector();
        if (this.ivString != null && this.ivString.trim().length() != 0) {
            FontMetrics mfm = null;
            mfm = this.getGraphics() == null ? FontManager.getFontMetrics(this.ivFont) : this.getGraphics().getFontMetrics(this.ivFont);
            Vector paragraphs = StringHelper.splitStringByAny(this.ivString, "\n");
            this.ivMaxWidth = this.getSize().width;
            this.ivSpaceWidth = mfm.stringWidth(" ");
            this.ivAktY = mfm.getMaxAscent();
            this.ivFontSize = mfm.getFont().getSize();
            this.ivNeededWidth = this.ivMaxWidth;
            int i = 0;
            while (i < paragraphs.size()) {
                this.digestParagraph((String)paragraphs.elementAt(i), mfm);
                ++i;
            }
        }
    }

    private void digestParagraph(String s, FontMetrics mfm) {
        if (s == null) {
            ++this.ivAktZeile;
            this.ivAktY += this.ivFontSize;
            return;
        }
        if (s.trim().length() == 0) {
            ++this.ivAktZeile;
            this.ivAktY += this.ivFontSize;
            return;
        }
        Vector words = StringHelper.splitStringBySpaces(s);
        int aktWidth = 0;
        Vector<String> aktLine = new Vector<String>();
        Vector<Integer> aktWidths = new Vector<Integer>();
        int wordsWidth = 0;
        while (!words.isEmpty()) {
            String w = (String)words.elementAt(0);
            int ww = mfm.stringWidth(w);
            if (aktLine.isEmpty()) {
                if (ww <= this.getZeilenBreite() || !this.ivHardWrapPossible) {
                    aktLine.addElement(w);
                    aktWidths.addElement(new Integer(ww));
                    aktWidth += ww;
                    wordsWidth += ww;
                    words.removeElementAt(0);
                    if (ww <= this.ivNeededWidth) continue;
                    this.ivNeededWidth = ww;
                    continue;
                }
                boolean cont = true;
                int lastPosFound = 0;
                int i = 1;
                while (i < w.length() && cont) {
                    if (mfm.stringWidth(w.substring(0, i)) <= this.getZeilenBreite()) {
                        lastPosFound = i;
                    }
                    ++i;
                }
                String rein = "";
                String rest = "";
                if (lastPosFound != 0) {
                    rein = w.substring(0, lastPosFound);
                    rest = w.substring(lastPosFound, w.length());
                } else {
                    rein = w.substring(0, 1);
                    if (w.length() > 1) {
                        rest = w.substring(1, w.length());
                    }
                }
                aktLine.addElement(rein);
                ww = mfm.stringWidth(rein);
                aktWidths.addElement(new Integer(ww));
                aktWidth += ww;
                wordsWidth += ww;
                if (rest.length() != 0) {
                    words.setElementAt(rest, 0);
                } else {
                    words.removeElementAt(0);
                }
                if (ww <= this.ivNeededWidth) continue;
                this.ivNeededWidth = ww;
                continue;
            }
            if (aktWidth + this.ivSpaceWidth + ww <= this.getZeilenBreite()) {
                aktLine.addElement(w);
                aktWidths.addElement(new Integer(ww));
                aktWidth += this.ivSpaceWidth + ww;
                wordsWidth += ww;
                words.removeElementAt(0);
                continue;
            }
            this.generateLineElements(aktLine, aktWidths, aktWidth, wordsWidth, false);
            aktWidth = 0;
            wordsWidth = 0;
            aktLine = new Vector();
            aktWidths = new Vector();
        }
        if (!aktLine.isEmpty()) {
            this.generateLineElements(aktLine, aktWidths, aktWidth, wordsWidth, true);
        }
    }

    protected int getZeilenBreite() {
        return this.ivMaxWidth;
    }

    protected int getLeftMargin() {
        return 0;
    }

    private void generateLineElements(Vector words, Vector widths, int totWidth, int wordsWidth, boolean lastLine) {
        if (this.ivOrientation == 2) {
            this.ivElements.addElement(new TextWrapElement(this.assembleSingleLineString(words), this.getLeftMargin(), this.ivAktY));
        } else if (this.ivOrientation == 0) {
            this.ivElements.addElement(new TextWrapElement(this.assembleSingleLineString(words), this.getLeftMargin() + (this.getZeilenBreite() - totWidth) / 2, this.ivAktY));
        } else if (this.ivOrientation == 4) {
            this.ivElements.addElement(new TextWrapElement(this.assembleSingleLineString(words), this.getLeftMargin() + this.getZeilenBreite() - totWidth, this.ivAktY));
        } else if (this.ivOrientation == 1112) {
            if (lastLine) {
                this.ivElements.addElement(new TextWrapElement(this.assembleSingleLineString(words), this.getLeftMargin(), this.ivAktY));
            } else {
                int restWidth = this.getZeilenBreite() - wordsWidth;
                int spacePlaces = words.size() - 1;
                int inter = 0;
                int extra = 0;
                if (spacePlaces > 0) {
                    inter = restWidth / spacePlaces;
                    extra = restWidth - inter * spacePlaces;
                }
                int aktx = this.getLeftMargin();
                int i = 0;
                while (i < words.size()) {
                    this.ivElements.addElement(new TextWrapElement((String)words.elementAt(i), aktx, this.ivAktY));
                    Integer traw = (Integer)widths.elementAt(i);
                    aktx += inter + traw;
                    if (extra != 0) {
                        ++aktx;
                        --extra;
                    }
                    ++i;
                }
            }
        }
        ++this.ivAktZeile;
        this.ivAktY += this.ivFontSize;
    }

    private String assembleSingleLineString(Vector v) {
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < v.size()) {
            if (i != 0) {
                msb.append(" ");
            }
            msb.append((String)v.elementAt(i));
            ++i;
        }
        return msb.toString();
    }

    public void paint(Graphics g) {
        if (this.ivElements == null) {
            this.generateElements();
        }
        if (this.ivElements != null) {
            g.setColor(this.getForeground());
            g.setFont(this.ivFont);
            int i = 0;
            while (i < this.ivElements.size()) {
                TextWrapElement twe = (TextWrapElement)this.ivElements.elementAt(i);
                g.drawString(twe.ivText, twe.ivX, twe.ivY);
                ++i;
            }
        }
    }
}

