/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.helper.WindowUtils;

public class WindowMinimalSizer
extends ComponentAdapter {
    private static final Vector INSTANCES = new Vector();
    private Component ivComponent;
    private final int ivMinimalWidth;
    private final int ivMinimalHeight;
    private final boolean ivWithRemeberBounds;

    public static void cleanUp() {
        Iterator iterator = INSTANCES.iterator();
        while (iterator.hasNext()) {
            WindowMinimalSizer wms = (WindowMinimalSizer)iterator.next();
            wms.dispose();
        }
        INSTANCES.clear();
    }

    public WindowMinimalSizer(Component c, int minWidth, int minHeight, boolean withRememberBounds) {
        this.ivComponent = c;
        this.ivMinimalWidth = minWidth;
        this.ivMinimalHeight = minHeight;
        this.ivWithRemeberBounds = withRememberBounds;
        c.setMinimumSize(new Dimension(this.ivMinimalWidth, this.ivMinimalHeight));
        c.addComponentListener(this);
        INSTANCES.add(this);
    }

    public void dispose() {
        this.ivComponent.removeComponentListener(this);
        this.ivComponent = null;
    }

    public void componentResized(ComponentEvent e) {
        Component c = (Component)e.getSource();
        Dimension d = c.getSize();
        boolean changed = false;
        if (d.width < this.ivMinimalWidth) {
            d.width = this.ivMinimalWidth;
            changed = true;
        }
        if (d.height < this.ivMinimalHeight) {
            d.height = this.ivMinimalHeight;
            changed = true;
        }
        if (changed) {
            c.setSize(d);
            super.componentResized(e);
        }
        if (this.ivWithRemeberBounds) {
            WindowUtils.rememberBounds(WindowUtils.getJFrame(c));
        }
    }

    public void componentMoved(ComponentEvent e) {
        if (this.ivWithRemeberBounds) {
            WindowUtils.rememberBounds(WindowUtils.getJFrame((Component)e.getSource()));
        }
    }
}

