/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui.browser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeNode;
import mausoleum.gui.browser.HEBrowserColumn;
import mausoleum.gui.browser.HEBrowserListner;
import mausoleum.ui.UIDef;

public class HEBrowser
extends JScrollPane
implements LayoutManager {
    private static final long serialVersionUID = 1L;
    public static final int CELL_WIDTH = UIDef.getScaled(240);
    public static final int CELL_HEIGHT = UIDef.getScaled(18);
    public static final int COLUMN_WIDTH = UIDef.getScaled(240);
    private JPanel ivPanel = new JPanel();
    private Vector ivColumns = new Vector();
    private Vector ivListeners = new Vector();

    public HEBrowser() {
        this.ivPanel.setLayout(this);
        this.setViewportView(this.ivPanel);
        this.setVerticalScrollBarPolicy(21);
        this.setHorizontalScrollBarPolicy(32);
    }

    public void clearColumns() {
        this.ivColumns = new Vector();
        this.ivPanel.removeAll();
        this.ivPanel.validate();
        this.validate();
        this.getHorizontalScrollBar().setValue(this.getHorizontalScrollBar().getMaximum());
        this.repaint();
    }

    public void addBrowserColumn(HEBrowserColumn column, TreeNode node, String name) {
        if (column == null) {
            this.ivColumns = new Vector();
            this.ivPanel.removeAll();
        } else {
            int ind = this.ivColumns.indexOf(column) + 1;
            this.removeColumnsStartingFromIndex(ind, false);
        }
        if (node.getChildCount() != 0) {
            HEBrowserColumn newsbc = new HEBrowserColumn(this, node, name);
            this.ivPanel.add(newsbc);
            this.ivColumns.addElement(newsbc);
        }
        this.ivPanel.validate();
        this.validate();
        this.getHorizontalScrollBar().setValue(this.getHorizontalScrollBar().getMaximum());
        this.repaint();
    }

    public void removeColumnsStartingFromIndex(int ind, boolean withValidation) {
        if (ind <= this.ivColumns.size()) {
            int anz = this.ivColumns.size() - ind;
            int i = 0;
            while (i < anz) {
                HEBrowserColumn tsbc = (HEBrowserColumn)this.ivColumns.lastElement();
                this.ivPanel.remove(tsbc);
                this.ivColumns.remove(tsbc);
                ++i;
            }
        }
        if (withValidation) {
            this.ivPanel.validate();
            this.validate();
            this.getHorizontalScrollBar().setValue(this.getHorizontalScrollBar().getMaximum());
            this.repaint();
        }
    }

    public int getIndexOfColumn(HEBrowserColumn column) {
        if (column != null) {
            return this.ivColumns.indexOf(column);
        }
        return -1;
    }

    public TreeNode getSelectedElementInColumn(int index) {
        if (index >= 0 && index < this.ivColumns.size()) {
            HEBrowserColumn tsbc = (HEBrowserColumn)this.ivColumns.lastElement();
            return tsbc.getSelectedNode();
        }
        return null;
    }

    public HEBrowserColumn getColumnAtIndex(int index) {
        if (index >= 0 && index < this.ivColumns.size()) {
            return (HEBrowserColumn)this.ivColumns.lastElement();
        }
        return null;
    }

    public void addBrowserListener(HEBrowserListner listener) {
        if (!this.ivListeners.contains(listener)) {
            this.ivListeners.addElement(listener);
        }
    }

    public void removeBrowserListener(HEBrowserListner listener) {
        if (this.ivListeners.contains(listener)) {
            this.ivListeners.removeElement(listener);
        }
    }

    protected void nodeClicked(HEBrowserColumn column, TreeNode node) {
        int i = 0;
        while (i < this.ivListeners.size()) {
            HEBrowserListner listener = (HEBrowserListner)this.ivListeners.elementAt(i);
            listener.nodeClicked(this, column, node);
            ++i;
        }
    }

    protected void nodeDoubleClicked(HEBrowserColumn column, TreeNode node) {
        int i = 0;
        while (i < this.ivListeners.size()) {
            HEBrowserListner listener = (HEBrowserListner)this.ivListeners.elementAt(i);
            listener.nodeDoubleClicked(this, column, node);
            ++i;
        }
    }

    protected void nodeRightClicked(HEBrowserColumn column, TreeNode node) {
        int i = 0;
        while (i < this.ivListeners.size()) {
            HEBrowserListner listener = (HEBrowserListner)this.ivListeners.elementAt(i);
            listener.nodeRightClicked(this, column, node);
            ++i;
        }
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void layoutContainer(Container parent) {
        Dimension siz = this.getViewport().getSize();
        int i = 0;
        while (i < this.ivColumns.size()) {
            Component c = (Component)this.ivColumns.elementAt(i);
            c.setBounds(i * COLUMN_WIDTH, 0, COLUMN_WIDTH, siz.height);
            ++i;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(this.ivColumns.size() * COLUMN_WIDTH, UIDef.getScaled(200));
    }

    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(this.ivColumns.size() * COLUMN_WIDTH, UIDef.getScaled(400));
    }

    public void removeLayoutComponent(Component comp) {
    }
}

