/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui.browser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeNode;
import mausoleum.gui.ColorManager;
import mausoleum.gui.browser.HEBrowser;
import mausoleum.gui.browser.HEBrowserLabel;
import mausoleum.gui.browser.HEBrowserNode;
import mausoleum.helper.FontManager;
import mausoleum.ui.UIDef;

public class HEBrowserColumn
extends JPanel
implements ListCellRenderer,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final Dimension HEADER_DIMENSION = new Dimension(HEBrowser.COLUMN_WIDTH, UIDef.getScaled(20));
    private static final Color HEADER_COLOR = new Color(20, 20, 70);
    private final JList ivList;
    private final JScrollPane ivScrollPane;
    private final JLabel ivHeader = new JLabel();
    private final HEBrowserLabel ivListLabel = new HEBrowserLabel();
    private final JLabel ivListLabel2 = new JLabel();
    private final HEBrowser ivBrowser;
    public final TreeNode ivNode;

    public HEBrowserColumn(HEBrowser browser, TreeNode node, String name) {
        super(new BorderLayout());
        this.ivBrowser = browser;
        this.ivNode = node;
        this.ivList = new JList(){
            private static final long serialVersionUID = 123423L;

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                if (HEBrowserColumn.this.ivScrollPane != null && d.width > ((HEBrowserColumn)HEBrowserColumn.this).ivScrollPane.getViewportBorderBounds().width) {
                    d.width = ((HEBrowserColumn)HEBrowserColumn.this).ivScrollPane.getViewportBorderBounds().width;
                }
                return d;
            }

            public Dimension getMinimumSize() {
                Dimension d = super.getMinimumSize();
                if (HEBrowserColumn.this.ivScrollPane != null && d.width > ((HEBrowserColumn)HEBrowserColumn.this).ivScrollPane.getViewportBorderBounds().width) {
                    d.width = ((HEBrowserColumn)HEBrowserColumn.this).ivScrollPane.getViewportBorderBounds().width;
                }
                return d;
            }
        };
        this.ivScrollPane = new JScrollPane(this.ivList);
        this.ivList.setModel(new ListModel(){

            public int getSize() {
                return HEBrowserColumn.this.ivNode.getChildCount();
            }

            public Object getElementAt(int arg0) {
                return HEBrowserColumn.this.ivNode.getChildAt(arg0);
            }

            public void addListDataListener(ListDataListener arg0) {
            }

            public void removeListDataListener(ListDataListener arg0) {
            }
        });
        this.ivList.addListSelectionListener(this);
        this.ivList.setCellRenderer(this);
        this.ivList.setSelectionMode(0);
        this.ivList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TreeNode snode = null;
                int index = HEBrowserColumn.this.ivList.locationToIndex(e.getPoint());
                if (index != -1) {
                    snode = (TreeNode)HEBrowserColumn.this.ivList.getModel().getElementAt(index);
                }
                if (snode != null) {
                    HEBrowserColumn.this.clicked(e, snode);
                }
            }
        });
        this.ivScrollPane.setVerticalScrollBarPolicy(22);
        this.ivScrollPane.setHorizontalScrollBarPolicy(31);
        this.ivHeader.setText(name);
        this.ivHeader.setPreferredSize(HEADER_DIMENSION);
        this.ivHeader.setMinimumSize(HEADER_DIMENSION);
        this.ivHeader.setMaximumSize(HEADER_DIMENSION);
        this.ivHeader.setSize(HEADER_DIMENSION);
        this.ivHeader.setOpaque(true);
        this.ivHeader.setBackground(HEADER_COLOR);
        this.ivHeader.setForeground(Color.white);
        this.ivHeader.setHorizontalAlignment(0);
        this.ivHeader.setBorder(new LineBorder(Color.white, 1));
        this.ivHeader.setFont(FontManager.getFont("SSB12"));
        this.add("North", this.ivHeader);
        this.add("Center", this.ivScrollPane);
    }

    public TreeNode getSelectedNode() {
        return (TreeNode)this.ivList.getSelectedValue();
    }

    private void clicked(MouseEvent e, TreeNode snode) {
        if (e.isMetaDown()) {
            this.ivBrowser.nodeRightClicked(this, snode);
        } else if (e.getClickCount() == 2) {
            this.ivBrowser.nodeDoubleClicked(this, snode);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof ListCellRenderer) {
            return ((ListCellRenderer)value).getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
        if (isSelected) {
            this.ivListLabel.setBackground(ColorManager.NEW_BACKGROUND);
            this.ivListLabel.setOpaque(true);
        } else {
            this.ivListLabel.setBackground(null);
            this.ivListLabel.setOpaque(false);
        }
        this.ivListLabel.setText(" " + value.toString() + " ");
        if (value instanceof HEBrowserNode) {
            ImageIcon icon;
            HEBrowserNode node = (HEBrowserNode)value;
            this.ivListLabel.setFont(node.ivEnabled ? FontManager.getFont("SSB11") : FontManager.getFont("SSP11"));
            ImageIcon imageIcon = icon = node.ivEnabled ? node.getIcon() : null;
            if (icon != null) {
                this.ivListLabel2.setIcon(icon);
                this.ivListLabel2.setBackground(this.ivListLabel.getBackground());
                this.ivListLabel2.setOpaque(this.ivListLabel.isOpaque());
                JPanel pan = new JPanel(new BorderLayout());
                pan.add("Center", this.ivListLabel);
                pan.add("East", this.ivListLabel2);
                pan.setOpaque(false);
                return pan;
            }
        } else {
            this.ivListLabel.setFont(FontManager.getFont("SSB11"));
        }
        return this.ivListLabel;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.ivBrowser.nodeClicked(this, (TreeNode)this.ivList.getSelectedValue());
        }
    }
}

