/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui.dnd;

import de.hannse.netobjects.objectstore.NULLObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DNDHandler
implements DropTargetListener,
ListSelectionListener {
    private static final NULLObject NULLER = NULLObject.INSTANCE;
    private final JList ivSortedSourceList;
    private final JList[] ivUnsortedTargetLists;
    private final ActionListener ivActionListener;
    private final Comparator ivSorter;
    private JList ivDragSource = null;
    private int[] ivDragSourceIndices = null;
    private int ivIndexInSortedList = -1;

    public DNDHandler(JList sortedSourceList, JList[] unsortedTargetLists, ActionListener al, Comparator sorter) {
        this.ivSortedSourceList = sortedSourceList;
        this.ivUnsortedTargetLists = unsortedTargetLists;
        this.ivActionListener = al;
        this.ivSorter = sorter;
        this.initList(this.ivSortedSourceList);
        int i = 0;
        while (i < this.ivUnsortedTargetLists.length) {
            this.initList(this.ivUnsortedTargetLists[i]);
            ++i;
        }
    }

    private void initList(JList list) {
        if (list != null) {
            list.setDragEnabled(true);
            list.setAutoscrolls(true);
            list.setCellRenderer(new SpecRenderer(list.getCellRenderer()));
            new DropTarget(list, this);
            list.addListSelectionListener(this);
        }
    }

    private int determineIndexInSortedList(JList source, int[] indices) {
        if (source != null && indices != null && indices.length != 0) {
            Object s = source.getModel().getElementAt(indices[0]);
            Vector v = new Vector();
            int anz = this.ivSortedSourceList.getModel().getSize();
            if (anz > 0) {
                int i = 0;
                while (i < anz) {
                    v.add(this.ivSortedSourceList.getModel().getElementAt(i));
                    ++i;
                }
            }
            v.add(s);
            if (this.ivSorter != null) {
                Collections.sort(v, this.ivSorter);
            } else {
                Collections.sort(v);
            }
            return v.indexOf(s);
        }
        return -1;
    }

    private int getIndex(JList list, Point p) {
        int index = -1;
        if (list == this.ivSortedSourceList) {
            index = this.ivIndexInSortedList;
        } else {
            index = list.locationToIndex(p);
            if (index != -1 && index == list.getModel().getSize() - 1 && !list.getCellBounds(index, index).contains(p)) {
                ++index;
            }
        }
        return index;
    }

    private void insertInTarget(JList target, int index) {
        if (this.ivDragSource != null) {
            if (this.ivDragSource == target && this.ivDragSource == this.ivSortedSourceList) {
                return;
            }
            ListModel model = this.ivDragSource.getModel();
            int anz = this.ivDragSource.getModel().getSize();
            Vector changedSource = new Vector(anz);
            int i = 0;
            while (i < anz) {
                changedSource.add(model.getElementAt(i));
                ++i;
            }
            Vector items = new Vector();
            int i2 = 0;
            while (i2 < this.ivDragSourceIndices.length) {
                items.addElement(model.getElementAt(this.ivDragSourceIndices[i2]));
                changedSource.setElementAt(NULLER, this.ivDragSourceIndices[i2]);
                ++i2;
            }
            int size = target.getModel().getSize();
            Vector sammel = new Vector(size + items.size());
            int i3 = 0;
            while (i3 < size) {
                if (i3 == index) {
                    sammel.addAll(items);
                    items.clear();
                }
                if (this.ivDragSource != target) {
                    sammel.add(target.getModel().getElementAt(i3));
                } else {
                    sammel.add(changedSource.elementAt(i3));
                }
                ++i3;
            }
            sammel.addAll(items);
            target.setListData(DNDHandler.removeNULLER(sammel));
            if (target != this.ivDragSource) {
                this.ivDragSource.setListData(DNDHandler.removeNULLER(changedSource));
            }
        }
    }

    private static Vector removeNULLER(Vector in) {
        Vector sammel = new Vector();
        Iterator iter = in.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj == NULLER) continue;
            sammel.addElement(obj);
        }
        return sammel;
    }

    private static void setRendererIndex(JList list, int index) {
        SpecRenderer sr;
        ListCellRenderer lce;
        if (list != null && (lce = list.getCellRenderer()) instanceof SpecRenderer && (sr = (SpecRenderer)lce) != null && sr.ivIndex != index) {
            sr.ivIndex = index;
            list.repaint();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        JList list;
        if (!e.getValueIsAdjusting() && (list = (JList)e.getSource()).getSelectedIndex() != -1) {
            this.ivDragSource = list;
            this.ivDragSourceIndices = this.ivDragSource.getSelectedIndices();
            this.ivIndexInSortedList = list == this.ivSortedSourceList ? -1 : this.determineIndexInSortedList(this.ivDragSource, this.ivDragSourceIndices);
        }
    }

    public void dragEnter(DropTargetDragEvent dte) {
    }

    public void dragExit(DropTargetEvent dte) {
        DNDHandler.setRendererIndex((JList)dte.getDropTargetContext().getComponent(), -1);
    }

    public void dragOver(DropTargetDragEvent dtde) {
        JList list = (JList)dtde.getDropTargetContext().getComponent();
        if (list == this.ivSortedSourceList && this.ivDragSource == this.ivSortedSourceList) {
            DNDHandler.setRendererIndex(this.ivSortedSourceList, -1);
            int i = 0;
            while (i < this.ivUnsortedTargetLists.length) {
                DNDHandler.setRendererIndex(this.ivUnsortedTargetLists[i], -1);
                ++i;
            }
        } else {
            int index = this.getIndex(list, dtde.getLocation());
            DNDHandler.setRendererIndex(list, index);
            list.ensureIndexIsVisible(index + 1);
            list.ensureIndexIsVisible(index - 1);
        }
    }

    public void drop(DropTargetDropEvent e) {
        try {
            Transferable tr = e.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                e.acceptDrop(3);
                JList list = (JList)e.getDropTargetContext().getComponent();
                this.insertInTarget(list, this.getIndex(list, e.getLocation()));
                e.getDropTargetContext().dropComplete(true);
                DNDHandler.setRendererIndex(this.ivSortedSourceList, -1);
                int i = 0;
                while (i < this.ivUnsortedTargetLists.length) {
                    DNDHandler.setRendererIndex(this.ivUnsortedTargetLists[i], -1);
                    ++i;
                }
                if (this.ivActionListener != null) {
                    this.ivActionListener.actionPerformed(new ActionEvent(list, 1, "DND"));
                }
                this.ivDragSource = null;
                this.ivDragSourceIndices = null;
                this.ivIndexInSortedList = -1;
            } else {
                e.rejectDrop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        System.out.println("HALLO");
    }

    private class SpecRenderer
    implements ListCellRenderer {
        private final ListCellRenderer ivPrimaerRenderer;
        public int ivIndex = -1;

        public SpecRenderer(ListCellRenderer primRenderer) {
            this.ivPrimaerRenderer = primRenderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = this.ivPrimaerRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (c instanceof JComponent) {
                JComponent comp = (JComponent)c;
                if (index == this.ivIndex) {
                    comp.setBorder(new MatteBorder(2, 0, 0, 0, Color.black));
                } else if (index == list.getModel().getSize() - 1 && index == this.ivIndex - 1) {
                    comp.setBorder(new MatteBorder(0, 0, 2, 0, Color.black));
                } else {
                    comp.setBorder(null);
                }
            }
            return c;
        }
    }
}

