/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui.documents;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import mausoleum.gui.KomfortTextField;

public class DoubleDocument
extends PlainDocument {
    private static final long serialVersionUID = 1L;
    private final JTextField ivTextField;

    public DoubleDocument(JTextField df) {
        this.ivTextField = df;
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.ivTextField.hasFocus()) {
            super.insertString(offs, str, a);
            return;
        }
        int newOff = offs;
        StringBuffer sb = new StringBuffer();
        String currText = "";
        if (this.ivTextField != null) {
            currText = this.ivTextField.getText();
        }
        char[] source = str.toCharArray();
        int i = 0;
        while (i < source.length) {
            int changed = this.add(currText, source[i], sb);
            if (changed != 0) {
                currText = this.ivTextField.getText();
                newOff += changed;
            }
            ++i;
        }
        super.insertString(newOff, sb.toString(), a);
    }

    private int add(String old, char c, StringBuffer sb) {
        int changed = 0;
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (old.length() > 0 && old.charAt(0) == '-' && this.ivTextField.getCaretPosition() == 0) break;
                sb.append(c);
                break;
            }
            case ',': 
            case '.': {
                if (c != KomfortTextField.cvDecTrennerChar || old.length() > 0 && old.charAt(0) == '-' && this.ivTextField.getCaretPosition() == 0 || sb.toString().indexOf(c) >= 0 || old.indexOf(c) >= 0) break;
                if (sb.length() == 0 && old.length() == 0 || old.length() == 0 && sb.length() == 1 && sb.charAt(0) == '-' || sb.length() == 0 && old.length() == 1 && old.charAt(0) == '-') {
                    sb.append("0");
                }
                sb.append(c);
                break;
            }
            case '-': {
                if (sb.length() != 0 && sb.charAt(0) == '-' || old.length() != 0 && old.charAt(0) == '-') break;
                if (old.length() == 0) {
                    sb.insert(0, "-");
                    break;
                }
                old = "-" + old;
                int cursPos = this.ivTextField.getCaretPosition();
                this.ivTextField.setText(old);
                this.ivTextField.setCaretPosition(cursPos + 1);
                changed = 1;
                break;
            }
            case '+': {
                if ((sb.length() <= 0 || sb.charAt(0) != '-') && (old.length() <= 0 || old.charAt(0) != '-')) break;
                if (old.length() == 0) {
                    sb.deleteCharAt(0);
                    break;
                }
                old = old.substring(1);
                int cursPos = this.ivTextField.getCaretPosition();
                this.ivTextField.setText(old);
                if (--cursPos < 0) {
                    cursPos = 0;
                }
                this.ivTextField.setCaretPosition(cursPos);
                changed = -1;
            }
        }
        return changed;
    }
}

