/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.helper;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JComboBox;
import mausoleum.main.DefaultManager;

public abstract class DatumFormat {
    public static final int DATE_MODE_EUROPEAN = 1;
    public static final int DATE_MODE_AMERICAN = 2;
    public static final int DATE_MODE_REVERS = 3;
    public static final int DATE_MODE_AMERICAN_SLASH = 4;
    public static String[] SEL_COMBO_STRINGS = new String[]{"13. Aug 1876", "Aug 13, 1876", "1876 Aug 13", "8/13/1876"};
    public static final int[] SEL_COMBO_VALS = new int[]{1, 2, 3, 4};
    private static final String[] MONTHS_SHORT = new String[]{"JANUARY_S", "FEBRUARY_S", "MARCH_S", "APRIL_S", "MAY_S", "JUNE_S", "JULY_S", "AUGUST_S", "SEPTEMBER_S", "OCTOBER_S", "NOVEMBER_S", "DECEMBER_S"};
    private static final String[] MONTHS_BIG = new String[]{"JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER"};
    private static final String[] WEEKDAYS_SHORT = new String[]{"WDMO", "WDTU", "WDWE", "WDTH", "WDFR", "WDSA", "WDSU"};
    private static final String[] KLEINE = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09"};

    public static void adjustCombo(int val, JComboBox box) {
        int i = 0;
        while (i < SEL_COMBO_VALS.length) {
            if (SEL_COMBO_VALS[i] == val) {
                box.setSelectedIndex(i);
                return;
            }
            ++i;
        }
        box.setSelectedIndex(0);
    }

    public static String getJustDateString(long millis) {
        return DatumFormat.getJustDateString(MyDate.getMyDate(millis));
    }

    public static String getJustDateString(Date date) {
        return DatumFormat.getJustDateString(MyDate.getMyDate(date.getTime()));
    }

    public static String getJustDateString(int tage) {
        return DatumFormat.getJustDateString(tage, true);
    }

    public static String getJustDateString(int tage, boolean shortMonth) {
        if (tage == Integer.MIN_VALUE) {
            return "";
        }
        String babel = StringHelper.getStringForInt(tage, MyDate.VARS, MyDate.VAR_BABELS, true, null);
        if (babel != null) {
            return babel;
        }
        return DatumFormat.getJustDateString(new MyDate(tage), shortMonth);
    }

    public static String getJustDayMonthString(long millis) {
        return DatumFormat.getJustDayMonthString(MyDate.getMyDate(millis));
    }

    public static String getJustDayMonthString(int tage) {
        return DatumFormat.getJustDayMonthString(new MyDate(tage));
    }

    public static final String getJustDateString(MyDate dat) {
        return DatumFormat.getJustDateString(dat, true);
    }

    public static final String getJustDateString(MyDate dat, boolean shortMonth) {
        int monat = dat.ivMonat - 1;
        switch (DefaultManager.getDatumFormat()) {
            case 2: {
                return String.valueOf(DatumFormat.monthString(monat, shortMonth)) + " " + dat.ivTag + ", " + dat.ivJahr;
            }
            case 3: {
                return String.valueOf(dat.ivJahr) + " " + DatumFormat.monthString(monat, shortMonth) + " " + dat.ivTag;
            }
            case 4: {
                return String.valueOf(dat.ivMonat) + "/" + dat.ivTag + "/" + dat.ivJahr;
            }
        }
        return String.valueOf(dat.ivTag) + ". " + DatumFormat.monthString(monat, shortMonth) + " " + dat.ivJahr;
    }

    public static final String getReportDate(int tage, String lang) {
        MyDate dat = new MyDate(tage);
        return String.valueOf(dat.ivTag) + ". " + DatumFormat.monthShort(dat.ivMonat - 1) + " " + dat.ivJahr;
    }

    public static String monthString(int monat, boolean shortMonth) {
        return shortMonth ? DatumFormat.monthShort(monat) : DatumFormat.monthBig(monat);
    }

    public static String monthShort(int monat) {
        return Babel.get(MONTHS_SHORT[monat]);
    }

    public static String monthShort(int monat, String lang) {
        return Babel.get(MONTHS_SHORT[monat], lang);
    }

    public static String monthBig(int monat) {
        return Babel.get(MONTHS_BIG[monat]);
    }

    public static String[] getBigMonths() {
        String[] arr = new String[MONTHS_BIG.length];
        int i = 0;
        while (i < arr.length) {
            arr[i] = DatumFormat.monthBig(i);
            ++i;
        }
        return arr;
    }

    public static String weekday(int wota) {
        return Babel.get(WEEKDAYS_SHORT[wota]);
    }

    public static final String getJustDateString(GregorianCalendar gc) {
        switch (DefaultManager.getDatumFormat()) {
            case 2: {
                return String.valueOf(DatumFormat.monthShort(gc.get(2))) + " " + gc.get(5) + ", " + gc.get(1);
            }
            case 3: {
                return String.valueOf(gc.get(1)) + " " + DatumFormat.monthShort(gc.get(2)) + " " + gc.get(5);
            }
            case 4: {
                return String.valueOf(gc.get(2) + 1) + "/" + gc.get(5) + "/" + gc.get(1);
            }
        }
        return String.valueOf(gc.get(5)) + ". " + DatumFormat.monthShort(gc.get(2)) + " " + gc.get(1);
    }

    public static final String getJustDayMonthString(MyDate dat) {
        switch (DefaultManager.getDatumFormat()) {
            case 2: {
                return String.valueOf(DatumFormat.monthShort(dat.ivMonat - 1)) + " " + dat.ivTag;
            }
            case 4: {
                return String.valueOf(dat.ivMonat) + "/" + dat.ivTag;
            }
            case 3: {
                return String.valueOf(DatumFormat.monthShort(dat.ivMonat - 1)) + " " + dat.ivTag;
            }
        }
        return String.valueOf(dat.ivTag) + ". " + DatumFormat.monthShort(dat.ivMonat - 1);
    }

    public static String getVeryShortDateString(Date date) {
        return DatumFormat.getVeryShortDateString(MyDate.getMyDate(date.getTime()));
    }

    public static String getVeryShortDateString(int datum) {
        return DatumFormat.getVeryShortDateString(new MyDate(datum));
    }

    public static final String getVeryShortDateString(MyDate dat) {
        return DatumFormat.getVeryShortDateString(dat.ivTag, dat.ivMonat, dat.ivJahr);
    }

    public static final String getVeryShortDateString(int tag, int monat, int ijahr) {
        String jahr = Integer.toString(ijahr % 100);
        if (jahr.length() == 1) {
            jahr = "0" + jahr;
        }
        switch (DefaultManager.getDatumFormat()) {
            case 2: {
                return String.valueOf(monat) + " " + tag + ", " + jahr;
            }
            case 3: {
                return String.valueOf(jahr) + " " + monat + " " + tag;
            }
            case 4: {
                return String.valueOf(monat) + "/" + tag + "/" + jahr;
            }
        }
        return String.valueOf(tag) + "." + monat + "." + jahr;
    }

    public static final String getVeryShortDateString(int tag, int monat) {
        switch (DefaultManager.getDatumFormat()) {
            case 2: {
                return String.valueOf(monat) + " " + tag;
            }
            case 3: {
                return String.valueOf(monat) + " " + tag;
            }
            case 4: {
                return String.valueOf(monat) + "/" + tag;
            }
        }
        return String.valueOf(tag) + "." + monat + ".";
    }

    public static final String getWeekDayMonthString(MyDate dat) {
        int wota = MyDate.getWochentag(MyDate.getTage(dat.ivTag, dat.ivMonat, dat.ivJahr));
        return DatumFormat.getWeekDayMonthString(dat, wota);
    }

    public static final String getWeekDayMonthString(int tage, int wota) {
        return DatumFormat.getWeekDayMonthString(new MyDate(tage), wota);
    }

    public static final String getWeekDayMonthString(MyDate dat, int wota) {
        switch (DefaultManager.getDatumFormat()) {
            case 2: {
                return String.valueOf(DatumFormat.weekday(wota)) + " " + DatumFormat.monthShort(dat.ivMonat - 1) + " " + dat.ivTag;
            }
            case 4: {
                return String.valueOf(DatumFormat.weekday(wota)) + " " + dat.ivMonat + "/" + dat.ivTag;
            }
            case 3: {
                return String.valueOf(DatumFormat.weekday(wota)) + " " + DatumFormat.monthShort(dat.ivMonat - 1) + " " + dat.ivTag;
            }
        }
        return String.valueOf(DatumFormat.weekday(wota)) + " " + dat.ivTag + ". " + DatumFormat.monthShort(dat.ivMonat - 1);
    }

    public static String getDateTimeString(String milliString, String defVal) {
        if (milliString.length() != 0) {
            try {
                return DatumFormat.getDateTimeString(Long.parseLong(milliString));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defVal;
    }

    public static String getJustDateString(String milliString, String defVal) {
        if (milliString.length() != 0) {
            try {
                return DatumFormat.getJustDateString(MyDate.getMyDate(Long.parseLong(milliString)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defVal;
    }

    public static String getDateTimeString() {
        return DatumFormat.getDateTimeString(System.currentTimeMillis());
    }

    public static String getDateTimeString(long millis) {
        GregorianCalendar greg = new GregorianCalendar();
        greg.setTimeInMillis(millis);
        return DatumFormat.getDateTimeString(greg);
    }

    public static String getDateTimeString(MyDate dat) {
        StringBuilder msb = new StringBuilder();
        msb.append(DatumFormat.getJustDateString(dat)).append(" ").append(DatumFormat.getTimeString(dat));
        return msb.toString();
    }

    public static String getDateTimeString(GregorianCalendar gc) {
        StringBuilder msb = new StringBuilder();
        msb.append(DatumFormat.getJustDateString(gc)).append(" ").append(DatumFormat.getTimeString(gc));
        return msb.toString();
    }

    public static String getDateTimeString(GregorianCalendar gc, boolean set) {
        gc.setTimeInMillis(System.currentTimeMillis());
        StringBuilder msb = new StringBuilder();
        msb.append(DatumFormat.getJustDateString(gc)).append(" ").append(DatumFormat.getTimeString(gc));
        return msb.toString();
    }

    public static String getTimeString(long millis) {
        return DatumFormat.getTimeString(new GregorianCalendar(), millis);
    }

    public static String getTimeString(MyDate dat) {
        StringBuilder msb = new StringBuilder();
        msb.append(DatumFormat.getDDString(dat.ivStunde)).append(":");
        msb.append(DatumFormat.getDDString(dat.ivMinute)).append(":");
        msb.append(DatumFormat.getDDString(dat.ivSekunde));
        return msb.toString();
    }

    public static String getProtDateTimeString(MyDate dat) {
        StringBuilder msb = new StringBuilder();
        msb.append(DatumFormat.getDDString(dat.ivTag)).append(".");
        msb.append(DatumFormat.getDDString(dat.ivMonat)).append(".");
        msb.append(dat.ivJahr).append(" ");
        msb.append(DatumFormat.getDDString(dat.ivStunde)).append(":");
        msb.append(DatumFormat.getDDString(dat.ivMinute)).append(":");
        msb.append(DatumFormat.getDDString(dat.ivSekunde));
        return msb.toString();
    }

    public static String getTimeString(GregorianCalendar gc) {
        StringBuilder msb = new StringBuilder();
        msb.append(DatumFormat.getDDString(gc.get(11))).append(":");
        msb.append(DatumFormat.getDDString(gc.get(12))).append(":");
        msb.append(DatumFormat.getDDString(gc.get(13)));
        return msb.toString();
    }

    public static String getTimeString(GregorianCalendar gc, long millis) {
        gc.setTimeInMillis(millis);
        return DatumFormat.getTimeString(gc);
    }

    public static String getISOStringDate(GregorianCalendar gc) {
        StringBuilder msb = new StringBuilder();
        msb.append(gc.get(1)).append("-");
        msb.append(DatumFormat.getDDString(gc.get(2) + 1)).append("-");
        msb.append(DatumFormat.getDDString(gc.get(5)));
        return msb.toString();
    }

    public static String getBackupDateTimeString(GregorianCalendar gc) {
        StringBuilder msb = new StringBuilder();
        msb.append(DatumFormat.getDDString(gc.get(5))).append("-");
        msb.append(DatumFormat.getDDString(gc.get(2) + 1)).append("-");
        msb.append(gc.get(1)).append("_");
        msb.append(DatumFormat.getDDString(gc.get(11))).append("_");
        msb.append(DatumFormat.getDDString(gc.get(12))).append("_");
        msb.append(DatumFormat.getDDString(gc.get(13)));
        return msb.toString();
    }

    private static String getDDString(int num) {
        if (num < 10) {
            return KLEINE[num];
        }
        return Integer.toString(num);
    }

    public static String getDurationString(long start, long end) {
        if (start == -1L && end == -1L) {
            return "unknown - unknown";
        }
        if (start == -1L) {
            return "unknown - " + DatumFormat.getDateTimeString(end);
        }
        if (end == -1L) {
            return String.valueOf(DatumFormat.getDateTimeString(start)) + " - unknown";
        }
        GregorianCalendar greg = new GregorianCalendar();
        greg.setTimeInMillis(start);
        MyDate sdat = new MyDate(greg);
        greg.setTimeInMillis(end);
        MyDate edat = new MyDate(greg);
        if (MyDate.sameDay(sdat, edat)) {
            StringBuilder msb = new StringBuilder();
            msb.append(DatumFormat.getJustDateString(sdat)).append(" ");
            msb.append(DatumFormat.getTimeString(sdat)).append(" - ");
            msb.append(DatumFormat.getTimeString(edat));
            return msb.toString();
        }
        return String.valueOf(DatumFormat.getDateTimeString(start)) + " - " + DatumFormat.getDateTimeString(end);
    }
}

