/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.helper;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.MyDate;

public abstract class DatumsFormat {
    private static final Object[] MONATSNAMEN = new Object[]{new String[]{"1", "01", "Jan", "Januar", "January"}, new String[]{"2", "02", "Feb", "Februar", "February"}, new String[]{"3", "03", "Mar", "M\u00e4r", "Mrz", "M\u00e4rz", "March"}, new String[]{"4", "04", "Apr", "April"}, new String[]{"5", "05", "Mai", "May"}, new String[]{"6", "06", "Jun", "Juni", "June"}, new String[]{"7", "07", "Jul", "Juli", "July"}, new String[]{"8", "08", "Aug", "August"}, new String[]{"9", "09", "Sep", "September"}, new String[]{"10", "Okt", "Oktober", "Oct", "October"}, new String[]{"11", "Nov", "November"}, new String[]{"12", "Dez", "Dezember", "Dec", "December"}};

    public static int getDatum(String s, int defVal) {
        try {
            return DatumsFormat.getDatum(s);
        }
        catch (Throwable throwable) {
            return defVal;
        }
    }

    public static int getDatum(String s) {
        if (s != null) {
            s = s.trim();
            s = StringHelper.gSub(s, "/", ".", true);
            s = StringHelper.gSub(s, ".", ". ", true);
            int tag = 0;
            int monat = 0;
            int jahr = 0;
            int ind1 = s.indexOf(".");
            if (ind1 != -1) {
                String tags = s.substring(0, ind1).trim();
                tag = DatumsFormat.getTag(tags);
                int spind = (s = s.substring(ind1 + 1, s.length()).trim()).lastIndexOf(" ");
                if (spind != -1) {
                    String jahrString = s.substring(spind, s.length()).trim();
                    jahr = DatumsFormat.getJahr(jahrString);
                    String monatsString = s.substring(0, spind).trim();
                    monatsString = StringHelper.gSub(monatsString, ".", "", true);
                    monat = DatumsFormat.getMonat(monatsString);
                }
                if (tag != -1 && monat != -1 && jahr != -1 && MyDate.isTagExistent(tag, monat, jahr)) {
                    return MyDate.getTage(tag, monat, jahr);
                }
            }
        }
        throw new IllegalArgumentException("Invalid Dateformat");
    }

    public static int getMonat(String s) {
        if (s != null) {
            s = s.trim();
            int i = 0;
            while (i < MONATSNAMEN.length) {
                String[] arr = (String[])MONATSNAMEN[i];
                int j = 0;
                while (j < arr.length) {
                    if (arr[j].equalsIgnoreCase(s)) {
                        return i + 1;
                    }
                    ++j;
                }
                ++i;
            }
        }
        throw new IllegalArgumentException("Invalid Dateformat");
    }

    public static int getTag(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Invalid Dateformat");
        }
        if (s.length() == 2 && s.startsWith("0")) {
            s = s.substring(1, s.length());
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid Dateformat");
        }
    }

    public static int getJahr(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Invalid Dateformat");
        }
        if (s.length() == 4) {
            try {
                return Integer.parseInt(s);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid Dateformat");
            }
        }
        if (s.length() == 2) {
            if (s.startsWith("0")) {
                s = s.substring(1, s.length());
            }
            try {
                int jahr = Integer.parseInt(s);
                jahr = jahr > 60 ? (jahr += 1900) : (jahr += 2000);
                return jahr;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid Dateformat");
            }
        }
        throw new IllegalArgumentException("Invalid Dateformat");
    }
}

