/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.helper;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.MyDate;

public abstract class DatumsParser {
    private static final Object[] MONATSNAMEN = new Object[]{new String[]{"1", "01", "Jan", "Januar", "January"}, new String[]{"2", "02", "Feb", "Februar", "February"}, new String[]{"3", "03", "Mar", "M\u00e4r", "Mrz", "M\u00e4rz", "March"}, new String[]{"4", "04", "Apr", "April"}, new String[]{"5", "05", "Mai", "May"}, new String[]{"6", "06", "Jun", "Juni", "June"}, new String[]{"7", "07", "Jul", "Juli", "July"}, new String[]{"8", "08", "Aug", "August"}, new String[]{"9", "09", "Sep", "September"}, new String[]{"10", "Okt", "Oktober", "Oct", "October"}, new String[]{"11", "Nov", "November"}, new String[]{"12", "Dez", "Dezember", "Dec", "December"}};

    public static int getDatum(String s, int defVal) {
        try {
            return DatumsParser.getDatum(s);
        }
        catch (Exception exception) {
            return defVal;
        }
    }

    public static int getDatum(String s) {
        if (s != null) {
            s = s.trim();
            s = StringHelper.gSub(s, "/", ".", true);
            s = StringHelper.gSub(s, ".", ". ", true);
            int tag = 0;
            int monat = 0;
            int jahr = 0;
            int ind1 = s.indexOf(".");
            if (ind1 != -1) {
                String tags = s.substring(0, ind1).trim();
                if (tags.length() == 2 && tags.startsWith("0")) {
                    tags = tags.substring(1, tags.length());
                }
                try {
                    tag = Integer.parseInt(tags);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid Dateformat");
                }
                s = s.substring(ind1 + 1, s.length()).trim();
                int spind = s.lastIndexOf(" ");
                if (spind != -1) {
                    String jahrString = s.substring(spind, s.length()).trim();
                    if (jahrString.length() == 4) {
                        try {
                            jahr = Integer.parseInt(jahrString);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Invalid Dateformat");
                        }
                    } else if (jahrString.length() == 2) {
                        if (jahrString.startsWith("0")) {
                            jahrString = jahrString.substring(1, jahrString.length());
                        }
                        try {
                            jahr = Integer.parseInt(jahrString);
                            if (jahr > 60) {
                                jahr += 1900;
                            }
                            jahr += 2000;
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Invalid Dateformat");
                        }
                    } else {
                        throw new IllegalArgumentException("Invalid Dateformat");
                    }
                }
                String monatsString = s.substring(0, spind).trim();
                monatsString = StringHelper.gSub(monatsString, ".", "", true);
                monat = DatumsParser.getMonat(monatsString);
                if (tag != -1 && monat != -1 && jahr != -1 && MyDate.isTagExistent(tag, monat, jahr)) {
                    return MyDate.getTage(tag, monat, jahr);
                }
            }
        }
        throw new IllegalArgumentException("Invalid Dateformat");
    }

    private static int getMonat(String s) {
        if (s != null) {
            s = s.trim();
            int i = 0;
            while (i < MONATSNAMEN.length) {
                String[] arr = (String[])MONATSNAMEN[i];
                int j = 0;
                while (j < arr.length) {
                    if (arr[j].equalsIgnoreCase(s)) {
                        return i + 1;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return -1;
    }
}

