/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.helper;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.line.Line;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;

public class GenotypeHelper {
    public static String getAutoGenotypeCommandString(long targetLineID, Mouse father, Mouse mother, String defaultVal) {
        if (DefaultManager.getAutoGenotype() && targetLineID != 0L && father != null && mother != null) {
            Line line;
            Vector<Mouse> parents = new Vector<Mouse>();
            parents.add(father);
            parents.add(mother);
            String group = IDObject.commonGroup(parents);
            if (group != null && (line = (Line)ObjectStore.getClientObject(7, targetLineID, group)) != null && line.getBoolean("LIN_AUTOGTOK", true)) {
                StringBuffer msb = new StringBuffer();
                HashSet locusIDs = line.getLocusIDs();
                Iterator iter = locusIDs.iterator();
                while (iter.hasNext()) {
                    Long longi = (Long)iter.next();
                    long locusID = longi;
                    Locus locus = (Locus)ObjectStore.getClientObject(14, locusID, group);
                    if (locus == null || !locus.getBoolean("LOC_AUTOGTOK", true) || !locus.isAutosomal()) continue;
                    String mall = GenotypeHelper.getHomozygousAllel(mother, locusID, false);
                    String fall = GenotypeHelper.getHomozygousAllel(father, locusID, false);
                    if (mall == null || fall == null) continue;
                    String[] nalls = new String[]{mall, fall};
                    LocusAndAlleles tlal = new LocusAndAlleles(locusID, nalls);
                    if (msb.length() != 0) {
                        msb.append("|");
                    }
                    msb.append(Base64Manager.encodeBase64(tlal.getTransportString()));
                }
                if (msb.length() != 0) {
                    return msb.toString();
                }
            }
        }
        return defaultVal;
    }

    private static String getHomozygousAllel(Mouse mouse, long locusID, boolean sexChromosomalAllowed) {
        Line line = mouse.getLine();
        if (line != null) {
            Locus locus = (Locus)ObjectStore.getClientObject(14, locusID, mouse.getGroup());
            if (line.isBreeder()) {
                if (locus != null) {
                    return locus.getWTString();
                }
            } else if (line.isLocusContained(locusID)) {
                LocusAndAlleles[] lalarr = (LocusAndAlleles[])mouse.get("MOS_LOCUSGENOTYPES");
                if (lalarr != null) {
                    int i = 0;
                    while (i < lalarr.length) {
                        if (lalarr[i].ivLocusID == locusID) {
                            if (lalarr[i].ivAllele.length == 1 && sexChromosomalAllowed) {
                                return lalarr[i].ivAllele[0];
                            }
                            if (lalarr[i].ivAllele.length == 2 && lalarr[i].ivAllele[0] != null && lalarr[i].ivAllele[0].equals(lalarr[i].ivAllele[1])) {
                                return lalarr[i].ivAllele[0];
                            }
                        }
                        ++i;
                    }
                }
            } else if (locus != null) {
                return locus.getWTString();
            }
        }
        return null;
    }
}

