/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.helper;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;

public class ImageCreator
implements ImageObserver {
    private boolean ivImageDone = false;
    private int ivWidth = -2;
    private int ivHeight = -2;

    public static Image loadImage(String filename) {
        return new ImageCreator().doLoadImage(filename);
    }

    public static int getWidth(Image i) {
        return new ImageCreator().doGetWidth(i);
    }

    public static int getHeight(Image i) {
        return new ImageCreator().doGetWidth(i);
    }

    public static Image getScaledInstance(Image i, int w, int h, int tip) {
        return new ImageCreator().doGetScaledInstance(i, w, h, tip);
    }

    public static Image createImageFromThumb(int[] data, int w, int h) {
        return new ImageCreator().doCreateImageFromThumb(data, w, h);
    }

    public static Image createImageFromBytes(byte[] arr, int w, int h) {
        return new ImageCreator().doCreateImageFromBytes(arr, w, h);
    }

    private synchronized Image doGetScaledInstance(Image i, int w, int h, int tip) {
        Image res = i.getScaledInstance(w, h, tip);
        Toolkit.getDefaultToolkit().prepareImage(res, -1, -1, this);
        while (!this.ivImageDone) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return res;
    }

    private synchronized int doGetWidth(Image i) {
        i.getWidth(this);
        while (!this.ivImageDone) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.ivWidth;
    }

    public synchronized int doGetHeight(Image i) {
        i.getHeight(this);
        while (!this.ivImageDone) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.ivHeight;
    }

    private synchronized Image doLoadImage(String filename) {
        Image res = Toolkit.getDefaultToolkit().createImage(filename);
        Toolkit.getDefaultToolkit().prepareImage(res, -1, -1, this);
        while (!this.ivImageDone) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return res;
    }

    private synchronized Image doCreateImageFromBytes(byte[] arr, int w, int h) {
        Image res = Toolkit.getDefaultToolkit().createImage(arr);
        Toolkit.getDefaultToolkit().prepareImage(res, -1, -1, this);
        while (!this.ivImageDone) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return res;
    }

    private synchronized Image doCreateImageFromThumb(int[] data, int w, int h) {
        MemoryImageSource source = new MemoryImageSource(w, h, data, 0, w);
        Image res = Toolkit.getDefaultToolkit().createImage(source);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x20) != 0) {
            this.ivImageDone = true;
            this.ivWidth = width;
            this.ivHeight = height;
            ImageCreator imageCreator = this;
            synchronized (imageCreator) {
                this.notifyAll();
            }
            return false;
        }
        if ((infoflags & 0x80) != 0) {
            this.ivImageDone = true;
            this.ivWidth = -1;
            this.ivHeight = -1;
            ImageCreator imageCreator = this;
            synchronized (imageCreator) {
                this.notifyAll();
            }
            return false;
        }
        return true;
    }
}

