/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.helper;

import de.hannse.netobjects.tools.FileManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.ImageIcon;
import mausoleum.gui.ColorManager;
import mausoleum.helper.ImageProvider;
import mausoleum.main.DefaultManager;
import mausoleum.util.InstallationType;

public class MausoleumImageStore {
    private static final String ALL = "ALL";
    public static final String MARBLE = "MARBLE";
    public static final String PLAIN = "PLAIN";
    public static final String ROCK = "ROCK";
    public static final String[] DESIGNS = new String[]{"MARBLE", "ROCK", "PLAIN"};
    public static final String[] DESIGNSTRINGS = new String[]{"Marble", "Rock", "Plain"};
    private static final String START_IMAGE = "startMaus";
    private static final String LOGO_IMAGE = "logoImage";
    private static final String RING_IMAGE = "ringImage";
    private static final String POPE_IMAGE = "popeImage";
    public static final String BUTTON_YELLOW = "yellowButton";
    public static final String BUTTON_RED = "redButton";
    public static final String BUTTON_BLUE = "blueButton";
    public static final String BUTTON_GREEN = "greenButton";
    public static final String BUTTON_INSPECTOR = "inspectorButton";
    public static final String BACK_INSPECTOR = "inspectorBack";
    private static final String[] IMAGE_DICT = new String[]{"ALL", "logoImage", InstallationType.isMouse() ? "LOGO" : "FLOGO", "ALL", "ringImage", "RINGE", "ALL", "startMaus", InstallationType.isMouse() ? "KMAUS" : "KFISH", "ALL", "popeImage", "POPE", "MARBLE", "yellowButton", "B_GELB", "MARBLE", "redButton", "B_ROT", "MARBLE", "blueButton", "B_BLAU", "MARBLE", "greenButton", "B_GRUEN", "MARBLE", "inspectorButton", "INSPECTORBUTTON", "MARBLE", "inspectorBack", "BACK2", "ROCK", "yellowButton", "RB_GELB", "ROCK", "redButton", "RB_ROT", "ROCK", "blueButton", "RB_BLAU", "ROCK", "greenButton", "RB_GRUEN", "ROCK", "inspectorButton", "R_INSPECTORBUTTON", "ROCK", "inspectorBack", "R_BACK2"};
    private static final HashMap IMAGES = new HashMap(5);
    private static boolean cvWithoutImages = false;

    static {
        int i = 0;
        while (i < DESIGNS.length) {
            IMAGES.put(DESIGNS[i], new Hashtable(30));
            ++i;
        }
        i = 0;
        while (i < IMAGE_DICT.length) {
            String design = IMAGE_DICT[i];
            String key = IMAGE_DICT[i + 1];
            String filename = IMAGE_DICT[i + 2];
            Image img = MausoleumImageStore.getImageFromFile("images/" + filename + ".GIF");
            if (img != null) {
                if (design.equals(ALL)) {
                    Iterator iterator = IMAGES.values().iterator();
                    while (iterator.hasNext()) {
                        Hashtable ht = (Hashtable)iterator.next();
                        ht.put(key, img);
                    }
                } else {
                    Hashtable ht = (Hashtable)IMAGES.get(design);
                    if (ht != null) {
                        ht.put(key, img);
                    }
                }
            }
            i += 3;
        }
    }

    public static Image getLogo() {
        return MausoleumImageStore.getImage(LOGO_IMAGE);
    }

    public static Image getRinge() {
        return ImageProvider.scaleIfNecess(MausoleumImageStore.getImage(RING_IMAGE));
    }

    public static Image getPope() {
        return ImageProvider.scaleIfNecess(MausoleumImageStore.getImage(POPE_IMAGE));
    }

    public static Image getStartImage() {
        return ImageProvider.scaleIfNecess(MausoleumImageStore.getImage(START_IMAGE));
    }

    public static void fillDimWithImage(Graphics g, String imageKey, Dimension d) {
        if (cvWithoutImages) {
            return;
        }
        if (DefaultManager.getDesign().equals(PLAIN)) {
            Color c = ColorManager.getMausoColor(imageKey);
            if (c != null) {
                g.setColor(c);
                g.fillRect(0, 0, d.width, d.height);
            }
        } else {
            Image image = MausoleumImageStore.getImage(imageKey);
            if (image != null) {
                int w = image.getWidth(null);
                int h = image.getHeight(null);
                if (w > 0 && h > 0) {
                    int x = 0;
                    while (x < d.width) {
                        int y = 0;
                        while (y < d.height) {
                            g.drawImage(image, x, y, null);
                            y += h;
                        }
                        x += w;
                    }
                }
            }
        }
    }

    public static BufferedImage createBack(Rectangle r, String imageKey, double angle, double percent) {
        if (cvWithoutImages) {
            return null;
        }
        BufferedImage res = new BufferedImage(r.width, r.height, 1);
        Graphics g = res.getGraphics();
        while (g == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            g = res.getGraphics();
        }
        MausoleumImageStore.drawImage(g, imageKey, r, angle, percent);
        return res;
    }

    public static void drawImage(Graphics g, String imgKey, Rectangle r, double angle, double percent) {
        if (cvWithoutImages) {
            return;
        }
        if (imgKey != null) {
            if (DefaultManager.getDesign().equals(PLAIN)) {
                Color c = ColorManager.getMausoColor(imgKey);
                if (c != null) {
                    g.setColor(c);
                    g.fillRect(0, 0, r.width, r.height);
                }
            } else {
                Image img = MausoleumImageStore.getImage(imgKey);
                if (img != null) {
                    int bw = img.getWidth(null);
                    int bh = img.getHeight(null);
                    if (g instanceof Graphics2D) {
                        Graphics2D g2d = (Graphics2D)g;
                        double alpha = angle / 180.0 * Math.PI;
                        g2d.rotate(-alpha);
                        double si = Math.sin(alpha);
                        double co = Math.cos(alpha);
                        double startx = (double)r.height * si;
                        int breite = (int)((double)r.height * si + (double)r.width * co) + 1;
                        int hoehe = (int)((double)r.width * si + (double)r.height * co) + 1;
                        g2d.translate(-startx, 0.0);
                        int aktx = -((int)(percent * (double)bw));
                        while (aktx < breite) {
                            int akty = -((int)(percent * (double)bh));
                            while (akty < hoehe) {
                                g.drawImage(img, aktx, akty, null);
                                akty += bh;
                            }
                            aktx += bw;
                        }
                        g2d.translate(startx, 0.0);
                        g2d.rotate(alpha);
                    } else {
                        int startx = 0;
                        while (startx < r.width) {
                            int starty = 0;
                            while (starty < r.height) {
                                g.drawImage(img, startx, starty, null);
                                starty += bh;
                            }
                            startx += bw;
                        }
                    }
                }
            }
        }
    }

    public static String getDesignStringForDesign(String s) {
        int i = 0;
        while (i < DESIGNS.length) {
            if (DESIGNS[i].equals(s)) {
                return DESIGNSTRINGS[i];
            }
            ++i;
        }
        return DESIGNSTRINGS[0];
    }

    public static String getDesignForDesignString(String s) {
        int i = 0;
        while (i < DESIGNSTRINGS.length) {
            if (DESIGNSTRINGS[i].equals(s)) {
                return DESIGNS[i];
            }
            ++i;
        }
        return DESIGNS[0];
    }

    private static Image getImage(String key) {
        Hashtable ht = (Hashtable)IMAGES.get(DefaultManager.getDesign());
        if (ht == null && (ht = (Hashtable)IMAGES.get(PLAIN)) == null) {
            return null;
        }
        return (Image)ht.get(key);
    }

    private static Image getImageFromFile(String filename) {
        byte[] b = FileManager.getBytesFromFile(filename);
        if (b == null) {
            return null;
        }
        ImageIcon imig = new ImageIcon(b);
        while (imig.getIconHeight() <= 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return imig.getImage();
    }
}

