/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.helper;

import de.hannse.netobjects.tools.FileManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JWindow;
import mausoleum.helper.Zeile;

public abstract class WindowUtils {
    public static void bringUpFrame(JFrame frame) {
        if (frame != null) {
            if (frame.getState() != 0) {
                frame.setState(0);
            }
            frame.toFront();
            frame.setVisible(true);
        }
    }

    public static JFrame getJFrame(Component origC) {
        Component c = origC;
        while (c != null && !(c instanceof JFrame)) {
            c = c.getParent();
        }
        return (JFrame)c;
    }

    public static JFrame getJFrameAndSelectTabs(Component origC) {
        Component c = origC;
        while (c != null && !(c instanceof JFrame)) {
            Container container = c.getParent();
            if (container instanceof JTabbedPane) {
                JTabbedPane jtb = (JTabbedPane)container;
                jtb.setSelectedComponent(c);
            }
            c = container;
        }
        return (JFrame)c;
    }

    public static Window getWindow(Component origC) {
        Component c = origC;
        while (c != null && !(c instanceof Window)) {
            c = c.getParent();
        }
        return (Window)c;
    }

    public static JWindow getJWindow(Component origC) {
        Component c = origC;
        while (c != null && !(c instanceof JWindow)) {
            c = c.getParent();
        }
        return (JWindow)c;
    }

    public static JScrollPane getJScrollPane(Component origC) {
        Component c = origC;
        while (c != null && !(c instanceof JScrollPane)) {
            c = c.getParent();
        }
        return (JScrollPane)c;
    }

    public static JTabbedPane getJTabbedPane(Component origC) {
        Component c = origC;
        while (c != null && !(c instanceof JTabbedPane)) {
            c = c.getParent();
        }
        return (JTabbedPane)c;
    }

    public static Component getParent(Component origC, Class wantedClass) {
        Component c = origC;
        while (c != null && !wantedClass.isInstance(c)) {
            c = c.getParent();
        }
        return c;
    }

    public static JDialog getJDialog(Component origC) {
        Component c = origC;
        while (c != null && !(c instanceof JDialog)) {
            c = c.getParent();
        }
        return (JDialog)c;
    }

    public static Component findComponent(Class cl, Component origC) {
        Component c = origC;
        while (c != null && !c.getClass().equals(cl)) {
            c = c.getParent();
        }
        return c;
    }

    public static void rememberBounds(JFrame frame) {
        if (frame != null) {
            WindowUtils.rememberBounds(frame, frame.getBounds());
        }
    }

    public static void rememberBounds(JFrame frame, Rectangle r) {
        FileManager.prepareDirs("files/windows");
        String s = String.valueOf(r.x) + " " + r.y + " " + r.width + " " + r.height;
        FileManager.saveStringToFile("files/windows/" + frame.getClass().getName() + ".txt", s);
    }

    public static void rememberSettings(Object obj, String s) {
        FileManager.prepareDirs("files/windows");
        FileManager.saveStringToFile("files/windows/" + obj.getClass().getName() + ".txt", s);
    }

    public static String getSettings(Object obj) {
        return FileManager.getStringFromFile("files/windows/" + obj.getClass().getName() + ".txt");
    }

    public static void setRememberedBounds(JFrame frame, Rectangle defVal) {
        Rectangle soll = new Rectangle(defVal);
        String s = WindowUtils.getSettings(frame);
        if (s != null && s.trim().length() != 0) {
            try {
                Zeile z = new Zeile(s, ' ');
                soll.x = z.getInt(0, 0);
                soll.y = z.getInt(1, 0);
                soll.width = z.getInt(2, 0);
                soll.height = z.getInt(3, 0);
            }
            catch (Exception e) {
                soll = new Rectangle(defVal);
            }
        }
        if (soll.width <= 0) {
            soll.width = defVal.width;
        }
        if (soll.width <= 0) {
            soll.width = 200;
        }
        if (soll.height <= 0) {
            soll.height = defVal.height;
        }
        if (soll.height <= 0) {
            soll.height = 200;
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (soll.x > screen.width) {
            soll.x = screen.width - 100;
        }
        if (soll.y > screen.height) {
            soll.y = screen.height - 100;
        }
        if (soll.x + soll.width <= 50 && soll.width > 50) {
            soll.x = 50 - soll.width;
        }
        if (soll.y + soll.height <= 50 && soll.height > 50) {
            soll.y = 50 - soll.height;
        }
        frame.setBounds(soll);
    }

    public static void bringUpCenteredFrame(JFrame frame, int wantedInnerWidth, int wantedInnerHeight, boolean showIt) {
        frame.pack();
        Insets myInsets = frame.getInsets();
        WindowUtils.setSizeAndCenterOnScreen(frame, wantedInnerWidth + myInsets.left + myInsets.right, wantedInnerHeight + myInsets.top + myInsets.bottom);
        if (showIt) {
            frame.setVisible(true);
        }
    }

    public static void bringUpCenteredDialog(JDialog dialog, int wantedInnerWidth, int wantedInnerHeight, boolean showIt) {
        dialog.pack();
        Insets insets = dialog.getInsets();
        WindowUtils.setSizeAndCenterOnScreen(dialog, wantedInnerWidth + insets.left + insets.right, wantedInnerHeight + insets.top + insets.bottom);
        if (showIt) {
            dialog.setVisible(true);
        }
    }

    public static void setSizeAndCenterOnScreen(Component c, int outerWidth, int outerHeight) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (outerWidth > screen.width) {
            outerWidth = screen.width;
        }
        if (outerHeight > screen.height) {
            outerHeight = screen.height;
        }
        c.setSize(outerWidth, outerHeight);
        c.setLocation((screen.width - outerWidth) / 2, (screen.height - outerHeight) / 2);
    }
}

