/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.idobjectgroup;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectRequest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.CageManager;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.objectstore.AftermathObject;
import mausoleum.rack.frame.RackOverview;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableFrame;
import mausoleum.tables.TableFrameMouse;

public class IDObjectGroupManager
extends ObjectManager {
    public static IDObjectGroupManager cvInstance;
    private static final HashMap COHORTS;
    private static final HashMap OWNER_GROUPS;

    static {
        COHORTS = new HashMap();
        OWNER_GROUPS = new HashMap();
    }

    public static void init() {
        if (cvInstance == null) {
            cvInstance = new IDObjectGroupManager();
        }
    }

    public static void exit() {
        COHORTS.clear();
        OWNER_GROUPS.clear();
        cvInstance.dispose();
        cvInstance = null;
    }

    public static Vector getActualObjectsOfType(String group, int type) {
        Vector<IDObjectGroup> res = new Vector<IDObjectGroup>();
        Enumeration en = cvInstance.getActualObjectEnumeration(group);
        while (en.hasMoreElements()) {
            IDObjectGroup iog = (IDObjectGroup)en.nextElement();
            if (iog.getInt("IDO_SUBTYP", 0) != type) continue;
            res.add(iog);
        }
        return res;
    }

    public static boolean ownerGruppenDaOderUninteressant(int objectType, String commonGroup) {
        boolean gruppenDaOderUninteressant = true;
        if (objectType == 20) {
            gruppenDaOderUninteressant = cvInstance.hasActiveObjects(commonGroup, 1);
        }
        return gruppenDaOderUninteressant;
    }

    private IDObjectGroupManager() {
        super(19);
        this.distribute();
    }

    public void notifyConsumers(IDObject iob) {
        if (iob instanceof IDObjectGroup) {
            IDObjectGroup iog = (IDObjectGroup)iob;
            int subtyp = iog.getInt("IDO_SUBTYP", 0);
            if (subtyp == 2) {
                COHORTS.put(iog.getIdentifierString(), iog);
                if (TableFrameMouse.cvCohorts != null) {
                    TableFrameMouse.cvCohorts.ivModel.fillMainTable();
                }
            } else if (subtyp == 1) {
                OWNER_GROUPS.put(iog.getIdentifierString(), iog);
                MausoleumTable mt = (MausoleumTable)MausoleumTableFrame.MAIN_TABLES.get(new Integer(20));
                if (mt != null) {
                    mt.ivModel.fillMainTable();
                }
            }
        }
        super.notifyConsumers(iob);
    }

    private void distribute() {
        Enumeration en = this.getActualObjectEnumerationAllGroups();
        while (en.hasMoreElements()) {
            IDObjectGroup iog = (IDObjectGroup)en.nextElement();
            int subtyp = iog.getInt("IDO_SUBTYP", 0);
            if (subtyp == 2) {
                COHORTS.put(iog.getIdentifierString(), iog);
                continue;
            }
            if (subtyp != 1) continue;
            OWNER_GROUPS.put(iog.getIdentifierString(), iog);
        }
    }

    public Vector getAllCohorts() {
        Vector erg = new Vector();
        erg.addAll(COHORTS.values());
        return erg;
    }

    public Vector getAllOwnerGroups() {
        Vector erg = new Vector();
        erg.addAll(OWNER_GROUPS.values());
        return erg;
    }

    public boolean hasActiveObjects(String group, int subtype) {
        Enumeration en = this.getActualObjectEnumeration(group);
        while (en.hasMoreElements()) {
            IDObjectGroup iog = (IDObjectGroup)en.nextElement();
            if (!iog.isAliveAndVisible() || iog.getInt("IDO_SUBTYP", 0) != subtype) continue;
            return true;
        }
        return false;
    }

    public Vector getActiveObjects(String group, int subtype) {
        Vector<IDObjectGroup> erg = new Vector<IDObjectGroup>();
        Enumeration en = this.getActualObjectEnumeration(group);
        while (en.hasMoreElements()) {
            IDObjectGroup iog = (IDObjectGroup)en.nextElement();
            if (!iog.isAliveAndVisible() || iog.getInt("IDO_SUBTYP", 0) != subtype) continue;
            erg.add(iog);
        }
        return erg;
    }

    public void performObjectInsertionAftermath(ObjectRequest or, Vector sentObjects, AftermathObject aftermathObject) {
        super.performObjectInsertionAftermath(or, sentObjects, aftermathObject);
        if (ProcessDefinition.isClient() && MausoleumClient.cvManagerInitialized && sentObjects != null && !sentObjects.isEmpty()) {
            HashSet<String> groupsOfCohorts = new HashSet<String>();
            HashSet<String> groupsOfOwnerGroups = new HashSet<String>();
            Iterator iter = sentObjects.iterator();
            while (iter.hasNext()) {
                Object ooo = iter.next();
                if (!(ooo instanceof IDObjectGroup)) continue;
                IDObjectGroup iog = (IDObjectGroup)ooo;
                int subtyp = iog.getInt("IDO_SUBTYP", 0);
                if (subtyp == 2) {
                    groupsOfCohorts.add(iog.getGroup());
                }
                if (subtyp != 1) continue;
                groupsOfOwnerGroups.add(iog.getGroup());
            }
            if (!groupsOfOwnerGroups.isEmpty() && DefaultManager.getCageDisplayMode() == 2) {
                iter = groupsOfOwnerGroups.iterator();
                while (iter.hasNext()) {
                    String group = (String)iter.next();
                    CageManager.prepareSingleColorsOfAllCages(2, group);
                }
                aftermathObject.redrawRackFrame();
                RackOverview.cageColorModeChanged();
            }
        }
    }
}

