/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import mausoleum.alert.Alert;
import mausoleum.building.Building;
import mausoleum.building.BuildingManager;
import mausoleum.gui.BorderPanel;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.SensitiveTable;
import mausoleum.inspector.panels.AttributePane;
import mausoleum.inspector.panels.QuotaPane;
import mausoleum.inspector.sensitives.CSTextArea;
import mausoleum.inspector.sensitives.CSTextField;
import mausoleum.inspector.sensitives.CSTextFieldName;
import mausoleum.inspector.util.ActionBundleSimple;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.main.MausoleumClient;
import mausoleum.requester.TextRequester;
import mausoleum.room.Room;
import mausoleum.room.RoomManager;
import mausoleum.ui.MausoleumTextAreaUI;

public class InspectorPanelBuilding
extends InspectorPanel {
    private static final long serialVersionUID = 2948534710284070955L;
    public static Vector cvListeners = new Vector();
    public CSTextField ivNameField = new CSTextFieldName(this);
    private CSTextArea ivCommentField = new CSTextArea(this, "BLD_DESC");
    private JTextArea ivRoomField = null;

    public InspectorPanelBuilding() {
        super(22, "BUILDING");
        this.addTab(Babel.get("ATTRIBUTES"), new BuildingAttributePanel());
        if (MausoleumClient.isHeadOfService()) {
            this.addTab(Babel.get("QUOTA"), new QuotaPane());
        }
        this.addDocumentsTab("BLDG_ADD_DOC", "BLDG_REM_DOC", "BLDG_GET_DOC");
    }

    public ActionBundleSimple createActionBundle() {
        return null;
    }

    public boolean isSetAllowed() {
        return !this.ivSelObjects.isEmpty();
    }

    public boolean doNew(boolean withExecution) {
        String ns;
        boolean res;
        boolean bl = res = (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && Privileges.hasPrivilege("CREATE_BUILDING");
        if (res && withExecution && (ns = TextRequester.displayTextRequester(Inspector.getInspector(), Babel.get("NEW_BUILDING"))) != null) {
            if ((ns = ns.trim()).length() == 0) {
                Alert.showAlert(Babel.get("ALERTNOBLANKS"), true);
            } else {
                InspectorCommandSender.executeCommand("BLDGNEW " + Base64Manager.encodeBase64(ns), "service");
            }
        }
        return res;
    }

    public boolean doRemove(boolean withExecution) {
        Building ro;
        boolean res = false;
        if (MausoleumClient.isHeadOfService() && Privileges.hasPrivilege("REMOVE_BUILDING") && this.ivSelObjects.size() == 1 && !RoomManager.istEinRaumInGebaeude((ro = (Building)this.ivSelObjects.firstElement()).getID(), ro.getGroup())) {
            res = true;
        }
        if (res && withExecution && Alert.showAlert(Babel.get("ALERTWANTREMOVEBUILDINGS"), Babel.get("YES"), Babel.get("NO"), false)) {
            Building building = (Building)this.ivSelObjects.firstElement();
            if (RoomManager.istEinRaumInGebaeude(building.getID(), building.getGroup())) {
                Alert.showAlert(Babel.get("ALERTBUILDINGFULL"), true);
            } else {
                InspectorCommandSender.executeCommand("BLDGRM " + building.getID(), "service");
            }
        }
        return res;
    }

    public void passiviereFelder() {
        this.ivNameField.setToPassive();
        this.ivCommentField.setToPassive();
    }

    public void disableFields() {
        this.ivNameField.setToNonApplicable();
        this.ivCommentField.setToNonApplicable();
        this.ivRoomField.setText("");
        this.ivRoomField.setBackground(Color.lightGray);
    }

    public String getSetCommand(Vector changeSensitives, Vector idObjects) {
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < changeSensitives.size()) {
            if (changeSensitives.elementAt(i) == this.ivNameField) {
                String nname = this.ivNameField.getText().trim();
                if (nname.length() == 0) {
                    Alert.showAlert(Babel.get("EMPTY_NOT_ALLOWED"), true);
                    this.adjustToSelectionChange(this.ivActTable);
                    return null;
                }
                Vector v = BuildingManager.cvInstance.getActualObjectVector("service");
                boolean nameTaken = false;
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    Building building = (Building)iter.next();
                    if (!building.getName().equals(nname)) continue;
                    nameTaken = true;
                }
                if (nameTaken) {
                    Alert.showAlert(Babel.get("BUILDINGALREADYPRESENT"), true);
                    this.adjustToSelectionChange(this.ivActTable);
                    return null;
                }
                InspectorPanelBuilding.makeCommand("BLDGCHNAME", Base64Manager.encodeBase64(nname), 1, msb, idObjects);
            } else if (changeSensitives.elementAt(i) == this.ivCommentField) {
                InspectorPanelBuilding.makeCommand("BLDGCHCOMMENT", Base64Manager.encodeBase64(this.ivCommentField.getText()), 1, msb, idObjects);
            }
            ++i;
        }
        return msb.toString();
    }

    class BuildingAttributePanel
    extends AttributePane {
        private static final long serialVersionUID = 5067010713733060702L;
        private BorderPanel ivAP_Comment = null;
        private BorderPanel ivAP_Rooms = null;

        public BuildingAttributePanel() {
            InspectorPanelBuilding.this.ivSensitiveTable = new SensitiveTable(InspectorPanelBuilding.this.ivChangeSensitives);
            this.add(InspectorPanelBuilding.this.ivSensitiveTable);
            JPanel mp = new JPanel(new BorderLayout());
            mp.setOpaque(false);
            mp.add((Component)new JScrollPane(InspectorPanelBuilding.this.ivCommentField), "Center");
            this.ivAP_Comment = new BorderPanel(mp, Babel.get("DESCRIPTION"));
            this.add(this.ivAP_Comment);
            InspectorPanelBuilding.this.ivRoomField = new JTextArea();
            InspectorPanelBuilding.this.ivRoomField.setEnabled(false);
            InspectorPanelBuilding.this.ivRoomField.setEditable(false);
            InspectorPanelBuilding.this.ivRoomField.setFont(FontManager.getFont("SSB12"));
            InspectorPanelBuilding.this.ivRoomField.setDisabledTextColor(Color.black);
            InspectorPanelBuilding.this.ivRoomField.setMargin(new Insets(4, 4, 4, 4));
            if (InspectorPanelBuilding.this.ivRoomField.getUI() instanceof MausoleumTextAreaUI) {
                ((MausoleumTextAreaUI)InspectorPanelBuilding.this.ivRoomField.getUI()).setImageKey("inspectorBack");
            }
            JScrollPane jsp = new JScrollPane(InspectorPanelBuilding.this.ivRoomField);
            mp = new JPanel(new BorderLayout());
            mp.setOpaque(false);
            mp.add((Component)new JScrollPane(jsp), "Center");
            this.ivAP_Rooms = new BorderPanel(mp, Babel.get("ROOMS"));
            this.add(this.ivAP_Rooms);
        }

        public void layoutContainer(Container parent) {
            Dimension d = parent.getSize();
            int x = Inspector.INTER_BUT;
            int w = d.width - 2 * Inspector.INTER_BUT;
            int y = Inspector.INTER_BUT;
            int sh = InspectorPanelBuilding.this.ivSensitiveTable.getPreferredSize().height;
            InspectorPanelBuilding.this.ivSensitiveTable.setBounds(x, y, w, sh);
            int lw = (w - Inspector.INTER_BUT) / 2;
            int rw = w - Inspector.INTER_BUT - lw;
            int rh = d.height - 2 * Inspector.INTER_BUT - (y += sh + Inspector.RAND);
            this.ivAP_Comment.setBounds(x, y, lw, rh);
            this.ivAP_Rooms.setBounds(x + Inspector.INTER_BUT + lw, y, rw, rh);
        }

        public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
            super.adapt(idObjects, mice, changeSensitives);
            if (idObjects == null || idObjects.isEmpty()) {
                this.disableAllSensitives(InspectorPanelBuilding.this.ivChangeSensitives);
                InspectorPanelBuilding.this.ivRoomField.setText("");
                InspectorPanelBuilding.this.ivRoomField.setBackground(Color.lightGray);
            } else if (idObjects.size() == 1) {
                Building building = (Building)InspectorPanelBuilding.this.ivSelObjects.elementAt(0);
                InspectorPanelBuilding.this.ivNameField.setState(Privileges.hasPrivilege("BLDG_CH_NAME") && !building.isSharedWithOtherGroups());
                InspectorPanelBuilding.this.ivCommentField.setState(Privileges.hasPrivilege("BLDG_CH_DESCRIPRION") && !building.isSharedWithOtherGroups());
                long rid = building.getID();
                StringBuffer msb = new StringBuffer();
                Vector v = RoomManager.getRoomsInBuilding(rid);
                if (v != null) {
                    Collections.sort(v, IDObject.SORTER_BY_NAME);
                    Iterator iter = v.iterator();
                    while (iter.hasNext()) {
                        Room room = (Room)iter.next();
                        msb.append(room.getName()).append("\n");
                    }
                }
                InspectorPanelBuilding.this.ivRoomField.setText(msb.toString());
                InspectorPanelBuilding.this.ivRoomField.setBackground(Color.white);
            } else {
                this.disableAllSensitives(InspectorPanelBuilding.this.ivChangeSensitives);
                InspectorPanelBuilding.this.ivRoomField.setText("");
                InspectorPanelBuilding.this.ivRoomField.setBackground(Color.lightGray);
            }
        }
    }
}

