/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mausoleum.alert.Alert;
import mausoleum.experiment.Experiment;
import mausoleum.gui.BorderPanel;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorActionButton;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.SensitiveTable;
import mausoleum.inspector.actions.experiment.ExperimentAction;
import mausoleum.inspector.panels.AttributePane;
import mausoleum.inspector.panels.SimpleRequesterPane;
import mausoleum.inspector.sensitives.CSStringInfo;
import mausoleum.inspector.sensitives.CSTextArea;
import mausoleum.inspector.sensitives.CSTextField;
import mausoleum.inspector.sensitives.CSTextFieldName;
import mausoleum.inspector.util.ActionBundleSimple;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.MouseManager;
import mausoleum.requester.NewExperimentRequester;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.MausoleumTableSelectionListener;
import mausoleum.tables.models.MTResultInExperimentInspector;
import mausoleum.ui.UIDef;
import mausoleum.util.InstallationType;

public class InspectorPanelExperiment
extends InspectorPanel
implements MausoleumTableSelectionListener {
    private static final long serialVersionUID = -987785328765721861L;
    public CSTextField ivNameField = new CSTextFieldName(this);
    private CSTextArea ivCommentField = new CSTextArea(this, "EXP_DESC");
    private BorderPanel ivAP_Comment = null;
    private MausoleumTable ivResultTable = new MausoleumTable(new MTResultInExperimentInspector(), false);

    public InspectorPanelExperiment() {
        super(12, "EXPERIMENT");
        this.addChangeSensitive(new CSExpTyp());
        this.addChangeSensitive(new CSExpValues());
        this.addChangeSensitive(new CSExpEnterer());
        this.addTab(Babel.get("ATTRIBUTES"), new ExpAttributePanel());
        if (MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker()) {
            SimpleRequesterPane srp = new SimpleRequesterPane(new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND), "inspectorBack"){
                private static final long serialVersionUID = 1323L;

                public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
                    ExperimentAction.setSelectedResults(null);
                    if (idObjects != null && idObjects.size() == 1) {
                        Experiment experiment = (Experiment)InspectorPanelExperiment.this.ivSelObjects.firstElement();
                        Vector mresV = MouseManager.getResultsInActualMice(experiment.getGroup(), experiment.getID());
                        ((InspectorPanelExperiment)InspectorPanelExperiment.this).ivResultTable.ivModel.setTable(mresV);
                    } else {
                        ((InspectorPanelExperiment)InspectorPanelExperiment.this).ivResultTable.ivModel.setTable(ArrayHelper.LEER);
                    }
                }
            };
            srp.setOpaque(false);
            this.ivResultTable.setIsSubdisplay();
            this.ivResultTable.ivInspectorWillReact = false;
            this.ivResultTable.ivModel.addSelectionListener(this);
            srp.add("Center", this.ivResultTable);
            InspectorActionButton iab = InspectorActionButton.createButton("EXP_SHOWMICE", this.ivActionButtons, null);
            srp.add("South", iab);
            this.addTab(Babel.get("RESULTS"), srp);
        }
        this.addDocumentsTab("EXP_ADD_DOC", "EXP_REM_DOC", "EXP_GET_DOC");
    }

    public ActionBundleSimple createActionBundle() {
        return new ActionBundleSimple(ExperimentAction.getExperimentActions(), 1);
    }

    public boolean isSetAllowed() {
        return (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && UserManager.getFirstGroup().equals(IDObject.commonGroup(this.ivSelObjects));
    }

    public boolean doNew(boolean withExecution) {
        boolean res;
        boolean bl = res = (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && Privileges.hasPrivilege("CREATE_EXPERIMENT");
        if (res && withExecution) {
            new NewExperimentRequester(Inspector.getInspector());
        }
        return res;
    }

    public boolean doRemove(boolean withExecution) {
        boolean warja;
        boolean res;
        boolean bl = res = (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && Privileges.hasPrivilege("REMOVE_EXPERIMENT") && UserManager.getFirstGroup().equals(IDObject.commonGroup(this.ivSelObjects));
        if (res && withExecution && (warja = Alert.showAlert(Babel.get("ALERTWANTREMOVEEXPERIMENT"), Babel.get("YES"), Babel.get("NO"), false))) {
            StringBuffer msb = new StringBuffer();
            int j = 0;
            while (j < this.ivSelObjects.size()) {
                Experiment tu = (Experiment)this.ivSelObjects.elementAt(j);
                if (j != 0) {
                    msb.append("\n");
                }
                msb.append("EXPRM " + tu.getID());
                ++j;
            }
            InspectorCommandSender.executeCommand(msb.toString(), UserManager.getFirstGroup());
        }
        return res;
    }

    public void passiviereFelder() {
        this.ivNameField.setToPassive();
        this.ivCommentField.setToPassive();
    }

    public void disableFields() {
        this.ivNameField.setToNonApplicable();
        this.ivCommentField.setToNonApplicable();
    }

    public String getSetCommand(Vector changeSensitives, Vector idObjects) {
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < changeSensitives.size()) {
            if (changeSensitives.elementAt(i) == this.ivNameField) {
                InspectorPanelExperiment.makeCommand("EXPCHNAME", Base64Manager.encodeBase64(this.ivNameField.getText()), 1, msb, this.ivNameField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCommentField) {
                InspectorPanelExperiment.makeCommand("EXPCHDESC", Base64Manager.encodeBase64(this.ivCommentField.getText()), 1, msb, this.ivCommentField.getAffecteds(idObjects));
            }
            ++i;
        }
        return msb.toString();
    }

    public void selectionChanged(MausoleumTableModel mt) {
        ExperimentAction.setSelectedResults(mt.getSelectedObjects());
        this.manageButEnabling("EXP_SHOWMICE", null, true);
    }

    class CSExpEnterer
    extends CSStringInfo {
        public CSExpEnterer() {
            super(Babel.get("ENTEREDBY"), null);
        }

        public String getValString(IDObject ido) {
            long entererID = ido.getLong("EXP_ENTERER", 0L);
            if (entererID == 0L) {
                return InstallationType.getNormalProgramName();
            }
            return UserManager.getNameOfUser(entererID, ido.getGroup());
        }
    }

    class CSExpTyp
    extends CSStringInfo {
        public CSExpTyp() {
            super(Babel.get("TYPE"), null);
        }

        public String getValString(IDObject ido) {
            return ((Experiment)ido).getExperimentTypeString();
        }
    }

    class CSExpValues
    extends CSStringInfo {
        public CSExpValues() {
            super(Babel.get("VALUES"), null);
        }

        public String getValString(IDObject ido) {
            return ((Experiment)ido).getPossValuesString("", false);
        }
    }

    class ExpAttributePanel
    extends AttributePane {
        private static final long serialVersionUID = 5067010713733060702L;

        public ExpAttributePanel() {
            InspectorPanelExperiment.this.ivSensitiveTable = new SensitiveTable(InspectorPanelExperiment.this.ivChangeSensitives);
            this.add(InspectorPanelExperiment.this.ivSensitiveTable);
            JPanel mp = new JPanel(new BorderLayout());
            mp.setOpaque(false);
            mp.add("Center", new JScrollPane(InspectorPanelExperiment.this.ivCommentField));
            InspectorPanelExperiment.this.ivAP_Comment = new BorderPanel(mp, Babel.get("DESCRIPTION"));
            this.add(InspectorPanelExperiment.this.ivAP_Comment);
        }

        public void layoutContainer(Container parent) {
            Dimension d = parent.getSize();
            int x = Inspector.INTER_BUT;
            int w = d.width - 2 * Inspector.INTER_BUT;
            int y = Inspector.INTER_BUT;
            int sh = InspectorPanelExperiment.this.ivSensitiveTable.getPreferredSize().height;
            InspectorPanelExperiment.this.ivSensitiveTable.setBounds(x, y, w, sh);
            int rh = d.height - 2 * Inspector.INTER_BUT - Inspector.RAND - sh;
            InspectorPanelExperiment.this.ivAP_Comment.setBounds(x, y += sh + Inspector.RAND, w, rh);
        }

        public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
            super.adapt(idObjects, mice, changeSensitives);
            if (idObjects == null || idObjects.isEmpty()) {
                InspectorPanelExperiment.this.ivNameField.setToNonApplicable();
                InspectorPanelExperiment.this.ivCommentField.setToNonApplicable();
            } else if (idObjects.size() == 1) {
                boolean sameGroup = UserManager.getFirstGroup().equals(IDObject.commonGroup(InspectorPanelExperiment.this.ivSelObjects));
                InspectorPanelExperiment.this.ivNameField.setState(sameGroup && Privileges.hasPrivilege("EXP_CH_NAME"));
                InspectorPanelExperiment.this.ivCommentField.setState(sameGroup && Privileges.hasPrivilege("EXP_CH_DESCRIPRION"));
            } else {
                InspectorPanelExperiment.this.ivNameField.setToNonApplicable();
                InspectorPanelExperiment.this.ivCommentField.setToNonApplicable();
            }
        }
    }
}

