/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import mausoleum.alert.Alert;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.MGButton;
import mausoleum.gui.documents.PureIntegerDocument;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.SensitiveTable;
import mausoleum.inspector.panels.AttributePane;
import mausoleum.inspector.panels.GrantedGroupsPane;
import mausoleum.inspector.panels.SimplePane;
import mausoleum.inspector.sensitives.CSColor;
import mausoleum.inspector.sensitives.CSDate;
import mausoleum.inspector.sensitives.CSDateIntTag;
import mausoleum.inspector.sensitives.CSForeignID;
import mausoleum.inspector.sensitives.CSLicenseSubtype;
import mausoleum.inspector.sensitives.CSLicenseType;
import mausoleum.inspector.sensitives.CSStressInputNecessary;
import mausoleum.inspector.sensitives.CSTextArea;
import mausoleum.inspector.sensitives.CSTextField;
import mausoleum.inspector.sensitives.CSTextFieldName;
import mausoleum.inspector.sensitives.CSTextFieldTag;
import mausoleum.inspector.sensitives.CSTextFieldTagInteger;
import mausoleum.inspector.util.ActionBundleSimple;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.license.License;
import mausoleum.license.LicenseAddRequester;
import mausoleum.license.UserLicenseLink;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.MouseManager;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.ui.UIDef;

public class InspectorPanelLicense
extends InspectorPanel
implements TableModel {
    private static final long serialVersionUID = 44544221846823L;
    private static final String STR_NAME_OHNE = "WITHOUT_PERMISSION";
    private static final String STR_NAME_MIT = "WITH_PERMISSION";
    private static final String[] ACTION_BUTT_DEFS = new String[]{"LICA_SHOWALLMICE", "LICA_USAGE_REPORT"};
    private static final String[] ACTION_BUTT_DEFS_HOS = new String[]{"LICA_USAGE_REPORT"};
    public CSTextField ivNameField = null;
    public CSDate ivStartDateButton = null;
    public CSDate ivEndDateButton = null;
    public CSTextField ivHolderField = null;
    public CSTextField ivMaxMouseCountField = null;
    public CSColor ivColorButton = null;
    private CSTextArea ivCommentField = new CSTextArea(this, "LIC_CO");
    public CSLicenseType ivTypeField = new CSLicenseType(this);
    public CSLicenseSubtype ivSubTypeField = new CSLicenseSubtype(this);
    public final CSForeignID ivForeignIDButton;
    public final CSStressInputNecessary ivStressInputNecessary;
    private JTable ivUserTable = null;
    private JLabel ivUserLabel = null;
    private MGButton ivHeaderButton = null;
    private MGButton ivGrantButton = null;
    private MGButton ivRefuseButton = null;
    private BorderPanel ivAP_Users = null;
    private final Vector ivUserLinks = new Vector();
    static /* synthetic */ Class class$0;

    public InspectorPanelLicense() {
        super(16, "LICENSES");
        this.ivNameField = new CSTextFieldName(this);
        this.ivHolderField = new CSTextFieldTag(this, "LIC_LH", Babel.get("LIC_HOLDER"));
        this.ivStartDateButton = new CSDateIntTag(this, "LIC_SD", Babel.get("LIC_STARTDATE"));
        this.ivStartDateButton.setMaximumDate(null);
        this.ivStartDateButton.setMaximumDate(null);
        this.ivEndDateButton = new CSDateIntTag(this, "LIC_ED", Babel.get("LIC_ENDDATE"));
        this.ivEndDateButton.setMaximumDate(null);
        this.ivEndDateButton.setMaximumDate(null);
        this.ivColorButton = new CSColor(this, "LIC_COL");
        this.ivMaxMouseCountField = new CSTextFieldTagInteger(this, "LIC_MMC", Babel.get("LIC_MOUSECOUNT"));
        this.ivMaxMouseCountField.setDocument(new PureIntegerDocument(this.ivMaxMouseCountField));
        this.ivMaxMouseCountField.setHorizontalAlignment(4);
        this.ivForeignIDButton = new CSForeignID(this);
        CSStressInputNecessary cSStressInputNecessary = this.ivStressInputNecessary = TierSchutz.belastungNeeded() ? new CSStressInputNecessary(this) : null;
        if (MausoleumClient.isRegularOrTGService()) {
            this.ivHeaderButton = MGButton.getInspectorActionButton("", "");
            this.ivUserTable = new JTable(this);
            this.ivUserTable.getSelectionModel().setSelectionMode(0);
            this.ivUserTable.getTableHeader().setPreferredSize(new Dimension(UIDef.getScaled(100), UIDef.getScaled(20)));
            this.ivUserTable.getColumnModel().getColumn(0).setPreferredWidth(100);
            this.ivUserTable.getColumnModel().getColumn(1).setPreferredWidth(100);
            this.ivUserTable.setOpaque(false);
            this.ivUserTable.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    InspectorPanelLicense.this.ivHeaderButton.setLabel(" " + InspectorPanelLicense.this.getColumnName(column) + " ");
                    return InspectorPanelLicense.this.ivHeaderButton;
                }
            });
            this.ivUserLabel = new JLabel("qQAy");
            this.ivUserLabel.setOpaque(false);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.ivUserTable.setDefaultRenderer(clazz, new TableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    InspectorPanelLicense.this.ivUserLabel.setText(" " + value + " ");
                    if (isSelected) {
                        InspectorPanelLicense.this.ivUserLabel.setOpaque(true);
                        InspectorPanelLicense.this.ivUserLabel.setBackground(UIDef.SELECTED_BACKGROUND);
                    } else {
                        InspectorPanelLicense.this.ivUserLabel.setOpaque(false);
                        InspectorPanelLicense.this.ivUserLabel.setBackground(null);
                    }
                    return InspectorPanelLicense.this.ivUserLabel;
                }
            });
            this.ivUserTable.setRowHeight(this.ivUserLabel.getPreferredSize().height);
            this.ivUserTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent arg0) {
                    if (!arg0.getValueIsAdjusting()) {
                        int row = InspectorPanelLicense.this.ivUserTable.getSelectedRow();
                        if (row >= 0 && row < InspectorPanelLicense.this.ivUserLinks.size()) {
                            UserLicenseLink ull = (UserLicenseLink)InspectorPanelLicense.this.ivUserLinks.elementAt(row);
                            if (ull.ivChangeable) {
                                if (ull.ivHasAccess) {
                                    InspectorPanelLicense.this.ivGrantButton.setEnabled(false);
                                    InspectorPanelLicense.this.ivRefuseButton.setEnabled(Privileges.hasPrivilege("LIC_CH_USERS"));
                                } else {
                                    InspectorPanelLicense.this.ivGrantButton.setEnabled(Privileges.hasPrivilege("LIC_CH_USERS"));
                                    InspectorPanelLicense.this.ivRefuseButton.setEnabled(false);
                                }
                                return;
                            }
                        }
                        InspectorPanelLicense.this.ivGrantButton.setEnabled(false);
                        InspectorPanelLicense.this.ivRefuseButton.setEnabled(false);
                    }
                }
            });
            this.ivGrantButton = new MGButton(Babel.get("LIC_GRANT_PERMISSION"));
            this.ivGrantButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    int row = InspectorPanelLicense.this.ivUserTable.getSelectedRow();
                    if (row >= 0 && row < InspectorPanelLicense.this.ivUserLinks.size()) {
                        UserLicenseLink ull = (UserLicenseLink)InspectorPanelLicense.this.ivUserLinks.elementAt(row);
                        if (ull.ivUser != null && ull.ivChangeable && !ull.ivHasAccess && Privileges.hasPrivilege("LIC_CH_USERS") && InspectorPanelLicense.this.ivSelObjects.size() == 1) {
                            License license = (License)InspectorPanelLicense.this.ivSelObjects.elementAt(0);
                            StringBuffer msb = new StringBuffer();
                            msb.append("LIC_ADD_USER").append(" ");
                            msb.append(license.getID()).append(" ");
                            msb.append(ull.ivUser.getID());
                            InspectorCommandSender.executeCommand(msb.toString(), license.getGroup());
                        }
                    }
                }
            });
            this.ivRefuseButton = new MGButton(Babel.get("LIC_REFUSE_PERMISSION"));
            this.ivRefuseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    int row = InspectorPanelLicense.this.ivUserTable.getSelectedRow();
                    if (row >= 0 && row < InspectorPanelLicense.this.ivUserLinks.size()) {
                        UserLicenseLink ull = (UserLicenseLink)InspectorPanelLicense.this.ivUserLinks.elementAt(row);
                        if (ull.ivUser != null && ull.ivChangeable && ull.ivHasAccess && Privileges.hasPrivilege("LIC_CH_USERS") && InspectorPanelLicense.this.ivSelObjects.size() == 1) {
                            License license = (License)InspectorPanelLicense.this.ivSelObjects.elementAt(0);
                            StringBuffer msb = new StringBuffer();
                            msb.append("LIC_REM_USER").append(" ");
                            msb.append(license.getID()).append(" ");
                            msb.append(ull.ivUser.getID());
                            InspectorCommandSender.executeCommand(msb.toString(), license.getGroup());
                        }
                    }
                }
            });
        }
        this.addTab(Babel.get("ATTRIBUTES"), new LicenseAttributePanel());
        SimplePane sp = new SimplePane(new BorderLayout()){
            private static final long serialVersionUID = 1232L;

            public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
                if (idObjects != null && idObjects.size() == 1) {
                    InspectorPanelLicense.this.ivCommentField.adaptToVector(idObjects);
                    InspectorPanelLicense.this.ivCommentField.setState(IDObject.nonEmptyAndAllActiveAndChangeable(idObjects) && Privileges.hasPrivilege("LIC_CH_DESCRIPRION"));
                } else {
                    InspectorPanelLicense.this.ivCommentField.setToNonApplicable();
                }
            }
        };
        sp.setOpaque(false);
        sp.add("Center", new JScrollPane(this.ivCommentField));
        this.addTab(Babel.get("DESCRIPTION"), sp);
        if (MausoleumClient.isHeadOfService()) {
            this.addTab(Babel.get("GROUPS"), new GrantedGroupsPane(16, null));
        }
        if (MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker()) {
            this.addMouseTab(Babel.get("ACTMICEOFLICENSE"), null);
            this.addCageTab(Babel.get("ACTCAGESOFLICENSE"), null);
        }
        this.addDocumentsTab("LIC_ADD_DOC", "LIC_REM_DOC", "LIC_GET_DOC");
    }

    public ActionBundleSimple createActionBundle() {
        String[] orig = null;
        if (MausoleumClient.isRegularOrTGService()) {
            orig = ACTION_BUTT_DEFS;
        } else if (MausoleumClient.isHeadOfService()) {
            orig = ACTION_BUTT_DEFS_HOS;
        }
        orig = TierSchutz.enrichLicenseActions(orig);
        return new ActionBundleSimple(orig);
    }

    public boolean isSetAllowed() {
        return !this.ivSelObjects.isEmpty();
    }

    public boolean doNew(boolean withExecution) {
        boolean res;
        boolean bl = res = (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && Privileges.hasPrivilege("CREATE_LICENSE");
        if (res && withExecution) {
            LicenseAddRequester.getNewLicense(Inspector.getInspector());
        }
        return res;
    }

    public boolean doRemove(boolean withExecution) {
        boolean res;
        boolean bl = res = this.areLicensesChangeable() && Privileges.hasPrivilege("DELETE_LICENSE") && !this.ivSelObjects.isEmpty();
        if (res && withExecution) {
            this.removeImportantObject("DELETE_LICENSE", "LIC_RM", "ALERTSELALICENSE", "ALERTGURUREMOVELICENSE", "ALERTWANTREMOVELICENSE");
        }
        return res;
    }

    private boolean areLicensesChangeable() {
        int i = 0;
        while (i < this.ivSelObjects.size()) {
            License license = (License)this.ivSelObjects.elementAt(i);
            if (!license.isAliveAndVisible() || !license.mayAttributeBeChangedByCommand()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void disableFields() {
        this.ivNameField.setToNonApplicable();
        this.ivHolderField.setToNonApplicable();
        this.ivColorButton.setToNonApplicable();
        this.ivMaxMouseCountField.setToNonApplicable();
        this.ivStartDateButton.setToNonApplicable();
        this.ivEndDateButton.setToNonApplicable();
        this.ivCommentField.setToNonApplicable();
        this.ivForeignIDButton.setToNonApplicable();
        if (MausoleumClient.isRegularOrTGService()) {
            this.ivUserLinks.clear();
            this.ivUserTable.tableChanged(new TableModelEvent(this));
            this.ivGrantButton.setEnabled(false);
            this.ivRefuseButton.setEnabled(false);
        }
        if (this.ivStressInputNecessary != null) {
            this.ivStressInputNecessary.setToNonApplicable();
        }
        this.ivSubTypeField.setToNonApplicable();
    }

    public void passiviereFelder() {
        this.ivNameField.setToPassive();
        this.ivHolderField.setToPassive();
        this.ivColorButton.setToPassive();
        this.ivStartDateButton.setToNonApplicable();
        this.ivEndDateButton.setToNonApplicable();
        this.ivMaxMouseCountField.setToNonApplicable();
        this.ivCommentField.setToPassive();
        this.ivForeignIDButton.setToPassive();
        if (MausoleumClient.isRegularOrTGService()) {
            this.ivUserLinks.clear();
            this.ivUserTable.tableChanged(new TableModelEvent(this));
            this.ivGrantButton.setEnabled(false);
            this.ivRefuseButton.setEnabled(false);
        }
        if (this.ivStressInputNecessary != null) {
            this.ivStressInputNecessary.setToPassive();
        }
        this.ivSubTypeField.setToPassive();
    }

    public boolean checkSet(Vector changeSensitives) {
        int i = 0;
        while (i < changeSensitives.size()) {
            if (changeSensitives.elementAt(i) == this.ivNameField) {
                if (this.ivNameField.getText().trim().length() == 0) {
                    Alert.showAlert(Babel.get("EMPTY_NOT_ALLOWED"), true);
                    return false;
                }
                if (!PopeAlert.settingOk(this.ivSelObjects, "LIC_NAME", "POPE_LICENSE_NAME")) {
                    return false;
                }
            } else if (changeSensitives.elementAt(i) == this.ivHolderField) {
                if (this.ivHolderField.getText().trim().length() == 0) {
                    Alert.showAlert(Babel.get("EMPTY_NOT_ALLOWED"), true);
                    return false;
                }
                if (!PopeAlert.settingOk(this.ivSelObjects, "LIC_LH", "POPE_LICENSE_HOLDER")) {
                    return false;
                }
            } else if (changeSensitives.elementAt(i) == this.ivMaxMouseCountField ? !PopeAlert.settingOk(this.ivSelObjects, "LIC_MMC", "POPE_LICENSE_MAX_COUNT") : (changeSensitives.elementAt(i) == this.ivStartDateButton ? !PopeAlert.settingOk(this.ivSelObjects, "LIC_SD", "POPE_LICENSE_START_DATE") : changeSensitives.elementAt(i) == this.ivEndDateButton && !PopeAlert.settingOk(this.ivSelObjects, "LIC_ED", "POPE_LICENSE_END_DATE"))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getSetCommand(Vector changeSensitives, Vector idObjects) {
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < changeSensitives.size()) {
            Date d;
            int val;
            if (changeSensitives.elementAt(i) == this.ivNameField) {
                InspectorPanelLicense.makeCommand("LIC_CH_NAME", Base64Manager.encodeBase64(this.ivNameField.getText().trim()), 1, msb, this.ivNameField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivHolderField) {
                InspectorPanelLicense.makeCommand("LIC_CH_HOLDER", Base64Manager.encodeBase64(this.ivHolderField.getText().trim()), 1, msb, this.ivHolderField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivColorButton) {
                InspectorPanelLicense.makeCommand("LIC_CH_COLOR", this.ivColorButton.getCommandValue(), 1, msb, this.ivColorButton.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivMaxMouseCountField) {
                InspectorPanelLicense.makeCommand("LIC_CH_MOUSECOUNT", Integer.toString(this.ivMaxMouseCountField.getInt(-1)), 1, msb, this.ivMaxMouseCountField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivStartDateButton) {
                val = -1;
                d = this.ivStartDateButton.getValue();
                if (d != null) {
                    val = (int)(d.getTime() / 86400000L);
                }
                InspectorPanelLicense.makeCommand("LIC_CH_STARTDATE", Integer.toString(val), 1, msb, this.ivStartDateButton.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivEndDateButton) {
                val = -1;
                d = this.ivEndDateButton.getValue();
                if (d != null) {
                    val = (int)(d.getTime() / 86400000L);
                }
                InspectorPanelLicense.makeCommand("LIC_CH_ENDDATE", Integer.toString(val), 1, msb, this.ivEndDateButton.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCommentField) {
                InspectorPanelLicense.makeCommand("LIC_CH_COMMENT", Base64Manager.encodeBase64(this.ivCommentField.getText().trim()), 1, msb, this.ivCommentField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivForeignIDButton && this.ivForeignIDButton.didYouChange()) {
                InspectorPanelLicense.makeCommand("SET_FOREIGN_ID", Integer.toString(16), Base64Manager.encodeBase64(this.ivForeignIDButton.getValue()), 1, msb, this.ivForeignIDButton.getAffecteds(idObjects));
            } else if (this.ivStressInputNecessary != null && changeSensitives.elementAt(i) == this.ivStressInputNecessary && this.ivStressInputNecessary.didYouChange()) {
                InspectorPanelLicense.makeCommand("LIC_STRESS_INPUT", this.ivStressInputNecessary.getValue(), 1, msb, this.ivStressInputNecessary.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivSubTypeField && this.ivSubTypeField.didYouChange()) {
                InspectorPanelLicense.makeCommand("LIC_CHSUBTYPE", this.ivSubTypeField.getValue(), 1, msb, this.ivSubTypeField.getAffecteds(idObjects));
            }
            ++i;
        }
        return msb.toString();
    }

    public Vector getMatchingMice() {
        return MouseManager.getActualMiceOfLicense(this.ivSelObjects);
    }

    public int getRowCount() {
        if (this.ivUserLinks != null) {
            return this.ivUserLinks.size();
        }
        return 0;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return Babel.get(STR_NAME_OHNE);
            }
            case 1: {
                return Babel.get(STR_NAME_MIT);
            }
        }
        return "";
    }

    public Class getColumnClass(int arg0) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Object getValueAt(int row, int column) {
        UserLicenseLink ull;
        if (row >= 0 && this.ivUserLinks != null && row < this.ivUserLinks.size() && (ull = (UserLicenseLink)this.ivUserLinks.elementAt(row)) != null) {
            if (column == 1 && ull.ivHasAccess) {
                return ull.ivName;
            }
            if (column == 0 && !ull.ivHasAccess) {
                return ull.ivName;
            }
        }
        return "";
    }

    public void setValueAt(Object arg0, int arg1, int arg2) {
    }

    public void addTableModelListener(TableModelListener arg0) {
    }

    public void removeTableModelListener(TableModelListener arg0) {
    }

    class LicenseAttributePanel
    extends AttributePane {
        private static final long serialVersionUID = 5067010713733060702L;

        public LicenseAttributePanel() {
            InspectorPanelLicense.this.ivSensitiveTable = new SensitiveTable(InspectorPanelLicense.this.ivChangeSensitives);
            this.add(InspectorPanelLicense.this.ivSensitiveTable);
            if (MausoleumClient.isRegularOrTGService()) {
                JPanel p = new JPanel(new GridLayout(1, 2));
                p.add(InspectorPanelLicense.this.ivGrantButton);
                p.add(InspectorPanelLicense.this.ivRefuseButton);
                p.setOpaque(false);
                JPanel p2 = new JPanel(new BorderLayout());
                p2.add("Center", new JScrollPane(InspectorPanelLicense.this.ivUserTable));
                p2.add("South", p);
                p2.setOpaque(false);
                InspectorPanelLicense.this.ivAP_Users = new BorderPanel(p2, Babel.get("LIC_USERS"));
                this.add(InspectorPanelLicense.this.ivAP_Users);
            }
        }

        public void layoutContainer(Container parent) {
            Dimension d = parent.getSize();
            int x = Inspector.INTER_BUT;
            int w = d.width - 2 * Inspector.INTER_BUT;
            int y = Inspector.INTER_BUT;
            int sh = InspectorPanelLicense.this.ivSensitiveTable.getPreferredSize().height;
            InspectorPanelLicense.this.ivSensitiveTable.setBounds(x, y, w, sh);
            y += sh + Inspector.RAND;
            if (MausoleumClient.isRegularOrTGService()) {
                InspectorPanelLicense.this.ivAP_Users.setBounds(x, y, w, d.height - 2 * Inspector.INTER_BUT - y);
            }
        }

        public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
            super.adapt(idObjects, mice, changeSensitives);
            if (idObjects != null && !idObjects.isEmpty()) {
                if (idObjects.size() == 1) {
                    License license = (License)InspectorPanelLicense.this.ivSelObjects.elementAt(0);
                    boolean changeable = IDObject.nonEmptyAndAllActiveAndChangeable(InspectorPanelLicense.this.ivSelObjects);
                    InspectorPanelLicense.this.ivNameField.setState(changeable && Privileges.hasPrivilege("LIC_CH_NAME"));
                    InspectorPanelLicense.this.ivHolderField.setState(changeable && Privileges.hasPrivilege("LIC_CH_HOLDER"));
                    InspectorPanelLicense.this.ivStartDateButton.setState(changeable && Privileges.hasPrivilege("LIC_CH_STARTDATE"));
                    InspectorPanelLicense.this.ivEndDateButton.setState(changeable && Privileges.hasPrivilege("LIC_CH_ENDDATE"));
                    InspectorPanelLicense.this.ivColorButton.setState(changeable && Privileges.hasPrivilege("LIC_CH_COLOR"));
                    InspectorPanelLicense.this.ivMaxMouseCountField.setState(changeable && Privileges.hasPrivilege("LIC_CH_MOUSEMAXIMUM"));
                    InspectorPanelLicense.this.ivForeignIDButton.setState(changeable && Privileges.hasPrivilege("EDIT_FOREIGN_ID"));
                    InspectorPanelLicense.this.ivSubTypeField.setState(changeable && Privileges.hasPrivilege("LIN_CH_SUBTYPE") && InspectorPanelLicense.this.ivSubTypeField.isChangeableByContent(license));
                    if (MausoleumClient.isRegularOrTGService()) {
                        InspectorPanelLicense.this.ivUserLinks.clear();
                        Vector v = UserManager.getActualAndVisibleObjects(license.getGroup());
                        Collections.sort(v);
                        Iterator iterator = v.iterator();
                        while (iterator.hasNext()) {
                            User user = (User)iterator.next();
                            if (Privileges.hasPrivilege(user, "ADD_LICENSE_TO_MOUSE_ALWAYS")) {
                                InspectorPanelLicense.this.ivUserLinks.add(new UserLicenseLink(user, true, false));
                                continue;
                            }
                            if (!Privileges.hasPrivilege(user, "ADD_LICENSE_TO_MOUSE")) continue;
                            InspectorPanelLicense.this.ivUserLinks.add(new UserLicenseLink(user, license.isAllowed(user.getID()), true));
                        }
                        InspectorPanelLicense.this.ivUserTable.tableChanged(new TableModelEvent(InspectorPanelLicense.this.ivUserTable.getModel()));
                        InspectorPanelLicense.this.ivGrantButton.setEnabled(false);
                        InspectorPanelLicense.this.ivRefuseButton.setEnabled(false);
                    }
                } else {
                    this.disableAllSensitives(InspectorPanelLicense.this.ivChangeSensitives);
                }
            }
        }
    }
}

