/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import mausoleum.gui.BorderPanel;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.SensitiveTable;
import mausoleum.inspector.actions.line.LineAction;
import mausoleum.inspector.panels.AttributePane;
import mausoleum.inspector.panels.GrantedGroupsPane;
import mausoleum.inspector.panels.IPTabPanel;
import mausoleum.inspector.sensitives.CSANTag;
import mausoleum.inspector.sensitives.CSAlwaysPraline;
import mausoleum.inspector.sensitives.CSAutoGenotype;
import mausoleum.inspector.sensitives.CSColor;
import mausoleum.inspector.sensitives.CSForeignID;
import mausoleum.inspector.sensitives.CSLicense;
import mausoleum.inspector.sensitives.CSLineEvaluation;
import mausoleum.inspector.sensitives.CSMatLim;
import mausoleum.inspector.sensitives.CSPrefix;
import mausoleum.inspector.sensitives.CSStressLevelLine;
import mausoleum.inspector.sensitives.CSTextArea;
import mausoleum.inspector.sensitives.CSTextField;
import mausoleum.inspector.sensitives.CSTextFieldName;
import mausoleum.inspector.sensitives.ChangeSensitive;
import mausoleum.inspector.util.ActionBundleSimple;
import mausoleum.license.LicenseManager;
import mausoleum.line.Line;
import mausoleum.line.LineAddRequester;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.locus.LocusManager;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.MouseManager;
import mausoleum.mouse.tierschutz.StressRulePane;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.ui.UIDef;
import mausoleum.ui.table.NiceRegularTable;

public class InspectorPanelLine
extends InspectorPanel
implements TableModel {
    private static final long serialVersionUID = 44544221846823L;
    private CSTextArea ivCommentField = new CSTextArea(this, "LIN_DESCRIPTION");
    private CSTextArea ivExpectedPropertiesField = new CSTextArea(this, "LIN_EXPROPS");
    private JTable ivLocusTable = new NiceRegularTable(this);
    public final CSTextField ivNameField = new CSTextFieldName(this);
    public final CSColor ivColorButton = new CSColor(this, "LIN_COLOR");
    public final CSANTag ivANTagButton = new CSANTag(this);
    public final CSPrefix ivPrefixButton = new CSPrefix(this);
    public final CSLicense ivCSLicense = new CSLicense((InspectorPanel)this, 3);
    public final CSMatLim ivMatLimButton = new CSMatLim(this);
    public final CSAutoGenotype ivAutoGenotypeButton = new CSAutoGenotype(this);
    public final CSAlwaysPraline ivAlwaysPraline = new CSAlwaysPraline(this);
    public final CSForeignID ivForeignIDButton = new CSForeignID(this);
    public final CSStressLevelLine ivMinStressLevel = TierSchutz.belastungNeeded() ? new CSStressLevelLine((InspectorPanel)this, true) : null;
    public final CSStressLevelLine ivMaxStressLevel = TierSchutz.belastungNeeded() ? new CSStressLevelLine((InspectorPanel)this, false) : null;
    public final CSLineEvaluation ivLineEvaluation = TierSchutz.isLineEvaluationPossible() ? new CSLineEvaluation(this) : null;
    private final ChangeSensitive[] ivCSArr = new ChangeSensitive[]{this.ivNameField, this.ivCommentField, this.ivColorButton, this.ivANTagButton, this.ivPrefixButton, this.ivAutoGenotypeButton, this.ivAlwaysPraline, this.ivForeignIDButton, this.ivMinStressLevel, this.ivMaxStressLevel, this.ivLineEvaluation, this.ivCSLicense, this.ivExpectedPropertiesField};
    private LocusAndAlleles[] ivLineLoci = null;
    static /* synthetic */ Class class$0;

    public InspectorPanelLine() {
        super(7, "LINE");
        this.ivNameField.ivSetCommand = "ENTERLINENAME";
        this.addTab(Babel.get("ATTRIBUTES"), new LineAttributePanel());
        if (MausoleumClient.isHeadOfService()) {
            this.addTab(Babel.get("GROUPS"), new GrantedGroupsPane(7, null));
        }
        if (MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker()) {
            this.addMouseTab(Babel.get("MICEOFLINE"), null);
            this.addCageTab(Babel.get("CAGESOFLINE"), null);
        }
        if (TierSchutz.belastungNeeded()) {
            this.addTab(Babel.get("STRESS_LEVEL_DETAILS"), new StressRulePane());
        }
        this.addTab(Babel.get("RES_TS_WB_ERWARTETE_EGS"), new ExpPropsPanel());
        this.addDocumentsTab("LIN_ADD_DOC", "LIN_REM_DOC", "LIN_GET_DOC");
    }

    public ActionBundleSimple createActionBundle() {
        return new ActionBundleSimple(TierSchutz.enrichLineActions(LineAction.getLineActions()), 2);
    }

    public boolean isSetAllowed() {
        if (this.ivSelObjects.isEmpty()) {
            return false;
        }
        Vector changeSensitives = this.getTheRealChangedItems();
        if (changeSensitives.size() == 1 && changeSensitives.firstElement() == this.ivCSLicense && this.ivSelObjects.size() == 1) {
            return InspectorPanelLine.isSetLicenseAllowed((Line)this.ivSelObjects.firstElement());
        }
        return this.areLinesChangeable();
    }

    public boolean doNew(boolean withExecution) {
        boolean res;
        boolean bl = res = (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && Privileges.hasPrivilege("CREATE_LINE");
        if (res && withExecution) {
            Line.createLineOnServer(LineAddRequester.getNewLine(Inspector.getInspector(), UserManager.getFirstGroup()));
        }
        return res;
    }

    public boolean doRemove(boolean withExecution) {
        boolean res = false;
        if ((MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && Privileges.hasPrivilege("REMOVE_LINE") && !this.ivSelObjects.isEmpty()) {
            res = this.areLinesChangeable();
        }
        if (res && withExecution) {
            this.removeImportantObject("REMOVE_LINE", "LINRM", "ALERTSELALINE", "ALERTGURUREMOVELINE", "ALERTWANTREMOVELINE");
        }
        return res;
    }

    public void disableFields() {
        this.setToNonApplicable(this.ivCSArr);
    }

    public void passiviereFelder() {
        this.setToPassive(this.ivCSArr);
    }

    public String getSetCommand(Vector changeSensitives, Vector idObjects) {
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < changeSensitives.size()) {
            if (changeSensitives.elementAt(i) == this.ivNameField) {
                InspectorPanelLine.makeCommand("LINCHNAME", Base64Manager.encodeBase64(this.ivNameField.getText().trim()), 1, msb, this.ivNameField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCommentField) {
                InspectorPanelLine.makeCommand("LINCHCOMMENT", Base64Manager.encodeBase64(this.ivCommentField.getText()), 1, msb, this.ivCommentField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivExpectedPropertiesField) {
                InspectorPanelLine.makeCommand("LINCHEXPPROPS", Base64Manager.encodeBase64(this.ivExpectedPropertiesField.getText()), 1, msb, this.ivExpectedPropertiesField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivColorButton) {
                InspectorPanelLine.makeCommand("LINCHCOLOR", this.ivColorButton.getCommandValue(), 1, msb, this.ivColorButton.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivMatLimButton && this.ivMatLimButton.didYouChange()) {
                InspectorPanelLine.makeCommand("LINSETMATLIM", Integer.toString(this.ivMatLimButton.getValue()), 1, msb, this.ivMatLimButton.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivANTagButton && this.ivANTagButton.didYouChange()) {
                InspectorPanelLine.makeCommand("LINSETANTAG", Base64Manager.encodeBase64(this.ivANTagButton.getValue()), 1, msb, this.ivANTagButton.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivPrefixButton && this.ivPrefixButton.didYouChange()) {
                InspectorPanelLine.makeCommand("LINSETPREFIX", Base64Manager.encodeBase64(this.ivPrefixButton.getValue()), 1, msb, this.ivPrefixButton.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivAutoGenotypeButton && this.ivAutoGenotypeButton.didYouChange()) {
                InspectorPanelLine.makeCommand("LINCHAUTOGENOTYPE", this.ivAutoGenotypeButton.getValue(), 1, msb, this.ivAutoGenotypeButton.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivAlwaysPraline && this.ivAlwaysPraline.didYouChange()) {
                InspectorPanelLine.makeCommand("LINCHALWAYSPRLAINE", this.ivAlwaysPraline.getValue(), 1, msb, this.ivAlwaysPraline.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivForeignIDButton && this.ivForeignIDButton.didYouChange()) {
                InspectorPanelLine.makeCommand("SET_FOREIGN_ID", Integer.toString(7), Base64Manager.encodeBase64(this.ivForeignIDButton.getValue()), 1, msb, this.ivForeignIDButton.getAffecteds(idObjects));
            } else if (this.ivMinStressLevel != null && changeSensitives.elementAt(i) == this.ivMinStressLevel && this.ivMinStressLevel.didYouChange()) {
                InspectorPanelLine.makeCommand("LINCHSTRESSLEVEL", this.ivMinStressLevel.getCommandValue(), 1, msb, this.ivMinStressLevel.getAffecteds(idObjects));
            } else if (this.ivLineEvaluation != null && changeSensitives.elementAt(i) == this.ivLineEvaluation && this.ivLineEvaluation.didYouChange()) {
                InspectorPanelLine.makeCommand("LINSET_EVALUATION", this.ivLineEvaluation.getCommandValue(), 1, msb, this.ivLineEvaluation.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCSLicense && this.ivCSLicense.didYouChange()) {
                InspectorPanelLine.makeCommand("LINSET_LICENSE", this.ivCSLicense.getCommandValue(), 1, msb, this.ivCSLicense.getAffecteds(idObjects));
            }
            ++i;
        }
        return msb.toString();
    }

    private boolean areLinesChangeable() {
        int i = 0;
        while (i < this.ivSelObjects.size()) {
            Line line = (Line)this.ivSelObjects.elementAt(i);
            if (line.isBreeder() || !line.isAliveAndVisible() || !line.mayAttributeBeChangedByCommand()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Vector getMatchingMice() {
        return MouseManager.getActualMiceOfLines(this.ivSelObjects);
    }

    public int getRowCount() {
        if (this.ivLineLoci != null) {
            return this.ivLineLoci.length;
        }
        return 0;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return Babel.get("LOCUS");
            }
            case 1: {
                return Babel.get("ALLELES");
            }
        }
        return "";
    }

    public Class getColumnClass(int arg0) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Object getValueAt(int row, int column) {
        if (this.ivLineLoci != null && this.ivSelObjects.size() == 1) {
            Line line = (Line)this.ivSelObjects.elementAt(0);
            if (row < this.ivLineLoci.length) {
                if (column == 0) {
                    Locus locus = LocusManager.getLocus(this.ivLineLoci[row].ivLocusID, line.getGroup());
                    if (locus != null) {
                        return locus.getBrowseName();
                    }
                } else if (column == 1) {
                    Locus locus = LocusManager.getLocus(this.ivLineLoci[row].ivLocusID, line.getGroup());
                    if (locus != null) {
                        return locus.getAllelString(this.ivLineLoci[row]);
                    }
                    return "";
                }
            }
        }
        return null;
    }

    public void setValueAt(Object arg0, int arg1, int arg2) {
    }

    public void addTableModelListener(TableModelListener arg0) {
    }

    public void removeTableModelListener(TableModelListener arg0) {
    }

    private static boolean isSetLicenseAllowed(Line line) {
        return line.isAliveAndVisible() && !line.isBreeder() && !line.isServiceGroupObject() && LicenseManager.hasAllowedLicenses(line.getGroup(), false);
    }

    class ExpPropsPanel
    extends JPanel
    implements IPTabPanel {
        private static final long serialVersionUID = 456545641L;

        public ExpPropsPanel() {
            super(new BorderLayout());
            this.setOpaque(false);
            JScrollPane jsp = new JScrollPane(InspectorPanelLine.this.ivExpectedPropertiesField);
            jsp.setOpaque(false);
            jsp.getViewport().setOpaque(false);
            this.add((Component)jsp, "Center");
        }

        public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
            if (idObjects.size() == 1) {
                boolean active = InspectorPanelLine.this.areLinesChangeable();
                InspectorPanelLine.this.ivExpectedPropertiesField.setState(active && Privileges.hasPrivilege("LIN_CH_EXP_PROPS"));
                InspectorPanelLine.this.ivExpectedPropertiesField.adaptToVector(idObjects);
            } else {
                InspectorPanelLine.this.setToNonApplicable(InspectorPanelLine.this.ivExpectedPropertiesField);
            }
        }
    }

    class LineAttributePanel
    extends AttributePane {
        private static final long serialVersionUID = 5067010713733060702L;
        private int cvLocusHeight = UIDef.getScaled(90);
        private int cvMinComHeight = UIDef.getScaled(60);
        private JScrollPane ivAP_Locus = null;
        private BorderPanel ivAP_Comment = null;
        private JScrollPane ivSensitivePane;

        public LineAttributePanel() {
            InspectorPanelLine.this.ivSensitiveTable = new SensitiveTable(InspectorPanelLine.this.ivChangeSensitives);
            this.ivSensitivePane = new JScrollPane(InspectorPanelLine.this.ivSensitiveTable);
            this.add(this.ivSensitivePane);
            InspectorPanelLine.this.ivLocusTable.getColumnModel().getColumn(0).setPreferredWidth(UIDef.getScaled(80));
            InspectorPanelLine.this.ivLocusTable.getColumnModel().getColumn(1).setPreferredWidth(UIDef.getScaled(200));
            this.ivAP_Locus = new JScrollPane(InspectorPanelLine.this.ivLocusTable);
            this.add(this.ivAP_Locus);
            JPanel mp = new JPanel(new BorderLayout());
            mp.setOpaque(false);
            JScrollPane jsp = new JScrollPane(InspectorPanelLine.this.ivCommentField);
            jsp.setOpaque(false);
            jsp.getViewport().setOpaque(false);
            mp.add((Component)jsp, "Center");
            this.ivAP_Comment = new BorderPanel(mp, Babel.get("DESCRIPTION"));
            this.add(this.ivAP_Comment);
        }

        public void layoutContainer(Container parent) {
            int sh;
            int commentHeight;
            Insets insets;
            Dimension d = parent.getSize();
            int x = Inspector.INTER_BUT;
            int w = d.width - 2 * Inspector.INTER_BUT;
            int y = Inspector.INTER_BUT;
            int extra = UIDef.getScaled(5);
            if (this.ivSensitivePane != null && (insets = this.ivSensitivePane.getInsets()) != null) {
                extra = insets.top + insets.bottom;
            }
            if ((commentHeight = d.height - 2 * Inspector.INTER_BUT - 2 * Inspector.RAND - (sh = InspectorPanelLine.this.ivSensitiveTable.getPreferredSize().height + extra) - this.cvLocusHeight) < this.cvMinComHeight) {
                commentHeight = this.cvMinComHeight;
                sh = d.height - 2 * Inspector.INTER_BUT - 2 * Inspector.RAND - commentHeight - this.cvLocusHeight;
            }
            this.ivSensitivePane.setBounds(x, y, w, sh);
            this.ivAP_Locus.setBounds(x, y += sh + Inspector.RAND, w, this.cvLocusHeight);
            this.ivAP_Comment.setBounds(x, y += this.cvLocusHeight + Inspector.RAND, w, commentHeight);
        }

        public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
            super.adapt(idObjects, mice, changeSensitives);
            if (idObjects == null || idObjects.isEmpty()) {
                InspectorPanelLine.this.ivLineLoci = null;
            } else if (idObjects.size() == 1) {
                Line line = (Line)InspectorPanelLine.this.ivSelObjects.elementAt(0);
                InspectorPanelLine.this.ivLineLoci = (LocusAndAlleles[])line.get("LIN_LOCIALLELES");
                InspectorPanelLine.this.ivLocusTable.tableChanged(new TableModelEvent(InspectorPanelLine.this.ivLocusTable.getModel()));
                boolean active = InspectorPanelLine.this.areLinesChangeable();
                InspectorPanelLine.this.ivNameField.setState(active && Privileges.hasPrivilege("LIN_CH_NAME"));
                InspectorPanelLine.this.ivCommentField.setState(active && Privileges.hasPrivilege("LIN_CH_DESCRIPRION"));
                InspectorPanelLine.this.ivColorButton.setState(active && Privileges.hasPrivilege("LIN_CH_COLOR"));
                InspectorPanelLine.this.ivMatLimButton.setState(active && Privileges.hasPrivilege("LIN_CH_MAT_LIMIT"));
                InspectorPanelLine.this.ivANTagButton.setState(active && Privileges.hasPrivilege("LIN_CH_TAG"));
                InspectorPanelLine.this.ivPrefixButton.setState(active && Privileges.hasPrivilege("LIN_CH_EARTAG_PREFIX"));
                InspectorPanelLine.this.ivAutoGenotypeButton.setState(active && Privileges.hasPrivilege("LIN_CH_AUTOGENOTYPE"));
                InspectorPanelLine.this.ivAlwaysPraline.setState(active && Privileges.hasPrivilege("LIN_CH_COLORMODE"));
                InspectorPanelLine.this.ivForeignIDButton.setState(active && Privileges.hasPrivilege("EDIT_FOREIGN_ID"));
                if (InspectorPanelLine.this.ivMinStressLevel != null) {
                    InspectorPanelLine.this.ivMinStressLevel.setState(active && Privileges.hasPrivilege("LIN_DEFINE_STRESS_LEVELS"));
                }
                InspectorPanelLine.this.setToPassive(InspectorPanelLine.this.ivMaxStressLevel);
                if (InspectorPanelLine.this.ivLineEvaluation != null) {
                    InspectorPanelLine.this.ivLineEvaluation.setState(active && Privileges.hasPrivilege("LIN_CH_EVALUATION"));
                }
                InspectorPanelLine.this.ivCSLicense.setState(InspectorPanelLine.isSetLicenseAllowed(line));
            } else {
                InspectorPanelLine.this.ivLineLoci = null;
                this.disableAllSensitives(InspectorPanelLine.this.ivChangeSensitives);
                boolean active = InspectorPanelLine.this.areLinesChangeable();
                InspectorPanelLine.this.ivMatLimButton.setState(active && Privileges.hasPrivilege("LIN_CH_MAT_LIMIT"));
                InspectorPanelLine.this.ivANTagButton.setState(active && Privileges.hasPrivilege("LIN_CH_TAG"));
                InspectorPanelLine.this.ivPrefixButton.setState(active && Privileges.hasPrivilege("LIN_CH_EARTAG_PREFIX"));
                InspectorPanelLine.this.ivAutoGenotypeButton.setState(active && Privileges.hasPrivilege("LIN_CH_AUTOGENOTYPE"));
                InspectorPanelLine.this.ivAlwaysPraline.setState(active && Privileges.hasPrivilege("LIN_CH_COLORMODE"));
                InspectorPanelLine.this.setToNonApplicable(InspectorPanelLine.this.ivForeignIDButton);
                InspectorPanelLine.this.setToNonApplicable(InspectorPanelLine.this.ivMinStressLevel);
                InspectorPanelLine.this.setToNonApplicable(InspectorPanelLine.this.ivMaxStressLevel);
                InspectorPanelLine.this.setToNonApplicable(InspectorPanelLine.this.ivCSLicense);
                if (InspectorPanelLine.this.ivLineEvaluation != null) {
                    InspectorPanelLine.this.ivLineEvaluation.setState(active && Privileges.hasPrivilege("LIN_CH_EVALUATION"));
                }
            }
            InspectorPanelLine.this.ivLocusTable.tableChanged(new TableModelEvent(InspectorPanelLine.this.ivLocusTable.getModel()));
        }
    }
}

